<?php

/* -----------------------------------------
   Module Prestashop CategoriesTopMenu
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ----------------------------------------- */

class CategoriesTopMenu extends Module
{
	public function __construct()
	{
		$this->name = 'categoriestopmenu';
		$this->tab = 'front_office_features';
		$this->version = '3.3';
		$this->author = 'PRESTACREA';
		
		$this->bootstrap = true;
		$this->need_instance = 0;
		parent::__construct();

		$this->displayName = ('PRESTACREA - Categories Top Menu');
		$this->description = $this->l('Adds a horizontal categories menu');
	}

	public function install()
	{
		if (file_exists(dirname(__FILE__).'/install/categoriestopmenu-install.php'))
			require_once(dirname(__FILE__).'/install/categoriestopmenu-install.php');
		
		if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
			unlink(dirname(__FILE__).'/css/less/default.less.cache');
		if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
			unlink(dirname(__FILE__).'/css/less/responsive.less.cache');
		
		if (!parent::install()
		OR !$this->registerHook('header')
		OR !$this->registerHook('top'))
			return false;
		return true;
	}

	public function uninstall()
	{
		if (file_exists(dirname(__FILE__).'/install/categoriestopmenu-uninstall.php'))
			require_once(dirname(__FILE__).'/install/categoriestopmenu-uninstall.php');
		
		if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
			unlink(dirname(__FILE__).'/css/less/default.less.cache');
		if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
			unlink(dirname(__FILE__).'/css/less/responsive.less.cache');
		
		if (!parent::uninstall())
			return false;
		return true;
	}

	public function getContent()
	{
		$this->_html .= '<h2>'.$this->displayName.' - v.'.$this->version.'</h2>
		<div id="lnkDocContainer">
			<a class="lnk" target="_blank" href="'.$this->_path.'doc/documentation.pdf">'.$this->l('PDF documentation').'</a>
			<a class="lnk" target="_blank" href="'.$this->_path.'doc/changelog.txt">'.$this->l('Changelog').'</a>
		</div>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post"><input style="margin:0 0 20px;" type="submit" name="submitCache" value="'.$this->l('Clear module cache').'" class="button" /></form>';
		if (Tools::isSubmit('submitGeneral')) {
			if (Tools::getValue('ctm_maxdepth') AND Validate::isInt(Tools::getValue('ctm_maxdepth')))
				Configuration::updateValue('CTM_MAXDEPTH', pSQL(Tools::getValue('ctm_maxdepth')));
			else
				$this->_html .= $this->displayError($this->l('Invalid number of levels'));
			Configuration::updateValue('CTM_TABS', pSQL(Tools::getValue('ctm_tabs')));
			Configuration::updateValue('CTM_RESPONSIVE', pSQL(Tools::getValue('ctm_responsive')));
			Configuration::updateValue('CTM_HOME', pSQL(Tools::getValue('ctm_home')));
			Configuration::updateValue('CTM_SPECIALS', pSQL(Tools::getValue('ctm_specials')));
			Configuration::updateValue('CTM_NEWS', pSQL(Tools::getValue('ctm_news')));
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		if (Tools::isSubmit('submitStyle')) {
			if (Validate::isInt(Tools::getValue('ctm_width')))
				Configuration::updateValue('CTM_WIDTH', pSQL(Tools::getValue('ctm_width')));
			else
				$this->_html .= $this->displayError($this->l('Invalid menu maximum width'));
			if (Tools::getValue('ctm_fontfamily') AND Validate::isName(Tools::getValue('ctm_fontfamily')))
				Configuration::updateValue('CTM_FONTFAMILY', pSQL(Tools::getValue('ctm_fontfamily')));
			else
				$this->_html .= $this->displayError($this->l('Invalid font family'));
			if (Tools::getValue('ctm_fontsize') AND Validate::isInt(Tools::getValue('ctm_fontsize')))
				Configuration::updateValue('CTM_FONTSIZE', pSQL(Tools::getValue('ctm_fontsize')));
			else
				$this->_html .= $this->displayError($this->l('Invalid font size'));
			if (Tools::getValue('ctm_menutopcolor'))
				Configuration::updateValue('CTM_MENUTOPCOLOR', pSQL(Tools::getValue('ctm_menutopcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid menu top color'));
			if (Tools::getValue('ctm_menubottomcolor'))
				Configuration::updateValue('CTM_MENUBOTTOMCOLOR', pSQL(Tools::getValue('ctm_menubottomcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid menu bottom color'));
			if (Tools::getValue('ctm_firstfontcolor'))
				Configuration::updateValue('CTM_FIRSTFONTCOLOR', pSQL(Tools::getValue('ctm_firstfontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid first level font color'));
			if (Tools::getValue('ctm_nextfontcolor'))
				Configuration::updateValue('CTM_NEXTFONTCOLOR', pSQL(Tools::getValue('ctm_nextfontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid next levels font color'));
			if (Tools::getValue('ctm_linkstopcolor'))
				Configuration::updateValue('CTM_LINKSTOPCOLOR', pSQL(Tools::getValue('ctm_linkstopcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid links top color'));
			if (Tools::getValue('ctm_linksbottomcolor'))
				Configuration::updateValue('CTM_LINKSBOTTOMCOLOR', pSQL(Tools::getValue('ctm_linksbottomcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid links bottom color'));
			if (Tools::getValue('ctm_linksfontcolor'))
				Configuration::updateValue('CTM_LINKSFONTCOLOR', pSQL(Tools::getValue('ctm_linksfontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid links font color'));
			if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
				unlink(dirname(__FILE__).'/css/less/default.less.cache');
			if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
				unlink(dirname(__FILE__).'/css/less/responsive.less.cache');
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		if (Tools::isSubmit('submitCSS')) {
			if ($this->putFileContents())
				$this->_html .= $this->displayConfirmation($this->l('CSS file updated'));
			else
				$this->_html .= $this->displayError($this->l('No CSS file selected'));
		}
		if (Tools::isSubmit('submitCache')) {
			if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
				unlink(dirname(__FILE__).'/css/less/default.less.cache');
			if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
				unlink(dirname(__FILE__).'/css/less/responsive.less.cache');
			$this->_html .= $this->displayConfirmation($this->l('Module cache cleared'));
		}
		$this->displayForm();
		return $this->_html;
	}

	public function displayForm()
	{
		global $cookie;
		$iso = Language::getIsoById((int)($cookie->id_lang));
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$this->_html .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'admin/css/admin.css" />
		<link rel="stylesheet" type="text/css" href="'.$this->_path.'admin/colorpicker/css/colorpicker.css" />
		<script type="text/javascript" src="'.$this->_path.'admin/js/admin.js"></script>
		<script type="text/javascript" src="'.$this->_path.'admin/colorpicker/js/colorpicker.js"></script>
		<div id="tab_container">
			<script type="text/javascript">var id_tab = '.'1'.';changeTab(id_tab);</script>
			<ul class="tabs">
				<li id="tab_1" class="tab active" onclick="changeTab(1);">'.$this->l('General configuration').'</li>
				<li id="tab_2" class="tab" onclick="changeTab(2);">'.$this->l('Graphical configuration').'</li>
				<li id="tab_3" class="tab" onclick="changeTab(3);">'.$this->l('CSS Editor').'</li>
			</ul>
			<div id="content_1" class="content" style="display:block">';
				$this->configGeneral();
			$this->_html .= '</div>
			<div id="content_2" class="content" style="display:none">';
				$this->configStyle();
			$this->_html .= '</div>
			<div id="content_3" class="content" style="display:none">';
				$this->configCSS();
			$this->_html .= '</div>
		</div>';
		
		$isoTinyMCE = (file_exists(_PS_ROOT_DIR_.'/js/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en');
		$ad = dirname($_SERVER["PHP_SELF"]);
		$this->_html .= '<script type="text/javascript">	
			var iso = \''.$isoTinyMCE.'\' ;
			var pathCSS = \''._THEME_CSS_DIR_.'\' ;
			var ad = \''.$ad.'\' ;
		</script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tiny_mce/tiny_mce.js"></script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce.inc.js"></script>';
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$this->_html .= '<script type="text/javascript">
				$(document).ready(function(){
					tinySetup({
						theme_advanced_buttons1 : "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
						theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,,|,forecolor,backcolor",
						theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,|,ltr,rtl,|,fullscreen",
						theme_advanced_buttons4 : "styleprops,|,cite,abbr,acronym,del,ins,attribs,pagebreak",
						theme_advanced_resizing : false
					});
				});
			</script>';
		}
	}
	
	public function configGeneral()
	{
		$this->_html .= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<h3>'.$this->l('General configuration options').'</h3>
				<div class="block mini high">
					<label>'.$this->l('Categories levels').'</label>
					<input type="text" size="4" maxlength="2" name="ctm_maxdepth" value="'.Configuration::get('CTM_MAXDEPTH').'" />
					<p>'.$this->l('Set the number of categories levels displayed in the menu').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Menu display').'</label>
					<div class="inputContainer">
						<input type="radio" name="ctm_tabs" value="1" '.(Configuration::get('CTM_TABS') ? 'checked="checked"' : '').' />'.$this->l('Tabs').'
						<input type="radio" name="ctm_tabs" value="0" '.(!Configuration::get('CTM_TABS') ? 'checked="checked"' : '').' />'.$this->l('Bar').'
					</div>
					<p>'.$this->l('Set the menu display type (tabs only on wide screens with responsive mode)').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Activate responsive mode').'</label>
					<div class="inputContainer">
						<input type="radio" name="ctm_responsive" value="1" '.(Configuration::get('CTM_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ctm_responsive" value="0" '.(!Configuration::get('CTM_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the responsive mode is activated or not (the template used must be compatible, disable this option if the template is not responsive)').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Display Home link').'</label>
					<div class="inputContainer">
						<input type="radio" name="ctm_home" value="1" '.(Configuration::get('CTM_HOME') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ctm_home" value="0" '.(!Configuration::get('CTM_HOME') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the home link is displayed or not').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Display Promotions link').'</label>
					<div class="inputContainer">
						<input type="radio" name="ctm_specials" value="1" '.(Configuration::get('CTM_SPECIALS') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ctm_specials" value="0" '.(!Configuration::get('CTM_SPECIALS') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the promotions link is displayed or not').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Display New products link').'</label>
					<div class="inputContainer">
						<input type="radio" name="ctm_news" value="1" '.(Configuration::get('CTM_NEWS') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ctm_news" value="0" '.(!Configuration::get('CTM_NEWS') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the new products link is displayed or not').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitGeneral" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function configStyle()
	{
		$this->_html .= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<h3>'.$this->l('Graphical configuration options').'</h3>
				<div class="block small high">
					<label>'.$this->l('Maximum width of the menu').'</label>
					<span class="label">'.$this->l('Maximum width').' :</span>
					<input type="text" size="4" maxlength="4" name="ctm_width" value="'.Configuration::get('CTM_WIDTH').'" /><span class="unity">px</span>
					<p>'.$this->l('Set the maximum width of the menu (set to 0 for 100% width)').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Global font style').'</label>
					<span class="label">'.$this->l('Font family').' :</span>
					<input type="text" size="16" name="ctm_fontfamily" value="'.Configuration::get('CTM_FONTFAMILY').'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Font size').' :</span>
					<input type="text" size="4" maxlength="2" name="ctm_fontsize" value="'.Configuration::get('CTM_FONTSIZE').'" /><span class="unity">px</span>
					<p>'.$this->l('Set the font family and the font size of the menu').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Menu background color').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Color top').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_menutopcolor" value="'.Configuration::get('CTM_MENUTOPCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_MENUTOPCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Color bottom').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_menubottomcolor" value="'.Configuration::get('CTM_MENUBOTTOMCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_MENUBOTTOMCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the color of the menu background (gradient)').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Menu font color').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('First level').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_firstfontcolor" value="'.Configuration::get('CTM_FIRSTFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_FIRSTFONTCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Next levels').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_nextfontcolor" value="'.Configuration::get('CTM_NEXTFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_NEXTFONTCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the color of the different categories levels font').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Links background color').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Color top').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_linkstopcolor" value="'.Configuration::get('CTM_LINKSTOPCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_LINKSTOPCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Color bottom').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_linksbottomcolor" value="'.Configuration::get('CTM_LINKSBOTTOMCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_LINKSBOTTOMCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the color of the links background (gradient)').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Links font color').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Color').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ctm_linksfontcolor" value="'.Configuration::get('CTM_LINKSFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('CTM_LINKSFONTCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the color of the links font').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitStyle" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function configCSS()
	{
		$dir = dirname(__FILE__)."/css/less/";
        $files = scandir($dir) ;
        $cnt = count($files) ;
        $this->_html .= '<script type="text/javascript">var baseDir = "'.$this->_path.'css/less/";</script>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<h3>'.$this->l('Warning').'</h3>
				<div class="warning">'.$this->l('Editing CSS file is only for experienced users. Edit these files only if you know what you are doing.').'<br />'.$this->l('Do not use any accent when you modify those CSS files, even in the comments.').'</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('List of CSS files (LESS files)').'</h3>
				<table class="table">
					<th>'.$this->l('Filename').'</th>
					<th class="center">'.$this->l('Edit').'</th>';
					for ($i = 0; $i < $cnt; $i++)
						if (preg_match('/.less$/', $files[$i])) {
							$link = '<a href="#editor" onclick="loadFile('.$i.');">';
							$link .= '<img src="'._PS_ADMIN_IMG_.'edit.gif" /></a>
							<input type="hidden" name="fileId" id="fileId" value="'.$i.'"/>
							<input type="hidden" name="fileName_'.$i.'" id="fileName_'.$i.'" value="'.$files[$i].'"/>';
							$this->_html .= '<tr>
								<td>'.$files[$i].'</td>
								<td class="center">'.$link.'</td>
							</tr>';
						}
				$this->_html .= '</table>
				<div>';
					$this->_html .= '<div id="editor">
						<textarea class="rte" cols="80" rows="30" id="contentCSS" name="contentCSS"></textarea>
						<input type="hidden" name="fileName" id="fileName" value=""/>
					</div>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitCSS" value="'.$this->l('Update the CSS file').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function putFileContents()
    {
        $filename = Tools::getValue('fileName');
		$file = dirname(__FILE__)."/css/less/".$filename;
		$balises = array('<br />', '<p>', '</p>');
		$replace = array("\n", "", "");
		$data = str_replace($balises, $replace, Tools::getValue('contentCSS'));
        $contents = htmlspecialchars_decode($data);
        if ($filename) {
			file_put_contents($file,$contents);
			return true;
		}
		else
			return false;
    }

	public function getTree($resultParents, $resultIds, $ctm_maxdepth, $id_category = 1, $currentDepth = 0)
	{
		global $link;
		$children = array();
		if (isset($resultParents[$id_category]) AND sizeof($resultParents[$id_category]) AND ($ctm_maxdepth == 0 OR $currentDepth < $ctm_maxdepth))
			foreach ($resultParents[$id_category] as $subcat)
				$children[] = $this->getTree($resultParents, $resultIds, $ctm_maxdepth, $subcat['id_category'], $currentDepth + 1);
		if (!isset($resultIds[$id_category]))
			return false;
		return array('id' => $id_category, 'link' => $link->getCategoryLink($id_category, $resultIds[$id_category]['link_rewrite']),
		'name' => $resultIds[$id_category]['name'], 'desc'=> $resultIds[$id_category]['description'],
		'children' => $children);
	}
	
	public function getTree15($resultParents, $resultIds, $ctm_maxdepth, $id_category = null, $currentDepth = 0)
	{
		if (is_null($id_category))
			$id_category = $this->context->shop->getCategory();
		$children = array();
		if (isset($resultParents[$id_category]) && count($resultParents[$id_category]) && ($ctm_maxdepth == 0 || $currentDepth < $ctm_maxdepth))
			foreach ($resultParents[$id_category] as $subcat)
				$children[] = $this->getTree15($resultParents, $resultIds, $ctm_maxdepth, $subcat['id_category'], $currentDepth + 1);
		if (!isset($resultIds[$id_category]))
			return false;
		$return = array('id' => $id_category, 'link' => $this->context->link->getCategoryLink($id_category, $resultIds[$id_category]['link_rewrite']),
		'name' => $resultIds[$id_category]['name'], 'desc'=> $resultIds[$id_category]['description'],
		'children' => $children);
		return $return;
	}

	public function cacheCompileLess($inputFile, $outputFile) {
		if (!class_exists('lessc'))
			require_once dirname(__FILE__).'/lessc.inc.php';
		
		$cacheFile = $inputFile.'.cache';
		if (file_exists($cacheFile))
			$cache = unserialize(file_get_contents($cacheFile));
		else
			$cache = $inputFile;

		$less = new lessc;
		$less->setVariables(array(
			'ctm_width' => Configuration::get('CTM_WIDTH') > 0 ? Configuration::get('CTM_WIDTH').'px' : '100%',
			'ctm_fontfamily' => Configuration::get('CTM_FONTFAMILY'),
			'ctm_fontsize' => Configuration::get('CTM_FONTSIZE').'px',
			'ctm_menutopcolor' => '#'.Configuration::get('CTM_MENUTOPCOLOR'),
			'ctm_menubottomcolor' => '#'.Configuration::get('CTM_MENUBOTTOMCOLOR'),
			'ctm_firstfontcolor' => '#'.Configuration::get('CTM_FIRSTFONTCOLOR'),
			'ctm_nextfontcolor' => '#'.Configuration::get('CTM_NEXTFONTCOLOR'),
			'ctm_linkstopcolor' => '#'.Configuration::get('CTM_LINKSTOPCOLOR'),
			'ctm_linksbottomcolor' => '#'.Configuration::get('CTM_LINKSBOTTOMCOLOR'),
			'ctm_linksfontcolor' => '#'.Configuration::get('CTM_LINKSFONTCOLOR')
		));
		
		$less->setFormatter("classic");
		$newCache = $less->cachedCompile($cache);

		if (!is_array($cache) || $newCache['updated'] > $cache['updated']) {
			file_put_contents($cacheFile, serialize($newCache));
			file_put_contents($outputFile, $newCache['compiled']);
		}
	}

	public function hookHeader($params)
	{
		global $smarty;
		$smarty->assign(array(
			'ctm_tabs' => Configuration::get('CTM_TABS'),
			'ctm_responsive' => Configuration::get('CTM_RESPONSIVE')
		));
		
		$this->cacheCompileLess(dirname(__FILE__).'/css/less/default.less', dirname(__FILE__).'/css/categoriestopmenu.css');
		$this->cacheCompileLess(dirname(__FILE__).'/css/less/responsive.less', dirname(__FILE__).'/css/categoriestopmenu-responsive.css');
		
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$this->context->controller->addCSS(($this->_path).'css/categoriestopmenu.css', 'all');
			if (Configuration::get('CTM_RESPONSIVE') == 1)
				$this->context->controller->addCSS(($this->_path).'css/categoriestopmenu-responsive.css', 'all');
		}
		else {
			Tools::addCSS($this->_path.'css/categoriestopmenu.css', 'all');
			if (Configuration::get('CTM_RESPONSIVE') == 1)
				Tools::addCSS($this->_path.'css/categoriestopmenu-responsive.css', 'all');
		}
	}

	public function hookTop($params)
	{
		global $smarty, $cookie;
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_customer = (int)$params['cookie']->id_customer;
			$groups = $id_customer ? implode(', ', Customer::getGroupsStatic($id_customer)) : Configuration::get('PS_UNIDENTIFIED_GROUP');
			$id_product = (int)Tools::getValue('id_product', 0);
			$id_category = (int)Tools::getValue('id_category', 0);
			$id_lang = (int)$params['cookie']->id_lang;
			$ctm_maxdepth = Configuration::get('CTM_MAXDEPTH');
			if (!$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('SELECT c.id_parent, c.id_category, cl.name, cl.description, cl.link_rewrite
			FROM `'._DB_PREFIX_.'category` c
			LEFT JOIN `'._DB_PREFIX_.'category_lang` cl ON (c.`id_category` = cl.`id_category` AND cl.`id_lang` = '.$id_lang.Shop::addSqlRestrictionOnLang('cl').')
			LEFT JOIN `'._DB_PREFIX_.'category_group` cg ON (cg.`id_category` = c.`id_category`)
			LEFT JOIN `'._DB_PREFIX_.'category_shop` cs ON (cs.`id_category` = c.`id_category`)
			WHERE (c.`active` = 1 OR c.`id_category` = '.(int)Configuration::get('PS_HOME_CATEGORY').')
			AND c.`id_category` != '.(int)Configuration::get('PS_ROOT_CATEGORY').'
			'.((int)($ctm_maxdepth) != 0 ? ' AND `level_depth` <= '.(int)($ctm_maxdepth) : '').'
			AND cg.`id_group` IN ('.pSQL($groups).')
			AND cs.`id_shop` = '.$this->context->shop->id.'
			GROUP BY id_category
			ORDER BY `level_depth` ASC, cs.`position` ASC'))
				return;
		}
		else {
			$id_customer = intval($params['cookie']->id_customer);
			$ctm_maxdepth = Configuration::get('CTM_MAXDEPTH');
			if (!$result = Db::getInstance()->ExecuteS('SELECT DISTINCT c.*, cl.*
			FROM `'._DB_PREFIX_.'category` c
			LEFT JOIN `'._DB_PREFIX_.'category_lang` cl ON (c.`id_category` = cl.`id_category` AND `id_lang` = '.intval($params['cookie']->id_lang).')
			LEFT JOIN `'._DB_PREFIX_.'category_group` ctg ON (ctg.`id_category` = c.`id_category`)
			'.($id_customer ? 'INNER JOIN `'._DB_PREFIX_.'customer_group` cg ON (cg.`id_group` = ctg.`id_group` AND cg.`id_customer` = '.intval($id_customer).')' : '' ).'
			WHERE 1'.(intval($ctm_maxdepth) != 0 ? ' AND `level_depth` <= '.intval($ctm_maxdepth) : '').'
			AND (c.`active` = 1 OR c.`id_category` = 1)
			'.(!$id_customer ? 'AND ctg.`id_group` = 1' : '' ).'
			ORDER BY `level_depth` ASC, c.`position` ASC'))
				return;
		}
		$resultParents = array();
		$resultIds = array();
		foreach ($result as $row) {
			$row['name'] = $row['name'];
			$resultParents[$row['id_parent']][] = $row;
			$resultIds[$row['id_category']] = $row;
		}
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$blockCategTree = $this->getTree15($resultParents, $resultIds, Configuration::get('CTM_MAXDEPTH'));
		else
			$blockCategTree = $this->getTree($resultParents, $resultIds, Configuration::get('CTM_MAXDEPTH'));
		$smarty->assign('currentCategoryId', intval(Tools::getValue('id_category')));
		if (Tools::getValue('id_product')) {
			if (!isset($cookie->last_visited_category) OR !Product::idIsOnCategoryId(intval(Tools::getValue('id_product')), array('0' => array('id_category' => $cookie->last_visited_category)))) {
				$product = new Product(intval(Tools::getValue('id_product')));
				if (isset($product) AND Validate::isLoadedObject($product))
					$cookie->last_visited_category = intval($product->id_category_default);
			}
			$smarty->assign('currentCategoryId', intval($cookie->last_visited_category));
		}
		$smarty->assign(array(
			'blockCategTree' => $blockCategTree,
			'ctm_home' => Configuration::get('CTM_HOME'),
			'ctm_specials' => Configuration::get('CTM_SPECIALS'),
			'ctm_news' => Configuration::get('CTM_NEWS')
		));
		$smarty->assign('branche_tpl_path', _PS_MODULE_DIR_.'categoriestopmenu/categoriestopmenu-list.tpl');
		return $this->display(__FILE__, 'categoriestopmenu.tpl');
	}
}