<?php

/* -----------------------------------------
   Module Prestashop FooterCustom
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ----------------------------------------- */

class FooterCustom extends Module
{
	public function __construct()
	{
		$this->name = 'footercustom';
		$this->tab = 'front_office_features';
		$this->version = '3.4';
		$this->author = 'PRESTACREA';
		$this->module_key = 'ac1b7c852095415433426bad93a47c6b';
		
		$this->bootstrap = true;
		$this->need_instance = 0;
		parent::__construct();

		$this->displayName = ('PRESTACREA - Footer Custom');
		$this->description = $this->l('Adds a large customizable footer');
		$this->confirmUninstall = $this->l('Uninstalling the module will delete all its data. Do you want to continue uninstalling the module ?');
	}

	public function install()
	{
		if (file_exists(dirname(__FILE__).'/install/footercustom-install.php'))
			require_once(dirname(__FILE__).'/install/footercustom-install.php');
		
		if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
			unlink(dirname(__FILE__).'/css/less/default.less.cache');
		if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
			unlink(dirname(__FILE__).'/css/less/responsive.less.cache');

		if (!parent::install()
		OR !$this->registerHook('header') 
		OR !$this->registerHook('footer'))
			return false;
		return true;
	}

	public function uninstall()
	{
		if (file_exists(dirname(__FILE__).'/install/footercustom-uninstall.php'))
			require_once(dirname(__FILE__).'/install/footercustom-uninstall.php');
		
		if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
			unlink(dirname(__FILE__).'/css/less/default.less.cache');
		if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
			unlink(dirname(__FILE__).'/css/less/responsive.less.cache');

		if (!parent::uninstall())
			return false;
		return true;
	}

	public function getCustomers()
	{
		$rq = Db::getInstance()->ExecuteS('SELECT c.`id_customer`, c.`lastname`, c.`firstname`, c.`email`, c.`ip_registration_newsletter`, c.`newsletter_date_add` FROM `'._DB_PREFIX_.'customer` c WHERE c.`newsletter` = 1 GROUP BY c.`id_customer`');
		$header = array('id_customer', 'lastname', 'firstname', 'email', 'ip_address', 'newsletter_date_add');
		$result = (is_array($rq) ? array_merge(array($header), $rq) : $header);
		return $result;
	}

	public function getFooterCustom()
	{
		$rq = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'footercustom_newsletter`');
		$header = array('id_customer', 'email', 'newsletter_date_add', 'ip_address');
		$result = (is_array($rq) ? array_merge(array($header), $rq) : $header);
		return $result;
	}

	public function putCSV($fd, $array)
	{
		$line = implode(';', $array);
		$line .= "\n";
		if (!fwrite($fd, utf8_decode($line), 4096))
			$this->_postErrors[] = $this->l('Cannot write to').' '.dirname(__FILE__).'/'.$this->_file.' !';
	}

 	public function isNewsletterRegistered($customerEmail)
 	{
		if (Db::getInstance()->getRow('SELECT `email` FROM '._DB_PREFIX_.'footercustom_newsletter WHERE `email` = \''.pSQL($customerEmail).'\''))
			return 1;
		if (!$registered = Db::getInstance()->getRow('SELECT `newsletter` FROM '._DB_PREFIX_.'customer WHERE `email` = \''.pSQL($customerEmail).'\''))
			return -1;
		if ($registered['newsletter'] == '1')
			return 2;
		return 0;
 	}
 	
 	public function newsletterRegistration()
 	{
		global $cookie;
		$this->error = false;
		$this->valid = false;
		if (!Validate::isEmail(pSQL(Tools::getValue('email'))))
			return $this->error = $this->l('Invalid mail address');
		else {
			$registerStatus = $this->isNewsletterRegistered(pSQL(Tools::getValue('email')));
			if ($registerStatus > 0)
				return $this->error = $this->l('Mail address already registered');
			elseif ($registerStatus == -1) {
				if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'footercustom_newsletter VALUES (\'\', \''.pSQL(Tools::getValue('email')).'\', NOW(), \''.pSQL($_SERVER['REMOTE_ADDR']).'\', 
				(SELECT c.http_referer FROM '._DB_PREFIX_.'connections c WHERE c.id_guest = '.intval($cookie->id_guest).' ORDER BY c.date_add DESC LIMIT 1))'))
					return $this->error = $this->l('Error during subscription');
				return $this->valid = $this->l('Subscription successful');
			}
			elseif ($registerStatus == 0) {
				if (!Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'customer SET `newsletter` = 1, newsletter_date_add = NOW(), `ip_registration_newsletter` = \''.pSQL($_SERVER['REMOTE_ADDR']).'\' WHERE `email` = \''.pSQL(Tools::getValue('email')).'\''))
					return $this->error = $this->l('Error during subscription');
				return $this->valid = $this->l('Subscription successful');
			}
		}
 	}

	public function getBlockTitle1($lang)
	{
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$result = Db::getInstance()->getRow('SELECT `title1` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_shop`='.(int)$id_shop.' AND `id_lang`='.$lang))
				return false;
			return $result;
		}
		else {
			if (!$result = Db::getInstance()->getRow('SELECT `title1` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_lang`='.$lang))
				return false;
			return $result;
		}
	}

	public function getBlockTitle2($lang)
	{
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$result = Db::getInstance()->getRow('SELECT `title2` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_shop`='.(int)$id_shop.' AND `id_lang`='.$lang))
				return false;
			return $result;
		}
		else {
			if (!$result = Db::getInstance()->getRow('SELECT `title2` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_lang`='.$lang))
				return false;
			return $result;
		}
	}

	public function getBlockTitle3($lang)
	{
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$result = Db::getInstance()->getRow('SELECT `title3` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_shop`='.(int)$id_shop.' AND `id_lang`='.$lang))
				return false;
			return $result;
		}
		else {
			if (!$result = Db::getInstance()->getRow('SELECT `title3` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_lang`='.$lang))
				return false;
			return $result;
		}
	}

	public function addBlock()
	{
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'footercustom VALUES ()') OR !$lastId = Db::getInstance()->Insert_ID())
				return false;
			foreach ($languages as $language) {
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$inblock = Tools::getValue('inblock_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'footercustom_lang VALUES ('.$lastId.', \''.(int)$id_shop.'\', '.$language['id_lang'].', \''.addslashes($title).'\' , \''.addslashes($link).'\', \''.addslashes($inblock).'\', \''.addslashes($position).'\')'))
					return false;
			}
			return true;
		}
		else {
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'footercustom VALUES ()') OR !$lastId = mysql_insert_id())
				return false;
			foreach ($languages as $language) {
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$inblock = Tools::getValue('inblock_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'footercustom_lang VALUES ('.$lastId.', "1", '.$language['id_lang'].', \''.addslashes($title).'\' , \''.addslashes($link).'\', \''.addslashes($inblock).'\', \''.addslashes($position).'\')'))
					return false;
			}
			return true;
		}
	}

	public function editBlock()
	{
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			foreach ($languages as $language) {
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$inblock = Tools::getValue('inblock_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				$id_block = (int)(Tools::getValue('id'));
				if (!Db::getInstance()->Execute('REPLACE '._DB_PREFIX_.'footercustom_lang VALUES (\''.($id_block).'\', \''.(int)$id_shop.'\', \''.$language['id_lang'].'\', \''.addslashes($title).'\', \''.addslashes($link).'\', \''.addslashes($inblock).'\', \''.addslashes($position).'\')'))
					return false;
			}
			return true;
		}
		else {
			foreach ($languages as $language) {
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$inblock = Tools::getValue('inblock_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				$id_block = (int)(Tools::getValue('id'));
				if (!Db::getInstance()->Execute('REPLACE '._DB_PREFIX_.'footercustom_lang VALUES (\''.($id_block).'\', "1", \''.$language['id_lang'].'\', \''.addslashes($title).'\', \''.addslashes($link).'\', \''.addslashes($inblock).'\', \''.addslashes($position).'\')'))
					return false;
			}
			return true;
		}
	}

	public function deleteBlock()
	{
		$id_block = (int)(Tools::getValue('id'));
		if (Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'footercustom WHERE `id_block`='.$id_block))
			return Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'footercustom_lang WHERE `id_block`='.$id_block);
		return false;
	}
	
	public function getReinsurance1($lang)
	{
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$result = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_reinsurance WHERE `id_block` = 1 AND `id_lang`='.$lang.' AND `id_shop`='.(int)$id_shop.''))
				return false;
			return $result;
		}
		else {
			if (!$result = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_reinsurance WHERE `id_block` = 1 AND `id_lang`='.$lang.''))
				return false;
			return $result;
		}
	}
	
	public function getReinsurance2($lang)
	{
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$result = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_reinsurance WHERE `id_block` = 2 AND `id_lang`='.$lang.' AND `id_shop`='.(int)$id_shop.''))
				return false;
			return $result;
		}
		else {
			if (!$result = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_reinsurance WHERE `id_block` = 2 AND `id_lang`='.$lang.''))
				return false;
			return $result;
		}
	}
	
	public function getReinsurance3($lang)
	{
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$result = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_reinsurance WHERE `id_block` = 3 AND `id_lang`='.$lang.' AND `id_shop`='.(int)$id_shop.''))
				return false;
			return $result;
		}
		else {
			if (!$result = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_reinsurance WHERE `id_block` = 3 AND `id_lang`='.$lang.''))
				return false;
			return $result;
		}
	}
	
	public function getReinsurance4($lang)
	{
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$result = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_reinsurance WHERE `id_block` = 4 AND `id_lang`='.$lang.' AND `id_shop`='.(int)$id_shop.''))
				return false;
			return $result;
		}
		else {
			if (!$result = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_reinsurance WHERE `id_block` = 4 AND `id_lang`='.$lang.''))
				return false;
			return $result;
		}
	}

	public function getEditor($lang)
	{
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$result = Db::getInstance()->getRow('SELECT `editor` FROM '._DB_PREFIX_.'footercustom_editor WHERE `id_shop`='.(int)$id_shop.' AND `id_lang`='.$lang))
				return false;
			return $result;
		}
		else {
			if (!$result = Db::getInstance()->getRow('SELECT `editor` FROM '._DB_PREFIX_.'footercustom_editor WHERE `id_lang`='.$lang))
				return false;
			return $result;
		}
	}

	public function getContent()
	{
		$this->_html .= '<h2>'.$this->displayName.' - v.'.$this->version.'</h2>
		<div id="lnkDocContainer">
			<a class="lnk" target="_blank" href="'.$this->_path.'doc/documentation.pdf">'.$this->l('PDF documentation').'</a>
			<a class="lnk" target="_blank" href="'.$this->_path.'doc/changelog.txt">'.$this->l('Changelog').'</a>
		</div>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post"><input style="margin:0 0 20px;" type="submit" name="submitCache" value="'.$this->l('Clear module cache').'" class="button" /></form>';
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$position = Tools::getValue('position_'.$defaultLanguage);
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
		}
		if (Tools::isSubmit('submitGeneral')) {
			Configuration::updateValue('FC_IMG', pSQL(Tools::getValue('fc_img')));
			if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
				if (isset($_FILES['footer_img']) AND isset($_FILES['footer_img']['tmp_name']) AND !empty($_FILES['footer_img']['tmp_name'])) {
					Configuration::set('PS_IMAGE_GENERATION_METHOD', 0);
					if (!copy($_FILES['footer_img']['tmp_name'], dirname(__FILE__).'/img/footer_img_'.(int)$id_shop.'.png'))
						$this->_html .= $this->displayError($this->l('An error occurred during the image upload'));
				}
			}
			else {
				if (isset($_FILES['footer_img']) AND isset($_FILES['footer_img']['tmp_name']) AND !empty($_FILES['footer_img']['tmp_name'])) {
					Configuration::set('PS_IMAGE_GENERATION_METHOD', 0);
					if (!copy($_FILES['footer_img']['tmp_name'], dirname(__FILE__).'/img/footer_img_1.png'))
						$this->_html .= $this->displayError($this->l('An error occurred during the image upload'));
				}
			}
			Configuration::updateValue('FC_TOPBLOCK', pSQL(Tools::getValue('fc_topblock')));
			Configuration::updateValue('FC_BOTTOMBLOCK', pSQL(Tools::getValue('fc_bottomblock')));
			Configuration::updateValue('FC_REINSURANCE', pSQL(Tools::getValue('fc_reinsurance')));
			Configuration::updateValue('FC_RESPONSIVE', pSQL(Tools::getValue('fc_responsive')));
			
			$company_name = Tools::getValue('company_name');
			$company_address1 = Tools::getValue('company_address1');
			$company_address2 = Tools::getValue('company_address2');
			$company_phone = Tools::getValue('company_phone');
			$company_mail = Tools::getValue('company_mail');
			if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
				Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_company (id, id_shop, name, address1, address2, phone, mail) VALUES (\''.(1).'\', \''.(int)$id_shop.'\', \''.addslashes($company_name).'\', \''.addslashes($company_address1).'\', \''.addslashes($company_address2).'\', \''.addslashes($company_phone).'\', \''.addslashes($company_mail).'\')');
			else
				Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_company (id, id_shop, name, address1, address2, phone, mail) VALUES (\''.(1).'\', \''.(1).'\', \''.addslashes($company_name).'\', \''.addslashes($company_address1).'\', \''.addslashes($company_address2).'\', \''.addslashes($company_phone).'\', \''.addslashes($company_mail).'\')');
			
			Configuration::updateValue('FC_SOCIAL', pSQL(Tools::getValue('fc_social')));
			$facebook_url = Tools::getValue('facebook_url');
			$twitter_url = Tools::getValue('twitter_url');
			$google_url = Tools::getValue('google_url');
			$pinterest_url = Tools::getValue('pinterest_url');
			$blog_url = Tools::getValue('blog_url');
			$rss_url = Tools::getValue('rss_url');
			if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
				Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_social (id, id_shop, facebook, twitter, google, pinterest, blog, rss) VALUES (\''.(1).'\', \''.(int)$id_shop.'\', \''.addslashes($facebook_url).'\', \''.addslashes($twitter_url).'\', \''.addslashes($google_url).'\', \''.addslashes($pinterest_url).'\', \''.addslashes($blog_url).'\', \''.addslashes($rss_url).'\')');
			else
				Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_social (id, id_shop, facebook, twitter, google, pinterest, blog, rss) VALUES (\''.(1).'\', \''.(1).'\', \''.addslashes($facebook_url).'\', \''.addslashes($twitter_url).'\', \''.addslashes($google_url).'\', \''.addslashes($pinterest_url).'\', \''.addslashes($blog_url).'\', \''.addslashes($rss_url).'\')');
			
			foreach ($languages as $language) {
				$title1 = Tools::getValue('title1_'.$language['id_lang']) ? Tools::getValue('title1_'.$language['id_lang']) : Tools::getValue('title1_'.$defaultLanguage);
				$title2 = Tools::getValue('title2_'.$language['id_lang']) ? Tools::getValue('title2_'.$language['id_lang']) : Tools::getValue('title2_'.$defaultLanguage);
				$title3 = Tools::getValue('title3_'.$language['id_lang']) ? Tools::getValue('title3_'.$language['id_lang']) : Tools::getValue('title3_'.$defaultLanguage);
				if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_blocktitles VALUES ('.$language['id_lang'].', \''.(int)$id_shop.'\', \''.addslashes($title1).'\', \''.addslashes($title2).'\', \''.addslashes($title3).'\')');
				else
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_blocktitles VALUES ('.$language['id_lang'].', "1", \''.addslashes($title1).'\', \''.addslashes($title2).'\', \''.addslashes($title3).'\')');
			}
			
			foreach ($languages as $language) {
				$reinsurancetitle1 = Tools::getValue('reinsurance1_title_'.$language['id_lang']) ? Tools::getValue('reinsurance1_title_'.$language['id_lang']) : Tools::getValue('reinsurance1_title_'.$defaultLanguage);
				$reinsurancedescription1 = Tools::getValue('reinsurance1_description_'.$language['id_lang']) ? Tools::getValue('reinsurance1_description_'.$language['id_lang']) : Tools::getValue('reinsurance1_description_'.$defaultLanguage);
				$reinsurancelink1 = Tools::getValue('reinsurance1_link_'.$language['id_lang']) ? Tools::getValue('reinsurance1_link_'.$language['id_lang']) : Tools::getValue('reinsurance1_link_'.$defaultLanguage);
				$reinsurancetitle2 = Tools::getValue('reinsurance2_title_'.$language['id_lang']) ? Tools::getValue('reinsurance2_title_'.$language['id_lang']) : Tools::getValue('reinsurance2_title_'.$defaultLanguage);
				$reinsurancedescription2 = Tools::getValue('reinsurance2_description_'.$language['id_lang']) ? Tools::getValue('reinsurance2_description_'.$language['id_lang']) : Tools::getValue('reinsurance2_description_'.$defaultLanguage);
				$reinsurancelink2 = Tools::getValue('reinsurance2_link_'.$language['id_lang']) ? Tools::getValue('reinsurance2_link_'.$language['id_lang']) : Tools::getValue('reinsurance2_link_'.$defaultLanguage);
				$reinsurancetitle3 = Tools::getValue('reinsurance3_title_'.$language['id_lang']) ? Tools::getValue('reinsurance3_title_'.$language['id_lang']) : Tools::getValue('reinsurance3_title_'.$defaultLanguage);
				$reinsurancedescription3 = Tools::getValue('reinsurance3_description_'.$language['id_lang']) ? Tools::getValue('reinsurance3_description_'.$language['id_lang']) : Tools::getValue('reinsurance3_description_'.$defaultLanguage);
				$reinsurancelink3 = Tools::getValue('reinsurance3_link_'.$language['id_lang']) ? Tools::getValue('reinsurance3_link_'.$language['id_lang']) : Tools::getValue('reinsurance3_link_'.$defaultLanguage);
				$reinsurancetitle4 = Tools::getValue('reinsurance4_title_'.$language['id_lang']) ? Tools::getValue('reinsurance4_title_'.$language['id_lang']) : Tools::getValue('reinsurance4_title_'.$defaultLanguage);
				$reinsurancedescription4 = Tools::getValue('reinsurance4_description_'.$language['id_lang']) ? Tools::getValue('reinsurance4_description_'.$language['id_lang']) : Tools::getValue('reinsurance4_description_'.$defaultLanguage);
				$reinsurancelink4 = Tools::getValue('reinsurance4_link_'.$language['id_lang']) ? Tools::getValue('reinsurance4_link_'.$language['id_lang']) : Tools::getValue('reinsurance4_link_'.$defaultLanguage);
				if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_reinsurance VALUES ("1", \''.(int)$id_shop.'\', '.$language['id_lang'].', \''.addslashes($reinsurancetitle1).'\', \''.addslashes($reinsurancedescription1).'\', \''.addslashes($reinsurancelink1).'\')');
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_reinsurance VALUES ("2", \''.(int)$id_shop.'\', '.$language['id_lang'].', \''.addslashes($reinsurancetitle2).'\', \''.addslashes($reinsurancedescription2).'\', \''.addslashes($reinsurancelink2).'\')');
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_reinsurance VALUES ("3", \''.(int)$id_shop.'\', '.$language['id_lang'].', \''.addslashes($reinsurancetitle3).'\', \''.addslashes($reinsurancedescription3).'\', \''.addslashes($reinsurancelink3).'\')');
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_reinsurance VALUES ("4", \''.(int)$id_shop.'\', '.$language['id_lang'].', \''.addslashes($reinsurancetitle4).'\', \''.addslashes($reinsurancedescription4).'\', \''.addslashes($reinsurancelink4).'\')');
				}
				else {
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_reinsurance VALUES ("1", "1", '.$language['id_lang'].', \''.addslashes($reinsurancetitle1).'\', \''.addslashes($reinsurancedescription1).'\', \''.addslashes($reinsurancelink1).'\')');
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_reinsurance VALUES ("2", "1", '.$language['id_lang'].', \''.addslashes($reinsurancetitle2).'\', \''.addslashes($reinsurancedescription2).'\', \''.addslashes($reinsurancelink2).'\')');
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_reinsurance VALUES ("3", "1", '.$language['id_lang'].', \''.addslashes($reinsurancetitle3).'\', \''.addslashes($reinsurancedescription3).'\', \''.addslashes($reinsurancelink3).'\')');
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_reinsurance VALUES ("4", "1", '.$language['id_lang'].', \''.addslashes($reinsurancetitle4).'\', \''.addslashes($reinsurancedescription4).'\', \''.addslashes($reinsurancelink4).'\')');
				}
			}
			
			foreach ($languages as $language) {
				$editor = Tools::getValue('editor_'.$language['id_lang']) ? Tools::getValue('editor_'.$language['id_lang']) : Tools::getValue('editor_'.$defaultLanguage);
				if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_editor VALUES ('.$language['id_lang'].', \''.(int)$id_shop.'\', \''.addslashes($editor).'\')');
				else 
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_editor VALUES ('.$language['id_lang'].', "1", \''.addslashes($editor).'\')');
			}
				
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		elseif (Tools::isSubmit('submitAddBlock')) {
			if (!$position OR $position <= 0 OR !Validate::isInt($position))
				$this->_html .= $this->displayError($this->l('Invalid position number'));
			else {
				if ($this->addBlock())
					$this->_html .= $this->displayConfirmation($this->l('The link has been added successfully'));
				else
					$this->_html .= $this->displayError($this->l('An error occured during link adding'));
			}
		}
		elseif (Tools::isSubmit('submitEditBlock')) {
			if (!$position OR $position <= 0 OR !Validate::isInt($position))
				$this->_html .= $this->displayError($this->l('Invalid position number'));
			else {
				if (!Tools::getValue('id') OR !is_numeric(Tools::getValue('id')) OR !$this->editBlock())
					$this->_html .= $this->displayError($this->l('An error occured during link editing'));
				else
					$this->_html .= $this->displayConfirmation($this->l('The link has been edited successfully'));
			}
		}
		elseif (Tools::getValue('id')) {
			if (!is_numeric(Tools::getValue('id')) OR !$this->deleteBlock())
				$this->_html .= $this->displayError($this->l('An error occurred during link deletion'));
			else
				$this->_html .= $this->displayConfirmation($this->l('The link has been deleted successfully'));
		}
		if (Tools::isSubmit('submitStyle')) {
			if (Validate::isInt(Tools::getValue('fc_width')))
				Configuration::updateValue('FC_WIDTH', pSQL(Tools::getValue('fc_width')));
			else
				$this->_html .= $this->displayError($this->l('Invalid footer maximum width'));
			if (Tools::getValue('fc_blockswidth') AND Validate::isInt(Tools::getValue('fc_blockswidth')))
				Configuration::updateValue('FC_BLOCKSWIDTH', pSQL(Tools::getValue('fc_blockswidth')));
			else
				$this->_html .= $this->displayError($this->l('Invalid links blocks width'));
			if (Tools::getValue('fc_basefontfamily') AND Validate::isName(Tools::getValue('fc_basefontfamily')))
				Configuration::updateValue('FC_BASEFONTFAMILY', pSQL(Tools::getValue('fc_basefontfamily')));
			else
				$this->_html .= $this->displayError($this->l('Invalid base font family'));
			if (Tools::getValue('fc_titlesfontfamily') AND Validate::isName(Tools::getValue('fc_titlesfontfamily')))
				Configuration::updateValue('FC_TITLESFONTFAMILY', pSQL(Tools::getValue('fc_titlesfontfamily')));
			else
				$this->_html .= $this->displayError($this->l('Invalid titles font family'));
			if (Tools::getValue('fc_basefontsize') AND Validate::isInt(Tools::getValue('fc_basefontsize')))
				Configuration::updateValue('FC_BASEFONTSIZE', pSQL(Tools::getValue('fc_basefontsize')));
			else
				$this->_html .= $this->displayError($this->l('Invalid base font size'));
			if (Tools::getValue('fc_titlesfontsize') AND Validate::isInt(Tools::getValue('fc_titlesfontsize')))
				Configuration::updateValue('FC_TITLESFONTSIZE', pSQL(Tools::getValue('fc_titlesfontsize')));
			else
				$this->_html .= $this->displayError($this->l('Invalid titles font size'));
			if (Tools::getValue('fc_maincolor'))
				Configuration::updateValue('FC_MAINCOLOR', pSQL(Tools::getValue('fc_maincolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid main color'));
			if (Tools::getValue('fc_altcolor'))
				Configuration::updateValue('FC_ALTCOLOR', pSQL(Tools::getValue('fc_altcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid alt color'));
			if (Tools::getValue('fc_topcolor'))
				Configuration::updateValue('FC_TOPCOLOR', pSQL(Tools::getValue('fc_topcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid top block background color'));
			if (Tools::getValue('fc_bottomcolor'))
				Configuration::updateValue('FC_BOTTOMCOLOR', pSQL(Tools::getValue('fc_bottomcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid bottom block background color'));
			if (Tools::getValue('fc_topfontcolor'))
				Configuration::updateValue('FC_TOPFONTCOLOR', pSQL(Tools::getValue('fc_topfontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid top block font color'));
			if (Tools::getValue('fc_bottomfontcolor'))
				Configuration::updateValue('FC_BOTTOMFONTCOLOR', pSQL(Tools::getValue('fc_bottomfontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid bottom block font color'));
			if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
				unlink(dirname(__FILE__).'/css/less/default.less.cache');
			if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
				unlink(dirname(__FILE__).'/css/less/responsive.less.cache');
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		if (Tools::isSubmit('submitCSS')) {
			if ($this->putFileContents())
				$this->_html .= $this->displayConfirmation($this->l('CSS file updated'));
			else
				$this->_html .= $this->displayError($this->l('No CSS file selected'));
		}
		if (Tools::isSubmit('submitNewsletter')) {
			Configuration::updateValue('FC_NEWSLETTER', pSQL(Tools::getValue('fc_newsletter')));
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		if (Tools::getValue('submitExportFC')) {
			$this->_file = ''.date('dmY').'.csv';
				$result = $this->getFooterCustom();
			if (!$nb = intval(Db::getInstance()->NumRows()))
				$this->_html .= $this->displayError($this->l('No customers were found'));
			elseif ($fd = @fopen(dirname(__FILE__).'/export/FooterCustomRegistered_'.$this->_file, 'w')) {
				foreach ($result as $tab)
					$this->putCSV($fd, $tab);
				fclose($fd);
				$this->_html .= $this->displayConfirmation($this->l('The CSV file has been successfully exported').' ('.$nb.' '.$this->l('customers found').')<br />>> <a href="../modules/footercustom/export/FooterCustomRegistered_'.$this->_file.'"><b>'.$this->l('Download the file').'</b></a>');
			}
			else
				$this->_html .= $this->displayError($this->l('Cannot write to').' '.dirname(__FILE__).'/FooterCustomRegistered_'.$this->_file.' !');
		}
		elseif (Tools::getValue('submitExportFCCustomers')) {
			$this->_file = ''.date('dmY').'.csv';
				$result = $this->getCustomers();
			if (!$nb = intval(Db::getInstance()->NumRows()))
				$this->_html .= $this->displayError($this->l('No customers were found'));
			elseif ($fd = @fopen(dirname(__FILE__).'/export/CustomersRegistered_'.$this->_file, 'w')) {
				foreach ($result as $tab)
					$this->putCSV($fd, $tab);
				fclose($fd);
				$this->_html .= $this->displayConfirmation($this->l('The CSV file has been successfully exported').' ('.$nb.' '.$this->l('customers found').')<br />>> <a href="../modules/footercustom/export/CustomersRegistered_'.$this->_file.'"><b>'.$this->l('Download the file').'</b></a>');
			}
			else
				$this->_html .= $this->displayError($this->l('Cannot write to').' '.dirname(__FILE__).'/CustomersRegistered_'.$this->_file.' !');
		}
		if (Tools::isSubmit('submitCache')) {
			if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
				unlink(dirname(__FILE__).'/css/less/default.less.cache');
			if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
				unlink(dirname(__FILE__).'/css/less/responsive.less.cache');
			$this->_html .= $this->displayConfirmation($this->l('Module cache cleared'));
		}
		$this->displayForm();
		return $this->_html;
	}
    
	public function displayForm()
	{
		global $cookie;
		$iso = Language::getIsoById((int)($cookie->id_lang));
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$this->_html .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'admin/css/admin.css" />
		<link rel="stylesheet" type="text/css" href="'.$this->_path.'admin/colorpicker/css/colorpicker.css" />
		<script type="text/javascript" src="'.$this->_path.'admin/js/admin.js"></script>
		<script type="text/javascript" src="'.$this->_path.'admin/colorpicker/js/colorpicker.js"></script>
		<div id="tab_container">
			<script type="text/javascript">var id_tab = '.'1'.';changeTab(id_tab);</script>
			<ul class="tabs">
				<li id="tab_1" class="tab active" onclick="changeTab(1);">'.$this->l('General configuration').'</li>
				<li id="tab_2" class="tab" onclick="changeTab(2);">'.$this->l('Graphical configuration').'</li>
				<li id="tab_3" class="tab" onclick="changeTab(3);">'.$this->l('CSS Editor').'</li>
				<li id="tab_4" class="tab" onclick="changeTab(4);">'.$this->l('Newsletter').'</li>
			</ul>
			<div id="content_1" class="content" style="display:block">';
				$this->configGeneral();
			$this->_html .= '</div>
			<div id="content_2" class="content" style="display:none">';
				$this->configStyle();
			$this->_html .= '</div>
			<div id="content_3" class="content" style="display:none">';
				$this->configCSS();
			$this->_html .= '</div>
			<div id="content_4" class="content" style="display:none">';
				$this->configNewsletter();
			$this->_html .= '</div>
		</div>';
		
		$isoTinyMCE = (file_exists(_PS_ROOT_DIR_.'/js/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en');
		$ad = dirname($_SERVER["PHP_SELF"]);
		$this->_html .= '<script type="text/javascript">	
			var iso = \''.$isoTinyMCE.'\' ;
			var pathCSS = \''._THEME_CSS_DIR_.'\' ;
			var ad = \''.$ad.'\' ;
		</script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tiny_mce/tiny_mce.js"></script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce.inc.js"></script>';
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$this->_html .= '<script type="text/javascript">
				$(document).ready(function(){
					tinySetup({
						theme_advanced_buttons1 : "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
						theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,,|,forecolor,backcolor",
						theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,|,ltr,rtl,|,fullscreen",
						theme_advanced_buttons4 : "styleprops,|,cite,abbr,acronym,del,ins,attribs,pagebreak",
						theme_advanced_resizing : false
					});
				});
			</script>';
		}
	}
	
	public function configGeneral()
	{
		global $cookie;
		$iso = Language::getIsoById((int)($cookie->id_lang));
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
		}
		$divLangName = 'title¤link';
		$divLangNameTitles = 'title1¤title2¤title3';
		$divLangNameBlock1 = 'rtitle1¤rdescription1¤rlink1';
		$divLangNameBlock2 = 'rtitle2¤rdescription2¤rlink2';
		$divLangNameBlock3 = 'rtitle3¤rdescription3¤rlink3';
		$divLangNameBlock4 = 'rtitle4¤rdescription4¤rlink4';
		$divLangNameEditor = 'editor';
		$this->_html .= '<script type="text/javascript">id_language = Number('.$defaultLanguage.');</script>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post" enctype="multipart/form-data">
			<fieldset>
				<h3>'.$this->l('General configuration options').'</h3>
				<div class="block mini" style="height:260px">
					<div class="inputContainer">
						<span class="label" style="width:105px">'.$this->l('Display image').' :</span>
						<input type="radio" name="fc_img" value="1" '.(Configuration::get('FC_IMG') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="fc_img" value="0" '.(!Configuration::get('FC_IMG') ? 'checked="checked"' : '').' />'.$this->l('No').'
						<p style="margin-top:5px">'.$this->l('Set whether the image is displayed or not').'</p>
					</div>';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
						$this->_html .= '<img src="'.$this->_path.'img/footer_img_'.(int)$id_shop.'.png" class="imgPreview" style="width:200px;height:70px;margin:10px 5px;padding:10px" />';
					}
					else {
						$this->_html .= '<img src="'.$this->_path.'img/footer_img_1.png" class="imgPreview" style="width:200px;height:70px;margin:10px 5px;padding:10px" />';
					}
					$this->_html .= '<div class="spaceSmall"></div>
					<input type="file" name="footer_img" />
					<p>'.$this->l('Set the image of the footer').'<br/>'.$this->l('Accepted formats :').' JPG, GIF, PNG</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Display top block').'</label>
					<div class="inputContainer">
						<input type="radio" name="fc_topblock" value="1" '.(Configuration::get('FC_TOPBLOCK') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="fc_topblock" value="0" '.(!Configuration::get('FC_TOPBLOCK') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the top block is displayed or not').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Display bottom block').'</label>
					<div class="inputContainer">
						<input type="radio" name="fc_bottomblock" value="1" '.(Configuration::get('FC_BOTTOMBLOCK') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="fc_bottomblock" value="0" '.(!Configuration::get('FC_BOTTOMBLOCK') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the bottom block is displayed or not').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Display reinsurance blocks').'</label>
					<div class="inputContainer">
						<input type="radio" name="fc_reinsurance" value="1" '.(Configuration::get('FC_REINSURANCE') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="fc_reinsurance" value="0" '.(!Configuration::get('FC_REINSURANCE') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the reinsurance blocks are displayed or not').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Activate responsive mode').'</label>
					<div class="inputContainer">
						<input type="radio" name="fc_responsive" value="1" '.(Configuration::get('FC_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="fc_responsive" value="0" '.(!Configuration::get('FC_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the responsive mode is activated or not (the template used must be compatible, disable this option if the template is not responsive)').'</p>
				</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('Company and social networks configuration').'</h3>
				<div class="block small" style="height:270px">';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
						$company = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
					else
						$company = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_company');
					$this->_html .= '<span class="label">'.$this->l('Company name').' :</span>
					<input type="text" size="20" name="company_name" id="company_name" class="inputText" value="'.$company['name'].'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Adress line 1').' :</span>
					<input type="text" size="20" name="company_address1" id="company_address1" class="inputText" value="'.$company['address1'].'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Adress line 2').' :</span>
					<input type="text" size="20" name="company_address2" id="company_address2" class="inputText" value="'.$company['address2'].'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Phone').' :</span>
					<input type="text" size="20" name="company_phone" id="company_phone" class="inputText" value="'.$company['phone'].'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('E-mail address').' :</span>
					<input type="text" size="20" name="company_mail" id="company_mail" class="inputText" value="'.$company['mail'].'" />
					<p>'.$this->l('Set the company informations').'</p>
				</div>
				<div class="block small" style="height:270px">';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
						$social = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
					else
						$social = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'footercustom_social');
					$this->_html .= '<div class="inputContainer">
						<span class="label" style="width:180px">'.$this->l('Display social networks').' :</span>
						<input type="radio" name="fc_social" value="1" '.(Configuration::get('FC_SOCIAL') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="fc_social" value="0" '.(!Configuration::get('FC_SOCIAL') ? 'checked="checked"' : '').' />'.$this->l('No').'
						<p style="margin-top:5px">'.$this->l('Set whether the social networks are displayed or not').'</p>
					</div>
					<span class="label">'.$this->l('URL Facebook').' :</span>
					<input type="text" size="20" name="facebook_url" id="facebook_url" class="inputText" value="'.$social['facebook'].'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('URL Twitter').' :</span>
					<input type="text" size="20" name="twitter_url" id="twitter_url" class="inputText" value="'.$social['twitter'].'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('URL Google +').' :</span>
					<input type="text" size="20" name="google_url" id="google_url" class="inputText" value="'.$social['google'].'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('URL Pinterest').' :</span>
					<input type="text" size="20" name="pinterest_url" id="pinterest_url" class="inputText" value="'.$social['pinterest'].'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('URL Blog').' :</span>
					<input type="text" size="20" name="blog_url" id="twitter_url" class="inputText" value="'.$social['blog'].'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('URL RSS feed').' :</span>
					<input type="text" size="20" name="rss_url" id="rss_url" class="inputText" value="'.$social['rss'].'" />
					<p>'.$this->l('Set the social networks urls').'</p>
				</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3 id="blockedit_h3">'.$this->l('Links blocks configuration').'</h3>
				<div id="blockedit" class="block auto">
					<label>'.$this->l('Add or edit a link').'</label>
					<span class="label" style="float:left;width:50px;margin-top:5px">'.$this->l('Title').' :</span>
					<div style="overflow:hidden">';
						foreach ($languages as $language)
						$this->_html .= '<div id="title_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
							<input type="text" size="20" name="title_'.$language['id_lang'].'" id="titleInput_'.$language['id_lang'].'" class="inputText float" value="" />
						</div>';
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'title', true);
					$this->_html .= '</div>
					<span class="label" style="float:left;width:50px;margin-top:15px;clear:both">'.$this->l('URL').' :</span>
					<div style="margin:10px 0;overflow:hidden">';
						foreach ($languages as $language)
						$this->_html .= '<div id="link_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
							<input type="text" size="20" name="link_'.$language['id_lang'].'" id="linkInput_'.$language['id_lang'].'" class="inputText float" value="" />
						</div>';
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'link', true);
					$this->_html .= '</div>
					<div style="float:left;width:100%;margin:0 0 10px">';
						foreach ($languages as $language)
						$this->_html .= '<div id="inblock_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float:left">
							<span class="label" style="float:left;width:50px;margin-top:5px">'.$this->l('Block N&ordm;').' :</span>
							<select name="inblock_'.$language['id_lang'].'" id="inblockInput_'.$language['id_lang'].'" style="width:45px;float:left">
								<option value="1">'.$this->l('1').'</option>
								<option value="2">'.$this->l('2').'</option>
								<option value="3">'.$this->l('3').'</option>
							</select>
							<span class="label" style="float:left;width:70px;margin-top:5px">'.$this->l('Position N&ordm;').' :</span>
							<input type="text" size="2" maxlength="2" name="position_'.$language['id_lang'].'" id="positionInput_'.$language['id_lang'].'" value="" />
						</div>';
					$this->_html .= '</div>
					<div style="float:left">
						<input type="hidden" name="id" id="id" value="'.(Tools::getValue('id') ? Tools::getValue('id') : '').'" />
						<input type="submit" id="submitAddBlock" name="submitAddBlock" value="'.$this->l('Add this link').'" class="button" style="display:block" />
						<input type="submit" id="submitEditBlock" name="submitEditBlock" value="'.$this->l('Edit this link').'" class="button" style="display:none" />
					</div>
					<div class="clear"></div>
					<p>'.$this->l('Set the title, the url and the location of the link').'</p>
				</div>';
				$this->listBlocks();
				$this->_html .= '<div class="block mini auto">
					<label>'.$this->l('Links block n&ordm;1').'</label>
					<span class="label" style="float:left;width:auto;margin-top:5px">'.$this->l('Title').' :</span>
					<div>';
						foreach ($languages as $language) {
							$blocktitle1 = $this->getBlockTitle1($language['id_lang']);
							$this->_html .= '<div id="title1_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="17" name="title1_'.$language['id_lang'].'" id="title1Input_'.$language['id_lang'].'" class="inputText float" value="'.$blocktitle1['title1'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameTitles, 'title1', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p>'.$this->l('Set the title of the links block n&ordm;1').'</p>';
					$this->displayBlocksList1();
				$this->_html .= '</div>
				<div class="block mini auto">
					<label>'.$this->l('Links block n&ordm;2').'</label>
					<span class="label" style="float:left;width:auto;margin-top:5px">'.$this->l('Title').' :</span>
					<div>';
						foreach ($languages as $language) {
							$blocktitle2 = $this->getBlockTitle2($language['id_lang']);
							$this->_html .= '<div id="title2_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="17" name="title2_'.$language['id_lang'].'" id="title2Input_'.$language['id_lang'].'" class="inputText float" value="'.$blocktitle2['title2'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameTitles, 'title2', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p>'.$this->l('Set the title of the links block n&ordm;2').'</p>';
					$this->displayBlocksList2();
				$this->_html .= '</div>
				<div class="block mini auto">
					<label>'.$this->l('Links block n&ordm;3').'</label>
					<span class="label" style="float:left;width:auto;margin-top:5px">'.$this->l('Title').' :</span>
					<div>';
						foreach ($languages as $language) {
							$blocktitle3 = $this->getBlockTitle3($language['id_lang']);
							$this->_html .= '<div id="title3_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="17" name="title3_'.$language['id_lang'].'" id="title3Input_'.$language['id_lang'].'" class="inputText float" value="'.$blocktitle3['title3'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameTitles, 'title3', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p>'.$this->l('Set the title of the links block n&ordm;3').'</p>';
					$this->displayBlocksList3();
				$this->_html .= '</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('Reinsurance blocks configuration').'</h3>
				<div class="block small auto">
					<label>'.$this->l('Reinsurance block n&ordm;1').'</label>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Title').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance1 = $this->getReinsurance1($language['id_lang']);
							$this->_html .= '<div id="rtitle1_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance1_title_'.$language['id_lang'].'" id="reinsurance1_title_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance1['title'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock1, 'rtitle1', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<div class="spaceSmall"></div>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Description').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance1 = $this->getReinsurance1($language['id_lang']);
							$this->_html .= '<div id="rdescription1_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance1_description_'.$language['id_lang'].'" id="reinsurance1_description_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance1['description'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock1, 'rdescription1', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<div class="spaceSmall"></div>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Link').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance1 = $this->getReinsurance1($language['id_lang']);
							$this->_html .= '<div id="rlink1_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance1_link_'.$language['id_lang'].'" id="reinsurance1_link_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance1['link'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock1, 'rlink1', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p>'.$this->l('Set the title, the description and the link of the reinsurance block n&ordm;1').'</p>
				</div>
				<div class="block small auto">
					<label>'.$this->l('Reinsurance block n&ordm;2').'</label>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Title').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance2 = $this->getReinsurance2($language['id_lang']);
							$this->_html .= '<div id="rtitle2_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance2_title_'.$language['id_lang'].'" id="reinsurance2_title_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance2['title'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock2, 'rtitle2', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<div class="spaceSmall"></div>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Description').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance2 = $this->getReinsurance2($language['id_lang']);
							$this->_html .= '<div id="rdescription2_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance2_description_'.$language['id_lang'].'" id="reinsurance2_description_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance2['description'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock2, 'rdescription2', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<div class="spaceSmall"></div>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Link').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance2 = $this->getReinsurance2($language['id_lang']);
							$this->_html .= '<div id="rlink2_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance2_link_'.$language['id_lang'].'" id="reinsurance2_link_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance2['link'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock2, 'rlink2', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p>'.$this->l('Set the title, the description and the link of the reinsurance block n&ordm;2').'</p>
				</div>
				<div class="block small auto">
					<label>'.$this->l('Reinsurance block n&ordm;3').'</label>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Title').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance3 = $this->getReinsurance3($language['id_lang']);
							$this->_html .= '<div id="rtitle3_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance3_title_'.$language['id_lang'].'" id="reinsurance3_title_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance3['title'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock3, 'rtitle3', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<div class="spaceSmall"></div>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Description').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance3 = $this->getReinsurance3($language['id_lang']);
							$this->_html .= '<div id="rdescription3_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance3_description_'.$language['id_lang'].'" id="reinsurance3_description_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance3['description'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock3, 'rdescription3', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<div class="spaceSmall"></div>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Link').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance3 = $this->getReinsurance3($language['id_lang']);
							$this->_html .= '<div id="rlink3_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance3_link_'.$language['id_lang'].'" id="reinsurance3_link_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance3['link'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock3, 'rlink3', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p>'.$this->l('Set the title, the description and the link of the reinsurance block n&ordm;3').'</p>
				</div>
				<div class="block small auto">
					<label>'.$this->l('Reinsurance block n&ordm;4').'</label>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Title').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance4 = $this->getReinsurance4($language['id_lang']);
							$this->_html .= '<div id="rtitle4_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance4_title_'.$language['id_lang'].'" id="reinsurance4_title_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance4['title'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock4, 'rtitle4', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<div class="spaceSmall"></div>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Description').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance4 = $this->getReinsurance4($language['id_lang']);
							$this->_html .= '<div id="rdescription4_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance4_description_'.$language['id_lang'].'" id="reinsurance4_description_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance4['description'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock4, 'rdescription4', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<div class="spaceSmall"></div>
					<span class="label" style="float:left;width:80px;margin-top:5px">'.$this->l('Link').' :</span>
					<div>';
						foreach ($languages as $language) {
							$reinsurance4 = $this->getReinsurance4($language['id_lang']);
							$this->_html .= '<div id="rlink4_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
								<input type="text" size="20" name="reinsurance4_link_'.$language['id_lang'].'" id="reinsurance4_link_'.$language['id_lang'].'" class="inputText float" value="'.$reinsurance4['link'].'" />
							</div>';
						}
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameBlock4, 'rlink4', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p>'.$this->l('Set the title, the description and the link of the reinsurance block n&ordm;4').'</p>
				</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('Editor configuration').'</h3>
				<div class="block auto editor_block">
					<label>'.$this->l('Editor content').'</label>';
					foreach ($languages as $language) {
						$editor = $this->getEditor($language['id_lang']);
						$this->_html .= '<div id="editor_'.$language['id_lang'].'" class="editor_space" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';margin:4px">
							<textarea class="rte" cols="80" rows="30" id="editorInput_'.$language['id_lang'].'" name="editor_'.$language['id_lang'].'">'.$editor['editor'].'</textarea>
						</div>';
					}
					$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameEditor, 'editor', true);
					$this->_html .= '<div class="clear"></div>
					<div class="spaceSmall"></div>
					<p>'.$this->l('Insert the informations of your choice (Images, texts, links...)').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitGeneral" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function configStyle()
	{
		$this->_html .= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<h3>'.$this->l('Graphical configuration options').'</h3>
				<div class="block small higher">
					<label>'.$this->l('Size of the footer').'</label>
					<span class="label">'.$this->l('Maximum width').' :</span>
					<input type="text" size="4" maxlength="4" name="fc_width" value="'.Configuration::get('FC_WIDTH').'" /><span class="unity">px</span>
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Blocks width').' :</span>
					<input type="text" size="4" maxlength="4" name="fc_blockswidth" value="'.Configuration::get('FC_BLOCKSWIDTH').'" /><span class="unity">px</span>
					<p>'.$this->l('Set the width of the top and bottom blocks and the maximum width of the footer').' '.$this->l('(set the maximum width to 0 for 100% width)').'</p>
				</div>
				<div class="block small higher">
					<label>'.$this->l('Fonts family').'</label>
					<span class="label">'.$this->l('Base font').' :</span>
					<input type="text" size="16" name="fc_basefontfamily" value="'.Configuration::get('FC_BASEFONTFAMILY').'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Titles font').' :</span>
					<input type="text" size="16" name="fc_titlesfontfamily" value="'.Configuration::get('FC_TITLESFONTFAMILY').'" />
					<p>'.$this->l('Set the family of the footer fonts').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Fonts size').'</label>
					<span class="label">'.$this->l('Base font').' :</span>
					<input type="text" size="4" maxlength="2" name="fc_basefontsize" value="'.Configuration::get('FC_BASEFONTSIZE').'" /><span class="unity">px</span>
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Titles font').' :</span>
					<input type="text" size="4" maxlength="2" name="fc_titlesfontsize" value="'.Configuration::get('FC_TITLESFONTSIZE').'" /><span class="unity">px</span>
					<p>'.$this->l('Set the size of the footer fonts').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Font color').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Top block').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="fc_topfontcolor" value="'.Configuration::get('FC_TOPFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('FC_TOPFONTCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Bottom block').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="fc_bottomfontcolor" value="'.Configuration::get('FC_BOTTOMFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('FC_BOTTOMFONTCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the color of the footer font').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Footer colors').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Main color').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="fc_maincolor" value="'.Configuration::get('FC_MAINCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('FC_MAINCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Alt color').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="fc_altcolor" value="'.Configuration::get('FC_ALTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('FC_ALTCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the colors of the footer').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Footer background colors').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Top block').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="fc_topcolor" value="'.Configuration::get('FC_TOPCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('FC_TOPCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Bottom block').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="fc_bottomcolor" value="'.Configuration::get('FC_BOTTOMCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('FC_BOTTOMCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the background colors of the footer').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitStyle" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function configCSS()
	{
		$dir = dirname(__FILE__)."/css/less/";
        $files = scandir($dir) ;
        $cnt = count($files) ;
        $this->_html .= '<script type="text/javascript">var baseDir = "'.$this->_path.'css/less/";</script>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<h3>'.$this->l('Warning').'</h3>
				<div class="warning">'.$this->l('Editing CSS file is only for experienced users. Edit these files only if you know what you are doing.').'<br />'.$this->l('Do not use any accent when you modify those CSS files, even in the comments.').'</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('List of CSS files (LESS files)').'</h3>
				<table class="table">
					<th>'.$this->l('Filename').'</th>
					<th class="center">'.$this->l('Edit').'</th>';
					for ($i = 0; $i < $cnt; $i++)
						if (preg_match('/.less$/', $files[$i])) {
							$link = '<a href="#editor" onclick="loadFile('.$i.');">';
							$link .= '<img src="'._PS_ADMIN_IMG_.'edit.gif" /></a>
							<input type="hidden" name="fileId" id="fileId" value="'.$i.'"/>
							<input type="hidden" name="fileName_'.$i.'" id="fileName_'.$i.'" value="'.$files[$i].'"/>';
							$this->_html .= '<tr>
								<td>'.$files[$i].'</td>
								<td class="center">'.$link.'</td>
							</tr>';
						}
				$this->_html .= '</table>
				<div>';
					$this->_html .= '<div id="editor">
						<textarea class="rte" cols="80" rows="30" id="contentCSS" name="contentCSS"></textarea>
						<input type="hidden" name="fileName" id="fileName" value=""/>
					</div>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitCSS" value="'.$this->l('Update the CSS file').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function configNewsletter()
	{
		$this->_fieldsExport = array(
		'SUSCRIBERS' => array(
		'title' => $this->l('Customers'),
		'type' => 'select',
		'value' => array(0 => $this->l('All customers'), 2 => $this->l('Subscribers'), 1 => $this->l('Non-subscribers')),
		'value_default' => 2));
		$this->_html .= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<h3>'.$this->l('Newsletter management').'</h3>
				<div class="block auto">
					<div class="inputContainer">
						<span class="label" style="width:180px">'.$this->l('Display newsletter').' :</span>
						<input type="radio" name="fc_newsletter" value="1" '.(Configuration::get('FC_NEWSLETTER') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="fc_newsletter" value="0" '.(!Configuration::get('FC_NEWSLETTER') ? 'checked="checked"' : '').' />'.$this->l('No').'
						<p style="margin-top:5px">'.$this->l('Set whether the newsletter is displayed or not').'</p>
					</div>
					<span class="label" style="width:auto">'.$this->l('Export list of visitors who have registered to the newsletter').' :</span>
					<div class="clear"></div>
					<input type="submit" name="submitExportFC" value="'.$this->l('Export CSV file').'" class="button" style="margin:5px 5px 0" />
					<div class="clear"></div>
					<div class="space"></div>
					<span class="label" style="width:auto">'.$this->l('Export list of customers who have registered to the newsletter').' :</span>
					<div class="clear"></div>
					<input type="submit" name="submitExportFCCustomers" value="'.$this->l('Export CSV file').'" class="button" style="margin:5px 5px 0" />
					<div class="space"></div>
					<p>'.$this->l('Warning : do not use the default block newsletter of Prestashop if you use the newsletter of the FooterCustom').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitNewsletter" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function putFileContents()
    {
        $filename = Tools::getValue('fileName');
		$file = dirname(__FILE__)."/css/less/".$filename;
		$balises = array('<br />', '<p>', '</p>');
		$replace = array("\n", "", "");
		$data = str_replace($balises, $replace, Tools::getValue('contentCSS'));
        $contents = htmlspecialchars_decode($data);
        if ($filename) {
			file_put_contents($file,$contents);
			return true;
		}
		else
			return false;
    }

	public function getBlocks($id_lang = null)
	{
		global $cookie;
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$blocks = Db::getInstance()->ExecuteS('SELECT f.`id_block`, fl.`position` FROM `'._DB_PREFIX_.'footercustom` f JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND `id_shop`='.(int)$id_shop.' AND fl.`id_lang` = '.intval($cookie->id_lang).') ORDER BY `position`'))
				return false;
		}
		else {
			if (!$blocks = Db::getInstance()->ExecuteS('SELECT f.`id_block`, fl.`position` FROM `'._DB_PREFIX_.'footercustom` f JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND fl.`id_lang` = '.intval($cookie->id_lang).') ORDER BY `position`'))
				return false;
		}
		$i = 0;
		foreach ($blocks as $block) {
			$result[$i]['id'] = $block['id_block'];
			if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
				$sql = 'SELECT `id_lang`, `title`, `link`, `inblock`, `position` FROM '._DB_PREFIX_.'footercustom_lang WHERE `id_block`='.(int)($block['id_block']).' AND `id_shop`='.(int)$id_shop;
			else
				$sql = 'SELECT `id_lang`, `title`, `link`, `inblock`, `position` FROM '._DB_PREFIX_.'footercustom_lang WHERE `id_block`='.(int)($block['id_block']);
			if (isset($id_lang) AND is_numeric($id_lang) AND (int)($id_lang) > 0)
				$sql .= ' AND `id_lang` = '.(int)($id_lang);
			if (!$texts = Db::getInstance()->ExecuteS($sql))
				return false;
			foreach ($texts as $text) {
				$result[$i]['title_'.$text['id_lang']] = $text['title'];
				$result[$i]['link_'.$text['id_lang']] = $text['link'];
				$result[$i]['inblock_'.$text['id_lang']] = $text['inblock'];
				$result[$i]['position_'.$text['id_lang']] = $text['position'];
			}
			$i++;
		}
		return $result;
	}

	public function listBlocks()
	{
		$blocks = $this->getBlocks();
		global $currentIndex, $adminObj;
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$token = Tools::safeOutput(Tools::getValue('token'));
		if ($blocks) {
			$this->_html .= '<script type="text/javascript">
				var currentUrl = \''.$currentIndex.'&configure='.$this->name.'\';';
				if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					$this->_html .= 'var token=\''.$token.'\';';
				else
					$this->_html .= 'var token=\''.$adminObj->token.'\';';
				$this->_html .= 'var blocks = new Array();';
				$var = '';
				foreach ($blocks as $block) {
					$var .= 'blocks['.$block['id'].'] = new Array(';
					$i = 0;
					foreach ($languages as $language) {
						if ($i > 0)
						$var .= ",";
						$var .= $language['id_lang'];
						$title = isset($block['title_'.$language['id_lang']]) ? $block['title_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes(html_entity_decode($title, ENT_QUOTES, 'UTF-8')).'\'';
						$link = isset($block['link_'.$language['id_lang']]) ? $block['link_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($link).'\'';
						$inblock = isset($block['inblock_'.$language['id_lang']]) ? $block['inblock_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($inblock).'\'';
						$position = isset($block['position_'.$language['id_lang']]) ? $block['position_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($position).'\'';
						$i++;
					}
					$var .= ');';
				}
			$var .= '</script>';
			$this->_html .= $var;
		}
	}

	public function displayBlocksList1()
	{
		$blocks = $this->getBlocks();
		global $cookie;
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		if (!$blocks)
			$this->_html .= '<p>'.$this->l('No links').'</p>';
		else {
			$this->_html .= '<table class="table" style="width:97%;max-width:100%;font-weight:normal">
				<tr>
					<th class="center" style="width:15px"></th>
					<th>'.$this->l('Title').'</th>
					<th class="center" style="width:60px">'.$this->l('Actions').'</th>
				</tr>';
				foreach ($blocks as $block) {
					$position = isset($block['position_'.$cookie->id_lang]) ? $block['position_'.$cookie->id_lang] : $block['position_'.$defaultLanguage];
					$title = isset($block['title_'.$cookie->id_lang]) ? $block['title_'.$cookie->id_lang] : $block['title_'.$defaultLanguage];
					if ($block['inblock_'.$cookie->id_lang] == 1) {
						$this->_html .= '<tr>
							<td class="center">'.$position.'</td>
							<td>'.$title.'</td>
							<td class="center">
								<a href="#blockedit_h3"><img src="'._PS_ADMIN_IMG_.'edit.gif" onclick="blockEdit('.$block['id'].')" style="padding:0" title="'.$this->l('Edit').'" /></a>
								<a href="#"><img src="'._PS_ADMIN_IMG_.'delete.gif" onclick="blockDelete('.$block['id'].');return false;" style="padding:0" title="'.$this->l('Delete').'" /></a>
							</td>
						</tr>';
					}
				}
			$this->_html .= '</table>
			<input type="hidden" id="languageFirst" value="'.$languages[0]['id_lang'].'" />
			<input type="hidden" id="languageNb" value="'.sizeof($languages).'" />';
		}
	}

	public function displayBlocksList2()
	{
		$blocks = $this->getBlocks();
		global $cookie;
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		if (!$blocks)
			$this->_html .= '<p>'.$this->l('No links').'</p>';
		else {
			$this->_html .= '<table class="table" style="width:97%;max-width:100%;font-weight:normal">
				<tr>
					<th class="center" style="width:15px"></th>
					<th>'.$this->l('Title').'</th>
					<th class="center" style="width:60px">'.$this->l('Actions').'</th>
				</tr>';
				foreach ($blocks as $block) {
					$position = isset($block['position_'.$cookie->id_lang]) ? $block['position_'.$cookie->id_lang] : $block['position_'.$defaultLanguage];
					$title = isset($block['title_'.$cookie->id_lang]) ? $block['title_'.$cookie->id_lang] : $block['title_'.$defaultLanguage];
					if ($block['inblock_'.$cookie->id_lang] == 2) {
						$this->_html .= '<tr>
							<td class="center">'.$position.'</td>
							<td>'.$title.'</td>
							<td class="center">
								<a href="#blockedit_h3"><img src="'._PS_ADMIN_IMG_.'edit.gif" onclick="blockEdit('.$block['id'].')" style="padding:0" title="'.$this->l('Edit').'" /></a>
								<a href="#"><img src="'._PS_ADMIN_IMG_.'delete.gif" onclick="blockDelete('.$block['id'].');return false;" style="padding:0" title="'.$this->l('Delete').'" /></a>
							</td>
						</tr>';
					}
				}
			$this->_html .= '</table>
			<input type="hidden" id="languageFirst" value="'.$languages[0]['id_lang'].'" />
			<input type="hidden" id="languageNb" value="'.sizeof($languages).'" />';
		}
	}

	public function displayBlocksList3()
	{
		$blocks = $this->getBlocks();
		global $cookie;
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		if (!$blocks)
			$this->_html .= '<p>'.$this->l('No links').'</p>';
		else {
			$this->_html .= '<table class="table" style="width:97%;max-width:100%;font-weight:normal">
				<tr>
					<th class="center" style="width:15px"></th>
					<th>'.$this->l('Title').'</th>
					<th class="center" style="width:60px">'.$this->l('Actions').'</th>
				</tr>';
				foreach ($blocks as $block) {
					$position = isset($block['position_'.$cookie->id_lang]) ? $block['position_'.$cookie->id_lang] : $block['position_'.$defaultLanguage];
					$title = isset($block['title_'.$cookie->id_lang]) ? $block['title_'.$cookie->id_lang] : $block['title_'.$defaultLanguage];
					if ($block['inblock_'.$cookie->id_lang] == 3) {
						$this->_html .= '<tr>
							<td class="center">'.$position.'</td>
							<td>'.$title.'</td>
							<td class="center">
								<a href="#blockedit_h3"><img src="'._PS_ADMIN_IMG_.'edit.gif" onclick="blockEdit('.$block['id'].')" style="padding:0" title="'.$this->l('Edit').'" /></a>
								<a href="#"><img src="'._PS_ADMIN_IMG_.'delete.gif" onclick="blockDelete('.$block['id'].');return false;" style="padding:0" title="'.$this->l('Delete').'" /></a>
							</td>
						</tr>';
					}
				}
			$this->_html .= '</table>
			<input type="hidden" id="languageFirst" value="'.$languages[0]['id_lang'].'" />
			<input type="hidden" id="languageNb" value="'.sizeof($languages).'" />';
		}
	}
	
	public function cacheCompileLess($inputFile, $outputFile) {
		if (!class_exists('lessc'))
			require_once dirname(__FILE__).'/lessc.inc.php';
		
		$cacheFile = $inputFile.'.cache';
		if (file_exists($cacheFile))
			$cache = unserialize(file_get_contents($cacheFile));
		else
			$cache = $inputFile;

		$less = new lessc;
		$less->setVariables(array(
			'fc_width' => Configuration::get('FC_WIDTH') > 0 ? Configuration::get('FC_WIDTH').'px' : '100%',
			'fc_blockswidth' => Configuration::get('FC_BLOCKSWIDTH').'px',
			'fc_basefontfamily' => Configuration::get('FC_BASEFONTFAMILY'),
			'fc_titlesfontfamily' => Configuration::get('FC_TITLESFONTFAMILY'),
			'fc_basefontsize' => Configuration::get('FC_BASEFONTSIZE').'px',
			'fc_titlesfontsize' => Configuration::get('FC_TITLESFONTSIZE').'px',
			'fc_maincolor' => '#'.Configuration::get('FC_MAINCOLOR'),
			'fc_altcolor' => '#'.Configuration::get('FC_ALTCOLOR'),
			'fc_topcolor' => '#'.Configuration::get('FC_TOPCOLOR'),
			'fc_bottomcolor' => '#'.Configuration::get('FC_BOTTOMCOLOR'),
			'fc_topfontcolor' => '#'.Configuration::get('FC_TOPFONTCOLOR'),
			'fc_bottomfontcolor' => '#'.Configuration::get('FC_BOTTOMFONTCOLOR')
		));
		
		$less->setFormatter("classic");
		$newCache = $less->cachedCompile($cache);

		if (!is_array($cache) || $newCache['updated'] > $cache['updated']) {
			file_put_contents($cacheFile, serialize($newCache));
			file_put_contents($outputFile, $newCache['compiled']);
		}
	}

	public function hookHeader($params)
	{	
		$this->cacheCompileLess(dirname(__FILE__).'/css/less/default.less', dirname(__FILE__).'/css/footercustom.css');
		$this->cacheCompileLess(dirname(__FILE__).'/css/less/responsive.less', dirname(__FILE__).'/css/footercustom-responsive.css');
		
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$this->context->controller->addCSS(($this->_path).'css/footercustom.css', 'all');
			if (Configuration::get('FC_RESPONSIVE') == 1)
				$this->context->controller->addCSS(($this->_path).'css/footercustom-responsive.css', 'all');
		}
		else {
			Tools::addCSS($this->_path.'css/footercustom.css', 'all');
			if (Configuration::get('FC_RESPONSIVE') == 1)
				Tools::addCSS($this->_path.'css/footercustom-responsive.css', 'all');
		}
	}

	public function hookFooter($params)
	{
		global $smarty, $cookie;
		if (Tools::isSubmit('submitFCNewsletter')) {
			$this->newsletterRegistration();
			if ($this->error) {
				$smarty->assign(array(
					'msg' => $this->error,
					'nw_value' => Tools::getValue('email') ? pSQL(Tools::getValue('email')) : false,
					'nw_error' => true
				));
			}
			elseif ($this->valid) {
				$smarty->assign(array(
					'msg' => $this->valid,
					'nw_error' => false
				));
			}
		}
		$blocktitle1 = $this->getBlockTitle1($cookie->id_lang);
		$blocktitle2 = $this->getBlockTitle2($cookie->id_lang);
		$blocktitle3 = $this->getBlockTitle3($cookie->id_lang);
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql1 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND `id_shop`='.(int)$id_shop.' AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 1
			ORDER BY `position`';
			$blocks1 = Db::getInstance()->ExecuteS($sql1);
			$sql2 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND `id_shop`='.(int)$id_shop.' AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 2
			ORDER BY `position`';
			$blocks2 = Db::getInstance()->ExecuteS($sql2);
			$sql3 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND `id_shop`='.(int)$id_shop.' AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 3
			ORDER BY `position`';
			$blocks3 = Db::getInstance()->ExecuteS($sql3);
			$company_name = Db::getInstance()->getRow('SELECT `name` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
			$company_address1 = Db::getInstance()->getRow('SELECT `address1` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
			$company_address2 = Db::getInstance()->getRow('SELECT `address2` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
			$company_phone = Db::getInstance()->getRow('SELECT `phone` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
			$company_mail = Db::getInstance()->getRow('SELECT `mail` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
			$facebook_url = Db::getInstance()->getRow('SELECT `facebook` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
			$twitter_url = Db::getInstance()->getRow('SELECT `twitter` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
			$google_url = Db::getInstance()->getRow('SELECT `google` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
			$pinterest_url = Db::getInstance()->getRow('SELECT `pinterest` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
			$blog_url = Db::getInstance()->getRow('SELECT `blog` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
			$rss_url = Db::getInstance()->getRow('SELECT `rss` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
			$smarty->assign('id_shop', $id_shop);
		}
		else {
			$sql1 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 1
			ORDER BY `position`';
			$blocks1 = Db::getInstance()->ExecuteS($sql1);
			$sql2 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 2
			ORDER BY `position`';
			$blocks2 = Db::getInstance()->ExecuteS($sql2);
			$sql3 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 3
			ORDER BY `position`';
			$blocks3 = Db::getInstance()->ExecuteS($sql3);
			$company_name = Db::getInstance()->getRow('SELECT `name` FROM '._DB_PREFIX_.'footercustom_company');
			$company_address1 = Db::getInstance()->getRow('SELECT `address1` FROM '._DB_PREFIX_.'footercustom_company');
			$company_address2 = Db::getInstance()->getRow('SELECT `address2` FROM '._DB_PREFIX_.'footercustom_company');
			$company_phone = Db::getInstance()->getRow('SELECT `phone` FROM '._DB_PREFIX_.'footercustom_company');
			$company_mail = Db::getInstance()->getRow('SELECT `mail` FROM '._DB_PREFIX_.'footercustom_company');
			$facebook_url = Db::getInstance()->getRow('SELECT `facebook` FROM '._DB_PREFIX_.'footercustom_social');
			$twitter_url = Db::getInstance()->getRow('SELECT `twitter` FROM '._DB_PREFIX_.'footercustom_social');
			$google_url = Db::getInstance()->getRow('SELECT `google` FROM '._DB_PREFIX_.'footercustom_social');
			$pinterest_url = Db::getInstance()->getRow('SELECT `pinterest` FROM '._DB_PREFIX_.'footercustom_social');
			$blog_url = Db::getInstance()->getRow('SELECT `blog` FROM '._DB_PREFIX_.'footercustom_social');
			$rss_url = Db::getInstance()->getRow('SELECT `rss` FROM '._DB_PREFIX_.'footercustom_social');
		}
		$reinsurance1 = $this->getReinsurance1($cookie->id_lang);
		$reinsurance2 = $this->getReinsurance2($cookie->id_lang);
		$reinsurance3 = $this->getReinsurance3($cookie->id_lang);
		$reinsurance4 = $this->getReinsurance4($cookie->id_lang);
		$editor = $this->getEditor($cookie->id_lang);
		$smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'fc_img' => Configuration::get('FC_IMG'),
			'fc_topblock' => Configuration::get('FC_TOPBLOCK'),
			'fc_bottomblock' => Configuration::get('FC_BOTTOMBLOCK'),
			'fc_reinsurance' => Configuration::get('FC_REINSURANCE'),
			'fc_social' => Configuration::get('FC_SOCIAL'),
			'fc_newsletter' => Configuration::get('FC_NEWSLETTER'),
			'blocktitle1' => $blocktitle1['title1'],
			'blocktitle2' => $blocktitle2['title2'],
			'blocktitle3' => $blocktitle3['title3'],
			'blocks1' => $blocks1,
			'blocks2' => $blocks2,
			'blocks3' => $blocks3,
			'company_name' => $company_name,
			'company_address1' => $company_address1,
			'company_address2' => $company_address2,
			'company_phone' => $company_phone,
			'company_mail' => $company_mail,
			'facebook_url' => $facebook_url,
			'twitter_url' => $twitter_url,
			'google_url' => $google_url,
			'pinterest_url' => $pinterest_url,
			'blog_url' => $blog_url,
			'rss_url' => $rss_url,
			'reinsurance1_title' => $reinsurance1['title'],
			'reinsurance1_description' => $reinsurance1['description'],
			'reinsurance1_link' => $reinsurance1['link'],
			'reinsurance2_title' => $reinsurance2['title'],
			'reinsurance2_description' => $reinsurance2['description'],
			'reinsurance2_link' => $reinsurance2['link'],
			'reinsurance3_title' => $reinsurance3['title'],
			'reinsurance3_description' => $reinsurance3['description'],
			'reinsurance3_link' => $reinsurance3['link'],
			'reinsurance4_title' => $reinsurance4['title'],
			'reinsurance4_description' => $reinsurance4['description'],
			'reinsurance4_link' => $reinsurance4['link'],
			'editor' => $editor['editor']
		));
		return $this->display(__FILE__, 'footercustom.tpl');
	}
}