<?php
/**
*  Please read the terms of the CLUF license attached to this module(cf "licences" folder)
*  
*  @author    Línea Gráfica E.C.E. S.L.
*  @copyright Lineagrafica.es - Línea Gráfica E.C.E. S.L. all rights reserved.
*  @license   https://www.lineagrafica.es/licenses/license_en.pdf https://www.lineagrafica.es/licenses/license_es.pdf https://www.lineagrafica.es/licenses/license_fr.pdf
*/

class lgimageblock4 extends Module
{
	protected $error = false;
	public $bootstrap;
	public function __construct()
	{
		$this->name = 'lgimageblock4';
		$this->tab = 'front_office_features';
		$this->version = '1.4.1';
		$this->author = 'Línea Gráfica';
		$this->module_key = 'c441c2fb39909e927d99f000645f0cf7';
		if (substr_count(_PS_VERSION_, '1.6') > 0)
			$this->bootstrap = true;
		else
			$this->bootstrap = false;
			parent::__construct();

			$this->displayName = $this->l('Image Block - Banner Ad 4');
			$this->description = $this->l('Add an image block to the left, right or center column of your store.');

		/* Backward compatibility */
		if (_PS_VERSION_ < '1.5')
			require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
	}

	public function install()
	{
		if (substr_count(_PS_VERSION_, '1.6') > 0)
		{
			if (parent::install() == false || $this->registerHook('leftColumn') == false)
				return false;
		}
		else
		{
			if (parent::install() == false || $this->registerHook('leftColumn') == false)
				return false;
		}

		$query = 'CREATE TABLE '._DB_PREFIX_.'lgimageblock4 (`id_lang` int(2) NOT NULL, `width` varchar(255) NOT NULL, `height` varchar(255) NOT NULL, `link` text NOT NULL, `content` text NOT NULL, PRIMARY KEY(`id_lang`)) ENGINE=MyISAM default CHARSET=utf8';
		if (!Db::getInstance()->Execute($query))
			return false;
		return true;
	}

	public function uninstall()
	{
		if (parent::uninstall() == false)
			return false;
		if (!Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.'lgimageblock4'))
			return false;
		return true;
	}

	private function formatBootstrap($text)
	{
		$text = str_replace('<fieldset>', '<div class="panel">', $text);
		$text = str_replace('<fieldset style="background:#DFF2BF;color:#4F8A10;border:1px solid #4F8A10;">', '<div class="panel"  style="background:#DFF2BF;color:#4F8A10;border:1px solid #4F8A10;">', $text);
		$text = str_replace('</fieldset>', '</div>', $text);
		$text = str_replace('<legend>', '<h3>', $text);
		$text = str_replace('</legend>', '</h3>', $text);
		return $text;
	}

	private function getP()
	{
		$default_lang = $this->context->language->id;
		$lang = Language::getIsoById($default_lang);
		$pl = array('es','fr');
		if (!in_array($lang, $pl))
			$lang = 'en';

		echo '<link href="'._MODULE_DIR_.$this->name.'/views/css/publi/style.css" rel="stylesheet" type="text/css"/>';
		$base = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off')  ? 'https://'.$this->context->shop->domain_ssl : 'http://'.$this->context->shop->domain);
		if (version_compare(_PS_VERSION_, '1.5.0', '>'))
			$uri = $base.$this->context->shop->getBaseURI();
		else
			$uri = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off')  ? 'https://'._PS_SHOP_DOMAIN_SSL_DOMAIN_:'http://'._PS_SHOP_DOMAIN_).__PS_BASE_URI__;

		$path = _PS_MODULE_DIR_.$this->name.DIRECTORY_SEPARATOR.'views'.DIRECTORY_SEPARATOR.'publi'.DIRECTORY_SEPARATOR.$lang.DIRECTORY_SEPARATOR.'index.php';
		$object = Tools::file_get_contents($path);
		$object = str_replace('src="/modules/', 'src="'.$uri.'modules/', $object);

		return $object;
	}

	public function hookDisplayHome($params)
	{
		$lgimageblock4 = $this->getlgimageblock4($this->context->cookie->id_lang);

		$this->context->smarty->assign(array(
			'height' => $lgimageblock4['height'],
			'width' => $lgimageblock4['width'],
			'lgimageblock4_content' => $lgimageblock4['content'],
			'lgimageblock4_link' => $lgimageblock4['link'],
		));
		if (!$lgimageblock4)
			return false;
		return $this->display(__FILE__, 'views/templates/hook/lgimageblock4.tpl');
	}

	public function hookLeftColumn($params)
	{
		return $this->hookDisplayHome($params);
	}

	public function hookDisplayHomeTab($params)
	{
		return $this->hookDisplayHome($params);
	}

	public function hookDisplayHomeTabContent($params)
	{
		return $this->hookDisplayHome($params);
	}

	public function hookRightColumn($params)
	{
		return $this->hookDisplayHome($params);
	}

	public function getlgimageblock4($lang)
	{
		$result = array();
		if (!$result = Db::getInstance()->getRow('SELECT `width`, `height`, `content`, `link` FROM '._DB_PREFIX_.'lgimageblock4 WHERE `id_lang`='.$lang))
			return false;
		return $result;
	}

	public function addlgimageblock4()
	{
		$languages = Language::getLanguages();
		$defaultLanguage = (int)Configuration::get('PS_LANG_DEFAULT');
		if (!$languages)
			return false;
			if ($_POST)
			{
				foreach ($languages as $language)
				{
					$lgimageblock4 = $this->getlgimageblock4($language['id_lang']);
					$imagename = $lgimageblock4['content'];
					echo $imagename;
					// upload image
					if (is_uploaded_file($_FILES['content_'.$language['id_lang']]['tmp_name']))
					{
						if (move_uploaded_file($_FILES['content_'.$language['id_lang']]['tmp_name'], dirname(__FILE__).'/files/'.$_FILES['content_'.$language['id_lang']]['name']))
						{
							$imagename = $_FILES['content_'.$language['id_lang']]['name'];
							$this->_html .= $this->displayConfirmation($this->l('The image has been successfully uploaded for the language ').$this->l($language['name']));
						}
						else
							$this->_html .= $this->displayError($this->l('An error occurred while uploading the image'));
					}
					else
						$this->_html .= $this->displayConfirmation($this->l('The image has not been uploaded for the language ').$this->l($language['name']));
					if (Tools::getValue('width_'.$language['id_lang'], 0) || Tools::getValue('height_'.$language['id_lang'], 0) || Tools::getValue('link_'.$language['id_lang'], 0))
					{
						if (!Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'lgimageblock4 VALUES ('.(int)$language['id_lang'].', \''.Tools::getValue('width_'.$language['id_lang'], 0).'\', \''.Tools::getValue('height_'.$language['id_lang'], 0).'\', \''.Tools::getValue('link_'.$language['id_lang'], 0).'\', \''.$imagename.'\')'))
							return false;
					}
				}
			}

			else
				if (!Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'lgimageblock4 WHERE `id_lang`='.(int)$language['id_lang']))
					return false;
	return true;
	}

	/**
	* Displays flash block help
	*/
	private function _displaylgimageblock4Help()
	{
		$this->_html .= '<br />';
	}

	/**
	* Back office control panel for flash blocks
	*/
	public function getContent()
	{
		$this->_html = $this->getP().'<h2>'.$this->displayName.'</h2>';

			/* Add a flash block */
			if (Tools::getIsset('submitlgimageblock4Add'))
			{
					if ($this->addlgimageblock4())
						$this->_html .= $this->displayConfirmation($this->l('The image block has been successfully added'));
					else
						$this->_html .= $this->displayError($this->l('An error occurred while creating the image block'));
			}

		$this->_displaylgimageblock4Help();
			$this->_displayForm();

			if ($this->bootstrap == true)
				$this->_html = $this->formatBootstrap($this->_html);
			return $this->_html;
	}

	/**
	* Displays the image block and title management form
	*/

	private function oLang($params, $sp)
	{
		$var = '<script type="text/javascript">
		';
		$ocultos = explode($sp, $params);
		$count = count($ocultos);
		for ($i = 0; $i < $count; $i++)
		{
			$var .= 'oLang(\'languages_'.$ocultos[$i].'\');
			';
		}
		$var .= '</script>
		';
		return $var;
	}

	private function _displayForm()
	{
		$cookie = $this->context->cookie;
		/* Language */
		$defaultLanguage = (int)Configuration::get('PS_LANG_DEFAULT');
		$languages = Language::getLanguages();
		$divLangName = 'widthdiv¤heightdiv¤linkdiv¤contentdiv¤previewdiv';

		/* Form */
		$this->_html .= '
		<script type="text/javascript">
			id_language = Number('.$defaultLanguage.');
		</script>	 	
		<script type="text/javascript">
			function oLang(campo)
			{
				document.getElementById(campo).style.display=\'none\';
			}
		</script>	 	
	 	<fieldset>
			<legend><a href="../modules/lgimageblock/readme/readme_'.$this->l('en').'.pdf#page=5" target="_blank"> '.$this->l('Configuration').' <img src="../modules/lgimageblock2/views/img/info.png"></a></legend>
			<form method="post" action="'.$_SERVER['REQUEST_URI'].'" enctype="multipart/form-data">
				<label>'.$this->l('Width (px):').'</label>
				<div class="margin-form">';
					foreach ($languages as $language)
					{
						/* Grab image block width */
						$lgimageblock4 = $this->getlgimageblock4($language['id_lang']);
						$this->_html .= '
					<div id="widthdiv_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';">
						<input type="text" name="width_'.$language['id_lang'].'" value="'.$lgimageblock4['width'].'" />
					</div>';
					}
					$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'widthdiv', true);
					$this->_html .= '
					<div class="clear"></div>
				</div><br>
				<label>'.$this->l('Height (px):').'</label>
				<div class="margin-form">';
					foreach ($languages as $language)
					{
						/* Grab image block height */
						$lgimageblock4 = $this->getlgimageblock4($language['id_lang']);
						$this->_html .= '
					<div id="heightdiv_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';">
						<input type="text" name="height_'.$language['id_lang'].'" value="'.$lgimageblock4['height'].'" />
					</div>';
					}
					$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'heightdiv', true);
					$this->_html .= '
					<div class="clear"></div>
				</div><br>
				<label>'.$this->l('Link:').'</label>
				<div class="margin-form">';
					foreach ($languages as $language)
					{
						/* Grab image block link */
						$lgimageblock4 = $this->getlgimageblock4($language['id_lang']);
						$this->_html .= '
					<div id="linkdiv_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';">
						<input type="text" name="link_'.$language['id_lang'].'" value="'.$lgimageblock4['link'].'" />
					</div>';
					}
					$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'linkdiv', true);
					$this->_html .= '
					<div class="clear"></div>
				</div><br>
				<label>'.$this->l('Image:').'</label>
				<div class="margin-form">';
					foreach ($languages as $language)
					{
						/* Grab flash block content */
						$lgimageblock4 = $this->getlgimageblock4($language['id_lang']);
						$this->_html .= '
					<div id="contentdiv_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';">
						<input type="file" name="content_'.$language['id_lang'].'" id="contentInput_'.$language['id_lang'].'">
					</div>';
					}
					$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'contentdiv', true);
					$this->_html .= '
					<div class="clear"></div>
				</div><br>
				<div class="margin-form">';
					$this->_html .= '<input type="submit" class="button" name="submitlgimageblock4Add" value="'.$this->l('Save').'" id="submitlgimageblock4Add" />';
					$this->_html .= '					
				</div><br>
				<label>'.$this->l('Preview:').'</label>
				<div class="margin-form">';
					foreach ($languages as $language)
					{
						$lgimageblock4 = $this->getlgimageblock4($language['id_lang']);
						$this->_html .= '
					<div id="previewdiv_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';">
					<img src="../modules/lgimageblock4/files/'.$lgimageblock4['content'].'" width="'.$lgimageblock4['width'].'" height="'.$lgimageblock4['height'].'"></div>';
					}
					$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'previewdiv', true);
					$this->_html .= '
				</div>';
				$this->_html .= $this->oLang($divLangName, '¤');
				$this->_html .= '
			</form>
		</fieldset>';
	}
}
?>