<?php
/**
* ProQuality (c) All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at addons4prestashop@gmail.com.
*
* @author    Andrei Cimpean (ProQuality) <addons4prestashop@gmail.com>
* @copyright 2015-2016 ProQuality
* @license   Do not edit, modify or copy this file
*/

header('Access-Control-Allow-Origin: *');
#if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))
#{
require_once(dirname(__FILE__).'/../../config/config.inc.php');

require_once(dirname(__FILE__).'/../../init.php');

ini_set('max_execution_time', '2880');

$module = Module::getInstanceByName('livechatpro');

$module->context->employee->id = Tools::getValue('id_employee');

$module->context->cookie->id_employee = Tools::getValue('id_employee');

$filename = pathinfo(__FILE__, PATHINFO_FILENAME);

$type = Tools::isSubmit('type') ? Tools::getValue('type') : false;

$request_data = Tools::getValue('data');


if ($type != 'popupChat' && $type != 'newChatAlert')
{
	if (Tools::isSubmit('token'))
	{
		if (!$module->isTokenValid(Tools::getValue('token')))
			die('Invalid Token!');
	}
	else
		die('Invalid Token!');
}

switch ($type)
{
	case 'departments':
	case 'staffprofiles':
	case 'predefinedmessages':
	case 'onlinevisitors':
	case 'archive':
	case 'visitorarchive':
	case 'messages':
	case 'visitormessages':
	case 'ratings':
	case 'visitorratings':
	case 'logs':
	case 'visitorlogs':
		$response = $module->fillGridDataTables($type, $_POST );
		break;

	case 'getDepartment':
		$data = $module->getDepartment( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'syncOnlineVisitors':
		$module->syncOnlineVisitors( Tools::getValue('data') );
		$is_chat_invitation = $module->isChatInvitation( Tools::getValue('data') );
		$ajax_chat_tpl = $module->syncFrontChatDialog(false, 'ajax.chat.tpl');
		$status = $module->getChatStatus();

		$response = array(
			'success' => true,
			'response' => array(
				'id_visitor' => $request_data['id_visitor'],
				'is_chat_invitation' => $is_chat_invitation,
				'ajax.chat.tpl' => $ajax_chat_tpl,
				'status' => $status,
			)
		);
		
		die(Tools::jsonEncode($response));
		#die($data);

	case 'countOnlineVisitors':
		$data = $module->countOnlineVisitors();
		die($data);

	case 'addUpdateVisitor':
		$data = $module->addUpdateVisitor( Tools::getValue('data') );
		die($data);

	case 'syncStaffProfiles':
		$data = $module->syncStaffProfiles();
		die($data);

	case 'transferVisitor':
		$data = $module->transferVisitor( Tools::getValue('data') );
		die(Tools::jsonEncode($data));		

	case 'syncMouseTracking':
		$data = $module->syncMouseTracking( Tools::getValue('data') );
		die($data);

	case 'getMouseTracking':
		$data = $module->getMouseTracking( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'getTheme':
		$data = $module->getTheme( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'getIconset':
		$data = $module->getIconset( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'getSetting':
		$data = $module->getSetting( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'getVisitor':
		$data = $module->getVisitor( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'chatRequestFromStaffToStaff':
		$data = $module->chatRequestFromStaffToStaff( Tools::getValue('data') );
		die( $data );

	case 'showVisitorDetails':
	case 'showVisitorVisitedPagesHistory':
	case 'showVisitorGeoTracking':
		$module->assignVisitorDetails( Tools::getValue('data') );
		$ajax_visitor_details_tpl = $module->display(dirname(__FILE__), '/views/templates/admin/ajax.visitor_details.tpl');
		$ajax_visitor_visited_pages_history_tpl = $module->display(dirname(__FILE__), '/views/templates/admin/ajax.visitor_visited_pages_history.tpl');
		$ajax_visitor_geotracking_tpl = $module->display(dirname(__FILE__), '/views/templates/admin/ajax.visitor_geotracking.tpl');

		$response = array(
			'success' => true,
			'response' => array(
				'ajax.visitor_details.tpl' => $ajax_visitor_details_tpl,
				'ajax.visitor_visited_pages_history.tpl' => $ajax_visitor_visited_pages_history_tpl,
				'ajax.visitor_geotracking.tpl' => $ajax_visitor_geotracking_tpl,
			)
		);

		die(Tools::jsonEncode($response));

	/*case 'showInviteToChat':
		$module->chatRequestFromStaff( Tools::getValue('data') );
		$data = $module->syncChatDialog(false, 'ajax.chats.tpl');
		die( $data );*/

	case 'showOnlineInternalUsers':
		$data = $module->showOnlineInternalUsers( Tools::getValue('data') );
		die( $data );

	case 'showMouseTracking':
		$data = $module->showMouseTracking( Tools::getValue('data') );
		die( $data );

	case 'getCookie':
		$data = $module->getCookie( Tools::getValue('data') );
		die($data);

	case 'setCookie':
		$data = $module->setCookie( Tools::getValue('data') );
		die($data);

	case 'addRating':
		$data = $module->addRating( Tools::getValue('data') );
		#print_r($module->context->language);
		die( $module->l('The rating was added!', $filename) );

	case 'getRating':
		$data = $module->getRating( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'replyToMessage':
		$data = $module->replyToMessage( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'getMessage':
		$data = $module->getMessage( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'getPredefinedMessage':
		$data = $module->getPredefinedMessage( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'addMessage':
		$data = $module->addMessage( Tools::getValue('data') );
		die( $module->l('The message was succesfully sent!', $filename) );

	case 'clearDatabase':
		$data = $module->clearDatabase();
		die( $module->l('The database was succesfully cleared!', $filename) );


	case 'deleteSettings':

		$result = $module->deleteSettings( Tools::getValue('data') );
		
		if ($result === true)
			$response = array(
				'success' => true,
				'response' => $module->showSettingsDropdown()
			);
		elseif ($result == 'ERROR_DEMO_MODE')
			$response = array(
				'success' => false,
				'response' => $module->l('You can`t delete the settings in DEMO MODE!', $filename)
			);
		
		die(Tools::jsonEncode($response));


	case 'savePerformanceSettings':

		$result = $module->savePerformanceSettings( Tools::getValue('data') );

		if ($result === true)
			$response = array(
				'success' => true,
				'response' => $module->l('The save was successful!', $filename)
			);
		elseif ($result == 'ERROR_DEMO_MODE')
			$response = array(
				'success' => false,
				'response' => $module->l('You can`t save settings in DEMO MODE!', $filename)
			);
		
		die(Tools::jsonEncode($response));

	case 'saveSettings':

		$result = $module->saveSettings( Tools::getValue('data') );

		if ($result === true)
			$response = array(
				'success' => true,
				'response' => $module->l('The save was successful!', $filename)
			);
		elseif ($result == 'ERROR_DEMO_MODE')
			$response = array(
				'success' => false,
				'response' => $module->l('You can`t save settings in DEMO MODE!', $filename)
			);
		
		die(Tools::jsonEncode($response));

	case 'saveAsSettings':
		$module->saveAsSettings( Tools::getValue('data') );
		die( $module->showSettingsDropdown() );

	case 'deleteTheme':
		$result = $module->deleteTheme( Tools::getValue('data') );
		
		if ($result === true)
			$response = array(
				'success' => true,
				'response' => $module->showThemesDropdown()
			);
		elseif ($result == 'ERROR_DEMO_MODE')
			$response = array(
				'success' => false,
				'response' => $module->l('You can`t delete the settings in DEMO MODE!', $filename)
			);
		
		die(Tools::jsonEncode($response));


	case 'saveTheme':

		$result = $module->saveTheme( Tools::getValue('data') );

		if ($result === true)
			$response = array(
				'success' => true,
				'response' => $module->l('The save was successful!', $filename)
			);
		elseif ($result == 'ERROR_DEMO_MODE')
			$response = array(
				'success' => false,
				'response' => $module->l('You can`t save settings in DEMO MODE!', $filename)
			);
		
		die(Tools::jsonEncode($response));


	case 'saveAsTheme':
		$module->saveAsTheme( Tools::getValue('data') );
		die( $module->showThemesDropdown() );

	case 'deleteIconset':

		$result = $module->deleteIconset( Tools::getValue('data') );
		
		if ($result === true)
			$response = array(
				'success' => true,
				'response' => $module->showIconsetsDropdown()
			);
		elseif ($result == 'ERROR_DEMO_MODE')
			$response = array(
				'success' => false,
				'response' => $module->l('You can`t delete the settings in DEMO MODE!', $filename)
			);
		
		die(Tools::jsonEncode($response));


	case 'saveIconset':

		$result = $module->saveIconset( Tools::getValue('data') );

		if ($result === true)
			$response = array(
				'success' => true,
				'response' => $module->l('The save was successful!', $filename)
			);
		elseif ($result == 'ERROR_DEMO_MODE')
			$response = array(
				'success' => false,
				'response' => $module->l('You can`t save settings in DEMO MODE!', $filename)
			);
		
		die(Tools::jsonEncode($response));


	case 'saveAsIconset':
		$module->saveAsIconset( Tools::getValue('data') );
		die( $module->showIconsetsDropdown() );


	case 'updateMessage':
		$data = $module->updateMessage( Tools::getValue('data') );
		die( $module->l('The message was updated!', $filename) );

	case 'updateRating':
		$data = $module->updateRating( Tools::getValue('data') );
		die( $module->l('The rating was updated!', $filename) );

	case 'deleteArchive':
		$data = $module->deleteArchive( Tools::getValue('data') );
		die( $module->l('The archive was deleted!', $filename) );

	case 'deleteMessage':
		$data = $module->deleteMessage( Tools::getValue('data') );
		die( $module->l('The message was deleted!', $filename) );

	case 'deleteRating':
		$data = $module->deleteRating( Tools::getValue('data') );
		die( $module->l('The rating was deleted!', $filename) );


	case 'getStaffProfile':
		$data = $module->getStaffProfile( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'getArchive':
		$data = $module->getArchive( Tools::getValue('data') );
		die(Tools::jsonEncode($data));

	case 'chatAcceptedFromStaff':
		$data = $module->chatAcceptedFromStaff( Tools::getValue('data') );
		die($data);

	case 'chatAcceptedFromClient':
		$data = $module->chatAcceptedFromClient( Tools::getValue('data') );
		die($data);

	case 'chatDeniedFromClient':
		$data = $module->chatDeniedFromClient( Tools::getValue('data') );
		die($data);

	case 'chatClosedFromStaff':
		$data = $module->chatClosedFromStaff( Tools::getValue('data') );
		die($data);

	case 'chatMessageFromStaff':
		$data = $module->chatMessageFromStaff( Tools::getValue('data') );
		die($data);

	case 'chatRequestFromStaff':
		$data = $module->chatRequestFromStaff( Tools::getValue('data') );
		die($data);

	case 'chatRequestFromClient':
		$data = $module->chatRequestFromClient( Tools::getValue('data') );
		die($data);

	case 'chatMessageFromClient':
		$data = $module->chatMessageFromClient( Tools::getValue('data') );
		die($data);

	case 'chatClosedFromClient':
		$data = $module->chatClosedFromClient( Tools::getValue('data') );
		die($data);

	/*case 'syncComet':
		$data = $module->syncComet( Tools::getValue('action'), Tools::getValue('id_visitor'), Tools::getValue('data'), Tools::getValue('timestamp') );
		die($data);*/


	case 'syncFrontChatDialog':
		$ajax_start_chat_tpl = $module->syncFrontChatDialog(false, 'ajax.start_chat.tpl');

		$response = array(
			'success' => true,
			'response' => array(
				'ajax.start_chat.tpl' => $ajax_start_chat_tpl,
				/*'staff_typing' => $staff_typing,*/
			)
		);
		
		die(Tools::jsonEncode($response));
		#die($data);

	case 'syncChatDialog':
		$module->syncOnlineUsers();
		$ajax_chats_tpl = $module->syncChatDialog(false, 'ajax.chats.tpl');
		$awaiting_response_from_staff_archives = $module->countAwaitingResponseFromStaffArchives();

		$response = array(
			'success' => true,
			'response' => array(
				'ajax.onlineusers.tpl' => $module->display(dirname(__FILE__), '/views/templates/admin/ajax.onlineusers.tpl'),
				'ajax.chats.tpl' => $ajax_chats_tpl,
				'ajax.header_chats_counter.tpl' => $awaiting_response_from_staff_archives,
				/*'visitor_typing' => $visitor_typing,*/
			)
		);
		
		die(Tools::jsonEncode($response));
		#die($data);

	case 'countAwaitingResponseFromStaffArchives':
		$data = $module->countAwaitingResponseFromStaffArchives();
		die($data);

	case 'changeStaffStatus':
		$result = $module->changeStaffStatus( Tools::getValue('data') );

		if ($result == false)
			$response = array(
				'success' => false,
				'response' => $module->l('You can`t change the status of an inactive profile!', $filename)
			);
		else
			$response = array(
				'success' => true,
				'response' => $result
			);
		
		die(Tools::jsonEncode($response));

	case 'countOnlineVisitors':
		$data = $module->countOnlineVisitors();
		die($data);

	case 'getOurModules':
		$data = $module->getOurModules();
		die($data);

	case 'img':
		$name = 'img/offline.png';
		$fp = fopen($name, 'rb');

		header('Content-Type: image/png');
		header('Content-Length: '.filesize($name));

		fpassthru($fp);
		break;

	case 'popupChat':
		$data = $module->popupChat( Tools::getValue('data') );
		die($data);

	case 'newChatAlert':
		$data = $module->l('You have new incoming chat request!', $filename);
		die($data);

	default:
	break;
}
#}
?>