<?php
/**
* ProQuality (c) All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at addons4prestashop@gmail.com.
*
* @author    Andrei Cimpean (ProQuality) <addons4prestashop@gmail.com>
* @copyright 2015-2016 ProQuality
* @license   Do not edit, modify or copy this file
*/

if (!defined('_PS_VERSION_'))
	exit;


require_once dirname(__FILE__).'/config/config.inc.php';

class LiveChatPro extends Module
{

	public $ps_version;
	public $context;
	public $hook1;
	public $hook2;
	public $hook3;
	public $hook4;
	public $hook5;
	public $module_token;
	public $ajax_token;
	public $employees_token;
	public $google_map_code;
	public $timeout;
	public $employee;
	public $id_product;
	public $url;
	const _THIS_MODULE_NAME_ = 'livechatpro';

	public function dev()
	{
		#require_once('libraries/geoplugin/geoplugin.class.php');
		#$geoplugin = new geoPlugin();
		#$geoplugin->locate('82.234.10.3');
	}

	public function __construct()
	{
		$this->name                   = 'livechatpro';
		$this->tab                    = 'front_office_features';
		$this->version                = '5.2.1';
		$this->author                 = 'ProQuality';
		$this->module_key             = '6391aed91fe8d0f835635bad4919563e';
		$this->need_instance          = 0;
		$this->ps_versions_compliancy = array(
			'min' => '1.4',
			'max' => '1.6'
		);

		parent::__construct();

		$this->timeout = 30; #seconds

		$this->displayName = $this->l('Live Chat Pro');

		$this->description = $this->l('Professional live chat with visitor tracking, browser tracking, geolocation.');

		$this->confirmUninstall = $this->l('Are you sure you want to uninstall?');

		$this->ps_version = (Tools::substr(_PS_VERSION_, 0, 3));

		$this->id_lang = (int)$this->context->language->id;

		$this->iso_lang = Language::getIsoById($this->id_lang);
		
		$this->id_product = '18967';

		if ($this->ps_version == '1.4')
		{
			$this->hook1 = 'backOfficeHeader';
			$this->hook2 = 'footer';
			$this->hook3 = 'backOfficeTop';
			$this->hook4 = 'header';
			$this->hook5 = 'top';

			require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
		}
		else
		{
			$this->hook1 = 'displayBackOfficeHeader';
			$this->hook2 = 'displayFooter';
			$this->hook3 = 'displayBackOfficeTop';
			$this->hook4 = 'displayHeader';
			$this->hook5 = 'displayTop';
		}

		$this->context->employee = new Employee($this->context->cookie->id_employee);

		$this->ajax_token = $this->getToken();

		$this->module_token = Tools::getAdminToken( 'AdminModules'.(int)Tab::getIdFromClassName('AdminModules').(int)$this->context->employee->id);

		$this->employees_token = Tools::getAdminToken( 'AdminEmployees'.(int)Tab::getIdFromClassName('AdminEmployees').(int)$this->context->employee->id);

		try {
			#if (!isset($this->context->smarty->registered_plugins['function']['split_array'])) 
				$this->context->smarty->registerPlugin('function', 'split_array', 'smartyFunctionSplitArray');
		}
		catch (Exception $e) {
			unset($e);
		}

		$this->postProcessing();
		$this->dev();
	}


	public function install()
	{
		$sql_array = '';
		$sql_execution = '';
		// creating table livechatpro_archive
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_archive` (
	`id_archive` INT(11) NOT NULL AUTO_INCREMENT,
	`id_chat` INT(11) NULL DEFAULT NULL,
	`id_visitor` TINYTEXT NULL,
	`id_staffprofile` INT(11) NULL DEFAULT NULL,
	`id_department` INT(11) NULL DEFAULT NULL,
	`action` TINYTEXT NULL,
	`internal` TINYTEXT NULL,
	`date_add` DATETIME NULL DEFAULT NULL,
	`in_chat` ENUM('Y','N','P') NULL DEFAULT NULL COMMENT 'Yes, No, Pending',
	`chat_request_from` ENUM('Staff','Client') NULL DEFAULT NULL,
	`awaiting_response_from_staff` ENUM('Y','N') NULL DEFAULT NULL,
	`visitor_typing` ENUM('Y','N') NULL DEFAULT NULL,
	`staff_typing` ENUM('Y','N') NULL DEFAULT NULL,
	`name` TINYTEXT NULL,
	`email` TINYTEXT NULL,
	`phone` TINYTEXT NULL,
	`company` TINYTEXT NULL,
	`language` TINYTEXT NULL,
	`country` TINYTEXT NULL,
	`ip` TINYTEXT NULL,
	`host` TINYTEXT NULL,
	`duration` TIME NULL DEFAULT NULL,
	`messages` LONGTEXT NULL,
	`last_message` LONGTEXT NULL,
	`log_entries` INT(11) NULL DEFAULT NULL,
	`is_archive` ENUM('Y','N') NULL DEFAULT NULL,
	`last_update` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id_archive`),
	INDEX `id_chat` (`id_chat`),
	INDEX `id_staffprofile` (`id_staffprofile`),
	INDEX `id_department` (`id_department`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=329
;";

		// creating table livechatpro_departments
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_departments` (
	`id_department` INT(11) NOT NULL AUTO_INCREMENT,
	`status` ENUM('Active','Inactive') NULL DEFAULT NULL,
	`name` TINYTEXT NULL,
	PRIMARY KEY (`id_department`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=4
;";

		// creating table livechatpro_emoticons
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_emoticons` (
	`id_emoticon` INT(11) NOT NULL AUTO_INCREMENT,
	`code` TINYTEXT NULL,
	`filename` TINYTEXT NULL,
	`alias` ENUM('Y','N') NULL DEFAULT 'N',
	PRIMARY KEY (`id_emoticon`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=65
;";

		// creating table livechatpro_iconsets
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_iconsets` (
	`id_iconset` INT(11) NOT NULL AUTO_INCREMENT,
	`name` TINYTEXT NULL,
	`is_default` INT(1) NULL DEFAULT '0',
	PRIMARY KEY (`id_iconset`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=3
;";

		// creating table livechatpro_iconsets_lang
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_iconsets_lang` (
	`id_iconset` INT(11) NULL DEFAULT NULL,
	`id_lang` INT(11) NULL DEFAULT NULL,
	`iso_code` TINYTEXT NULL,
	`offline_img` TEXT NULL,
	`online_img` TEXT NULL,
	INDEX `id_iconset` (`id_iconset`),
	INDEX `id_lang` (`id_lang`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
;";

		// creating table livechatpro_logs
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_logs` (
	`id_log` INT(11) NOT NULL AUTO_INCREMENT,
	`id_staffprofile` INT(11) NOT NULL DEFAULT '0',
	`id_visitor` TINYTEXT NULL,
	`message` TEXT NULL,
	`date_add` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id_log`),
	INDEX `id_staffprofile` (`id_staffprofile`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=360
;";

		// creating table livechatpro_messages
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_messages` (
	`id_message` INT(11) NOT NULL AUTO_INCREMENT,
	`id_visitor` TINYTEXT NOT NULL,
	`id_department` INT(11) NULL DEFAULT NULL,
	`date_add` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	`status` ENUM('Read','Unread') NULL DEFAULT NULL,
	`name` TINYTEXT NULL,
	`email` TINYTEXT NULL,
	`phone` TINYTEXT NULL,
	`department` TINYTEXT NULL,
	`question` MEDIUMTEXT NULL,
	`ip` TINYTEXT NULL,
	PRIMARY KEY (`id_message`),
	INDEX `id_department` (`id_department`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=21
;";

		// creating table livechatpro_mousetracking
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_mousetracking` (
	`id_mousetracking` INT(11) NOT NULL AUTO_INCREMENT,
	`id_visitor` TINYTEXT NULL,
	`tracking_data` LONGTEXT NOT NULL,
	`last_update` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id_mousetracking`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
;";

		// creating table livechatpro_onlineusers
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_onlineusers` (
	`id_user` INT(11) NOT NULL AUTO_INCREMENT,
	`id_staffprofile` INT(11) NOT NULL,
	`id_visitor` TINYTEXT NULL,
	`type` ENUM('Internal','External') NULL DEFAULT NULL,
	`last_update` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id_user`),
	INDEX `id_staffprofile` (`id_staffprofile`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=25
;";

		// creating table livechatpro_onlinevisitors
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_onlinevisitors` (
	`id_visitor` INT(11) NOT NULL AUTO_INCREMENT,
	`session_id` TINYTEXT NULL,
	`country` TINYTEXT NULL,
	`city` TINYTEXT NULL,
	`province` TINYTEXT NULL,
	`language` TINYTEXT NULL,
	`visits` TINYTEXT NULL,
	`current_page` TINYTEXT NULL,
	`host` TINYTEXT NULL,
	`ip` TINYTEXT NULL,
	`browser` TINYTEXT NULL,
	`timezone` TINYTEXT NULL,
	`resolution` TINYTEXT NULL,
	`online_time` TINYTEXT NULL,
	`referrer` TINYTEXT NULL,
	`page_count` TINYTEXT NULL,
	`os` TINYTEXT NULL,
	`last_visit` DATETIME NULL DEFAULT NULL,
	`last_update` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id_visitor`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=18
;";


		// creating table livechatpro_onlinevisitors
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_performancesettings` (
	`id_performancesetting` INT(11) NOT NULL AUTO_INCREMENT,
	`sync_chat_dialog_interval_admin` INT(11) NOT NULL DEFAULT '1',
	`sync_chat_dialog_interval_front` INT(11) NOT NULL DEFAULT '1',
	`sync_online_visitors_interval_datatable_admin` INT(11) NOT NULL DEFAULT '1',
	`sync_online_visitors_interval_front` INT(11) NOT NULL DEFAULT '1',
	`last_update` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id_performancesetting`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=2
;";


		// creating table livechatpro_onlinevisitors
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_predefinedmessages` (
	`id_predefinedmessage` INT(11) NOT NULL AUTO_INCREMENT,
	`id_lang` INT(11) NULL DEFAULT NULL,
	`iso_code` TINYTEXT NULL,
	`title` TEXT NULL,
	`message` LONGTEXT NULL,
	`last_update` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id_predefinedmessage`),
	INDEX `id_lang` (`id_lang`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=14
;";

		// creating table livechatpro_ratings
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_ratings` (
	`id_rating` INT(11) NOT NULL AUTO_INCREMENT,
	`id_archive` INT(11) NULL DEFAULT NULL,
	`id_staffprofile` INT(11) NULL DEFAULT NULL,
	`id_visitor` TINYTEXT NULL,
	`status` ENUM('Read','Unread') NULL DEFAULT NULL,
	`internal` TINYTEXT NULL,
	`politness` DECIMAL(10,1) NULL DEFAULT NULL,
	`qualification` DECIMAL(10,1) NULL DEFAULT NULL,
	`date_add` DATETIME NULL DEFAULT NULL,
	`name` TINYTEXT NULL,
	`email` TINYTEXT NULL,
	`company` TINYTEXT NULL,
	`comment` MEDIUMTEXT NULL,
	PRIMARY KEY (`id_rating`),
	INDEX `id_staffprofile` (`id_staffprofile`),
	INDEX `id_archive` (`id_archive`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=13
;";

		// creating table livechatpro_settings
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_settings` (
	`id_setting` INT(11) NOT NULL AUTO_INCREMENT,
	`id_iconset` INT(11) NULL DEFAULT NULL,
	`id_theme` INT(11) NULL DEFAULT NULL,
	`name` TINYTEXT NULL,
	`offline_messages_go_to` TINYTEXT NULL,
	`new_chat_sound` TINYTEXT NULL,
	`new_message_sound` TINYTEXT NULL,
	`name_field` ENUM('Y','N') NULL DEFAULT NULL,
	`email_field` ENUM('Y','N') NULL DEFAULT NULL,
	`phone_field` ENUM('Y','N') NULL DEFAULT NULL,
	`department_field` ENUM('Y','N') NULL DEFAULT NULL,
	`question_field` ENUM('Y','N') NULL DEFAULT NULL,
	`chat_type` ENUM('Slide','Popup') NULL DEFAULT NULL,
	`orientation` TINYTEXT NULL,
	`offset` TINYTEXT NULL,
	`start_minimized` ENUM('Y','N') NULL DEFAULT NULL,
	`fields_are_not_mandatory` ENUM('Y','N') NULL DEFAULT NULL,
	`hide_when_offline` ENUM('Y','N') NULL DEFAULT NULL,
	`show_names` ENUM('Y','N') NULL DEFAULT NULL,
	`staff_qualification` ENUM('Y','N') NULL DEFAULT NULL,
	`position` TINYTEXT NULL,
	`position_options` TINYTEXT NULL,
	`code` TEXT NULL,
	`hook` TEXT NULL,
	`is_default` INT(1) NULL DEFAULT '0',
	`is_primary` INT(1) NULL DEFAULT '0',
	PRIMARY KEY (`id_setting`),
	INDEX `id_icons` (`id_iconset`),
	INDEX `id_skin` (`id_theme`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=3
;";

		// creating table livechatpro_settings_lang
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_settings_lang` (
	`id_setting` INT(11) NULL DEFAULT NULL,
	`id_lang` INT(11) NULL DEFAULT NULL,
	`iso_code` TINYTEXT NULL,
	`offline_header_message` LONGTEXT NULL,
	`online_header_message` LONGTEXT NULL,
	`offline_welcome_message` LONGTEXT NULL,
	`online_welcome_message` LONGTEXT NULL,
	INDEX `id_setting` (`id_setting`),
	INDEX `id_lang` (`id_lang`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
;";


		// creating table livechatpro_staffprofiles
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_staffprofiles` (
	`id_staffprofile` INT(11) NOT NULL AUTO_INCREMENT,
	`id_employee` INT(11) NOT NULL,
	`avatar` TINYTEXT NOT NULL,
	`departments` TINYTEXT NOT NULL,
	`welcome_message` TEXT NULL,
	`signature` TEXT NULL,
	`status` ENUM('Online','Offline') NULL DEFAULT NULL,
	`is_active` ENUM('Y','N') NULL DEFAULT NULL,
	PRIMARY KEY (`id_staffprofile`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=5
;";

		// creating table livechatpro_themes
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_themes` (
	`id_theme` INT(11) NOT NULL AUTO_INCREMENT,
	`name` TINYTEXT NULL,
	`width` TINYTEXT NULL,
	`height` TINYTEXT NULL,
	`corners_radius` TINYTEXT NULL,
	`chat_box_background` TINYTEXT NULL,
	`chat_box_foreground` TINYTEXT NULL,
	`chat_box_border` ENUM('Y','N') NULL DEFAULT NULL,
	`chat_box_border_color` TINYTEXT NULL,
	`header_offline_background` TINYTEXT NULL,
	`header_online_background` TINYTEXT NULL,
	`header_offline_foreground` TINYTEXT NULL,
	`header_online_foreground` TINYTEXT NULL,
	`submit_button_background` TINYTEXT NULL,
	`submit_button_foreground` TINYTEXT NULL,
	`is_default` INT(1) NULL DEFAULT '0',
	PRIMARY KEY (`id_theme`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=3
;";

		// creating table livechatpro_visitedpages
		$sql_array[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name."_visitedpages` (
	`id_visitedpage` INT(11) NOT NULL AUTO_INCREMENT,
	`id_visitor` TINYTEXT NULL,
	`date_add` DATETIME NOT NULL,
	`duration` TINYTEXT NOT NULL,
	`url` TEXT NOT NULL,
	`referrer` TEXT NOT NULL,
	`last_update` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id_visitedpage`)
)
COLLATE='utf8_general_ci'
ENGINE=InnoDB
AUTO_INCREMENT=27
;";

		// inserting departments
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_departments` (`id_department`, `status`, `name`) VALUES (1, 'Active', '".$this->l('Support')."');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_departments` (`id_department`, `status`, `name`) VALUES (2, 'Inactive', '".$this->l('Sales')."');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_departments` (`id_department`, `status`, `name`) VALUES (3, 'Active', '".$this->l('Billing')."');";

		// inserting emoticons
		$sql_array[]  = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (1, ':)', 'happy.gif', 'N');";
		$sql_array[]  = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (2, ':-)', 'happy.gif', 'Y');";
		$sql_array[]  = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (3, ':(', 'sad.gif', 'N');";
		$sql_array[]  = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (4, ':-(', 'sad.gif', 'Y');";
		$sql_array[]  = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (5, ';)', 'winking.gif', 'N');";
		$sql_array[]  = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (6, ':d', 'big-grin.gif', 'N');";
		$sql_array[]  = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (7, ';;)', 'batting-eyelashes.gif', 'N');";
		$sql_array[]  = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (8, '>:d<', 'big-hug.gif', 'N');";
		$sql_array[]  = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (9, ':-/', 'confused.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (10, ':x', 'love-struck.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (11, ':\">', 'blushing.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (12, ':p', 'tongue.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (13, ':*', 'kiss.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (14, '=((', 'broken-heart.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (15, ':-0', 'surprise.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (16, 'x(', 'angry.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (17, ':>', 'smug.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (18, 'b-)', 'cool.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (19, ':-s', 'worried.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (20, '#:-s', 'whew.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (21, '>:)', 'devil.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (22, ':((', 'crying.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (23, ':))', 'laughing.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (24, ':|', 'straight-face.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (25, '/:)', 'raised-eyebrows.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (26, '=))', 'rolling-on-the-floor.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (27, 'o:-)', 'angel.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (28, ':-b', 'nerd.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (29, '=;', 'talk-to-the-hand.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (30, ':-c', 'call-me.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (31, ':)]', 'on-the-phone.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (32, '~x(', 'at-wits-end.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (33, ':-h', 'wave.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (34, ':-t', 'time-out.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (35, '8->', 'day-dreaming.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (36, 'i-)', 'sleepy.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (37, '8-|', 'rolling-eyes.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (38, 'l-)', 'loser.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (39, ':-&', 'sick.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (40, ':-$', 'dont-tell-anyone.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (41, '[-(', 'no-talking.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (42, ':o)', 'clown.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (43, '8-}', 'silly.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (44, '<:-p', 'party.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (45, '(:|', 'yawn.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (46, '=p~', 'drooling.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (47, ':-?', 'thinking.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (48, '#-o', 'doh.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (49, '=d>', 'applause.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (50, ':-ss', 'nail-biting.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (51, '@-)', 'hypnotized.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (52, ':^o', 'liar.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (53, ':-w', 'waiting.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (54, ':-<', 'sigh.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (55, '>:p', 'phbbbbt.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (56, '<):)', 'cowboy.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (57, 'x_x', 'i-dont-want-to-see.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (58, ':!!', 'hurry-up.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (59, '\\m/', 'rock-on.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (60, ':-q', 'thumbs-down.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (61, ':-bd', 'thumbs-up.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (62, '^#(^', 'it-wasnt-me.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (63, ':ar!', 'pirate.gif', 'N');";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_emoticons` (`id_emoticon`, `code`, `filename`, `alias`) VALUES (64, ':-*', 'kiss.gif', 'Y');";

		$languages = Language::getLanguages(false);

		// inserting iconsets
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_iconsets` (`id_iconset`, `name`, `is_default`) VALUES (1, 'set1', 1);";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_iconsets` (`id_iconset`, `name`, `is_default`) VALUES (2, 'mycustomiconset1', 0);";

		// inserting iconsets_lang
		foreach ($languages as $value)
		{
			$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name.'_iconsets_lang` (`id_iconset`, `id_lang`, `iso_code`, `offline_img`, `online_img`) VALUES (1, '.pSQL(Language::getIdByIso($value['iso_code'])).", '".pSQL($value['iso_code'])."', '556cb4ddaab46.png', '556cb4ddab31a.png');";
			$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name.'_iconsets_lang` (`id_iconset`, `id_lang`, `iso_code`, `offline_img`, `online_img`) VALUES (2, '.pSQL(Language::getIdByIso($value['iso_code'])).", '".pSQL($value['iso_code'])."', '55728fda162b5.png', '55728fda15646.png');";
		}

		// inserting performance_settings
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name.'_performancesettings` (`id_performancesetting`, `sync_chat_dialog_interval_admin`, `sync_chat_dialog_interval_front`, `sync_online_visitors_interval_datatable_admin`, `sync_online_visitors_interval_front`) VALUES (1, 5, 5, 30, 15);';

		// inserting settings
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_settings` (`id_setting`, `id_iconset`, `id_theme`, `name`, `offline_messages_go_to`, `new_chat_sound`, `new_message_sound`, `name_field`, `email_field`, `phone_field`, `department_field`, `question_field`, `chat_type`, `orientation`, `offset`, `start_minimized`, `fields_are_not_mandatory`, `hide_when_offline`, `show_names`, `staff_qualification`, `position`, `position_options`, `code`, `hook`, `is_default`, `is_primary`) VALUES (1, 0, 1, 'default', 'demo@demo.com', 'new-chat-default.mp3', 'new-message-default.mp3', 'Y', 'Y', 'N', 'Y', 'Y', 'Slide', 'bottom-right', '50',  'Y', 'N', 'N', 'Y', 'Y', 'Fixed', NULL, NULL, NULL, 1, 1);";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_settings` (`id_setting`, `id_iconset`, `id_theme`, `name`, `offline_messages_go_to`, `new_chat_sound`, `new_message_sound`, `name_field`, `email_field`, `phone_field`, `department_field`, `question_field`, `chat_type`, `orientation`, `offset`, `start_minimized`, `fields_are_not_mandatory`, `hide_when_offline`, `show_names`, `staff_qualification`, `position`, `position_options`, `code`, `hook`, `is_default`, `is_primary`) VALUES (2, 1, 2, 'defaultpopup', 'demo@demo.com', 'new-chat-default.mp3', 'new-message-default.mp3', 'Y', 'Y', 'N', 'Y', 'Y', 'Popup', 'left-top', '250', 'Y', 'N', 'N', 'Y', 'Y', 'Fixed', NULL, NULL, NULL, 0, 0);";

		// inserting settings_lang
		foreach ($languages as $value)
		{
			$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name.'_settings_lang` (`id_setting`, `id_lang`, `iso_code`, `offline_header_message`, `online_header_message`, `offline_welcome_message`, `online_welcome_message`) VALUES (1, '.pSQL(Language::getIdByIso($value['iso_code'])).", '".pSQL($value['iso_code'])."', 'Contact us', 'Talk to us', 'We`re not around right now. But you can send us an email and we`ll get back to you, asap.', 'Questions? We`re here. Send us a message!');";
			$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name.'_settings_lang` (`id_setting`, `id_lang`, `iso_code`, `offline_header_message`, `online_header_message`, `offline_welcome_message`, `online_welcome_message`) VALUES (2, '.pSQL(Language::getIdByIso($value['iso_code'])).", '".pSQL($value['iso_code'])."', 'Contact us', 'Talk to us', 'We`re not around right now. But you can send us an email and we`ll get back to you, asap.', 'Questions? We`re here. Send us a message!');";
		}

		// inserting staffprofile
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_staffprofiles` (`id_staffprofile`, `id_employee`, `avatar`, `departments`, `welcome_message`, `signature`, `status`, `is_active`) VALUES (1, 1, 'male9-40x40.png', '1,2', '".$this->l('Hello!')."', '".$this->l('Good Bye!')."', 'Offline', 'Y');";

		// inserting themes
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_themes` (`id_theme`, `name`, `width`, `height`, `corners_radius`, `chat_box_background`, `chat_box_foreground`, `chat_box_border`, `chat_box_border_color`, `header_offline_background`, `header_online_background`, `header_offline_foreground`, `header_online_foreground`, `submit_button_background`, `submit_button_foreground`, `is_default`) VALUES (1, 'default', '300', '380', '10', 'ffffff', '222222', 'Y', 'cccccc', 'BF3723', '3A99D1', 'FFFFFF', 'FFFFFF', '3A99D1', 'FFFFFF', 1);";
		$sql_array[] = 'INSERT INTO `'._DB_PREFIX_.$this->name."_themes` (`id_theme`, `name`, `width`, `height`, `corners_radius`, `chat_box_background`, `chat_box_foreground`, `chat_box_border`, `chat_box_border_color`, `header_offline_background`, `header_online_background`, `header_offline_foreground`, `header_online_foreground`, `submit_button_background`, `submit_button_foreground`, `is_default`) VALUES (2, 'defaultpopup', '300', '450', '10', 'ffffff', '222222', 'Y', 'cccccc', 'BF3723', '3A99D1', 'FFFFFF', 'FFFFFF', '3A99D1', 'FFFFFF', 0);";

		
		foreach ($sql_array as $sql)
			$sql_execution[] = Db::getInstance()->Execute($sql);

		Configuration::updateValue(Tools::strtoupper($this->name).'_SETTINGS', serialize(array(
			'name' => $this->name,
			'ajax_token' => $this->ajax_token,
			'module_token' => $this->module_token,
		)));

		return parent::install()
				&& $this->registerHook($this->hook1)
				&& $this->registerHook($this->hook2)
				&& $this->registerHook($this->hook3)
				&& $this->registerHook($this->hook4)
				&& (!in_array(false, $sql_execution))
				&& $this->syncStaffProfiles() 
				&& $this->syncEmailTemplates();
	}

	public function uninstall()
	{
		$sql_array = '';
		$sql_execution = '';

		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_archive`;';
		#$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_cometactions`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_departments`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_emoticons`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_iconsets`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_iconsets_lang`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_logs`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_messages`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_mousetracking`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_onlineusers`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_onlinevisitors`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_performancesettings`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_predefinedmessages`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_ratings`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_settings`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_settings_lang`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_staffprofiles`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_themes`;';
		$sql_array[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'_visitedpages`;';

		foreach ($sql_array as $sql)
			$sql_execution[] = Db::getInstance()->Execute($sql);

		#$configuration_array = unserialize(Configuration::get(Tools::strtoupper($this->name).'_SETTINGS'));

		return parent::uninstall() && Configuration::deleteByName($this->name);
	}


	public static function getToken()
	{
		return Tools::encrypt(self::_THIS_MODULE_NAME_);
	}

	public static function isTokenValid($token)
	{
		return (self::getToken() === $token);
	}


	public function hookHeader()
	{
		$this->assignModuleVars();

		$media = '';

		if ($this->ps_version == '1.4')
		{
			//jquery
			$media .= '<script type="text/javascript">$.noConflict(true);</script>';
			$media .= '<script src="'.$this->_path.'views/js/jquery/jquery-1.7.2.js"></script>';

			//module media
			//js
			$media .= '<script src="'.$this->_path.'views/js/jquery/ui/jquery-ui-1.10.4.custom.min.js"></script>';
			$media .= '<script src="'.$this->_path.'views/js/uploadify/jquery.uploadify.min.js"></script>';
			$media .= '<script src="'.$this->_path.'views/js/jquery.storageapi.plugin.min.js"></script>';
			$media .= '<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/js/assigned_vars_front.js').'</script>
						<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/templates/admin/translations.js.tpl').'</script>
						<script src="'.$this->_path.'views/js/front.js"></script>
						<script src="'.$this->_path.'views/js/global.functions.js"></script>';
			//css
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/jquery_themes/base/jquery.ui.all.css">';
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/uploadify.css">';
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/front.css">';
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/fontawesome/font-awesome.min.css">';
			$media .= '
			<style>
				.ui-tabs .ui-tabs-nav li a { line-height: 30px !important; padding: 0px 10px 0px 10px !important; margin: 0px !important; }
				.ui-icon .ui-icon-close { background-image:url(../img/uploadify-cancel.png) !important; }
				.ui-dialog-buttonpane { display: block !important; }
				.ui-dialog-buttonset { display: block !important; }
			</style>';
		
		}
		else
		{
			//add jquery
			$this->context->controller->addJquery();

			//load jquery ui & plugins
			$this->context->controller->addJqueryUI('ui.tabs');
			$this->context->controller->addJqueryUI('ui.dialog');
			#$this->context->controller->addJqueryUI('ui.datepicker');
			#$this->context->controller->addJqueryUI('ui.menu');
			$this->context->controller->addJqueryUI('ui.button');
			
			//module media
			//js
			$this->context->controller->addJS($this->_path.'views/js/jquery.storageapi.plugin.min.js');
			$this->context->controller->addJS($this->_path.'views/js/uploadify/jquery.uploadify.min.js');
			$media  .= '<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/js/assigned_vars_front.js').'</script>
						<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/templates/admin/translations.js.tpl').'</script>
						';//<script src="'.$this->_path.'views/js/front.js"></script>
			$this->context->controller->addJS($this->_path.'views/js/front.js');
			$this->context->controller->addJS($this->_path.'views/js/global.functions.js');
			//css
			$this->context->controller->addCSS($this->_path.'views/css/jquery_themes/bootstrap/jquery.ui.theme.css', 'all');
			$this->context->controller->addCSS($this->_path.'views/css/uploadify.css', 'all');
			$this->context->controller->addCSS($this->_path.'views/css/front.css', 'all');
			$this->context->controller->addCSS($this->_path.'views/css/fontawesome/font-awesome.min.css', 'all');

		}

		$media .= '
			<meta name="viewport" content="width=device-width, initial-scale=1.0">
			<audio id="newchat" src=""></audio>
			<audio id="newmessage" src=""></audio>
			';

		return $media;
	}

	public function hookBackOfficeHeader($params)
	{
		$this->assignModuleVars();

		$media = '';

		if ($this->ps_version == '1.4')
		{
			//jquery
			$media .= '<script type="text/javascript">$.noConflict(true);</script>';
			$media .= '<script src="'.$this->_path.'views/js/jquery/jquery-1.7.2.js"></script>';

			//module media
			//js
			$media .= '<script src="'.$this->_path.'views/js/jquery/ui/jquery-ui-1.10.4.custom.min.js"></script>';
			#$media .= '<script src="'.$this->_path.'views/js/jscolor.js"></script>';
			$media .= '<script src="'.$this->_path.'views/js/uploadify/jquery.uploadify.min.js"></script>';
			$media .= '<script src="'.$this->_path.'views/js/jquery.storageapi.plugin.min.js"></script>';
			$media .= '<script src="'.$this->_path.'libraries/datatables/datatables.min.js"></script>';
			$media .= '<script src="'.$this->_path.'libraries/datatables/RowGrouping-1.2.9/dataTables.rowGrouping.js"></script>';
			$media .= '<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/js/assigned_vars_back.js').'</script>
						<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/templates/admin/translations.js.tpl').'</script>
						<script src="'.$this->_path.'views/js/back.js"></script>
						<script src="'.$this->_path.'views/js/global.functions.js"></script>';
			//css
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/jquery_themes/base/jquery.ui.all.css">';
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/uploadify.css">';
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/back.css">';
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'libraries/datatables/datatables.min.css">';
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/fontawesome/font-awesome.min.css">';
			$media .= '
			<style>
				.ui-tabs .ui-tabs-nav li a { line-height: 30px !important; padding: 0px 10px 0px 10px !important; margin: 0px !important; }
				.ui-icon .ui-icon-close { background-image:url(../img/uploadify-cancel.png) !important; }
				.ui-dialog-buttonpane { display: block !important; }
				.ui-dialog-buttonset { display: block !important; }
			</style>';

			if ((Tools::isSubmit('configure') && Tools::getValue('configure') == $this->name))
				$media .= '<script src="'.$this->_path.'views/js/jscolor.js"></script>';
		
		}
		else
		{
			//add jquery
			$this->context->controller->addJquery();

			//load jquery ui & plugins
			$this->context->controller->addJqueryUI('ui.tabs');
			$this->context->controller->addJqueryUI('ui.dialog');
			#$this->context->controller->addJqueryUI('ui.menu');
			$this->context->controller->addJqueryUI('ui.button');
			
			//module media
			//js
			#$this->context->controller->addJS($this->_path.'views/js/jscolor.js');
			$this->context->controller->addJS($this->_path.'views/js/uploadify/jquery.uploadify.min.js');
			$this->context->controller->addJS($this->_path.'views/js/jquery.storageapi.plugin.min.js');
			$this->context->controller->addJS($this->_path.'libraries/datatables/datatables.min.js');
			$this->context->controller->addJS($this->_path.'libraries/datatables/RowGrouping-1.2.9/dataTables.rowGrouping.js');
			$media  .= '<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/js/assigned_vars_back.js').'</script>
						<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/templates/admin/translations.js.tpl').'</script>
						';//<script src="'.$this->_path.'views/js/back.js"></script>
			$this->context->controller->addJS($this->_path.'views/js/back.js');
			$this->context->controller->addJS($this->_path.'views/js/global.functions.js');

			//css
			$this->context->controller->addCSS($this->_path.'views/css/jquery_themes/bootstrap/jquery.ui.theme.css', 'all');
			$this->context->controller->addCSS($this->_path.'views/css/uploadify.css', 'all');
			$this->context->controller->addCSS($this->_path.'views/css/back.css', 'all');
			$this->context->controller->addCSS($this->_path.'libraries/datatables/datatables.min.css', 'all');
			$this->context->controller->addCSS($this->_path.'views/css/fontawesome/font-awesome.min.css', 'all');

			if ($this->ps_version == '1.6')
				$this->context->controller->addJS($this->_path.'views/js/fixwidth.js');

			if ((Tools::isSubmit('configure') && Tools::getValue('configure') == $this->name))
				$this->context->controller->addJS($this->_path.'views/js/jscolor.js');

		}

		$id_staffprofile = $this->getCurrentStaffProfileId();

		$staff_avatar    = $this->getAvatar(array('id_employee' => $this->context->employee->id));

		$primary_settings = $this->getPrimarySettings();


		$media .= '
			<meta name="viewport" content="width=device-width, initial-scale=1.0">
			<script type="text/javascript" src="'.$this->http_or_https().'maps.google.com/maps/api/js?sensor=false"></script>
			<audio id="newchat" src=""></audio>
			<audio id="newmessage" src=""></audio>
			<input type="hidden" name="active_chat_tab" id="active_chat_tab" value="0" autocomplete="off">
			<input type="hidden" name="active_chat_subtab" id="active_chat_subtab" value="userchat_span_0" autocomplete="off">
			<input type="hidden" name="active_users_tab" id="active_users_tab" value="0" autocomplete="off">
			<input type="hidden" name="active_statistics_tab" id="active_statistics_tab" value="0" autocomplete="off">
			<input type="hidden" name="active_statistics_tab_link" id="active_statistics_tab_link" value="tabs-visitors-a" autocomplete="off">
			<input type="hidden" name="id_staffprofile" id="id_staffprofile" value="'.$id_staffprofile.'">
			<input type="hidden" name="id_employee" id="id_employee" value="'.$this->context->employee->id.'">
			<input type="hidden" name="internal" id="internal" value="'.$this->context->employee->lastname.'">
			<input type="hidden" name="deny_chat_clicked_from" id="deny_chat_clicked_from" value="" autocomplete="off">
			<input type="hidden" name="staff_avatar" id="staff_avatar" value="'.$staff_avatar.'">
			<input type="hidden" name="show_names" id="show_names" size="20" value="'.$primary_settings['show_names'].'">	
			<input type="hidden" name="staff_qualification" id="staff_qualification" size="20" value="'.$primary_settings['staff_qualification'].'">
			<input type="hidden" name="visitor_details_showed" id="visitor_details_showed" size="20" value="" autocomplete="off">	
			';

		return $media;
	}

	public function getContent()
	{
		$output = null;

		if (Tools::isSubmit('submit'.$this->name))
		{
			#$configuration_array = unserialize(Configuration::get(Tools::strtoupper($this->name).'_SETTINGS'));

			if (!$this->name || empty($this->name) || !Validate::isGenericName($this->name))
				$output .= $this->displayError($this->l('Invalid Configuration value'));
			else
			{
				Configuration::updateValue(Tools::strtoupper($this->name).'_SETTINGS', serialize(array(
					'name' => $this->name,
					'ajax_token' => $this->ajax_token,
					'module_token' => $this->module_token,
				)));

				$output .= $this->displayConfirmation($this->l('Settings updated'));
			}
		}

		return $output.$this->displayForm();
	}

	public function displayForm()
	{
		$settings     = $this->getSettings();

		$performance_settings     = $this->getPerformanceSettings();

		$iconsets     = $this->getIconsets();

		$themes       = $this->getThemes();

		$departments  = $this->getDepartments();

		$hooks        = Hook::getHooks();

		$avatars      = $this->getAvatars();

		$staff_avatar = $this->getAvatar(array('id_employee' => $this->context->employee->id));

		$languages = Language::getLanguages(false);

		// show only the display hooks
		$hooks2 = '';

		foreach ($hooks as $value)
		{
			if (strstr($value['name'], 'display'))
				$hooks2[] = $value;

		}

		$hooks = $hooks2;

		$this->assignModuleVars();

		$employee = $this->objectToArray($this->context->employee);

		$this->context->smarty->assign(array(
			'settings' => $settings,
			'performance_settings' => $performance_settings,
			'iconsets' => $iconsets,
			'themes' => $themes,
			'departments' => $departments,
			'languages' => $languages,
			'hooks' => $hooks,
			'employee' => $employee,
			'rss_code' => '',
			'avatars' => $avatars,
			'staff_avatar' => $staff_avatar,
			'visitor_details' => '',
			'media' => ''
		));

		return $this->display(dirname(__FILE__), '/views/templates/admin/index.tpl');
	}

	public function hookBackOfficeTop()
	{
		$staff_chat_status = $this->getStaffChatStatus();

		if ($this->ps_version == '1.4')
		{
			if ($staff_chat_status == 'offline') $notification_style = 'color: #000000;';
			else $notification_style = 'color: #7ab726;';
		}
		elseif ($this->ps_version == '1.5')
		{
			if ($staff_chat_status == 'offline') $notification_style = 'margin-top: 12px; margin-left: 5px; float: left; color: #ffffff;';
			else $notification_style = 'margin-top: 12px; margin-left: 5px; float: left; color: #7ab726;';
		}
		else
		{
			if ($staff_chat_status == 'offline') $notification_style = 'margin-left: 40px; color: #b3b3b3;';
			else $notification_style = 'margin-left: 40px; color: #7ab726;';
		}

		$html = '<a id="dialog_chat_a" href="javascript:{}" style="'.$notification_style.'"><span class="lcp blink-container">(<span id="awaiting_response_chat_dialogs">'.$this->countAwaitingResponseFromStaffArchives().'</span>) <span class="icon-comment fa fa-comment" style="margin-top: 10px;"></span></span></a>
				<span id="dialog_chat_window_span">
					<div id="dialog_chat" title="'.$this->l('Staff:').' '.$this->context->employee->firstname.' '.$this->context->employee->lastname.'" style="overflow-x: hidden; display:none; background-color: #dddddd; border-top: 1px solid #aaaaaa;">
						'.$this->syncChatDialog(false, 'popup_chat_window.tpl').'
					</div>
				</span>';

		return $html;
	}

	/*public function hookTop()
	 {
	 	$this->assignModuleVars();
		$html = '<div style="cursor: hand; cursor: pointer; z-index: 9999;  top: 250px; left: 0px;"><a onclick=\'popupWindow("/work/git/prestashop16/modules/livechatpro/ajax.php?type=popupChat", "Chat", "300", "450");\' href="javascript:{}"><img id="lcp_popup_img" border="0"></a></div>';
		return $html;
	 }*/


	public function hookFooter()
	{
		$session_id = $this->getSessionId();

		$id_visitor = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('SELECT * FROM '._DB_PREFIX_.$this->name.'_onlinevisitors WHERE session_id = "'.pSQL($session_id).'"');

		$id_visitor = empty($id_visitor[0]['id_visitor']) ? '' : $id_visitor[0]['id_visitor'];

		$status = $this->getChatStatus();

		$primary_settings = $this->getPrimarySettings();

		$theme = $this->getTheme(array('id_theme' => $primary_settings['id_theme']));

		$chat_type = $primary_settings['chat_type'];

		$html = '';

		if ($chat_type == 'Popup')
		{
			$iconset = $this->getIconset(array('id_iconset' => $primary_settings['id_iconset']));

			$iconset_img = ($status == 'offline') ? $iconset['offline_img'][$this->context->language->iso_code] : $iconset['online_img'][$this->context->language->iso_code];

			if ($primary_settings['orientation'] == 'left-top') $offset = 'top: '.$primary_settings['offset'].'px; left: 0px;';
			else if ($primary_settings['orientation'] == 'left-bottom') $offset = 'bottom: '.$primary_settings['offset'].'px; left: 0px;';
			else if ($primary_settings['orientation'] == 'right-top') $offset = 'top: '.$primary_settings['offset'].'px; right: 0px;';
			else if ($primary_settings['orientation'] == 'right-bottom') $offset = 'bottom: '.$primary_settings['offset'].'px; right: 0px;';

			$position = (Tools::strtolower($primary_settings['position']) == 'fixed') ? 'position: fixed !important;' : '';

			$display = '';

			if ($primary_settings['hide_when_offline'] == 'Y')
				$display = 'display: none;';

			$html .= '
				<div id="popup_chat_window" style="cursor: hand; cursor: pointer; z-index: 9998; '.$position.' '.$display.' '.$offset.'">
					<a onclick=\'popupWindow("'.$this->_path.'ajax.php?type=popupChat", "Chat", "'.($theme['width']).'", "'.($theme['height']).'");\' href="javascript:{}">
						<img id="lcp_popup_img_fixed" border="0" src="'.$this->_path.'views/img/iconsets/'.$iconset_img.'">
					</a>
				</div>

				<script type="text/javascript">$("#lcp_popup_img").attr("src", "'.$this->_path.'views/img/iconsets/'.$iconset_img.'");</script>
				';
		}
		else
		{
			if ($primary_settings['orientation'] == 'bottom-left') $offset = 'left: '.$primary_settings['offset'].'px; bottom: 0px;';
			else if ($primary_settings['orientation'] == 'bottom-right') $offset = 'right: '.$primary_settings['offset'].'px; bottom: 0px;';

			$html .= '
				<div id="slide_chat_window" style="z-index: 9998; position: fixed !important; '.$offset.'">
				'.$this->syncFrontChatDialog(false, 'chat_window.tpl').'
				</div>
				';
		}
		return $html;
	}


	public function getAvatar($data = '')
	{
		if (empty($data['id_employee']))
			return false;
		else
		{
			$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_staffprofiles` lsp WHERE lsp.`id_employee` = "'.(int)$data['id_employee'].'"');
			
			if ($result) 
				return $result[0]['avatar'];
			else 
				return false;
		}
	}

	public function getAvatars($type = 'all')
	{
		$files = array();

		foreach (glob(dirname(__FILE__).'/views/img/avatars/*') as $key => $filename)
		{
			$filename_exp = explode('/views/img/avatars/', $filename);

			if ($filename_exp[1] != 'index.php')
			{
				if (empty($type) || $type == 'all')
				{
					$files[$key]['full'] = $filename;

					$files[$key]['ext'] = $filename_exp[1];
				}
				elseif ($type == 'for_datatables')
				{
					//$files[$key] = $filename_exp[1];
					$files[$filename_exp[1]] = $filename_exp[1];
				}
			}
		}

		return $files;
	}

	public function addLog($data)
	{
		$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_logs 
		(
			id_staffprofile,
			id_visitor,
			message
		) 
		VALUES 
		(
			"'.pSQL($data['id_staffprofile']).'",
			"'.pSQL($data['id_visitor']).'",
			"'.pSQL($data['message']).'"
		)';
		
		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);
		return true;
	}

	public function getEmoticons($with_aliases = false)
	{
		if ($with_aliases == false)
			$emoticons = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_emoticons` le WHERE le.alias = "N"');
		else
			$emoticons = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_emoticons`');

		return $emoticons;
	}

	public function getStaffStatus($id_staffprofile)
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_staffprofiles` lsp WHERE lsp.id_staffprofile = "'.(int)$id_staffprofile.'"');
		
		if ($result) 
			return $result[0]['status'];
		else
			return false;
	}

	public function syncFrontChatDialog($plus_media = false, $display = false)
	{
		$this->assignModuleVars();
		
		$session_id = $this->getSessionId();
		
		$id_visitor = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('SELECT * FROM '._DB_PREFIX_.$this->name.'_onlinevisitors WHERE session_id = "'.pSQL($session_id).'"');
		$id_visitor = empty($id_visitor[0]['id_visitor']) ? '' : $id_visitor[0]['id_visitor'];
		
		$visitor_chat_status = $this->getVisitorChatStatus($id_visitor);
		
		$departments = $this->getDepartments('Active');

		$status = $this->getChatStatus();

		$primary_settings = $this->getPrimarySettings();

		$theme = $this->getTheme(array('id_theme' => $primary_settings['id_theme']));

		$chat_type = $primary_settings['chat_type'];

		if ($chat_type == 'Popup')
		{
			$chat_toggled = 'up';

			$iconset = $this->getIconset(array('id_iconset' => $primary_settings['id_iconset']));

			$iconset_img = ($status == 'offline') ? $iconset['offline_img'][$this->context->language->iso_code] : $iconset['online_img'][$this->context->language->iso_code];
		}
		else
			$chat_toggled = $this->getCookie('chat_toggled');

		$emoticons = $this->getEmoticons();

		$visitor_online_archive_details = $this->getVisitorOnlineArchiveDetails(array('id_visitor' => $id_visitor));

		$visitor_archive_details = $this->getVisitorArchiveDetails(array('id_visitor' => $id_visitor));

		$customer_details = $this->getCustomerDetails();

		$department = @$this->getDepartment(array('id_department' => $visitor_online_archive_details['id_department']));

		$media = '';//<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/templates/admin/translations.js.tpl').'</script><script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/js/assigned_vars_front.js').'</script>

		if ($plus_media == true)
		{
			//$media .= '<script type="text/javascript">$.noConflict(true);</script>';
			$media .= '<script src="'.$this->_path.'views/js/jquery/jquery-1.10.2.js"></script>';
			$media .= '<script src="'.$this->_path.'views/js/jquery/ui/jquery-ui-1.10.4.custom.min.js"></script>';
			$media .= '<script src="'.$this->_path.'views/js/uploadify/jquery.uploadify.min.js"></script>';
			$media .= '<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/js/assigned_vars_front.js').'</script>
						<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/templates/admin/translations.js.tpl').'</script>
						<script src="'.$this->_path.'views/js/front.js"></script>
						<script src="'.$this->_path.'views/js/global.functions.js"></script>';
			$media .= '<script src="'.$this->_path.'views/js/jquery.storageapi.plugin.min.js"></script>';
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/front.css">';
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/jquery_themes/base/jquery.ui.all.css">';
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/fontawesome/font-awesome.min.css">';
			$media .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/uploadify.css">';
		}

		#d($status);
		#d($visitor_archive_details['action']);
		$smarty_vars_to_assign = array(
			'status' => $status,
			'iconset' => @$iconset,
			'iconset_img' => @$iconset_img,
			'chat_toggled' => $chat_toggled,
			'customer_details' => $customer_details,
			'visitor_chat_status' => $visitor_chat_status,
			'visitor_online_archive_details' => $visitor_online_archive_details,
			'visitor_archive_details' => $visitor_archive_details,
			'action' => !empty($visitor_archive_details['action']) ? $visitor_archive_details['action'] : '',
			'chat_type' => $chat_type,
			'primary_settings' => $primary_settings,
			'theme' => $theme,
			'departments' => $departments,
			'department_name' => $department['name'],
			'emoticons' => $emoticons,
			'media' => $media,
		);

		$this->context->smarty->assign($smarty_vars_to_assign);

		if ($display != false)
			return $this->display(dirname(__FILE__), '/views/templates/front/'.$display);
	}




	public function syncChatDialog($plus_media = false, $display = false)
	{
		$this->assignModuleVars();

		$online_external_users                 = $this->getOnlineUsers('External');

		$online_internal_users                 = $this->getOnlineUsers('Internal');

		$count_online_external_users           = $this->countOnlineUsers('External');

		$count_online_internal_users           = $this->countOnlineUsers('Internal');

		$count_online_visitors                 = $this->countOnlineVisitors();

		$count_active_archives                 = $this->countArchives('Y');

		$count_pending_archives                = $this->countArchives('P');

		$count_active_pending_archives 			= $count_active_archives + $count_pending_archives;

		#$inactive_archives                     = $this->getArchives('N');

		$active_archives                       = $this->getArchives('Y');

		$pending_archives                      = $this->getArchives('P');

		$active_pending_archives       			= array_merge($active_archives, $pending_archives);

		//$archives                              = $this->getArchives('');

		$emoticons                             = $this->getEmoticons();

		$id_staffprofile                       = $this->getCurrentStaffProfileId();

		$staff_status                          = $this->getStaffStatus($id_staffprofile);

		$predefined_messages				   = $this->getPredefinedMessages();

		$media = '';
		//$media = '<script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/js/assigned_vars_back.js').'</script><script type="text/javascript">'.$this->context->smarty->fetch(dirname(__FILE__).'/views/templates/admin/translations.js.tpl').'</script>';

		if ($plus_media == true)
		{
			$media .= '<script src="'.$this->_path.'views/js/back.js"></script>';
			$media .= '<script src="'.$this->_path.'views/js/global.functions.js"></script>';
		}


		$employee = $this->objectToArray($this->context->employee);

		$this->context->smarty->assign(array(
			'staff_status'                          => $staff_status,
			'predefined_messages'                   => $predefined_messages,
			'id_staffprofile'                       => $id_staffprofile,
			'employee'                              => $employee,
			'online_external_users'                 => $online_external_users,
			'online_internal_users'                 => $online_internal_users,
			'count_online_external_users'           => $count_online_external_users,
			'count_online_internal_users'           => $count_online_internal_users,
			'count_total_online_users'              => $count_online_external_users + $count_online_internal_users,
			'count_online_visitors'                 => $count_online_visitors,
			'active_pending_archives'       		=> $active_pending_archives,
			'count_active_pending_archives' 		=> $count_active_pending_archives,
			'count_pending_archives'                => $count_pending_archives,
			'emoticons'                             => $emoticons,
			//'archives'                              => $archives,
			'media'                                 => $media
		));
		
		if ($display != false)
			return $this->display(dirname(__FILE__), '/views/templates/admin/'.$display);
	}

	public function getPredefinedMessages()
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_predefinedmessages`');
		
		if ($result) 
			return $result;
		else
			return false;
	}


	public function getEmployeeIdByStaffProfile($id_staffprofile = '')
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_staffprofiles` lsp WHERE lsp.id_staffprofile = "'.(int)$id_staffprofile.'"');
		
		if ($result) 
			return $result[0]['id_employee'];
		else
			return false;
	}

	public function getVisitorOnlineArchiveDetails($data)
	{
		$sql = 'SELECT *
			FROM `'._DB_PREFIX_.$this->name.'_archive` la
			LEFT JOIN `'._DB_PREFIX_.$this->name.'_staffprofiles` lsp ON (la.`id_staffprofile` = lsp.`id_staffprofile`)
			WHERE la.id_visitor = "'.pSQL($data['id_visitor']).'" AND la.in_chat = "Y"';

		$archive_details = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

		if ($archive_details)
		{
			$archive_details = $archive_details[0];

			$archive_details['messages'] = $archive_details['messages'];
		}

		return $archive_details;
	}


	public function getVisitorArchiveDetails($data)
	{
		$sql = 'SELECT *
			FROM `'._DB_PREFIX_.$this->name.'_archive` la
			LEFT JOIN `'._DB_PREFIX_.$this->name.'_staffprofiles` lsp ON (la.`id_staffprofile` = lsp.`id_staffprofile`)
			WHERE la.id_visitor = "'.pSQL($data['id_visitor']).'" ORDER BY la.id_archive DESC LIMIT 1';

		$archive_details = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

		if ($archive_details)
		{
			$archive_details = $archive_details[0];

			$archive_details['signature'] = Tools::jsonEncode($archive_details['signature']);

			$archive_details['messages'] = $archive_details['messages'];
		}

		return $archive_details;
	}

	public function getStaffChatStatus($id_staffprofile = '')
	{
		if (empty($id_staffprofile))
			$id_staffprofile = $this->getCurrentStaffProfileId();

		$internal_users = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlineusers` lou WHERE lou.type = "Internal" AND lou.id_staffprofile = "'.pSQL($id_staffprofile).'"');

		if (empty($internal_users))
			return 'offline';
		else
			return 'online';
	}

	public function getChatStatus()
	{
		$internal_users = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlineusers` lou WHERE lou.type = "Internal"');

		if (empty($internal_users))
			return 'offline';
		else
			return 'online';
	}

	public function changeStaffStatus($data = '')
	{
		$id_staffprofile = $this->getCurrentStaffProfileId();

		if ($this->checkIfStaffProfileIsActive($id_staffprofile) == false)
			return false;

		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_staffprofiles lsp SET status = "'.pSQL($data['status']).'" WHERE id_staffprofile = "'.(int)$id_staffprofile.'"';

		Db::getInstance()->Execute($sql);

		if ($data['status'] == 'Offline')
		{
			$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlineusers WHERE id_staffprofile = "'.(int)$id_staffprofile.'"';
			Db::getInstance()->Execute($sql);
		}
		else
		{
			if ($this->checkIfStaffProfileIdInOnlineUsers($id_staffprofile) == false)
			{
				$data['id_staffprofile'] = $id_staffprofile;
				$data['id_visitor'] = '0';
				$data['type'] = 'Internal';

				$this->addOnlineUser($data);
			}
		}

		return $this->syncChatDialog(false, 'ajax.onlineusers.tpl');
		#return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.onlineusers.tpl');
	}

	/*id_staffprofile, id_visitor, type*/
	public function addOnlineUser($data = '')
	{
		$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_onlineusers
			(
				id_staffprofile,
				id_visitor,
				type
			) 
			VALUES 
			(
				"'.pSQL($data['id_staffprofile']).'", 
				"'.pSQL($data['id_visitor']).'", 
				"'.pSQL($data['type']).'"
			)';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);
	}



	public function checkIfEmployeeIsSuperAdmin()
	{
		$id_staffprofile = $this->getCurrentStaffProfileId();

		$result = Db::getInstance()->executeS(
			'SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_staffprofiles lsp 
			LEFT JOIN `'._DB_PREFIX_.'employee` e ON (lsp.`id_employee` = e.`id_employee`)
			WHERE lsp.id_staffprofile = "'.(int)$id_staffprofile.'" AND e.id_profile = "1"'
			);

		$res = $result[0]['COUNT(*)'];

		if (empty($res))
			return false;
		else
			return true;
	}


	public function checkIfStaffProfileIsActive($id_staffprofile)
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_staffprofiles lsp WHERE id_staffprofile = "'.(int)$id_staffprofile.'" AND is_active = "Y"');

		$res = $result[0]['COUNT(*)'];

		if (empty($res))
			return false;
		else
			return true;
	}


	public function checkIfStaffProfileIdInOnlineUsers($id_staffprofile)
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_onlineusers lou WHERE id_staffprofile = "'.(int)$id_staffprofile.'"');

		$res = $result[0]['COUNT(*)'];

		if (empty($res))
			return false;
		else
			return true;
	}

	public function getThemes()
	{
		return Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_themes`');
	}

	public function getTheme($data)
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_themes` lt WHERE lt.id_theme = "'.(int)$data['id_theme'].'"');
		
		if ($result) 
			return $result[0];
		else
			return false;
	}

	public function getIconsets()
	{
		return Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_iconsets`');
	}

	public function getIconset($data)
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_iconsets` li WHERE li.id_iconset = "'.(int)$data['id_iconset'].'"');

		$languages = Language::getLanguages(false);

		$arr_info = array();

		foreach ($result as $value)
		{
			foreach ($languages as $value2)
			{
				$iconsets_lang = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_iconsets_lang` lil WHERE lil.id_iconset = "'.pSQL($value['id_iconset']).'" AND lil.iso_code = "'.pSQL($value2['iso_code']).'"');
				
				if (!empty($iconsets_lang))
				{
					$value['offline_img'][$value2['iso_code']] = $iconsets_lang[0]['offline_img'];
					$value['online_img'][$value2['iso_code']] = $iconsets_lang[0]['online_img'];
				}
			}
			$arr_info[] = $value;
		}

		$result = $arr_info;
		
		if ($result) 
			return $result[0];
		else
			return false;
	}

	public function http_or_https()
	{
		return empty($_SERVER['HTTPS']) ? 'http://' : 'https://';
	}


	public function getPerformanceSettings()
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_performancesettings`');

		if ($result) 
			return $result[0];
		else
			return false;
	}

	public function getSettings()
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_settings`');

		$arr_info = array();

		if ($result)
		{
			foreach ($result as $value)
			{
				$value['code'] = $value['code'];

				$arr_info[] = $value;
			}
		}

		return $arr_info;
	}

	public function getSetting($data)
	{
		$result = Db::getInstance()->executeS('
			SELECT *, ls.name AS name, ls.is_default AS is_default
			FROM `'._DB_PREFIX_.$this->name.'_settings` ls
			LEFT JOIN `'._DB_PREFIX_.$this->name.'_iconsets` li ON (ls.`id_iconset` = li.`id_iconset`)
			LEFT JOIN `'._DB_PREFIX_.$this->name.'_themes` lt ON (ls.`id_theme` = lt.`id_theme`)
			WHERE ls.id_setting = "'.(int)$data['id_setting'].'"
		');

		$languages = Language::getLanguages(false);

		$arr_info = array();

		foreach ($result as $value)
		{
			foreach ($languages as $value2)
			{
				$settings_lang = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_settings_lang` lsl WHERE lsl.id_setting = "'.pSQL($value['id_setting']).'" AND lsl.iso_code = "'.pSQL($value2['iso_code']).'"');
				
				if (!empty($settings_lang))
				{
					$value['offline_header_message'][$value2['iso_code']] = $settings_lang[0]['offline_header_message'];
					$value['online_header_message'][$value2['iso_code']] = $settings_lang[0]['online_header_message'];
					$value['offline_welcome_message'][$value2['iso_code']] = $settings_lang[0]['offline_welcome_message'];
					$value['online_welcome_message'][$value2['iso_code']] = $settings_lang[0]['online_welcome_message'];
				}
			}
			$arr_info[] = $value;
		}

		$result = $arr_info;

		//fac update la id settings la primary in baza de date
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_settings SET is_primary = "0"';
		Db::getInstance()->Execute($sql);

		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_settings SET is_primary = "1" WHERE id_setting = "'.(int)$data['id_setting'].'"';
		Db::getInstance()->Execute($sql);		

		if ($result) 
			return $result[0];
		else
			return false;
	}

	public function getPrimarySettings()
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_settings` ls
			LEFT JOIN `'._DB_PREFIX_.$this->name.'_settings_lang` lsl ON (ls.`id_setting` = lsl.`id_setting`) 
			WHERE ls.is_primary = "1" AND lsl.iso_code = "'.pSQL($this->context->language->iso_code).'"');

		if ($result) 
			return $result[0];
		else
			return false;
	}

	public function getDepartment($data)
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_departments` WHERE id_department = "'.(int)$data['id_department'].'"');
		
		if ($result) 
			return $result[0];
		else
			return false;
	}

	public function getDepartments($status = 'Active', $type = 'all')
	{
		$arr_info = array();

		if ($status == 'all')
			$status_condition = '';
		else
			$status_condition = 'WHERE ld.status = "'.$status.'"';

		$departments = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_departments` ld '.$status_condition);

		if ($type == 'all')
			return $departments;

		elseif ($type == 'for_datatables')
		{
			foreach ($departments as $value)
				$arr_info[$value['name']] = $value['name'];

			return $arr_info;
		}
	}

	public function syncEmailTemplates()
	{
		$languages = Language::getLanguages(false);
		
		$status = '';

		foreach ($languages as $value)
		{
			if ($value['iso_code'] != 'en')
				$status[] = $this->copyr(dirname(__FILE__).'/mails/en/', dirname(__FILE__).'/mails/'.$value['iso_code'].'/');
		}

		return true;
	}


	public function copyr($src, $dst) 
	{
		$dir = opendir($src); 
		
		@mkdir($dst); 
		
		while (false !== ($file = readdir($dir))) 
		{
			if (($file != '.' ) && ( $file != '..')) 
			{
				if (is_dir($src.'/'.$file)) 
					$this->copyr($src.'/'.$file, $dst.'/'.$file); 
				else 
					copy($src.'/'.$file, $dst.'/'.$file); 
			} 
		} 
		closedir($dir);
	}


	public function syncStaffProfiles()
	{
		$employees = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.'employee`');

		$employees_ids = array();

		foreach ($employees as $value)
		{
			if ($this->checkIfEmployeeInStaffProfile($value['id_employee']) == false)
			{
				//adaugam staffprofile-ul
				$this->addStaffProfile(array(
					'id_employee' => $value['id_employee'],
					'avatar' => 'sample-40x40.png',
					'departments' => '1',
					'welcome_message' => 'Hello!',
					'signature' => '',
					'status' => 'Offline',
					'is_active' => 'Y',
				));

			}

			$employees_ids[] = $value['id_employee'];
		}

		$staffprofiles_ids_to_delete = $this->getStaffProfilesIdsToDelete($employees_ids);

		foreach ($staffprofiles_ids_to_delete as $value)
		{
			$this->deleteStaffProfile(array(
				'id_staffprofile' => $value
			));
		}
		return true;
	}


	public function getStaffProfile($data)
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.'employee` e
			LEFT JOIN `'._DB_PREFIX_.$this->name.'_staffprofiles` lsp ON (e.`id_employee` = lsp.`id_employee`)
			WHERE e.id_employee = "'.(int)$data['id_employee'].'"');
		return $result[0];
	}

	public function getCurrentStaffProfileId()
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_staffprofiles` lsp WHERE lsp.id_employee = "'.(int)$this->context->employee->id.'"');
		
		if ($result) 
			return $result[0]['id_staffprofile'];
		else
			return false;
	}

	public function getRating($data)
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_ratings` lr WHERE lr.`id_rating` = "'.(int)$data['id_rating'].'"');
		
		if ($result) 
			return $result[0];
		else
			return false;
	}

	public function getVisitor($data = '')
	{
		if (empty($data['id_visitor']))
			return false;
		else
		{
			$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlinevisitors` lov WHERE lov.`id_visitor` = "'.pSQL($data['id_visitor']).'"');
			
			if ($result) 
				return $result[0];
			else
				return false;
		}
	}

	public function getUser($data = '')
	{
		if (empty($data['id_user']))
			return false;
		else
		{
			$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlineusers` lou WHERE lou.`id_user` = "'.pSQL($data['id_user']).'"');
			
			if ($result) 
				return $result[0];
			else
				return false;
		}
	}

	public function getVisitorVisitedPages($data = '')
	{
		if (empty($data['id_visitor']))
		{
			$data = array();

			$data['id_visitor'] = $this->getLastVisitorId();
		}

		return Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_visitedpages` lv WHERE lv.`id_visitor` = "'.pSQL($data['id_visitor']).'"');
	}

	public function getMessage($data)
	{
		$result = Db::getInstance()->executeS('
			SELECT *, (
			SELECT `name`
			FROM  `'._DB_PREFIX_.$this->name.'_departments` ld
			WHERE ld.`id_department` = lm.`id_department`
			) `department_name`
			FROM `'._DB_PREFIX_.$this->name.'_messages` lm WHERE lm.`id_message` = "'.(int)$data['id_message'].'"');

		if ($result) 
			return $result[0];
		else
			return false;
	}

	public function getPredefinedMessage($data)
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_predefinedmessages` lpm WHERE lpm.`id_predefinedmessage` = "'.(int)$data['id_predefinedmessage'].'"');

		if ($result) 
			return $result[0];
		else
			return false;
	}


	public function getArchive($data)
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_archive` WHERE id_archive = "'.(int)$data['id_archive'].'" LIMIT 1');
		
		if ($result) 
			return $result[0];
		else
			return false;
	}


	public function countAwaitingResponseFromStaffArchives()
	{
		$id_staffprofile = $this->getCurrentStaffProfileId();

		$result_new_chats = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_archive la WHERE la.in_chat = "P" AND la.awaiting_response_from_staff = "Y" AND la.id_staffprofile = "'.(int)$id_staffprofile.'"');

		$result_new_messages = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_archive la WHERE la.in_chat = "Y" AND la.awaiting_response_from_staff = "Y" AND la.id_staffprofile = "'.(int)$id_staffprofile.'"');

		$resunt_online_chats = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_archive la WHERE (la.in_chat = "Y" OR la.in_chat = "P") AND la.id_staffprofile = "'.(int)$id_staffprofile.'"');

		$primary_settings = $this->getPrimarySettings();

		$this->context->smarty->assign(array(

			'primary_settings' => $primary_settings,

			'new_chats' => $result_new_chats[0]['COUNT(*)'],

			'new_messages' => $result_new_messages[0]['COUNT(*)'],

			'new_chats_and_messages' => ($result_new_chats[0]['COUNT(*)'] + $result_new_messages[0]['COUNT(*)']),

			'online_chats' => $resunt_online_chats[0]['COUNT(*)'],
		));

		return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.header_chats_counter.tpl');

	}

	public function isChatInvitation($data)
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_archive la WHERE la.in_chat = "P" AND la.chat_request_from = "Staff" AND la.id_visitor = "'.pSQL($data['id_visitor']).'"');

		$res = $result[0]['COUNT(*)'];

		if (!empty($res)) 
			return true;
		else 
			return false;
	}

	public function syncOnlineUsers()
	{
		$id_staffprofile = $this->getCurrentStaffProfileId();

		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_onlineusers SET last_update = DATE_FORMAT(NOW(),\'%Y-%m-%d %H:%i:%s\') WHERE id_staffprofile = "'.(int)$id_staffprofile.'"';
		Db::getInstance()->Execute($sql);

		$internals_to_delete = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlineusers` WHERE UNIX_TIMESTAMP(last_update) < '.pSQL(time() - $this->timeout));

		foreach ($internals_to_delete as $value)
		{
			$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive SET in_chat = "N", awaiting_response_from_staff = "N", is_archive = "Y" WHERE id_staffprofile = "'.(int)$value['id_staffprofile'].'"';
			Db::getInstance()->Execute($sql);

			$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_staffprofiles SET status = "Offline" WHERE id_staffprofile = "'.(int)$value['id_staffprofile'].'"';
			Db::getInstance()->Execute($sql);

			$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlineusers WHERE id_user = "'.(int)$value['id_user'].'"';
			Db::getInstance()->Execute($sql);
		}

		$visitors_to_delete = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlinevisitors` WHERE UNIX_TIMESTAMP(last_update) < '.pSQL(time() - $this->timeout));

		foreach ($visitors_to_delete as $value)
		{
			$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive SET in_chat = "N", awaiting_response_from_staff = "N", is_archive = "Y" WHERE id_visitor = "'.pSQL($value['id_visitor']).'"';
			Db::getInstance()->Execute($sql);

			$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlineusers WHERE id_visitor = "'.pSQL($value['id_visitor']).'"';
			Db::getInstance()->Execute($sql);

			$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlinevisitors WHERE id_visitor = "'.pSQL($value['id_visitor']).'"';
			Db::getInstance()->Execute($sql);

			$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_visitedpages WHERE id_visitor = "'.pSQL($value['id_visitor']).'"';
			Db::getInstance()->Execute($sql);
		}

		#return true;
		#return $this->syncChatDialog(false, 'ajax.onlineusers.tpl');
		#return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.onlineusers.tpl');
	}


	public function getVisitorArvhives($data = '')
	{
		return Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_archive` la WHERE la.`id_visitor` = "'.pSQL($data['id_visitor']).'"');
	}


	public function getArchives($in_chat = 'Y', $group_by_ip = false)
	{
		$group_by_ip_cond = ($group_by_ip == true) ? 'GROUP BY la.ip' : '';

		$in_chat_cond = empty($in_chat) ? '1' : 'la.in_chat = "'.pSQL($in_chat).'"';

		$current_staff_profile_id = $this->getCurrentStaffProfileId();

		$archives = Db::getInstance()->executeS(
			'SELECT *, 
			(
				SELECT `name` FROM  `'._DB_PREFIX_.$this->name.'_departments` ld WHERE ld.`id_department` = la.`id_department`
			) `department_name`
			FROM `'._DB_PREFIX_.$this->name.'_archive` la
   			WHERE '.$in_chat_cond.' AND (la.id_staffprofile = "'.(int)$current_staff_profile_id.'" OR la.id_visitor = "i'.(int)$current_staff_profile_id.'") 
   			'.$group_by_ip_cond.'
   			');

		return $archives;
	}


	public function showThemesDropdown()
	{
		$themes         = $this->getThemes();

		$module_js_dir  = dirname(__FILE__).'/views/js/';

		$livechatpro_js = '';

		$this->context->smarty->assign(array(
			'themes' => $themes,
			'module_js_dir' => $module_js_dir,
			'livechatpro_js' => $livechatpro_js
		));

		return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.themes.tpl');
	}

	public function deleteTheme($data)
	{
		if ($this->isDemo() == true)
			return 'ERROR_DEMO_MODE';
		
		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_themes WHERE id_theme = "'.(int)$data['id_theme'].'"';
		Db::getInstance()->Execute($sql);

		return true;
	}

	public function saveTheme($data)
	{
		$is_default = ($data['id_theme'] >= 1 && $data['id_theme'] <= 2) ? true : false;
		
		if ($this->isDemo() == true && $is_default == true)
			return 'ERROR_DEMO_MODE';

		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_themes lt SET ';
		$i   = 1;
		foreach ($data as $key => $value)
		{
			$sql .= pSQL($key).' = "'.pSQL($value).'"'.',';
			$i++;
		}
		$sql = Tools::substr($sql, 0, -1);
		$sql .= ' WHERE lt.id_theme = "'.(int)$data['id_theme'].'"';

		Db::getInstance()->Execute($sql);

		return true;
	}

	public function saveAsTheme($data)
	{
		$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_themes
        (
			name,
			width,
			height,
			corners_radius,
			chat_box_background,
			chat_box_foreground,
			chat_box_border,
			chat_box_border_color,
			header_offline_background,
			header_online_background,
			header_offline_foreground,
			header_online_foreground,
			submit_button_background,
			submit_button_foreground,
			is_default
		)
		VALUES
		(
			"'.pSQL($data['name']).'",
			"'.pSQL($data['width']).'",
			"'.pSQL($data['height']).'",
			"'.pSQL($data['corners_radius']).'",
			"'.pSQL($data['chat_box_background']).'",
			"'.pSQL($data['chat_box_foreground']).'",
			"'.pSQL($data['chat_box_border']).'",
			"'.pSQL($data['chat_box_border_color']).'",
			"'.pSQL($data['header_offline_background']).'",
			"'.pSQL($data['header_online_background']).'",
			"'.pSQL($data['header_offline_foreground']).'",
			"'.pSQL($data['header_online_foreground']).'",
			"'.pSQL($data['submit_button_background']).'",
			"'.pSQL($data['submit_button_foreground']).'",
			"0"
		)';

		Db::getInstance()->Execute($sql);

		return true;
	}


	public function checkIfSettingAndIsoCodeExists($data = '')
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_settings_lang lsl WHERE id_setting = "'.(int)$data['id_setting'].'" AND iso_code = "'.pSQL($data['iso_code']).'"');

		$res = $result[0]['COUNT(*)'];

		if (empty($res))
			return false;
		else
			return true;
	}


	public function savePerformanceSettings($data)
	{
		if ($this->isDemo() == true)
			return 'ERROR_DEMO_MODE';

		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_performancesettings lps SET ';
		$i   = 1;
		foreach ($data as $key => $value)
		{
			if ($key != 'id_performancesetting')
			{
					$sql .= pSQL($key).' = "'.pSQL($value).'"'.',';
				$i++;
			}
		}
		$sql = Tools::substr($sql, 0, -1);
		$sql .= ' WHERE lps.id_performancesetting = "1"';

		Db::getInstance()->Execute($sql);

		return true;
	}


	public function saveSettings($data)
	{
		$is_default_setting = ($data['id_setting'] >= 1 && $data['id_setting'] <= 2) ? true : false;
		
		if ($this->isDemo() == true && $is_default_setting == true)
			return 'ERROR_DEMO_MODE';

		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_settings ls SET ';
		$i   = 1;
		foreach ($data as $key => $value)
		{
			if ($key != 'offline_header_message' && $key != 'online_header_message' && $key != 'offline_welcome_message' && $key != 'online_welcome_message' && $key != 'iso_codes')
			{
				if ($key == 'code')
					$sql .= pSQL($key).' = "'.pSQL($value, true).'"'.',';
				else
					$sql .= pSQL($key).' = "'.pSQL($value).'"'.',';

				$i++;
			}
		}
		$sql = Tools::substr($sql, 0, -1);
		$sql .= ' WHERE ls.id_setting = "'.(int)$data['id_setting'].'"';

		Db::getInstance()->Execute($sql);

		//update la languages
		foreach ($data['iso_codes'] as $key => $value)
		{
			if ($this->checkIfSettingAndIsoCodeExists(array('id_setting' => $data['id_setting'], 'iso_code' => $value)) == true)
			{
				$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_settings_lang SET 
				offline_header_message = "'.pSQL($data['offline_header_message'][$value], true).'",
				online_header_message = "'.pSQL($data['online_header_message'][$value], true).'", 
				offline_welcome_message = "'.pSQL($data['offline_welcome_message'][$value], true).'", 
				online_welcome_message = "'.pSQL($data['online_welcome_message'][$value], true).'" 
				WHERE id_setting = "'.(int)$data['id_setting'].'" AND iso_code = "'.pSQL($value).'"';
			}
			else
			{
				$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_settings_lang
				(
					id_setting,
					id_lang,
					iso_code,
					offline_header_message,
					online_header_message,
					offline_welcome_message,
					online_welcome_message
				)
				VALUES 
				(
					"'.pSQL($data['id_setting']).'",
					"'.pSQL(Language::getIdByIso($value)).'",
					"'.pSQL($value).'",
					"'.pSQL($data['offline_header_message'][$value], true).'",
					"'.pSQL($data['online_header_message'][$value], true).'",
					"'.pSQL($data['offline_welcome_message'][$value], true).'",
					"'.pSQL($data['online_welcome_message'][$value], true).'"
				)';
			}
			Db::getInstance()->Execute($sql);
		}

		return true;
	}

	public function saveAsSettings($data)
	{
		$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_settings
		(
			id_iconset,
			id_theme,
			name,
			offline_messages_go_to,
			new_chat_sound,
			new_message_sound,
			name_field,
			email_field,
			phone_field,
			department_field,
			question_field,
			chat_type,
			orientation,
			offset,
			start_minimized,
			fields_are_not_mandatory,
			hide_when_offline,
			show_names,
			staff_qualification,
			position,
			position_options,
			code,
			hook,
			is_default,
			is_primary
		)
		VALUES 
		(
			"'.pSQL($data['id_iconset']).'",
			"'.pSQL($data['id_theme']).'",
			"'.pSQL($data['name']).'",
			"'.pSQL($data['offline_messages_go_to']).'",
			"'.pSQL($data['new_chat_sound']).'",
			"'.pSQL($data['new_message_sound']).'",
			"'.pSQL($data['name_field']).'",
			"'.pSQL($data['email_field']).'",
			"'.pSQL($data['phone_field']).'",
			"'.pSQL($data['department_field']).'",
			"'.pSQL($data['question_field']).'",
			"'.pSQL($data['chat_type']).'",
			"'.pSQL($data['orientation']).'",
			"'.pSQL($data['offset']).'",
			"'.pSQL($data['start_minimized']).'",
			"'.pSQL($data['fields_are_not_mandatory']).'",
			"'.pSQL($data['hide_when_offline']).'",
			"'.pSQL($data['show_names']).'",
			"'.pSQL($data['staff_qualification']).'",
			"'.pSQL(Tools::ucfirst($data['position'])).'",
			"'.pSQL($data['position_options']).'",
			"'.pSQL($data['code'], true).'",
			"'.pSQL($data['hook']).'",
			"0",
			"0"
		)';

		Db::getInstance()->Execute($sql);

		//get id_setting
		$id_setting = $this->getLastSettingId();

		//si lang
		foreach ($data['iso_codes'] as $value)
		{
			$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_settings_lang
			(
				id_setting,
				id_lang,
				iso_code,
				offline_header_message,
				online_header_message,
				offline_welcome_message,
				online_welcome_message
			)
			VALUES 
			(
				"'.pSQL($id_setting).'",
				"'.pSQL(Language::getIdByIso($value)).'",
				"'.pSQL($value).'",
				"'.pSQL($data['offline_header_message'][$value], true).'",
				"'.pSQL($data['online_header_message'][$value], true).'",
				"'.pSQL($data['offline_welcome_message'][$value], true).'",
				"'.pSQL($data['online_welcome_message'][$value], true).'"
			)';
			
			Db::getInstance()->Execute($sql);
		}

		return true;
	}

	public function getLastSettingId()
	{
		$sql = 'SELECT id_setting FROM '._DB_PREFIX_.$this->name.'_settings ORDER BY id_setting DESC LIMIT 1';

		$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

		if ($result)
			return $result[0]['id_setting'];
		else
			return 0;
	}	

	public function getLastIconsetId()
	{
		$sql = 'SELECT id_iconset FROM '._DB_PREFIX_.$this->name.'_iconsets ORDER BY id_iconset DESC LIMIT 1';

		$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

		if ($result)
			return $result[0]['id_iconset'];
		else
			return 0;
	}


	public function deleteSettings($data)
	{
		// nu stergem defaulturile
		if ($this->isDemo() == true)
			return 'ERROR_DEMO_MODE';

		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_settings WHERE id_setting = "'.(int)$data['id_setting'].'"';
		Db::getInstance()->Execute($sql);

		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_settings_lang WHERE id_setting = "'.(int)$data['id_setting'].'"';
		Db::getInstance()->Execute($sql);

		return true;
	}

	public function showSettingsDropdown()
	{
		$settings       = $this->getSettings();

		$module_js_dir  = dirname(__FILE__).'/views/js/';

		$livechatpro_js = '';

		$this->context->smarty->assign(array(
			'settings' => $settings,
			'module_js_dir' => $module_js_dir,
			'livechatpro_js' => $livechatpro_js
		));

		return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.settings.tpl');
	}

	public function showIconsetsDropdown()
	{
		$iconsets       = $this->getIconsets();

		$module_js_dir  = dirname(__FILE__).'/views/js/';

		$livechatpro_js = '';

		$this->context->smarty->assign(array(
			'iconsets' => $iconsets,
			'module_js_dir' => $module_js_dir,
			'livechatpro_js' => $livechatpro_js
		));

		return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.iconsets.tpl');
	}

	public function isDemo()
	{
		$is_demo = (stristr($_SERVER['SERVER_NAME'], 'prestashopaddonsmodules.com') || stristr($_SERVER['SERVER_NAME'], '4prestashop.com')) ? true : false;
		//$is_demo = ( stristr($_SERVER['SERVER_NAME'], 'prestashopaddonsmodules.com') || stristr($_SERVER['SERVER_NAME'], '4prestashop.com') ) ? false : true;
		
		return $is_demo;
	}

	public function deleteIconset($data)
	{
		if ($this->isDemo() == true)
			return 'ERROR_DEMO_MODE';		

		$iconset = $this->getIconset($data);

		$languages = Language::getLanguages(false);

		foreach ($languages as $value)
		{
			$offline_img_file = dirname(__FILE__).'/views/img/iconsets/'.$iconset['offline_img'][$value['iso_code']];
			$online_img_file  = dirname(__FILE__).'/views/img/iconsets/'.$iconset['online_img'][$value['iso_code']];

			//sterg iconitele
			@unlink($offline_img_file);
			@unlink($online_img_file);
		}

		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_iconsets WHERE id_iconset = "'.(int)$data['id_iconset'].'"';
		Db::getInstance()->Execute($sql);

		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_iconsets_lang WHERE id_iconset = "'.(int)$data['id_iconset'].'"';
		Db::getInstance()->Execute($sql);

		return true;
	}


	public function checkIfIconsetAndIsoCodeExists($data = '')
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_iconsets_lang lil WHERE id_iconset = "'.(int)$data['id_iconset'].'" AND iso_code = "'.pSQL($data['iso_code']).'"');

		$res = $result[0]['COUNT(*)'];

		if (empty($res))
			return false;
		else
			return true;
	}


	public function saveIconset($data)
	{
		$is_default = ($data['id_iconset'] >= 1 && $data['id_iconset'] <= 2) ? true : false;
		
		if ($this->isDemo() == true && $is_default == true)
			return 'ERROR_DEMO_MODE';

		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_iconsets li SET ';
		$i   = 1;
		foreach ($data as $key => $value)
		{
			if ($key != 'offline_img' && $key != 'online_img' && $key != 'iso_codes')
			{
				$sql .= pSQL($key).' = "'.pSQL($value).'"'.',';
				$i++;
			}
		}
		$sql = Tools::substr($sql, 0, -1);
		$sql .= ' WHERE li.id_iconset = "'.(int)$data['id_iconset'].'"';

		Db::getInstance()->Execute($sql);

		//update la languages
		foreach ($data['iso_codes'] as $key => $value)
		{
			if ($this->checkIfIconsetAndIsoCodeExists(array('id_iconset' => $data['id_iconset'], 'iso_code' => $value)) == true)
			{
				$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_iconsets_lang SET 
				offline_img = "'.pSQL($data['offline_img'][$value]).'",
				online_img = "'.pSQL($data['online_img'][$value]).'" 
				WHERE id_iconset = "'.(int)$data['id_iconset'].'" AND iso_code = "'.pSQL($value).'"';
			}
			else
			{
				$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_iconsets_lang
				(
					id_iconset,
					id_lang,
					iso_code,
					offline_img,
					online_img
				)
				VALUES 
				(
					"'.pSQL($data['id_iconset']).'",
					"'.pSQL(Language::getIdByIso($value)).'",
					"'.pSQL($value).'",
					"'.pSQL($data['offline_img'][$value]).'",
					"'.pSQL($data['online_img'][$value]).'"
				)';
			}
			Db::getInstance()->Execute($sql);
		}


		return true;
	}

	public function getMouseTracking($data)
	{
		$result = Db::getInstance()->executeS('SELECT *
			FROM `'._DB_PREFIX_.$this->name.'_mousetracking` lm
			LEFT JOIN `'._DB_PREFIX_.$this->name.'_onlinevisitors` lov ON (lm.`id_visitor` = lov.`id_visitor`)
			WHERE lm.id_visitor = "'.pSQL($data['id_visitor']).'"');

		return $result;
	}

	public function syncMouseTracking($data)
	{
		$data['tracking_data'] = pSQL(Tools::jsonEncode($data['tracking_data']));

		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_mousetracking WHERE id_visitor = "'.pSQL($data['id_visitor']).'"');

		$count  = $result[0]['COUNT(*)'];

		if (empty($count))
		{
			//fac insert
			$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_mousetracking
					(
						id_visitor,
						tracking_data
					)
					VALUES
					(
						"'.pSQL($data['id_visitor']).'",
						"'.pSQL($data['tracking_data']).'"
					)';

			Db::getInstance()->Execute($sql);
		}
		else
		{
			//fac update
			$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_mousetracking lm SET ';
			$i   = 1;
			foreach ($data as $key => $value)
			{
				$sql .= pSQL($key).' = "'.pSQL($value).'"'.',';
				$i++;
			}
			$sql = Tools::substr($sql, 0, -1);
			$sql .= ' WHERE lm.id_visitor = "'.pSQL($data['id_visitor']).'"';

			Db::getInstance()->Execute($sql);
		}

		return true;
	}

	public function saveAsIconset($data)
	{
		$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_iconsets
		(
			name,
			is_default
		)
		VALUES 
		(
			"'.pSQL($data['name']).'",
			"0"
		)';

		Db::getInstance()->Execute($sql);


		//get id_setting
		$id_iconset = $this->getLastIconsetId();

		//si lang
		foreach ($data['iso_codes'] as $value)
		{
			if (!empty($data['offline_img'][$value]))
			{
				//verific daca exista deja fisierele cu numele astea si daca exista fac o copie la ele cu alt nume (uniqid)
				$filename1 = dirname(__FILE__).'/views/img/iconsets/'.$data['offline_img'][$value];

				if (file_exists($filename1))
				{
					$uniqid1               = uniqid();

					$pathinfo_offline_img  = pathinfo($data['offline_img'][$value]);

					$offline_img_extension = $pathinfo_offline_img['extension'];

					$data['offline_img'][$value] = $uniqid1.'.'.$offline_img_extension;

					$filename1_new = dirname(__FILE__).'/views/img/iconsets/'.$data['offline_img'][$value];

					call_user_func('copy', $filename1, $filename1_new);
				}
			}

			if (!empty($data['online_img'][$value]))
			{
				$filename2 = dirname(__FILE__).'/views/img/iconsets/'.$data['online_img'][$value];

				if (file_exists($filename2))
				{
					$uniqid2              = uniqid();

					$pathinfo_online_img  = pathinfo($data['online_img'][$value]);

					$online_img_extension = $pathinfo_online_img['extension'];

					$data['online_img'][$value] = $uniqid2.'.'.$online_img_extension;

					$filename2_new = dirname(__FILE__).'/views/img/iconsets/'.$data['online_img'][$value];

					call_user_func('copy', $filename2, $filename2_new);
				}
			}

			$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_iconsets_lang
			(
				id_iconset,
				id_lang,
				iso_code,
				offline_img,
				online_img
			)
			VALUES 
			(
				"'.pSQL($id_iconset).'",
				"'.pSQL(Language::getIdByIso($value)).'",
				"'.pSQL($value).'",
				"'.pSQL($data['offline_img'][$value]).'",
				"'.pSQL($data['online_img'][$value]).'"
			)';
			
			Db::getInstance()->Execute($sql);
		}

		@ob_end_clean();

		return true;
	}


	public function deleteStaffProfile($data)
	{
		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_staffprofiles WHERE id_staffprofile = "'.(int)$data['id_staffprofile'].'"';
		Db::getInstance()->Execute($sql);

		return true;
	}

	public function deleteArchive($data)
	{
		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_archive WHERE id_archive = "'.(int)$data['id_archive'].'"';
		Db::getInstance()->Execute($sql);

		return true;
	}

	public function deleteMessage($data)
	{
		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_messages WHERE id_message = "'.(int)$data['id_message'].'"';
		Db::getInstance()->Execute($sql);

		return true;
	}

	public function deleteRating($data)
	{
		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_ratings WHERE id_rating = "'.(int)$data['id_rating'].'"';
		Db::getInstance()->Execute($sql);

		return true;
	}

	public function updateMessage($data)
	{
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_messages lm SET ';
		$i   = 1;
		foreach ($data as $key => $value)
		{
			$sql .= pSQL($key).' = "'.pSQL($value).'"'.',';
			$i++;
		}
		$sql = Tools::substr($sql, 0, -1);
		$sql .= ' WHERE id_message = "'.(int)$data['id_message'].'"';

		Db::getInstance()->Execute($sql);

		return true;

	}

	public function updateRating($data)
	{
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_ratings lr SET ';
		$i   = 1;
		foreach ($data as $key => $value)
		{
			$sql .= pSQL($key).' = "'.pSQL($value).'"'.',';
			$i++;
		}
		$sql = Tools::substr($sql, 0, -1);
		$sql .= ' WHERE id_rating = "'.(int)$data['id_rating'].'"';

		Db::getInstance()->Execute($sql);

		return true;

	}

	public function addRating($data = '')
	{
		$archive_details = $this->getArchive(array('id_archive' => $data['id_archive']));

		$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_ratings 
				(
					id_archive,
					id_staffprofile,
					id_visitor,
					status,
					internal,
					politness,
					qualification,
					date_add,
					name,
					email,
					company,
					comment
				) 
				VALUES 
				(
					"'.pSQL($archive_details['id_archive']).'",
					"'.pSQL($archive_details['id_staffprofile']).'",
					"'.pSQL($archive_details['id_visitor']).'",
					"Unread",
					"'.pSQL($archive_details['internal']).'",
					"'.pSQL($data['stars']).'",
					"'.pSQL($data['stars']).'",
					DATE_FORMAT(NOW(),\'%Y-%m-%d %H:%i:%s\'),
					"'.pSQL($archive_details['name']).'",
					"'.pSQL($archive_details['email']).'",
					"'.pSQL($archive_details['company']).'",
					"'.pSQL($data['comment']).'"
                )';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		return true;
	}

	public function updateStaffProfile($data)
	{
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_staffprofiles lsp
			SET avatar = "'.pSQL($data['avatar']).'",
				departments = "'.pSQL($data['departments']).'",
				welcome_message = "'.pSQL($data['welcome_message'], true).'",
				signature = "'.pSQL($data['signature'], true).'",
				is_active = "'.pSQL($data['is_active']).'"
			WHERE id_staffprofile = "'.(int)$data['id_staffprofile'].'"';

		Db::getInstance()->Execute($sql);

		return true;

	}

	public function addStaffProfile($data)
	{
		$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_staffprofiles 
				(
					id_employee,
					avatar,
					departments,
					welcome_message,
					signature,
					status,
					is_active
				) 
				VALUES 
				(
					"'.(int)$data['id_employee'].'",
					"'.pSQL($data['avatar']).'",
					"'.pSQL($data['departments']).'",
					"'.pSQL($data['welcome_message'], true).'",
					"'.pSQL($data['signature'], true).'",
					"'.pSQL($data['status']).'",
					"'.pSQL($data['is_active']).'"
                )';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		return true;
	}


	public function replyToMessage($data)
	{
		$primary_settings = $this->getPrimarySettings();

		//make mark as read message
		$this->updateMessage(array(
			'id_message' => $data['id_message'],
			'status' => 'Read',
		));

		$message = $this->getMessage(array('id_message' => $data['id_message']));

		$params = array(
			'{name}' => $this->context->employee->firstname.' '.$this->context->employee->lastname,
			'{from_email}' => $primary_settings['offline_messages_go_to'], // shop email address
			'{to_email}' => $message['email'],
			'{message}' => $data['messages_reply'],
		);

		Mail::Send($this->id_lang, 
					'lcp_reply', 
					$this->l('Livechat reply to your message'), 
					$params, 
					$message['email'], // to
					null,
					$primary_settings['offline_messages_go_to'], // from
					$this->context->employee->firstname.' '.$this->context->employee->lastname,
					null,
					null,
					dirname(__FILE__).'/mails/');

		@ob_end_clean();

		return true;
	}


	public function clearDatabase()
	{
		$sql_array = '';
		$sql_execution = '';

		$sql_array[] = 'DELETE FROM `'._DB_PREFIX_.$this->name.'_archive`;';
		$sql_array[] = 'DELETE FROM `'._DB_PREFIX_.$this->name.'_logs`;';
		$sql_array[] = 'DELETE FROM `'._DB_PREFIX_.$this->name.'_messages`;';
		$sql_array[] = 'DELETE FROM `'._DB_PREFIX_.$this->name.'_ratings`;';

		foreach ($sql_array as $sql)
			$sql_execution[] = Db::getInstance()->Execute($sql);	

		return true;
	}

	public function addMessage($data)
	{
		$sql = 'INSERT
		   INTO '._DB_PREFIX_.$this->name.'_messages (
														id_visitor,
														id_department,
														date_add,
														status,
														name,
														email,
														phone,
														department,
														question,
														ip
		   											 ) 
													VALUES 
													(
														"'.pSQL($data['id_visitor']).'",
														"'.pSQL($data['id_department']).'",
   											 			DATE_FORMAT(NOW(),\'%Y-%m-%d %H:%i:%s\'),
   											 			"Unread",
   											 			"'.pSQL($data['name']).'",
   											 			"'.pSQL($data['email']).'",
   											 			"'.pSQL($data['phone']).'",
   											 			"'.pSQL($data['department']).'",
   											 			"'.pSQL($data['question']).'",
   											 			"'.pSQL(Tools::getRemoteAddr()).'"
								   					)';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		//sending the email
		$primary_settings = $this->getPrimarySettings();

			$params = array(
				'{name}' => $data['name'],
				'{email}' => $data['email'],
				'{phone}' => $data['phone'],
				'{department}' => $data['department'],
				'{question}' => $data['question'],
				'{current_url}' => $data['current_url'],
				'{ip_address}' => Tools::getRemoteAddr(),
			);

		Mail::Send($this->id_lang, 
					'lcp_offline_message', 
					$this->l('Livechat offline message from:').' '.$data['email'], 
					$params, 
					$primary_settings['offline_messages_go_to'],
					null,
					$data['email'], // from
					$data['name'],
					null,
					null,
					dirname(__FILE__).'/mails/');

		@ob_end_clean();

		return true;

	}

	public function addVisitedPage($data)
	{
		$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_visitedpages 
				(
					id_visitor,
					date_add,
					duration,
					url,
					referrer
				) 
				VALUES 
				(
					"'.pSQL($data['id_visitor']).'",
					DATE_FORMAT(NOW(),\'%Y-%m-%d %H:%i:%s\'),
					"00:00:10",
					"'.pSQL($data['url']).'",
					"'.pSQL($data['referrer']).'"
				)';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		return true;
	}





	public function addUpdateArchive($data = '')
	{
		if (empty($data['id_employee']))
			$data['id_employee'] = $this->getEmployeeIdByStaffProfile($data['id_staffprofile']);

		$employee_details = $this->getEmployeeById($data['id_employee']);

		if ($this->checkIfVisitorIdInArchive($data['id_visitor']) == false)
		{
			//$data['id_chat']                      = '';
			//$data['id_visitor']                   = $data['id_visitor'];
			//$data['id_staffprofile']              = $data['id_staffprofile'];
			$data['id_department']                = ifsetor($data['id_department'], 1);
			//$data['action']                       = $data['action'];
			$data['internal']                     = $employee_details['firstname'].' '.$employee_details['lastname'];
			//$data['in_chat']                      = $data['in_chat'];
			//$data['chat_request_from']            = $data['chat_request_from'];
			//$data['awaiting_response_from_staff'] = $data['awaiting_response_from_staff'];
			$data['name']                         = ifsetor($data['name'], '');
			$data['email']                        = ifsetor($data['email'], '');
			$data['phone']                        = ifsetor($data['phone'], '');
			$data['company']                      = ifsetor($data['company'], '');
			$data['duration']                     = '0';
			$data['messages']                     = $data['messages'];
			$data['last_message']                 = $data['messages'];
			$data['log_entries']                  = '0';
			// some of the above vars are for remembering purposes.
			$this->addArchive($data);
		}
		else
		{
			//$data['id_visitor']                   = $data['id_visitor'];
			//$data['in_chat']                      = $data['in_chat'];
			//$data['chat_request_from']            = $data['chat_request_from'];
			//$data['awaiting_response_from_staff'] = $data['awaiting_response_from_staff'];
			//$data['id_staffprofile']              = $data['id_staffprofile'];
			//$data['action']                       = $data['action'];
			$data['internal']                     = $employee_details['firstname'].' '.$employee_details['lastname'];
			// some of the above vars are for remembering purposes.
			$this->updateArchive($data);
		}		

		@ob_end_clean();

		return true;
	}


	public function addArchive($data = '')
	{
		$visitor_details = $this->getVisitor(array('id_visitor' => $data['id_visitor']));

		$id_chat = $this->getLastChatId() + 1;
		// 1) --------------------------------------------------------------------------------
		$sql1 = 'INSERT INTO '._DB_PREFIX_.$this->name.'_archive
			(
				id_chat,
				id_visitor,
				id_staffprofile,
				id_department,
				action,
				internal,
				date_add,
				in_chat,
				chat_request_from,
				awaiting_response_from_staff,
				name,
				email,
				phone,
				company,
				language,
				country,
				ip,
				host,
				duration,
				messages,
				last_message,
				log_entries,
				is_archive
			) 
			VALUES 
			(
				"'.(int)$id_chat.'",
				"'.pSQL($data['id_visitor']).'",
				"'.(int)$data['id_staffprofile'].'",
				"'.pSQL($data['id_department']).'",
				"'.pSQL($data['action']).'",
				"'.pSQL($data['internal']).'",
				DATE_FORMAT(NOW(),\'%Y-%m-%d %H:%i:%s\'),
				"'.pSQL($data['in_chat']).'",
				"'.pSQL($data['chat_request_from']).'",
				"'.pSQL($data['awaiting_response_from_staff']).'",
				"'.pSQL($data['name']).'",
				"'.pSQL($data['email']).'",
				"'.pSQL($data['phone']).'",
				"'.pSQL($data['company']).'",
				"'.pSQL($visitor_details['language']).'",
				"'.pSQL($visitor_details['country']).'",
				"'.pSQL($visitor_details['ip']).'",
				"'.pSQL($visitor_details['host']).'",
				"'.pSQL($data['duration']).'",
				"'.pSQL($data['messages'], true).'",
				"'.pSQL($data['last_message']).'",
				"'.pSQL($data['log_entries']).'",
				"'.pSQL($data['is_archive']).'"
			)';

		@Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql1);

		// adaugam cookie cu set visitor details
		/*if (Tools::substr($data['id_visitor'], 0, 1) !== 'i')
		{
			$staff_details_to_show = $this->getCookie('staff_details_to_show');	

			if (empty($staff_details_to_show))
				$staff_details_to_show = array();

			array_push($staff_details_to_show, $data['id_visitor']);

			$this->setCookie( $staff_details_to_show );
		}
		else
		{
			$visitor_details_to_show = $this->getCookie('visitor_details_to_show');	

			if (empty($visitor_details_to_show))
				$visitor_details_to_show = array();

			array_push($visitor_details_to_show, $data['id_visitor']);

			$this->setCookie( $visitor_details_to_show );
		}*/

	}


	public function addVisitor($data)
	{
		$ip = (Tools::getRemoteAddr() == '::1') ? '127.0.0.1' : Tools::getRemoteAddr();

		$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_onlinevisitors 
			(
				session_id,
				country,
				city,
				province,
				language,
				visits,
				current_page,
				host,
				ip,
				browser,
				timezone,
				resolution,
				online_time,
				referrer,
				page_count,
				os,
				last_visit
            ) 
			VALUES 
			(
				"'.pSQL($data['session_id']).'",
				"",
				"",
				"",
				"'.pSQL($data['language']).'",
				"0",
				"'.pSQL($data['current_page']).'",
				"'.pSQL($_SERVER['HTTP_HOST']).'",
				"'.pSQL($ip).'",
				"'.pSQL($data['browser']).'",
				"GMT '.pSQL($data['timezone']).':00",
				"'.pSQL($data['resolution']).'",
				"00:00:10",
				"'.pSQL($data['referrer']).'",
				"0",
				"'.pSQL($data['os']).'",
				DATE_FORMAT(NOW(),\'%Y-%m-%d %H:%i:%s\') 
            )';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		$id_visitor = $this->getLastVisitorId();

		$tracking_info = $this->getGeoTracking();

		//update geotracking
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_onlinevisitors
			SET country = "'.pSQL($tracking_info['country']).'",
			city = "'.pSQL($tracking_info['city']).'"
		WHERE id_visitor = "'.pSQL($id_visitor).'"';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);
		
		@ob_end_clean();

		return $id_visitor;
	}

	public function updateArchive($data)
	{
		/*if (isset($data['id_employee']))
			unset($data['id_employee']);*/

		$sql = 'UPDATE `'._DB_PREFIX_.$this->name.'_archive` la SET ';
		$i   = 1;
		foreach ($data as $key => $value)
		{
			if ($key != 'id_employee')
			{
				$sql .= pSQL($key).' = "'.pSQL($value).'"'.',';
				$i++;
			}
		}
		$sql = Tools::substr($sql, 0, -1);
		$sql .= ' WHERE id_visitor = "'.pSQL($data['id_visitor']).'" AND is_archive != "Y"';

		Db::getInstance()->Execute($sql);

		return true;
	}


	public function updateVisitor($data)
	{
		$sql = 'UPDATE `'._DB_PREFIX_.$this->name.'_onlinevisitors` lov SET ';
		$i   = 1;
		foreach ($data as $key => $value)
		{
			$sql .= pSQL($key).' = "'.pSQL($value).'"'.',';
			$i++;
		}
		$sql = Tools::substr($sql, 0, -1);
		$sql .= ' WHERE session_id = "'.pSQL($data['session_id']).'"';

		Db::getInstance()->Execute($sql);

		return true;
	}

	public function getLastVisitorId()
	{
		$sql = 'SELECT id_visitor
			FROM '._DB_PREFIX_.$this->name.'_onlinevisitors
			ORDER BY id_visitor DESC LIMIT 1';

		$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

		if ($result)
			return $result[0]['id_visitor'];
		else
			return 0;
	}

	public function getLastChatId()
	{
		$sql = 'SELECT id_chat FROM '._DB_PREFIX_.$this->name.'_archive ORDER BY id_archive DESC LIMIT 1';

		$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

		if ($result)
			return $result[0]['id_chat'];
		else
			return 0;
	}

	/*public function checkIfVisitorIdInCometActions($id_visitor)
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_cometactions la WHERE id_visitor = "'.pSQL($id_visitor).'"');

		$res = $result[0]['COUNT(*)'];

		if (empty($res))
			return false;
		else
			return true;
	}*/

	public function chatAcceptedFromClient($data = '')
	{
		// 1) --------------------------------------------------------------------------------
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive
          SET
          action = "chatAcceptedFromClient",
          awaiting_response_from_staff = "Y",
          in_chat = "Y",
          is_archive = "N" 
          WHERE id_visitor = "'.pSQL($data['id_visitor']).'" AND is_archive != "Y"';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		// get data from archive
		$sql = 'SELECT * FROM '._DB_PREFIX_.$this->name.'_archive WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';

		$archive_details = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		$archive_details = $archive_details[0];

		// 3) --------------------------------------------------------------------------------
		$data['id_staffprofile'] = $archive_details['id_staffprofile'];
		$data['id_visitor'] = $data['id_visitor'];
		$data['type'] = 'External';

		$this->addOnlineUser($data);

		// fac update la comet actions
		/*$sql = 'UPDATE
          '._DB_PREFIX_.$this->name.'_cometactions
          SET name = "chatAcceptedFromClient",
              data = "'.pSQL(Tools::jsonEncode($data)).'"
          WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';
		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);*/

		@$this->addLog(array(
			'id_staffprofile' => $archive_details['id_staffprofile'],
			'id_visitor' => $data['id_visitor'],
			'message' => 'Chat-Request accepted by (Client).'
		));
		#return $this->syncChatDialog(false, 'ajax.onlineusers.tpl');
		#return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.onlineusers.tpl');
	}


	public function chatAcceptedFromStaff($data = '')
	{
		// 1) --------------------------------------------------------------------------------
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive
          SET
          id_staffprofile = "'.(int)$data['id_staffprofile'].'",
          action = "chatAcceptedFromStaff",
          awaiting_response_from_staff = "Y",
          internal = "'.pSQL($data['internal']).'",
          in_chat = "Y",
          is_archive = "N" 
          WHERE id_visitor = "'.pSQL($data['id_visitor']).'" AND is_archive != "Y"';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		// 3) --------------------------------------------------------------------------------
		$data['id_staffprofile'] = $data['id_staffprofile'];
		$data['id_visitor'] = $data['id_visitor'];
		$data['type'] = 'External';

		$this->addOnlineUser($data);

		// fac update la comet actions
		/*$sql = 'UPDATE
          '._DB_PREFIX_.$this->name.'_cometactions
          SET name = "chatAcceptedFromStaff",
              data = "'.pSQL(Tools::jsonEncode($data)).'"
          WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';
		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);*/

		#@$this->addLog('Chat-Request accepted by '.pSQL($this->context->employee->lastname).' (Staff).');
		@$this->addLog(array(
			'id_staffprofile' => $data['id_staffprofile'],
			'id_visitor' => $data['id_visitor'],
			'message' => 'Chat-Request accepted by '.pSQL($this->context->employee->lastname).' (Staff).'
		));

		return $this->syncChatDialog(false, 'ajax.onlineusers.tpl');
		#return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.onlineusers.tpl');
	}



	public function chatDeniedFromStaff($data = '')
	{
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive
			SET
				id_staffprofile = "'.(int)$data['id_staffprofile'].'",
				action = "chatDeniedFromStaff",
				awaiting_response_from_staff = "N",
				internal = "'.pSQL($data['internal']).'",
				in_chat = "N",
				is_archive = "Y" 
			WHERE id_visitor = "'.pSQL($data['id_visitor']).'" AND is_archive != "Y"';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		// get data from archive
		$sql = 'SELECT * FROM '._DB_PREFIX_.$this->name.'_archive WHERE  id_visitor = "'.pSQL($data['id_visitor']).'"';

		$archive_details = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql); 

		$archive_details = $archive_details[0];

		$department = $this->getDepartment(array('id_department' => $archive_details['id_department']));

		$archive_details['department'] = $department['name'];

		// 2) --------------------------------------------------------------------------------
		$sql = 'INSERT INTO '._DB_PREFIX_.$this->name.'_messages
			(
				id_department,
				status,
				name,
				email,
				phone,
				department,
				question,
				ip
			) 
			VALUES 
			(
				"'.(int)$archive_details['id_department'].'",
				"Unread",
				"'.pSQL($archive_details['name']).'",
				"'.pSQL($archive_details['email']).'",
				"'.pSQL($archive_details['phone']).'",
				"'.pSQL($archive_details['department']).'",
				"'.pSQL($archive_details['last_message']).'",
				"'.pSQL($archive_details['ip']).'"
			)';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);


		// 4) --------------------------------------------------------------------------------
		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlineusers WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';

		Db::getInstance()->Execute($sql);

		// fac update la comet actions
		/*$sql = 'UPDATE
          '._DB_PREFIX_.$this->name.'_cometactions
          SET name = "chatDeniedFromStaff",
              data = "'.pSQL(Tools::jsonEncode($data)).'"
          WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';
		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);*/

		#@$this->addLog('Chat-Request denied by '.pSQL($this->context->employee->lastname).' (Staff).');
		@$this->addLog(array(
			'id_staffprofile' => $archive_details['id_staffprofile'],
			'id_visitor' => $data['id_visitor'],
			'message' => 'Chat-Request denied by '.pSQL($this->context->employee->lastname).' (Staff).'
		));

		#return $this->syncChatDialog(false, 'ajax.chats.tpl');
		#return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.chats.tpl');
	}



	public function chatDeniedFromClient($data = '')
	{
		// 1) --------------------------------------------------------------------------------
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive
			SET
				action = "chatDeniedFromClient",
				awaiting_response_from_staff = "N",
				in_chat = "N",
				is_archive = "Y" 
			WHERE id_visitor = "'.pSQL($data['id_visitor']).'" AND is_archive != "Y"';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		// get data from archive
		$sql = 'SELECT * FROM '._DB_PREFIX_.$this->name.'_archive WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';

		$archive_details = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql); 

		$archive_details = $archive_details[0];

		// 4) --------------------------------------------------------------------------------
		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlineusers WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';

		Db::getInstance()->Execute($sql);

		// fac update la comet actions
		/*$sql = 'UPDATE
          '._DB_PREFIX_.$this->name.'_cometactions
          SET name = "chatDeniedFromClient",
              data = "'.pSQL(Tools::jsonEncode($data)).'"
          WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';
		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);*/

		#@$this->addLog('Chat-Request denied by (Client).');
		@$this->addLog(array(
			'id_staffprofile' => $archive_details['id_staffprofile'],
			'id_visitor' => $data['id_visitor'],
			'message' => 'Chat-Request denied by (Client).'
		));

		#return $this->syncChatDialog(false, 'ajax.chats.tpl');
		#return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.chats.tpl');
	}



	public function chatClosedFromStaff($data = '')
	{
		// 1) --------------------------------------------------------------------------------
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive
			SET
				id_staffprofile = "'.(int)$data['id_staffprofile'].'",
				action = "chatClosedFromStaff",
				awaiting_response_from_staff = "N",
				internal = "'.pSQL($data['internal']).'",
				in_chat = "N",
				is_archive = "Y" 
			WHERE id_visitor = "'.pSQL($data['id_visitor']).'" AND is_archive != "Y"';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		// get data from archive
		$sql = 'SELECT * FROM '._DB_PREFIX_.$this->name.'_archive WHERE  id_visitor = "'.pSQL($data['id_visitor']).'"';

		$archive_details = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql); 

		$archive_details = $archive_details[0];

		// 4) --------------------------------------------------------------------------------
		if (Tools::substr($data['id_visitor'], 0, 1) !== 'i')
		{
			$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlineusers WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';
			Db::getInstance()->Execute($sql);
			
			// scot cookie to show
			/*$visitor_details_to_show = $this->getCookie('visitor_details_to_show');	

			if (!empty($visitor_details_to_show))
			{
				if (($key = array_search($data['id_visitor'], $visitor_details_to_show)) !== false) 
	    			unset($visitor_details_to_show[$key]);
			}
			else
				$visitor_details_to_show = array();

	    	$this->setCookie( $visitor_details_to_show );*/

		}
		else
		{
			// scot cookie to show
			/*$staff_details_to_show = $this->getCookie('staff_details_to_show');	

			if (!empty($staff_details_to_show))
			{
				if (($key = array_search($data['id_visitor'], $staff_details_to_show)) !== false) 
	    			unset($staff_details_to_show[$key]);
			}
			else
				$staff_details_to_show = array();

	    	$this->setCookie( $staff_details_to_show );*/
		}

		// fac update la comet actions
		/*$sql = 'UPDATE
          '._DB_PREFIX_.$this->name.'_cometactions
          SET name = "chatClosedFromStaff",
              data = "'.pSQL(Tools::jsonEncode($data)).'"
          WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';
		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);*/

		#@$this->addLog('Chat-Request closed by '.pSQL($this->context->employee->lastname).' (Staff).');
		@$this->addLog(array(
			'id_staffprofile' => $archive_details['id_staffprofile'],
			'id_visitor' => $data['id_visitor'],
			'message' => 'Chat-Request closed by '.pSQL($this->context->employee->lastname).' (Staff).'
		));

	}


	public function chatClosedFromClient($data = '')
	{
		// 1) in livechatpro_archive pun id_staffprofile, internal, in_chat = N
		// 2) adaug chatul in messages
		// 3) in onlinevisitors pun in_chat = N
		// 4) sterg din onlineusers

		// 1) --------------------------------------------------------------------------------
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive
			SET
				in_chat = "N",
				action = "chatClosedFromClient",
				awaiting_response_from_staff = "N",
				is_archive = "Y" 
			WHERE id_visitor = "'.pSQL($data['id_visitor']).'" AND is_archive != "Y"';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		// get data from archive
		$sql = 'SELECT * FROM '._DB_PREFIX_.$this->name.'_archive WHERE  id_visitor = "'.pSQL($data['id_visitor']).'"';

		$archive_details = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql); 

		$archive_details = $archive_details[0];

		// 4) --------------------------------------------------------------------------------
		if (Tools::substr($data['id_visitor'], 0, 1) !== 'i')
		{
			$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlineusers WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';

			Db::getInstance()->Execute($sql);
		}
		#@$this->addLog('Chat-Request closed by '.pSQL($archive_details['name']).' (Client).');
		@$this->addLog(array(
			'id_staffprofile' => $archive_details['id_staffprofile'],
			'id_visitor' => $data['id_visitor'],
			'message' => 'Chat-Request closed by '.pSQL($archive_details['name']).' (Client).'
		));
		#return $this->syncFrontChatDialog(false, 'ajax.start_chat.tpl');
	}
	

	/* --------------------------------------------------------------------------------------------------- */
	/*id_visitor , id_staffprofile*/
	public function chatRequestFromStaff($data = '')
	{
		$data['action'] = 'chatRequestFromStaff';
		$data['in_chat'] = 'P';
		$data['chat_request_from'] = 'Staff';
		$data['awaiting_response_from_staff'] = 'N';
		$data['messages'] = $this->l('Chat invitation from staff');
		$data['is_archive'] = 'N';

		$this->addUpdateArchive($data);

		@$this->addLog(array(
			'id_staffprofile' => $this->getCurrentStaffProfileId(),
			'id_visitor' => $data['id_visitor'],
			'message' => 'Chat-Request from (Staff).'
		));
		#return $this->syncFrontChatDialog(false, 'ajax.start_chat.tpl');
	}

	/*id_visitor , id_staffprofile*/
	public function chatRequestFromStaffToStaff($data = '')
	{
		#$id_visitor_staffprofile = Tools::substr($data['id_visitor'], 1);
		#$id_employee = $this->getEmployeeIdByStaffProfile($id_visitor_staffprofile);
		#$employee_details = $this->getEmployeeById($id_employee);	

		$data['action'] = 'chatRequestFromStaffToStaff';
		$data['in_chat'] = 'Y';
		$data['chat_request_from'] = 'Staff';
		$data['awaiting_response_from_staff'] = 'N';
		$data['messages'] = $this->l('Chat invitation from staff to staff');
		$data['is_archive'] = 'N';
		$data['name'] = 'Staff';

		$this->addUpdateArchive($data);

		@$this->addLog(array(
			'id_staffprofile' => $this->getCurrentStaffProfileId(),
			'id_visitor' => $data['id_visitor'],
			'message' => 'Chat-Request from (Staff).'
		));
		#return $this->syncFrontChatDialog(false, 'ajax.start_chat.tpl');
	}


	/*name, email, phone, department, question, id_department, id_visitor*/
	public function chatRequestFromClient($data = '')
	{
		if ($this->getChatStatus() == 'offline') 
			return;

		$data['action'] = 'chatRequestFromClient';
		$data['in_chat'] = 'P';
		$data['chat_request_from'] = 'Client';
		$data['awaiting_response_from_staff'] = 'Y';
		$data['id_staffprofile'] = $this->getMostAvailableStaffMemberId($data['id_department']);
		$data['messages'] = $data['question'];
		$data['is_archive'] = 'N';

		$this->addUpdateArchive($data);	

		#@$this->addLog('Chat-Request from (Client).');
		@$this->addLog(array(
			'id_staffprofile' => $data['id_staffprofile'],
			'id_visitor' => $data['id_visitor'],
			'message' => 'Chat-Request from (Client).'
		));
		#return $this->syncFrontChatDialog(false, 'ajax.start_chat.tpl');

	}


	public function chatMessageFromStaff($data = '')
	{
		// 1) face update la archive fieldul messages si last_message

		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive
			SET messages = CONCAT(messages, "'.pSQL($data['messages'], true).'"),
			action = "chatMessageFromStaff",
			awaiting_response_from_staff = "N",
			last_message = "'.pSQL($data['msg'], true).'"
			WHERE id_visitor = "'.pSQL($data['id_visitor']).'" AND is_archive != "Y"';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		// fac update la comet actions
		/*$sql = 'UPDATE
			'._DB_PREFIX_.$this->name.'_cometactions
			SET name = "chatMessageFromStaff",
				data = "'.pSQL(Tools::jsonEncode($data)).'"
			WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';
		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);*/

		#return $this->syncChatDialog(false, 'ajax.chats.tpl');
		#return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.chats.tpl');
	}


	public function chatMessageFromClient($data = '')
	{
		// 1) face update la archive fieldul messages si last_message
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive
			SET messages = CONCAT(messages, "'.pSQL($data['messages'], true).'"),
				awaiting_response_from_staff = "Y",
				action = "chatMessageFromClient",
				last_message = "'.pSQL($data['msg'], true).'"
			WHERE id_visitor = "'.pSQL($data['id_visitor']).'" AND is_archive != "Y"';

		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

		// fac update la comet actions
		/*$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_cometactions
			SET name = "chatMessageFromClient",
				data = "'.pSQL(Tools::jsonEncode($data)).'"
			WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';
		Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);	*/

		#return $this->syncFrontChatDialog(false, 'ajax.start_chat.tpl');		
	}


	/**
	* Unused parameter function $id_department
	* @return int
	*/
	public function getMostAvailableStaffMemberId($id_department = '')
	{
		$online_staff_members = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlineusers` lou
			LEFT JOIN `'._DB_PREFIX_.$this->name.'_staffprofiles` lsp ON (lou.`id_staffprofile` = lsp.`id_staffprofile`)
			WHERE lou.type = "Internal" AND lsp.is_active = "Y" AND lsp.departments LIKE "%'.(int)$id_department.'%"');

		#$online_staff_members = '';

		if (empty($online_staff_members))
		{
			// cautam la alt departament
			$online_staff_members = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlineusers` lou
			LEFT JOIN `'._DB_PREFIX_.$this->name.'_staffprofiles` lsp ON (lou.`id_staffprofile` = lsp.`id_staffprofile`)
			WHERE lou.type = "Internal" AND lsp.is_active = "Y"');
		}

		$arr_info = array();
		foreach ($online_staff_members as $value)
		{
			$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_archive la WHERE la.in_chat = "Y" AND la.id_visitor REGEXP("(^[0-9]+$)") AND la.id_staffprofile = "'.(int)$value['id_staffprofile'].'"');
			$arr_info[$value['id_staffprofile']] = $result[0]['COUNT(*)'];
		}
		//AND la.id_visitor REGEXP("(^[0-9]+$)")
		#d($arr_info);

		$min = min($arr_info);

		$id_staffprofile = array_search($min, $arr_info);

		return $id_staffprofile;
	}


	public function transferVisitor($data = '')
	{
		if (!empty($data['id_visitor']) && !empty($data['id_staffprofile_destination']))
		{
			$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive
				SET
					in_chat = "P",
					id_staffprofile = "'.(int)$data['id_staffprofile_destination'].'",
					action = "chatRequestFromClient",
					awaiting_response_from_staff = "Y" 
				WHERE id_visitor = "'.pSQL($data['id_visitor']).'" AND is_archive != "Y"';

			Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

			if (Tools::substr($data['id_visitor'], 0, 1) !== 'i')
			{
				$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlineusers WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';

				Db::getInstance()->Execute($sql);
			}

			@$this->addLog(array(
						'id_staffprofile' => $data['id_staffprofile_destination'],
						'id_visitor' => $data['id_visitor'],
						'message' => 'Chat-Transfer to another staff (Staff).'
					));

			return true;
		}
		else
			return false;
	}


	public function getOnlineUsers($type = 'External')
	{
		if ($type == 'External')
		{
			return Db::getInstance()->executeS('SELECT *
				FROM `'._DB_PREFIX_.$this->name.'_onlineusers` lou
				LEFT JOIN `'._DB_PREFIX_.$this->name.'_onlinevisitors` lov ON (lou.`id_visitor` = lov.`id_visitor`)
				LEFT JOIN `'._DB_PREFIX_.$this->name.'_archive` la ON (lou.`id_visitor` = la.`id_visitor`)
				WHERE lou.type = "'.pSQL(Tools::ucfirst($type)).'" AND la.is_archive != "Y"');
		}
		else
		{
			$online_internal_users = Db::getInstance()->executeS('SELECT *
				FROM `'._DB_PREFIX_.$this->name.'_onlineusers` lou
				LEFT JOIN `'._DB_PREFIX_.$this->name.'_staffprofiles` lsp ON (lou.`id_staffprofile` = lsp.`id_staffprofile`)
				LEFT JOIN `'._DB_PREFIX_.'employee` e ON (lsp.`id_employee` = e.`id_employee`)
				WHERE lou.type = "'.pSQL(Tools::ucfirst($type)).'"');

			$arr_info = array();

			if ($online_internal_users)
			{
				foreach ($online_internal_users as $value)
				{
					$value['count_online_archives'] = $this->countStaffOnlineArchives($value['id_staffprofile']);

					$arr_info[] = $value;
				}
			}

			return $arr_info;
		}
	}


	public function countStaffOnlineArchives($id_staffprofile)
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_onlineusers lou WHERE lou.id_staffprofile = "'.pSQL($id_staffprofile).'" AND lou.id_visitor != "0"');

		$res = $result[0]['COUNT(*)'];

		if (!empty($res)) 
			return $result[0]['COUNT(*)'];
		else 
			return 0;
	}


	/* type : Active, Pending, Inactive */
	public function countArchives($in_chat = 'Y')
	{
		$in_chat_cond = empty($in_chat) ? '1' : 'la.in_chat = "'.pSQL($in_chat).'"';

		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_archive la WHERE '.$in_chat_cond.'');

		$res = $result[0]['COUNT(*)'];

		if (!empty($res)) 
			return $result[0]['COUNT(*)'];
		else 
			return 0;
	}

	public function countOnlineUsers($type = 'External')
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_onlineusers lou WHERE lou.type = "'.pSQL(Tools::ucfirst($type)).'"');

		$res = $result[0]['COUNT(*)'];

		if (!empty($res)) 
			return $result[0]['COUNT(*)'];
		else 
			return 0;
	}

	public function countOnlineVisitors()
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_onlinevisitors lov');

		$res = $result[0]['COUNT(*)'];

		if (!empty($res))  
			return $result[0]['COUNT(*)'];
		else 
			return 0;
	}

	public function getStaffProfilesIdsToDelete($employees_ids)
	{
		if (!empty($employees_ids))
		{
			$employees_ids_list = '';

			foreach ($employees_ids as $value)
				$employees_ids_list .= $value.',';

			$employees_ids_list = Tools::substr($employees_ids_list, 0, -1);
		}

		$result = Db::getInstance()->executeS('SELECT * FROM '._DB_PREFIX_.$this->name.'_staffprofiles lsp WHERE id_employee NOT IN ('.pSQL($employees_ids_list).')');
		$staffprofiles_ids = array();

		foreach ($result as $value)
			$staffprofiles_ids[] = $value['id_staffprofile'];

		return $staffprofiles_ids;
	}

	public function checkIfEmployeeInStaffProfile($id_employee)
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_staffprofiles lsp WHERE id_employee = "'.(int)$id_employee.'"');

		$res = $result[0]['COUNT(*)'];

		if (empty($res))
			return false;
		else
			return true;
	}


	public function getVisitorChatStatus($id_visitor)
	{
		$result = Db::getInstance()->executeS('SELECT * FROM '._DB_PREFIX_.$this->name.'_archive la WHERE id_visitor = "'.pSQL($id_visitor).'" ORDER BY id_archive DESC LIMIT 1');
		#d('SELECT * FROM '._DB_PREFIX_.$this->name.'_archive la WHERE id_visitor = "'.pSQL($id_visitor).'" ORDER BY id_archive DESC LIMIT 1');
		if ($result)
			return $result[0]['in_chat'];
		else
			return 'N';
	}


	public function checkIfVisitorIdInArchive($id_visitor)
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_archive la WHERE id_visitor = "'.pSQL($id_visitor).'" AND is_archive != "Y"');

		$res = $result[0]['COUNT(*)'];

		if (empty($res))
			return false;
		else
			return true;
	}

	public function checkIfVisitorIdNotOffline($id_visitor)
	{
		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_archive la WHERE id_visitor = "'.pSQL($id_visitor).'" AND is_archive != "Y" AND in_chat != "N"');

		$res = $result[0]['COUNT(*)'];

		if (empty($res))
			return false;
		else
			return true;
	}

	public function getCookie($data = '')
	{
		$cookie = new LiveChatProCookie($this->name/*, time() + 259200*/);

		$result = $cookie->get($this->name);

		if (is_array($result) && isset($result[$data]))
			return $result[$data];

	}

	public function setCookie($data = '')
	{
		$cookie = new LiveChatProCookie($this->name/*, time() + 259200*/);

		$cookie->set($this->name, $data);	
	}



	public function assignVisitorDetails($data = '')
	{
		$visitor_details = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlinevisitors` lov WHERE lov.id_visitor = "'.pSQL($data['id_visitor']).'" LIMIT 1');

		if (!empty($visitor_details))
		{
			$visitor_details = $visitor_details[0];
			$visitor_details['key'] = $data['key'];
			$visitor_details['visited_pages'] = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_visitedpages` lvp WHERE lvp.id_visitor = "'.pSQL($data['id_visitor']).'"');
			$visitor_details['tracking_info'] = $this->getGeoTracking(array('id_visitor' => $data['id_visitor']));
			//$visitor_details['http_or_https'] = $this->http_or_https();
		}

		$this->context->smarty->assign(array(
			'visitor_details' => $visitor_details,
			'key' => $data['key'],
		));
		return true;
	}




	public function getGeoTracking($data = '')
	{
		//get visitor details
		if (!empty($data['id_visitor']))
		{
			$visitor_details = $this->getVisitor( array('id_visitor' => $data['id_visitor']) );
			$ip = $visitor_details['ip'];
		}
		else
			$ip = (Tools::getRemoteAddr() == '::1') ? '127.0.0.1' : Tools::getRemoteAddr();
			#$ip = '197.231.64.118';

		require_once dirname(__FILE__).'/libraries/geoplugin/geoplugin.class.php';

		$geoplugin = new geoPlugin();
		$geoplugin->locate($ip);

		$city = empty($geoplugin->city) ? 'unknown' : $geoplugin->city;
		$country = empty($geoplugin->countryName) ? 'unknown' : $geoplugin->countryName;

		if ($country != 'unknown')
		{
			if ($city != 'unknown')
				$coordinates_precision = 7;
			else
				$coordinates_precision = 2;
		}
		else
			$coordinates_precision = 1;

		$tracking_info = array(
			'city' => $city,
			'country' => $country,
			'latitude' => number_format($geoplugin->latitude, $coordinates_precision, '.', ''),
			'longitude' => number_format($geoplugin->longitude, $coordinates_precision, '.', '')
		);

		@ob_end_clean();

		return $tracking_info;
	}


	public function showOnlineInternalUsers($data = '')
	{	
		$online_internal_users = $this->getOnlineUsers('Internal');
		$count_online_internal_users = $this->countOnlineUsers('Internal');
		$id_staffprofile = $this->getCurrentStaffProfileId();

		#d($this->getCarrierPredefinedPackages($data));
		$this->context->smarty->assign(array(
			'online_internal_users' => $online_internal_users,
			'count_online_internal_users' => $count_online_internal_users,
			'id_staffprofile' => $id_staffprofile,
		));

		return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.online_internal_users.tpl');
	}


	public function showMouseTracking($data = '')
	{
		$this->assignModuleVars();

		$visitor_details = $this->getVisitor($data);

		$tracking_data = array(
			'current_page' => $visitor_details['current_page']
		);

		$this->context->smarty->assign(array(
			'tracking_data' => $tracking_data
		));

		return $this->display(dirname(__FILE__), '/views/templates/admin/ajax.mousetracking.tpl');
	}


	/*public function showInviteToChat($data = '')
	{
		return $this->syncChatDialog(false, 'ajax.chats.tpl');
	}*/

	/**
	* @param  string $data The parameter data is not used in this function
	* @return string       HTML
	*/
	public function popupChat()
	{
		return $this->syncFrontChatDialog(true, 'chat_window.tpl');
	}

	public static function replaceVars($template, $variables = array())
	{
		self::$replace_vars = $variables;
		$template           = preg_replace_callback('/{(?P<tag>[^}]+)}/', 'self::replaceCallback', $template);

		return $template;
	}

	public static function replaceCallback($matches)
	{
		$tag = $matches['tag'];
		return (isset(self::$replace_vars['{'.$tag.'}'])) ? self::$replace_vars['{'.$tag.'}'] : '{'.$tag.'}';
	}

	public function assignModuleVars()
	{
		#$configuration_array = unserialize(Configuration::get(Tools::strtoupper($this->name).'_SETTINGS'));

		$module_dir                = dirname(__FILE__);
		$module_templates_back_dir = dirname(__FILE__).'/views/templates/admin/';
		$module_templates_front_dir = dirname(__FILE__).'/views/templates/front/';
		$module_js_dir             = dirname(__FILE__).'/views/js/';

		if (Tools::substr(_PS_VERSION_, 0, 3) == '1.4')
			$module_link = 'index.php?tab=AdminModules&configure='.$this->name.'&token='.$this->module_token.'&tab_module=front_office_features&module_name='.$this->name;
		else
			$module_link = 'index.php?controller=AdminModules&configure='.$this->name.'&token='.$this->module_token.'&module_name='.$this->name;

		$doc_iso = file_exists(_PS_MODULE_DIR_.$this->name.'/readme_'.$this->iso_lang.'.pdf') ? $this->iso_lang : 'en';
		$avatars = $this->getAvatars('for_datatables');
		$departments  = $this->getDepartments('all', 'for_datatables'); #d($departments);
		$module_url = $this->http_or_https().Tools::getShopDomain().$this->_path;

		$this->context->smarty->assign(array(
			'dev_modules_link' => 'http://addons.prestashop.com/'.$this->iso_lang.'/93_proquality',
			'support_link' => 'http://addons.prestashop.com/'.$this->iso_lang.'/contact-community.php?id_product='.$this->id_product,
			'doc_link' => '../modules/'.$this->name.'/readme_'.$doc_iso.'.pdf',
			'video_link' => 'https://www.youtube.com/watch?v=YWo1dP_x_rU',
			'avatars' => Tools::jsonEncode($this->arrayToObject($avatars)),
			'departments' => Tools::jsonEncode($this->arrayToObject($departments)),
			'performance_settings' => Tools::jsonEncode($this->arrayToObject($this->getPerformanceSettings())),
			'module_version' => $this->version,
			'ps_version' => $this->ps_version,
			'module_name' => $this->name,
			'module_path' => $this->_path,
			'module_url' => $module_url,
			'module_dir' => $module_dir,
			'module_token' => $this->module_token,
			'module_link' => $module_link,
			'module_templates_back_dir' => $module_templates_back_dir,
			'module_templates_front_dir' => $module_templates_front_dir,
			'module_js_dir' => $module_js_dir,
			'ajax_token' => $this->ajax_token,
			'db_prefix' => _DB_PREFIX_,
			'id_employee' => $this->context->employee->id,
			'employee_is_superadmin' => ($this->checkIfEmployeeIsSuperAdmin() == true) ? 'Y' : 'N',
			'http_or_https' => $this->http_or_https(),
			'employees_token' => $this->employees_token,
			'lcp_current_url' => $this->http_or_https()."$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]",
			#'module_path' => $this->http_or_https().$_SERVER['HTTP_HOST'].$this->_path,
			#'module_path' => $this->http_or_https().str_replace('www.', '', $_SERVER['HTTP_HOST']).$this->_path,
			#'module_path' => '../modules/'.$this->name.'/',
		));
	}



	public function syncOnlineVisitors($data = '')
	{
		$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_onlinevisitors SET last_update = DATE_FORMAT(NOW(),\'%Y-%m-%d %H:%i:%s\') WHERE id_visitor = "'.pSQL($data['id_visitor']).'"';
		Db::getInstance()->Execute($sql);

		$visitors_to_delete = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlinevisitors` WHERE UNIX_TIMESTAMP(last_update) < '.pSQL(time() - $this->timeout));

		foreach ($visitors_to_delete as $value)
		{
			$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive SET in_chat = "N", awaiting_response_from_staff = "N", is_archive = "Y" WHERE id_visitor = "'.pSQL($value['id_visitor']).'"';
			Db::getInstance()->Execute($sql);

			$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlineusers WHERE id_visitor = "'.pSQL($value['id_visitor']).'"';
			Db::getInstance()->Execute($sql);

			$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlinevisitors WHERE id_visitor = "'.pSQL($value['id_visitor']).'"';
			Db::getInstance()->Execute($sql);

			$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_visitedpages WHERE id_visitor = "'.pSQL($value['id_visitor']).'"';
			Db::getInstance()->Execute($sql);
		}

		$internals_to_delete = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlineusers` WHERE UNIX_TIMESTAMP(last_update) < '.pSQL(time() - $this->timeout));

		foreach ($internals_to_delete as $value)
		{
			$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_archive SET in_chat = "N", awaiting_response_from_staff = "N", is_archive = "Y" WHERE id_staffprofile = "'.(int)$value['id_staffprofile'].'"';
			Db::getInstance()->Execute($sql);

			$sql = 'UPDATE '._DB_PREFIX_.$this->name.'_staffprofiles SET status = "Offline" WHERE id_staffprofile = "'.(int)$value['id_staffprofile'].'"';
			Db::getInstance()->Execute($sql);

			$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlineusers WHERE id_staffprofile = "'.(int)$value['id_staffprofile'].'"';
			Db::getInstance()->Execute($sql);

		}

		return true;
	}

	public function getCustomerDetails()
	{
		$customer = '';
		if (!empty($this->context->cookie->id_customer))
		{
			$customer = Db::getInstance()->executeS(
				'SELECT * FROM `'._DB_PREFIX_.'customer` c 
				LEFT JOIN `'._DB_PREFIX_.'address` a ON (c.`id_customer` = a.`id_customer`)
				WHERE c.`id_customer` = "'.pSQL($this->context->cookie->id_customer).'" LIMIT 1'
				);
			$customer = $customer[0];
		}
		return $customer;
	}


	public function getSessionId()
	{
		// for php 5.2
		if (call_user_func('session_id') === '')
			call_user_func('session_start');
		
		$session_id = call_user_func('session_id');

		session_write_close();

		return $session_id;
	}


	public function addUpdateVisitor($data)
	{
		$data['session_id'] = $this->getSessionId();

		$result = Db::getInstance()->executeS('SELECT COUNT(*) FROM '._DB_PREFIX_.$this->name.'_onlinevisitors WHERE session_id = "'.pSQL($data['session_id']).'"');
		$count  = $result[0]['COUNT(*)'];

		if ($count == 0)
			$id_visitor = $this->addVisitor($data);
		else
		{
			$visitor = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_onlinevisitors` lov WHERE lov.`session_id` = "'.pSQL($data['session_id']).'"');
			$visitor = $visitor[0];
			$id_visitor = $visitor['id_visitor'];
			//update user in baza de date
			$data['timezone']    = 'GMT '.$data['timezone'].':00';
			$data['online_time'] = gmdate('H:i:s', time() - strtotime($visitor['last_update']));
			$data['last_visit']  = date('Y-m-d H:i:s', time());

			$this->updateVisitor($data);			
		}

		//adaugam pagina visitata
		$data['id_visitor'] = $id_visitor;

		$data['url']        = $data['current_page'];

		//add visited page
		$this->addVisitedPage($data);

		//returnez visitor id
		return $id_visitor;
	}


	public function deleteOfflineVisitors()
	{
		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlinevisitors WHERE UNIX_TIMESTAMP(last_update) < '.pSQL(time() - $this->timeout);
		Db::getInstance()->Execute($sql);

		return true;
	}

	public function deleteOfflineUsers()
	{
		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_onlineusers WHERE UNIX_TIMESTAMP(last_update) < '.pSQL(time() - $this->timeout);
		Db::getInstance()->Execute($sql);

		return true;
	}

	public function deleteOldVisitedPages()
	{
		$sql = 'DELETE FROM '._DB_PREFIX_.$this->name.'_visitedpages WHERE UNIX_TIMESTAMP(last_update) < '.pSQL(time() - $this->timeout);
		Db::getInstance()->Execute($sql);

		return true;
	}

	public function fillGridDataTables($type, $data = '')
	{
		$db = '';		

		include('libraries/datatables/PHP/DataTables.php');

			if ($type == 'departments')
			{
				//$editor = DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_departments',  'id_department');
				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_departments', 'id_department')->fields(
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_departments.id_department' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_departments.status' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_departments.name' )->validator( 'Validate::notEmpty' )
					)->process( $data )->json();
			}
			elseif ($type == 'staffprofiles')
			{
				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_staffprofiles', 'id_staffprofile')->fields(
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_staffprofiles.id_staffprofile' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_staffprofiles.status' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.'employee.firstname' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.'employee.lastname' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_staffprofiles.avatar' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_staffprofiles.departments' )->validator( 'Validate::notEmpty' )->getFormatter( 

							function ( $val, $data, $opts ) { // from server for client
									
									$departments_names = '';
									$departments_ids_array = @explode(',', $val);

									foreach ($departments_ids_array as $value)
									{
										$department_name = Db::getInstance()->executeS('SELECT name FROM `'._DB_PREFIX_.'livechatpro_departments` ld WHERE ld.id_department = "'.pSQL($value).'"');
										if (!empty($department_name))
											$departments_names .= $department_name[0]['name'].',';
									}
									return Tools::substr(trim($departments_names), 0, -1);
								
								} )->setFormatter( 
							
							function ( $val, $data, $opts ) { // from client for server

									$departments_ids = '';
									$departments_names_array = @explode(',', $val);

									foreach ($departments_names_array as $value)
									{
										$department_id = Db::getInstance()->executeS('SELECT id_department FROM `'._DB_PREFIX_.'livechatpro_departments` ld WHERE ld.name = "'.pSQL($value).'"');
										if (!empty($department_id))
											$departments_ids .= $department_id[0]['id_department'].',';
									}
									return Tools::substr(trim($departments_ids), 0, -1);
								} ),
						//Field::inst( _DB_PREFIX_.$this->name.'_departments.name' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_staffprofiles.welcome_message' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_staffprofiles.signature' )->validator( 'Validate::notEmpty' )
					)->leftJoin( _DB_PREFIX_.'employee', _DB_PREFIX_.'employee.id_employee', '=', _DB_PREFIX_.$this->name.'_staffprofiles.id_employee' )->process( $data )->json();
			}
			elseif ($type == 'predefinedmessages')
			{
				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_predefinedmessages', 'id_predefinedmessage')->fields(
					DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_predefinedmessages.id_predefinedmessage' )->validator( 'Validate::notEmpty' ),
					DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_predefinedmessages.iso_code' )->options( _DB_PREFIX_.'lang', 'iso_code', 'iso_code' )->validator( 'Validate::notEmpty' ),
					DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_predefinedmessages.title' )->validator( 'Validate::notEmpty' ),
					DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_predefinedmessages.message' )->validator( 'Validate::notEmpty' ),
					DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_predefinedmessages.last_update' )->validator( 'Validate::notEmpty' )
					)->leftJoin( _DB_PREFIX_.'lang', _DB_PREFIX_.'lang.iso_code', '=', _DB_PREFIX_.$this->name.'_predefinedmessages.iso_code' )->process( $data )->json();
			}
			elseif ($type == 'onlinevisitors')
			{
				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_onlinevisitors', 'id_visitor')->fields(
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.id_visitor' )->validator( 'Validate::notEmpty' ),
						//Field::inst( _DB_PREFIX_.$this->name.'_archive.name' )->validator( 'Validate::notEmpty' ),
						//Field::inst( _DB_PREFIX_.$this->name.'_archive.email' )->validator( 'Validate::notEmpty' ),
						//Field::inst( _DB_PREFIX_.$this->name.'_archive.phone' )->validator( 'Validate::notEmpty' ),
						//Field::inst( _DB_PREFIX_.$this->name.'_archive.company' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.country' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.city' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.province' )->validator( 'Validate::notEmpty' ),
						//Field::inst( _DB_PREFIX_.$this->name.'_archive.in_chat' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.language' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.visits' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.current_page' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.host' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.ip' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.browser' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.timezone' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.resolution' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.online_time' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.referrer' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.page_count' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.os' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_onlinevisitors.last_visit' )->validator( 'Validate::dateFormat', array('format'  => DataTables\Editor\Format::DATE_ISO_8601, 'message' => 'Please enter a date in the format yyyy-mm-dd') )->getFormatter( 'Format::date_sql_to_format', DataTables\Editor\Format::DATE_ISO_8601 )->setFormatter( 'Format::date_format_to_sql', DataTables\Editor\Format::DATE_ISO_8601 )
					)->process( $data )->json();
			}
			elseif ($type == 'archive')
			{
				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_archive', 'id_archive')->fields(
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.id_archive' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.date_add' )->validator( 'Validate::dateFormat', array('format'  => DataTables\Editor\Format::DATE_ISO_8601,'message' => 'Please enter a date in the format yyyy-mm-dd') )->getFormatter( 'Format::date_sql_to_format', DataTables\Editor\Format::DATE_ISO_8601 )->setFormatter( 'Format::date_format_to_sql', DataTables\Editor\Format::DATE_ISO_8601 ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.id_chat' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.name' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.internal' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_departments.name' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.email' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.company' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.language' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.country' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.ip' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.host' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.duration' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.log_entries' )->validator( 'Validate::notEmpty' )
					)->leftJoin( _DB_PREFIX_.$this->name.'_departments', _DB_PREFIX_.$this->name.'_departments.id_department', '=', _DB_PREFIX_.$this->name.'_archive.id_department' )->process( $data )->json();
			}
			elseif ($type == 'visitorarchive')
			{
				$archive_visitor_details = $this->getVisitorArchiveDetails(array('id_visitor' => @$data['id_visitor']));
				//d($visitor_details['ip']);

				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_archive', 'id_archive')->fields(
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.id_archive' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.id_visitor' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.date_add' )->validator( 'Validate::dateFormat', array('format'  => DataTables\Editor\Format::DATE_ISO_8601,'message' => 'Please enter a date in the format yyyy-mm-dd') )->getFormatter( 'Format::date_sql_to_format', DataTables\Editor\Format::DATE_ISO_8601 )->setFormatter( 'Format::date_format_to_sql', DataTables\Editor\Format::DATE_ISO_8601 ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.id_chat' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.name' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.internal' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_departments.name' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.email' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.company' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.language' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.country' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.ip' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.host' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.duration' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_archive.log_entries' )->validator( 'Validate::notEmpty' )
					)->leftJoin( _DB_PREFIX_.$this->name.'_departments', _DB_PREFIX_.$this->name.'_departments.id_department', '=', _DB_PREFIX_.$this->name.'_archive.id_department' )->where( _DB_PREFIX_.$this->name.'_archive.ip', @$archive_visitor_details['ip'] )->process( $data )->json();
			}
			elseif ($type == 'messages')
			{
				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_messages', 'id_message')->fields(
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.id_message' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.date_add' )->validator( 'Validate::dateFormat', array('format'  => DataTables\Editor\Format::DATE_ISO_8601,'message' => 'Please enter a date in the format yyyy-mm-dd') )->getFormatter( 'Format::date_sql_to_format', DataTables\Editor\Format::DATE_ISO_8601 )->setFormatter( 'Format::date_format_to_sql', DataTables\Editor\Format::DATE_ISO_8601 ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.name' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.email' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.phone' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.department' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.question' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.ip' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.status' )->validator( 'Validate::notEmpty' )
					)->process( $data )->json();
			}
			elseif ($type == 'visitormessages')
			{
				$archive_visitor_details = $this->getVisitorArchiveDetails(array('id_visitor' => @$data['id_visitor']));

				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_messages', 'id_message')->fields(
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.id_message' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.id_visitor' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.date_add' )->validator( 'Validate::dateFormat', array('format'  => DataTables\Editor\Format::DATE_ISO_8601,'message' => 'Please enter a date in the format yyyy-mm-dd') )->getFormatter( 'Format::date_sql_to_format', DataTables\Editor\Format::DATE_ISO_8601 )->setFormatter( 'Format::date_format_to_sql', DataTables\Editor\Format::DATE_ISO_8601 ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.name' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.email' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.phone' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.department' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.question' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.ip' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_messages.status' )->validator( 'Validate::notEmpty' )
					)->where( _DB_PREFIX_.$this->name.'_messages.ip', @$archive_visitor_details['ip'] )->process( $data )->json();
			}
			elseif ($type == 'ratings')
			{
				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_ratings', 'id_rating')->fields(
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.id_rating' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.politness' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.qualification' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.date_add' )->validator( 'Validate::dateFormat', array('format'  => DataTables\Editor\Format::DATE_ISO_8601,'message' => 'Please enter a date in the format yyyy-mm-dd') )->getFormatter( 'Format::date_sql_to_format', DataTables\Editor\Format::DATE_ISO_8601 )->setFormatter( 'Format::date_format_to_sql', DataTables\Editor\Format::DATE_ISO_8601 ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.internal' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.name' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.email' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.company' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.comment' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.status' )->validator( 'Validate::notEmpty' )
					)->process( $data )->json();
			}
			elseif ($type == 'visitorratings')
			{
				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_ratings', 'id_rating')->fields(
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.id_rating' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.id_visitor' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.politness' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.qualification' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.date_add' )->validator( 'Validate::dateFormat', array('format'  => DataTables\Editor\Format::DATE_ISO_8601,'message' => 'Please enter a date in the format yyyy-mm-dd') )->getFormatter( 'Format::date_sql_to_format', DataTables\Editor\Format::DATE_ISO_8601 )->setFormatter( 'Format::date_format_to_sql', DataTables\Editor\Format::DATE_ISO_8601 ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.internal' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.name' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.email' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.company' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.comment' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_ratings.status' )->validator( 'Validate::notEmpty' )
					)->where( _DB_PREFIX_.$this->name.'_ratings.id_visitor', @$data['id_visitor'] )->process( $data )->json();
			}
			elseif ($type == 'logs')
			{
				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_logs', 'id_log')->fields(
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_logs.id_log' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_logs.date_add' )->validator( 'Validate::dateFormat', array('format'  => DataTables\Editor\Format::DATE_ISO_8601,'message' => 'Please enter a date in the format yyyy-mm-dd') )->getFormatter( 'Format::date_sql_to_format', DataTables\Editor\Format::DATE_ISO_8601 )->setFormatter( 'Format::date_format_to_sql', DataTables\Editor\Format::DATE_ISO_8601 ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_logs.message' )->validator( 'Validate::notEmpty' )
					)->process( $data )->json();
			}
			elseif ($type == 'visitorlogs')
			{
				return DataTables\Editor::inst( $db, _DB_PREFIX_.$this->name.'_logs', 'id_log')->fields(
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_logs.id_log' )->validator( 'Validate::notEmpty' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_logs.id_visitor' ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_logs.date_add' )->validator( 'Validate::dateFormat', array('format'  => DataTables\Editor\Format::DATE_ISO_8601,'message' => 'Please enter a date in the format yyyy-mm-dd') )->getFormatter( 'Format::date_sql_to_format', DataTables\Editor\Format::DATE_ISO_8601 )->setFormatter( 'Format::date_format_to_sql', DataTables\Editor\Format::DATE_ISO_8601 ),
						DataTables\Editor\Field::inst( _DB_PREFIX_.$this->name.'_logs.message' )->validator( 'Validate::notEmpty' )
					)->where( _DB_PREFIX_.$this->name.'_logs.id_visitor', @$data['id_visitor'] )->process( $data )->json();
			}
		
	}


	public function fillGrid($type)
	{
		if ($type == 'departments')
		{
			$sql = 'SELECT *
	        FROM '._DB_PREFIX_.$this->name.'_departments ld
	        WHERE 1
	        ORDER BY ld.id_department ASC';
		}
		elseif ($type == 'staffprofiles')
		{
			$sql = 'SELECT *
	        FROM '._DB_PREFIX_.'employee e
	        LEFT JOIN `'._DB_PREFIX_.$this->name.'_staffprofiles` lsp ON (e.`id_employee` = lsp.`id_employee`)
          WHERE 1
	        ORDER BY e.id_employee ASC';
		}
		elseif ($type == 'visitors')
		{
			$sql = 'SELECT *
	        FROM '._DB_PREFIX_.$this->name.'_onlinevisitors lov
	        WHERE 1
	        ORDER BY lov.id_visitor ASC';
		}
		elseif ($type == 'archive')
		{
			$sql = 'SELECT *
	        FROM '._DB_PREFIX_.$this->name.'_archive la
	        WHERE 1 
	        GROUP BY la.ip 
	        ORDER BY la.id_archive ASC';
		}
		elseif ($type == 'messages')
		{
			$sql = 'SELECT *
	        FROM '._DB_PREFIX_.$this->name.'_messages lm
	        WHERE 1
	        ORDER BY lm.id_message ASC';
		}
		elseif ($type == 'ratings')
		{
			$sql = 'SELECT *
	        FROM '._DB_PREFIX_.$this->name.'_ratings lr
	        WHERE 1
	        ORDER BY lr.id_rating ASC';
		}
		elseif ($type == 'logs')
		{
			$sql = 'SELECT *
	        FROM '._DB_PREFIX_.$this->name.'_logs ll
	        WHERE 1
	        ORDER BY ll.id_log ASC';
		}

		$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

	
		if ($type == 'staffprofiles')
		{
			$arr_info = array();
			foreach ($result as $value)
			{
				if (empty($value['departments']))
					$value['departments'] = 1;

				$departments = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_departments` ld WHERE ld.id_department IN ('.pSQL($value['departments']).')');

				$value['departments_names'] = '';

				foreach ($departments as $value2)
					$value['departments_names'] .= $value2['name'].', ';

				$value['departments_names'] = Tools::substr(trim($value['departments_names']), 0, -1);

				$arr_info[] = $value;

			}
			$result = $arr_info;

		}

		return Tools::jsonEncode($result);
	}

	public function getEmployeeById($id_employee, $active_only = false)
	{
		$result = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.'employee`
		WHERE `id_employee` = '.(int)$id_employee.'
		'.($active_only ? ' AND `active` = 1' : ''));
		
		if ($result)
			return $result[0];
		else
			return false;
	}

	public function getStoreById($id_store)
	{
		return Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.'store` WHERE id_store = '.(int)$id_store.'');
	}

	public function postProcessing()
	{
		if (Tools::isSubmit('action'))
		{
			$action = Tools::getValue('action');

			switch ($action)
			{
				case '':
					break;

				default:
					break;
			}
		}
	}


	public static function makeClickableLinks($s) 
	{
		return preg_replace('@(https?://([-\w\.]+[-\w])+(:\d+)?(/([\w/_\.#-]*(\?\S+)?[^\.\s])?)?)@', '<a href="$1" target="_blank">$1</a>', $s);
	}

	public function generateJSON()
	{
		$emoticons = Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.$this->name.'_emoticons` ORDER BY id_emoticon DESC');

		$json = Tools::jsonEncode($emoticons);

		$filename = dirname(__FILE__).'/emoticons.json';

		file_put_contents($filename, $json);

	}

	/**
	 * Convert object to array.
	 */
	public function objectToArray($obj)
	{
		if (is_array($obj) || is_object($obj))
		{
			$result = array();

			foreach ($obj as $key => $value)
				$result[$key] = $this->objectToArray($value);

			return $result;
		}
		return $obj;
	}

	/**
	 * Convert array to object.
	 */
	/*public function arrayToObject($array)
	{
		$obj = new stdClass;

		if (!isset($array) || empty($array))
			return false;

		foreach ($array as $k => $v)
		{
			if (is_array($v))
				$obj->{$k} = $this->arrayToObject($v); // recursion
			else
				$obj->{$k} = $v;
		}
		return $obj;
	}*/


public function arrayToObject($array) 
{
	if (!is_array($array))
		return $array;

	$object = new stdClass();

	if (is_array($array) && count($array) > 0) 
	{
		foreach ($array as $name => $value) 
		{
			$name = Tools::strtolower(trim($name));

			if (!empty($name))
				$object->$name = $this->arrayToObject($value);
		}
		return $object;
	}
	else
		return false;
}


} /* end class */


function ifsetor(&$variable, $default = null) 
{
	if (isset($variable)) 
		$tmp = $variable;
	else
		$tmp = $default;

	return $tmp;
}




if (!function_exists('smartyFunctionSplitArray')) 
{

function smartyFunctionSplitArray($params, &$smarty)
{
	if (!isset($params['var']))
	{
		trigger_error("split_array: missing 'var' parameter");
		return;
	}
	if (!isset($params['num']))
	{
		trigger_error("split_array: missing 'num' parameter");
		return;
	}
	if (!isset($params['assign']))
	{
		trigger_error("split_array: missing 'assign' parameter");
		return;
	}
	if (!is_array($params['var']))
	{
		trigger_error("split_array: expecting 'var' as an array");
		return;
	}

	$num = (int)$params['num'];

	$count = count($params['var']);

	$split_array = '';

	if ($count <= $num)
	{
		for ($x = 0; $x < $count; $x++)
			$split_array[$x] = isset($params['var'][$x]) ? array(
				$params['var'][$x]
			) : array(
				''
			);
	}
	else
	{
		$mod = $count % $num;
		$div = floor($count / $num);
		for ($x = 0; $x < $num; $x++)
		{
			if ($x + 1 <= $mod)
				$length = $div + 1;
			else
				$length = $div;

			$split_array[$x] = !empty($params['var']) ? array_splice($params['var'], 0, $length) : array(
				''
			);
		}
	}

	$smarty->assign($params['assign'], $split_array);
}

}



?>