/**
* ProQuality (c) All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at addons4prestashop@gmail.com.
*
* @author    Andrei Cimpean (ProQuality) <addons4prestashop@gmail.com>
* @copyright 2015-2016 ProQuality
* @license   Do not edit, modify or copy this file
*/

/*document.write( generateRatingStars(3) );*/
var  test;

$(window).load(function() 
{
	if(checkLibraryConflict() == true)
		return;

	try {
		if ($.localStorage.isEmpty('status_select'))
			$('#status_select').val('Online').trigger('change');
	} catch(e){}

	if ($("#lcp_box").is(':visible'))
	{
		$("#settings").trigger("change");
		$("#iconsets").trigger("change");
	}

	var sync_online_visitors_interval_datatable_admin = (!isNaN(parseInt(lcp_performance_settings.sync_online_visitors_interval_datatable_admin))) ? parseInt(lcp_performance_settings.sync_online_visitors_interval_datatable_admin) * 1000 : 30000;
	var sync_chat_dialog_interval_admin = (!isNaN(parseInt(lcp_performance_settings.sync_chat_dialog_interval_admin))) ? parseInt(lcp_performance_settings.sync_chat_dialog_interval_admin) * 1000 : 5000;

	
		// reload the visitors datatable
		setInterval( function () {
			if ( $('#dialog_chat').is(":visible")  )
			{
				try {
					if ( $.fn.DataTable.isDataTable( '#onlinevisitors_grid' ) )
						onlinevisitors_datatable.api().ajax.reload();
			    } catch(e){}
			}
		}, sync_online_visitors_interval_datatable_admin);
	

	// sync the chat dialog
	setInterval(function(){
		syncChatDialog();
	}, sync_chat_dialog_interval_admin);	

});

$(window).resize(function () {
   $('#dialog_chat').closest( "div.ui-dialog" ).css({
        'width': parseInt($(window).width()) - 20,
        'height': parseInt($(window).height()) - 50,
        /*'left': '0px',*/
        'top':'40px'
   });

   $('#onlinevisitors_grid_wrapper, #archive_grid_wrapper, #messages_grid_wrapper, #ratings_grid_wrapper, #logs_grid_wrapper').css({
        'width': parseInt($(window).width()) - 80 + 'px',
   });

}).resize(); 


$(document).ready(function(){

	if(checkLibraryConflict() == true)
		return;

	//if (typeof(google) !== 'object')
		//$.getScript( lcp_http_or_https+"maps.google.com/maps/api/js?sensor=false" );


	//adding header buttons
	if (getUrlParameter('controller') == 'AdminModules' && getUrlParameter('configure') == 'livechatpro')
	{
		lcpAddToolbarBtn('separator');
		lcpAddToolbarBtn('video');
		lcpAddToolbarBtn('documentation');
		lcpAddToolbarBtn('contact');
		lcpAddToolbarBtn('modules');
	}


	if (getUrlParameter('controller') == 'AdminModules' || getUrlParameter('tab') == 'AdminModules')
	{
	//datatables
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	var departments_table = lcp_db_prefix+lcp_module_name+'_departments';

    var departments_editor = new $.fn.dataTable.Editor( {
        ajax: lcp_grid_path+'departments',
        table: "#departments_grid",
        fields: [ 
	        { label: l("Name:"), name: departments_table+".name", }, 
	        {
                label: l("Status:"),
                name:  departments_table+".status",
                type:  "select",
                options: [
                    { label: l("Active"), value: "Active" },
                    { label: l("Inactive"), value: "Inactive" },
                ]
            }
        ]
    } );
 

    var departments_editor_create_button = { extend: "create", editor: departments_editor };
    var departments_editor_edit_button = { extend: "edit",   editor: departments_editor };
    var departments_editor_remove_button = { extend: "remove", editor: departments_editor };

    var departments_editor_buttons = [];

    if (lcp_employee_is_superadmin == 'Y') 
    {
    	 departments_editor_buttons.push(departments_editor_create_button);
    	 departments_editor_buttons.push(departments_editor_edit_button);
    	 departments_editor_buttons.push(departments_editor_remove_button);

    }
    else
    {
    	 departments_editor_buttons.push(departments_editor_create_button);
    }

    var departments_datatable = $('#departments_grid').dataTable( {

        dom: 'Bfrtip',
        //"processing": true,
        //"serverSide": true,
        "pageLength": 50,
        "autoWidth": false,
        ajax: {
            url: lcp_grid_path+'departments',
            type: 'POST'
        },

        columns: [
            { data: departments_table+".name", },
            { data: departments_table+".status", },
        ],

        select: true,

       buttons : departments_editor_buttons,

    });



	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	var avatars = lcp_avatars; //console.log(avatars);
	var departments = lcp_departments; //console.log(departments);

	var staffprofiles_table = lcp_db_prefix+lcp_module_name+'_staffprofiles';
	//var departments_table = lcp_db_prefix+lcp_module_name+'_departments';
	var employee_table = lcp_db_prefix+'employee';

    var staffprofiles_editor = new $.fn.dataTable.Editor( {
        ajax: lcp_grid_path+'staffprofiles',
        table: "#staffprofiles_grid",
        fields: [ 
	        {
                label: l("Status:"),
                name:  staffprofiles_table+".status",
                type:  "select",
                options: [
                    { label: l("Online"), value: "Online" },
                    { label: l("Offline"), value: "Offline" },
                ]
            },
            //{ label: l("Firstname:"), name: employee_table+".firstname", }, 
            //{ label: l("Lastname:"), name: employee_table+".lastname", },
            //{ label: l("Avatar:"), name: staffprofiles_table+".avatar", },
            {
                label: l("Avatar:"),
                name:  staffprofiles_table+".avatar",
                type:  "select",
                options: avatars
            },
            {
                label: l("Departments:"),
                name:  staffprofiles_table+".departments",
                type:  "checkbox",
                options: departments,
                separator: ','
            },
            { label: l("Welcome message:"), name: staffprofiles_table+".welcome_message", },
            { label: l("Signature:"), name: staffprofiles_table+".signature", },
        ]
    } );
 

    var staffprofiles_editor_create_button = {
                    //extend: 'text',
                    //class: 'marginLeft',
                    text: l('Add (redirect to employees)'),
                    action: function ( e, dt, node, config ) {
                        //if ( staffprofiles_datatable.row( '.selected' ).length !== 0 ) {
                            window.open("index.php?controller=AdminEmployees&token="+lcp_employees_token , '_blank');                            
                        //}
                    }
                };

    var staffprofiles_editor_edit_button = { extend: "edit",   editor: staffprofiles_editor };

    var staffprofiles_editor_remove_button = {
                    extend: 'selectedSingle',
                    //class: 'marginLeft',
                    text: l('Delete (redirect to employees)'),
                    action: function ( e, dt, node, config ) {
                        //if ( staffprofiles_datatable.row( '.selected' ).length !== 0 ) {
                            window.open("index.php?controller=AdminEmployees&token="+lcp_employees_token , '_blank');                            
                        //}
                    }
                };

    var staffprofiles_editor_buttons = [];

    if (lcp_employee_is_superadmin == 'Y') 
    {
    	staffprofiles_editor_buttons.push(staffprofiles_editor_create_button);
    	staffprofiles_editor_buttons.push(staffprofiles_editor_edit_button);
    	staffprofiles_editor_buttons.push(staffprofiles_editor_remove_button);
    }
    else
    {
    	staffprofiles_editor_buttons.push(staffprofiles_editor_create_button);
    }



    staffprofiles_editor.on( 'open', function () {
    	$('#DTE_Field_'+staffprofiles_table+'-avatar').trigger('change');
    	//$(this.get(staffprofiles_table+'.avatar')).trigger('change');
    	//console.log(staffprofiles_editor.get());
    });


    var staffprofiles_datatable = $('#staffprofiles_grid').dataTable( {

        dom: "Bfrtip",
        //"processing": true,
        //"serverSide": true,
        "pageLength": 50,
        "autoWidth": false,
        ajax: {
            url: lcp_grid_path+'staffprofiles',
            type: 'POST'
        },

        columns: [
            { data: staffprofiles_table+".status", className: "dt-body-center" },
            { data: employee_table+".firstname", className: "dt-body-center" },
            { data: employee_table+".lastname", className: "dt-body-center" },
            { 
            	data: staffprofiles_table+".avatar", 
            	className: "dt-body-center",
            	render: function ( data, type, row, meta ) {
      				//return '<a href="'+data+'">Download</a>';
      				return '<img border="0" src="'+lcp_path+'views/img/avatars/'+data+'" width="40" height="40">';
    			}
            },
            { data: staffprofiles_table+".departments", className: "dt-body-center", },
            { data: staffprofiles_table+".welcome_message", className: "dt-body-center" },
            { data: staffprofiles_table+".signature", className: "dt-body-center" },
        ],

        select: true,

       	buttons : staffprofiles_editor_buttons,
    });



	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	var predefinedmessages_table = lcp_db_prefix+lcp_module_name+'_predefinedmessages';

    var predefinedmessages_editor = new $.fn.dataTable.Editor( {
        ajax: lcp_grid_path+'predefinedmessages',
        table: "#predefinedmessages_grid",
        fields: [ 
            { label: l("Language:"), name: predefinedmessages_table+".iso_code", type: "select" },
            { label: l("Title:"), name: predefinedmessages_table+".title", },
            { label: l("Message:"), name: predefinedmessages_table+".message", },
        ]
    } );
 

    var predefinedmessages_editor_create_button = { extend: "create", editor: predefinedmessages_editor };
    var predefinedmessages_editor_edit_button = { extend: "edit",   editor: predefinedmessages_editor };
    var predefinedmessages_editor_remove_button = { extend: "remove", editor: predefinedmessages_editor };

    var predefinedmessages_editor_buttons = [];

    if (lcp_employee_is_superadmin == 'Y') 
    {
    	predefinedmessages_editor_buttons.push(predefinedmessages_editor_create_button)
		predefinedmessages_editor_buttons.push(predefinedmessages_editor_edit_button)
		predefinedmessages_editor_buttons.push(predefinedmessages_editor_remove_button);
    }
    else
    {
    	predefinedmessages_editor_buttons.push(predefinedmessages_editor_create_button);
    }


    var predefinedmessages_datatable = $('#predefinedmessages_grid').dataTable( {

        dom: "Bfrtip",
        //"processing": true,
        //"serverSide": true,
        "pageLength": 50,
        "autoWidth": false,
        ajax: {
            url: lcp_grid_path+'predefinedmessages',
            type: 'POST'
        },

        columns: [
            { data: predefinedmessages_table+".iso_code", className: "dt-body-center", },
            { data: predefinedmessages_table+".title", className: "dt-body-center" },
            { data: predefinedmessages_table+".message", className: "dt-body-center" },
            { data: predefinedmessages_table+".last_update", className: "dt-body-center" },
        ],

        select: true,

       	buttons : predefinedmessages_editor_buttons,
    });


	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++



	$("#tabs-departments-a").on('click', function(){

		try{
			departments_datatable.api().ajax.reload();
		} catch(e){}

	});



	$("#tabs-staff-profiles-a").on('click', function(){

		try{
			/*fac sync la staffprofiles cu employees*/
			var params = {

				'load' : 'syncStaffProfiles',
				'divs' : null,
				/*'params' : {
					'data' : data,
				},
				'preloader' : {
					'divs' : {
						0 : 'staff_profiles_ajax_load_span',
					},
					'type' : 1,
					'style' : 3,
				}*/
			};

			lcpAjaxController(params, function(result){
				staffprofiles_datatable.api().ajax.reload();
				//preload({ 0: 'staff_profiles_ajax_load_span'}, 'off', 3); 
			});
	
		} catch(e){}

	});


	$("#tabs-predefined-messages-a").on('click', function(){

		try{
			predefinedmessages_datatable.api().ajax.reload();
		} catch(e){}

	});


	} // end if controller




	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	/*$("#div_scroll").css('width', (window.innerWidth - 50)+'px' );
	$('#browsertracking_iframe').on('mouseover', function() { return false; });
	$( document ).tooltip();*/
	/*init the tabs*/

	$( "#tabs" ).tabs();
	$( "#tabs-users" ).tabs();
	$( "#tabs-chat" ).tabs();
	//$( "#tabs-geotracking" ).tabs();
	//$( "#tabs-mousetracking" ).tabs();
	$( "#tabs-statistics" ).tabs();
	$( "#tabs-visitordetails" ).tabs();


	/*$(document.body).on('click', '#tabs-visitordetails > ul > li > a', function(event){

		var tab = $(this).attr('href').split('_')[0]; 

		//if (tab == '#tabs-visitordetails-geotracking')
			//init_map();
	});*/



	$(document.body).on('change', '#DTE_Field_'+staffprofiles_table+'-avatar', function(event){

		if ($('#staffprofiles_avatar_img').length === 0)
			$('div.DTE_Field_Name_'+staffprofiles_table+'\\.avatar > .DTE_Field_Input').append('<img id="staffprofiles_avatar_img" border="0" src="'+lcp_path+'views/img/avatars/'+$(this).val()+'" width="40" height="40">');		
		else
			$('#staffprofiles_avatar_img').attr('src', lcp_path + 'views/img/avatars/'+$(this).val() );
	});

	
	$(document.body).on('click', '#tabs-chat > ul > li > a', function(event){

		var active_chat_tab = $("#tabs-chat").tabs('option', 'active');

		$('#active_chat_tab').val( active_chat_tab );

		var active_chat_subtab = $( "#tabs-chat-"+ active_chat_tab ).find("span.tab-selected").attr('id'); 

		$('#active_chat_subtab').val( active_chat_subtab );

		$('#'+$("#active_chat_subtab").val()).trigger('click');

		var id_visitor = $('#id_visitor_'+active_chat_tab).val();

		showVisitorDetails(id_visitor);
		showVisitorArchive(id_visitor);
		showVisitorMessages(id_visitor);
		showVisitorRatings(id_visitor);
		showVisitorLogs(id_visitor);
		
		//$('#visitor_details_id_visitor, #visitor_visited_pages_history_id_visitor, #visitor_geotracking_id_visitor, #visitor_archive_id_visitor, #visitor_messages_id_visitor, #visitor_ratings_id_visitor, #visitor_logs_id_visitor').val(id_visitor);
	});


	$(document.body).on('click', '#tabs-users > ul > li > a', function(event){

		var active_users_tab = $("#tabs-users").tabs('option', 'active');

		$('#active_users_tab').val( active_users_tab );

	});


	$(document.body).on('click', '#tabs-statistics > ul > li > a', function(event){

		var active_statistics_tab = $("#tabs-statistics").tabs('option', 'active');

		$('#active_statistics_tab').val( active_statistics_tab );

		$('#active_statistics_tab_link').val( $(this).attr('id') );

	});



	/*submit button format*/

	$( "input[type=submit], button" )
	.button()
	/*.click(function( event ) {
		event.preventDefault();
	})*/;	

	$('#submit').css('height', $('#submit').parent('td').height());


	$("input[type=submit], button").on('mouseover', function(){

		$(this).addClass('ui-priority-primary');

	});

	$("input[type=submit], button").on('mouseout', function(){

		$(this).removeClass('ui-priority-primary');
	});



	$('#word').keydown(function (event) {
	    var keypressed = event.keyCode || event.which;
	    if (keypressed == 13) {
	        $(this).closest('form').submit();
	    	$(this).val('');
	    	return false;
	    }
	});


	/*$( "#transparency" ).slider({
		value: 50,
		orientation: "horizontal",
		range: "min",
		animate: true
	});*/
		

	/*init the menus*/
/*
	$("#menu-visitors").menu();

	$("#menu-archive").menu();

	$("#menu-messages").menu();

	$("#menu-ratings").menu();
*/
	/*$("#menu-emoticons").menu();*/


$(document.body).on('mouseleave', '#menu-emoticons', function(){

	var _this = this;

	setTimeout(function () { 
		var hovered = $(_this).find("li:hover").length;
		if ($(_this).is(':visible') && !hovered)
			$(_this).hide(); 
	}, 300);
});

/*$(document.body).on('mouseleave', '.gk-button.actions', function(){

	var text = $(this).attr('id').split('_')[0];
		text = text.split('-')[1];
		
	var _this = this;
	//var hovered = $('[id^=actions-'+text+']').find("li:hover").length;
	setTimeout(function () { 
		var hovered = $('#menu-'+text).find("li:hover").length;
		if ($('#menu-'+text).is(':visible') && !hovered)
			$('#menu-'+text).hide(); 
	}, 300);
});
*/
/*$( "#dialog_chat" ).scroll(function() {
	

});*/




	// initializam datagridurile
	if ( ! $.fn.DataTable.isDataTable( '#onlinevisitors_grid' ) )
	{
		var onlinevisitors_table = lcp_db_prefix+lcp_module_name+'_onlinevisitors';
		var archive_table = lcp_db_prefix+lcp_module_name+'_archive';

		onlinevisitors_datatable = $('#onlinevisitors_grid').dataTable( {

	        dom: "Bfrtip",
	        //"processing": true,
	        //"serverSide": true,
	        "scrollX": true,
	        "pageLength": 50,
	        "autoWidth": false,
	        ajax: {
	            url: lcp_grid_path+'onlinevisitors',
	            type: 'POST'
	        },

	        columns: [
	            { data: onlinevisitors_table+".id_visitor", className: "dt-body-center" },
	            //{ data: onlinevisitors_table+".country", className: "dt-body-center" },
	            { 
	            	data: onlinevisitors_table+".country", 
	            	className: "dt-body-center",
	            	render: function ( data, type, row, meta ) {
	      				return '<table style="border: 0px !important;"><tr><td><img id="county_flag" border="0" style="width:16px;height:16px;vertical-align:middle;" src="'+lcp_path+'views/img/country_flags/'+data+'.png"></td><td><span style="">'+data+'</span></td></tr></table>';
	    			}
	            },
	            //{ data: onlinevisitors_table+".in_chat", className: "dt-body-center" },
	            /*{ 
	            	data: archive_table+".in_chat", 
	            	className: "dt-body-center",
	            	render: function ( data, type, row, meta ) {
	      					 if(data == 'Y') return l('Yes');
	      				else if(data == 'N') return l('No');
	      				else if(data == 'P') return l('Pending');
	      				else if(data == 'D') return l('Details');
	      				else if(data == 'A') return l('Archive');
	    			}
	            },*/
	            { data: onlinevisitors_table+".city", className: "dt-body-center" },
	            { data: onlinevisitors_table+".language", className: "dt-body-center" },
	            { data: onlinevisitors_table+".visits", className: "dt-body-center" },
	            { data: onlinevisitors_table+".current_page" },
	            { data: onlinevisitors_table+".host" },
	            { data: onlinevisitors_table+".ip", className: "dt-body-center" },
	            { data: onlinevisitors_table+".browser" },
	            { data: onlinevisitors_table+".timezone", className: "dt-body-center" },
	            { data: onlinevisitors_table+".resolution", className: "dt-body-center" },
	            { data: onlinevisitors_table+".referrer" },
	            { data: onlinevisitors_table+".page_count", className: "dt-body-center" },
	            { data: onlinevisitors_table+".os" },
	            { data: onlinevisitors_table+".last_visit", className: "dt-body-center" },
	        ],

			select: true,

				buttons : [
					{
                    extend: 'selectedSingle',
                    //sButtonClass: 'marginLeft',
                    text: l('Invite to chat'),
                    action: function ( e, dt, node, config ) {
                        if ( onlinevisitors_datatable.api().row('.selected').length !== 0 ) {

							var id_visitor = onlinevisitors_datatable.api().row('.selected').data()[onlinevisitors_table].id_visitor;

							var data =  { 
									'id_visitor' : id_visitor,
									'id_staffprofile' : $('#id_staffprofile').val(),
									//'internal' : $('#internal').val(),
								};

							var params = {

								'load' : 'chatRequestFromStaff',
								'divs' : null,
								'params' : {
									'data' : data,
								},
								'preloader' : {
									'divs' : {
										0 : 'statistics_ajax_load_span',
									},
									'type' : 2,
									'style' : 3,
								}
							};

							lcpAjaxController(params, function(result){		
								syncChatDialog('statistics_ajax_load_span');
							}, true);
                        }
                    }
	            },
	            {
                    extend: 'selectedSingle',
                    //sButtonClass: 'marginLeft',
                    text: l('View details'),
                    action: function ( e, dt, node, config ) {
                        if ( onlinevisitors_datatable.api().row('.selected').length !== 0 ) 
                        {
                           // window.open("index.php?controller=AdminEmployees&token="+lcp_employees_token , '_blank');                            
                    		var id_visitor = onlinevisitors_datatable.api().row('.selected').data()[onlinevisitors_table].id_visitor;
                    		showVisitorDetails(id_visitor, true);
                        	$( "#dialog-form-visitordetails" ).dialog( "open" );
                        }
                    }
	            },
				],

	    });

		//fortam selectia
		/*$('#onlinevisitors_grid tbody').on( 'click', 'tr', function () {
	        $(this).toggleClass('selected');
	    } );*/


		$("#tabs-visitors-a").on('click', function(){
			try{
			preload({ 0: 'online_visitors_ajax_load_span'}, 'on', 3);
			onlinevisitors_datatable.api().ajax.reload( function ( json ) {
				preload({ 0: 'online_visitors_ajax_load_span'}, 'off', 3); //$('#myInput').val( json.lastInput );
			} );
			//preload({ 0: 'online_visitors_ajax_load_span'}, 'on', 3);
			} catch(e){}
		});
	}

	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


	/*$(document.body).on('click', "#dialog_chat_a", function(){*/

	$('#dialog_chat_a').on('click', function(){

		$( "#dialog_chat" ).dialog({
			autoOpen: false,
			width: parseInt($(window).width()) - 20,
	        height: parseInt($(window).height()) - 50,
	        position: ['top', 40],
			modal: false,
			close: function() {

			if ( $('#dialog-mousetracking').is(":visible")  )
				$( "#dialog-mousetracking" ).dialog( "close" );	
				/*allFields.val( "" ).removeClass( "ui-state-error" ); */
			}
		});


		if ( $('#dialog_chat').is(":visible")  )
		{
			$( "#dialog_chat" ).dialog( "close" );	
		}
		else
		{		

			if ( ! $.fn.DataTable.isDataTable( '#archive_grid' ) )
			{
				var archive_table = lcp_db_prefix+lcp_module_name+'_archive';
				var departments_table = lcp_db_prefix+lcp_module_name+'_departments';

			    var archive_editor = new $.fn.dataTable.Editor( {
			        ajax: lcp_grid_path+'archive',
			        table: "#archive_grid",
			        fields: [ 
				        { label: l("Name:"), name: archive_table+".name", }, 
			        ]
			    } );


			    var archive_editor_view_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('View details'),
			                    action: function ( e, dt, node, config ) {
			                        if ( archive_datatable.api().row('.selected').length !== 0 ) {
			                            
			                        	var id_archive = archive_datatable.api().row('.selected').data()[archive_table].id_archive;

			                        	//$( "#dialog-form-archive" ).dialog( "open" );

										var data = { 	
												'id_archive' : id_archive,
										};

										var params = {

											'load' : 'getArchive',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};


										lcpAjaxController(params, function(result){

											var res = JSON.parse(result);

											$("#archive_message").html(res.messages);

											$( "#dialog-form-archive" ).dialog( "open" );

										}, true);

			                        }
			                    }
			                };

			    var archive_editor_remove_button = { extend: "remove", editor: archive_editor };

			    var archive_editor_buttons = [];

			    if (lcp_employee_is_superadmin == 'Y') 
			    {
			    	archive_editor_buttons.push(archive_editor_view_button);
					archive_editor_buttons.push(archive_editor_remove_button);
			    }
			    else
			    {
			    	archive_editor_buttons.push(archive_editor_view_button);
			    }


				var archive_datatable = $('#archive_grid').dataTable( {

			        dom: "Bfrtip",
			        //"processing": true,
			        //"serverSide": true,
			        //"scrollX": true,
			        "pageLength": 10,
			        "autoWidth": false,
			        ajax: {
			            url: lcp_grid_path+'archive',
			            type: 'POST'
			        },

			        columns: [
			            { data: archive_table+".date_add", className: "dt-body-center" },
			            { data: archive_table+".id_chat", className: "dt-body-center" },
			            { data: archive_table+".name", className: "dt-body-center" },
			            { data: archive_table+".internal", className: "dt-body-center" },
			            { data: departments_table+".name", className: "dt-body-center" },
			            { data: archive_table+".email", className: "dt-body-center" },
			            { data: archive_table+".company", className: "dt-body-center" },
			            { data: archive_table+".language", className: "dt-body-center" },
			            { data: archive_table+".country", className: "dt-body-center" },
			            { data: archive_table+".ip", className: "dt-body-center" },
			            { data: archive_table+".host", className: "dt-body-center" },
			            { data: archive_table+".duration", className: "dt-body-center" },
			            { data: archive_table+".log_entries", className: "dt-body-center" },
			        ],

			        select: true,

       				buttons : archive_editor_buttons,

			    })/*.rowGrouping({
						iGroupingColumnIndex: 9,
						//bHideGroupingColumn: false,
						//sGroupingColumnSortDirection: "asc",
						//iGroupingOrderByColumnIndex: 1,
				})*/;

				$("#tabs-archive-a").on('click', function(){
					try{
					//archive_datatable.api().ajax.reload();
					} catch(e){}
				});
			}



			//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

			if ( ! $.fn.DataTable.isDataTable( '#messages_grid' ) )
			{
				var messages_table = lcp_db_prefix+lcp_module_name+'_messages';

				var messages_editor = new $.fn.dataTable.Editor( {
			        ajax: lcp_grid_path+'messages',
			        table: "#messages_grid",
			        fields: [ 
				        { label: l("Name:"), name: messages_table+".name", }, 
			        ]
			    } );


			    var messages_editor_remove_button = { extend: "remove", editor: messages_editor };

				var messages_editor_reply_button = {
							                    extend: 'selectedSingle',
							                    //sButtonClass: 'marginLeft',
							                    text: l('Reply'),
							                    action: function ( e, dt, node, config ) {
							                        if ( messages_datatable.api().row('.selected').length !== 0 ) {

							                        	var id_message = messages_datatable.api().row('.selected').data()[messages_table].id_message;

														var data = { 	
																'id_message' : id_message,
														};

														var params = {

															'load' : 'replyToMessage',
															'divs' : null,
															'params' : {
																'data' : data,
															},
															'preloader' : {
																'divs' : {
																	0 : 'statistics_ajax_load_span',
																},
																'type' : 2,
																'style' : 3,
															}
														};

														lcpAjaxController(params, function(result){

															var res = JSON.parse(result);

															$("#messages_id").val(res.id_message);
															$("#messages_date").html(res.date_add);
															$("#messages_department").html(res.department_name);
															$("#messages_sender_name").html(res.name);
															$("#messages_sender_email").html(res.email);
															$("#messages_sender_phone").html(res.phone);
															$("#messages_sender_company").html(res.company);
															$("#messages_message").html(res.question);
															$("#messages_reply_tr").show();
															$( "#dialog-form-messages" ).dialog( "open" );

														});
														
							                        }
							                    }
							                };

			    var messages_editor_view_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('View details'),
			                    action: function ( e, dt, node, config ) {
			                        if ( messages_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_message = messages_datatable.api().row('.selected').data()[messages_table].id_message;

										var data = { 	
												'id_message' : id_message,
										};

										var params = {

											'load' : 'getMessage',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){

											var res = JSON.parse(result);
											/*console.log(res); return;*/

											$("#messages_id").val(res.id_message);
											$("#messages_date").html(res.date_add);
											$("#messages_department").html(res.department_name);
											$("#messages_sender_name").html(res.name);
											$("#messages_sender_email").html(res.email);
											$("#messages_sender_phone").html(res.phone);
											$("#messages_sender_company").html(res.company);
											$("#messages_message").html(res.question);

											$( "#dialog-form-messages" ).dialog( "open" );

										});
			                        }
			                    }
			                };

			    var messages_editor_mark_as_read_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('Mark as read'),
			                    action: function ( e, dt, node, config ) {
			                        if ( messages_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_message = messages_datatable.api().row('.selected').data()[messages_table].id_message;
			                        	//console.log(messages_datatable.api().row('.selected').data()); 
										var data = { 	
												'id_message' : id_message,
												'status' : 'Read',
										};

										var params = {

											'load' : 'updateMessage',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){
											messages_datatable.api().ajax.reload();
										});
			                        }
			                    }
			                };

			        var messages_editor_mark_as_unread_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('Mark as unread'),
			                    action: function ( e, dt, node, config ) {
			                        if ( messages_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_message = messages_datatable.api().row('.selected').data()[messages_table].id_message;

										var data = { 	
												'id_message' : id_message,
												'status' : 'Unread',
										};

										var params = {

											'load' : 'updateMessage',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){
											messages_datatable.api().ajax.reload();
										});
			                        }
			                    }
			                };

			    var messages_editor_buttons = [];


			    if (lcp_employee_is_superadmin == 'Y') 
			    {
			    	messages_editor_buttons.push(messages_editor_remove_button);
					messages_editor_buttons.push(messages_editor_view_button);
					//messages_editor_buttons.push(messages_editor_reply_button);
					messages_editor_buttons.push(messages_editor_mark_as_read_button);
					messages_editor_buttons.push(messages_editor_mark_as_unread_button);
			    }
			    else
			    {
			    	messages_editor_buttons.push(messages_editor_view_button);
			    	//messages_editor_buttons.push(messages_editor_reply_button);
					messages_editor_buttons.push(messages_editor_mark_as_read_button);
					messages_editor_buttons.push(messages_editor_mark_as_unread_button);
			    }


				var messages_datatable = $('#messages_grid').dataTable( {

			        dom: "Bfrtip",
			        //"processing": true,
			        //"serverSide": true,
			        //"scrollX": true,
			        "pageLength": 10,
			        "autoWidth": false,
			        ajax: {
			            url: lcp_grid_path+'messages',
			            type: 'POST'
			        },

			        columns: [
			            { data: messages_table+".date_add", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".name", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".email", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".phone", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".department", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".question", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data.substring(0,20)+' [...]</span>'; else return data.substring(0,20)+' [...]'; } },
			            { data: messages_table+".ip", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".status", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+l(data)+'</span>'; else return l(data); } },
			        ],

			        select: true,

       				buttons : messages_editor_buttons,

			    });

				$("#tabs-messages-a").on('click', function(){
					try{
					//messages_datatable.api().ajax.reload();
					} catch(e){}
				});

			}
			//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

			if ( ! $.fn.DataTable.isDataTable( '#ratings_grid' ) )
			{
				var ratings_table = lcp_db_prefix+lcp_module_name+'_ratings';

				var ratings_editor = new $.fn.dataTable.Editor( {
			        ajax: lcp_grid_path+'ratings',
			        table: "#ratings_grid",
			        fields: [ 
				        { label: l("Name:"), name: ratings_table+".name", }, 
			        ]
			    } );


				var ratings_editor_remove_button = { extend: "remove", editor: ratings_editor };

			    var ratings_editor_view_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('View details'),
			                    action: function ( e, dt, node, config ) {
			                        if ( ratings_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_rating = ratings_datatable.api().row('.selected').data()[ratings_table].id_rating;

										var data = { 	
												'id_rating' : id_rating,
										};

										var params = {

											'load' : 'getRating',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){

											var res = JSON.parse(result);
											/*console.log(res); return;*/

											$("#ratings_politness").html( generateRatingStars( res.politness ) );
											$("#ratings_qualification").html( generateRatingStars( res.qualification ) );
											$("#ratings_date").html(res.date_add);
											$("#ratings_internal").html(res.internal);
											$("#ratings_sender_name").html(res.name);
											$("#ratings_sender_email").html(res.email);
											$("#ratings_sender_phone").html(res.phone);
											$("#ratings_sender_company").html(res.company);
											$("#ratings_comment").html(res.comment);

											$( "#dialog-form-ratings" ).dialog( "open" );

										});
			                        }
			                    }
			                };

			    var ratings_editor_mark_as_read_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('Mark as read'),
			                    action: function ( e, dt, node, config ) {
			                        if ( ratings_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_rating = ratings_datatable.api().row('.selected').data()[ratings_table].id_rating;

										var data = { 	
												'id_rating' : id_rating,
												'status' : 'Read',
										};

										var params = {

											'load' : 'updateRating',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){
											ratings_datatable.api().ajax.reload();
										});
			                        }
			                    }
			                };

			    var ratings_editor_mark_as_unread_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('Mark as unread'),
			                    action: function ( e, dt, node, config ) {
			                        if ( ratings_datatable.api().row('.selected').length !== 0 ) {

										var id_rating = ratings_datatable.api().row('.selected').data()[ratings_table].id_rating;

										var data = { 	
												'id_rating' : id_rating,
												'status' : 'Unread',
										};

										var params = {

											'load' : 'updateRating',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){
											ratings_datatable.api().ajax.reload();
										});
			                        }
			                    }
			                };
			    
			    var ratings_editor_view_matching_chat_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('View matching chat'),
			                    action: function ( e, dt, node, config ) {
			                        if ( ratings_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_rating = ratings_datatable.api().row('.selected').data()[ratings_table].id_rating;

										var data = { 	
												'id_rating' : id_rating,
										};

										var params = {

											'load' : 'getRating',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){

											var res = JSON.parse(result);

											var id_archive = res.id_archive;

											var data2 = { 	
													'id_archive' : id_archive,
											};

											var params2 = {

												'load' : 'getArchive',
												'divs' : null,
												'params' : {
													'data' : data2,
												},
												'preloader' : {
													'divs' : {
														0 : 'statistics_ajax_load_span',
													},
													'type' : 2,
													'style' : 3,
												}
											};

											lcpAjaxController(params2, function(result2){

												var res2 = JSON.parse(result2);

												$("#archive_message").html(res2.messages);

												$( "#dialog-form-archive" ).dialog( "open" );

											});

										});

			                        }
			                    }
			                };

			    var ratings_editor_buttons = [];

			    if (lcp_employee_is_superadmin == 'Y') 
			    {
			    	ratings_editor_buttons.push(ratings_editor_remove_button);
					ratings_editor_buttons.push(ratings_editor_view_button);
					ratings_editor_buttons.push(ratings_editor_mark_as_read_button);
					ratings_editor_buttons.push(ratings_editor_mark_as_unread_button);
					ratings_editor_buttons.push(ratings_editor_view_matching_chat_button);
			    }
			    else
			    {
			    	ratings_editor_buttons.push(ratings_editor_view_button);
					ratings_editor_buttons.push(ratings_editor_mark_as_read_button);
					ratings_editor_buttons.push(ratings_editor_mark_as_unread_button);
					ratings_editor_buttons.push(ratings_editor_view_matching_chat_button);
			    }


				var ratings_datatable = $('#ratings_grid').dataTable( {

			        dom: "Bfrtip",
			        //"processing": true,
			        //"serverSide": true,
			        //"scrollX": true,
			        "pageLength": 10,
			        "autoWidth": false,
			        ajax: {
			            url: lcp_grid_path+'ratings',
			            type: 'POST'
			        },

			        columns: [
			            { data: ratings_table+".politness", className: "dt-body-center", render: function ( data, type, row, meta ) { return generateRatingStars(data); } },
			            { data: ratings_table+".qualification", className: "dt-body-center", render: function ( data, type, row, meta ) { return generateRatingStars(data); } },
			            { data: ratings_table+".date_add", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: ratings_table+".internal", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: ratings_table+".name", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: ratings_table+".email", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: ratings_table+".company", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: ratings_table+".comment", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data.substring(0,20)+' [...]</span>'; else return data.substring(0,20)+' [...]'; } },
			            { data: ratings_table+".status", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+l(data)+'</span>'; else return l(data); } },
			        ],

			        select: true,

       				buttons : ratings_editor_buttons,

			    });

				$("#tabs-ratings-a").on('click', function(){
					try{
					//ratings_datatable.api().ajax.reload();
					} catch(e){}
				});			
			}

			//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

			if ( ! $.fn.DataTable.isDataTable( '#logs_grid' ) )
			{
				var logs_table = lcp_db_prefix+lcp_module_name+'_logs';

				var logs_editor = new $.fn.dataTable.Editor( {
			        ajax: lcp_grid_path+'logs',
			        table: "#logs_grid",
			        fields: [ 
				        { label: l("Name:"), name: logs_table+".name", }, 
			        ]
			    } );

			    var logs_editor_create_button = {};

			    var logs_editor_edit_button = {};

			    var logs_editor_remove_button = { extend: "remove", editor: logs_editor };

			    var logs_editor_buttons = [];

			    if (lcp_employee_is_superadmin == 'Y') 
			    {
			    	logs_editor_buttons.push(logs_editor_remove_button);
			    }
			    else
			    {
			    	logs_editor_buttons = [];
			    }

				var logs_datatable = $('#logs_grid').dataTable( {

			        dom: "Bfrtip",
			        //"processing": true,
			        //"serverSide": true,
			        //"scrollX": true,
			        "pageLength": 10,
			        "autoWidth": false,
			        ajax: {
			            url: lcp_grid_path+'logs',
			            type: 'POST'
			        },

			        columns: [
			            { data: logs_table+".date_add", className: "dt-body-center" },
			            { data: logs_table+".message" },
			        ],

			        select: true,

       				buttons : logs_editor_buttons,

			    });

				$("#tabs-logs-a").on('click', function(){
					try{
					//logs_datatable.api().ajax.reload();
					} catch(e){}
				});
			}
			//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

			// set date range regionals
			//$.datepicker.regional[""].dateFormat = 'yy-mm-dd';
		    //$.datepicker.setDefaults($.datepicker.regional['']);
			$(".dataTables_filter input").addClass("lcp formfield1");
			$(".date_range_filter, .text_filter").addClass("lcp formfield1");

			//fac sa mearga scrollul la datatables
			setTimeout(function() { 
		
				$('#onlinevisitors_grid_wrapper, #archive_grid_wrapper, #messages_grid_wrapper, #ratings_grid_wrapper, #logs_grid_wrapper').css({
	        		'width': parseInt($(window).width()) - 80 + 'px',
	   			});

				$('#'+ $("#active_statistics_tab_link").val() ).trigger('click'); 

			}, 1500 );

			//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			// END DATAGRIDS

			$( "#dialog_chat" ).dialog( "open" );

		}
		/*
		else
		{
			$('#'+ $("#active_statistics_tab_link").val() ).trigger('click');

			$( "#dialog_chat" ).dialog( "open" );	

			var data = { 	
					'id_employee' : $('#id_employee').val(),
			};

			var params = {

				'load' : 'syncChatDialog',
				'divs' : null,
				'params' : {
					'data' : data,
				},
			};

			lcpAjaxController(params, function(result){

				var res = JSON.parse(result);

				$("#ajax_chats_div").html(res.response['ajax.chats.tpl']);
				$("#ajax_onlineusers_div").html(res.response['ajax.onlineusers.tpl']);
				$("#awaiting_response_chat_dialogs").html(res.response['ajax.header_chats_counter.tpl']);

			});	
		}*/

		/*alos close mousetracking*/
		if ( $('#dialog-mousetracking').is(":visible")  )
		{
			$( "#dialog-mousetracking" ).dialog( "close" );	
		}


	});



    $('#online_icon_upload').uploadify({
    	'multi'    : false,
    	'method'   : 'post',
    	'formData' : { 'path' : lcp_path },
    	'buttonText' : l('Upload'),
        'swf'      : lcp_path+'views/js/uploadify/uploadify.swf',
        'uploader' : lcp_path+'views/js/uploadify/uploadify.php',
        'onUploadSuccess' : function(file, data, response) 
        {
        	if (data == 'error1') 
        		alert(l('File exists, choose different filename.'));
        	else if (data == 'error2') 
        		alert(l('Invalid file type.'));
        	else
        	{
        		var iso_code = $('#online_img_languages').find('option:selected').text();
        		$("#online_img_"+iso_code).attr('src', lcp_path + 'views/img/iconsets/'+data );
        	}

    	}, 
        /*height     : 20,
        width      : 50,*/
    }); 


    $('#offline_icon_upload').uploadify({
    	'multi'    : false,
    	'method'   : 'post',
    	'formData' : { 'path' : lcp_path },
    	'buttonText' : l('Upload'),
        'swf'      : lcp_path+'views/js/uploadify/uploadify.swf',
        'uploader' : lcp_path+'views/js/uploadify/uploadify.php',
        'onUploadSuccess' : function(file, data, response) 
        {
        	if (data == 'error1') 
        		alert(l('File exists, choose different filename.'));
        	else if (data == 'error2') 
        		alert(l('Invalid file type.'));
        	else
        	{
        		var iso_code = $('#offline_img_languages').find('option:selected').text();
        		$("#offline_img_"+iso_code).attr('src', lcp_path + 'views/img/iconsets/'+data );
        	}
    	}, 
        /*height     : 20,
        width      : 50,*/
    }); 





/*-------------------------------------------------------------------------*/

	$(document.body).on('click', 'img[id^="emoticon_img"]', function(){

		var key = $('#active_chat_subtab').val().split('_')[2];
		
		var textarea_val = $('#msg_admin').val();

		$('#msg_admin').val('');

		$('#msg_admin').val( textarea_val + $(this).prev().val() );

		$('#menu-emoticons').hide();

	});



	$(document.body).on('click', 'input[id^="accept_chat"]', function(){

		/*clearInterval(blink_interval_id);*/

		/*var tab_active = $(this).attr('id').split('_')[0];*/
		var key = $(this).attr('id').split('_')[2];
		var id_visitor = $('#id_visitor_'+key).val();

		var data =  { 
				'id_visitor' : id_visitor,
				'id_staffprofile' : $('#id_staffprofile').val(),
				'internal' : $('#internal').val(),
				'action' : 'chatAcceptedFromStaff',
			};

		/*console.log(data);return;*/

		/*$('#msg').val('');*/

			var params = {

				'load' : 'chatAcceptedFromStaff',
				'divs' : {
					0: 'ajax_onlineusers_div',
				},
				'params' : {
					/*'action' : 'chatAcceptedFromStaff',
					'id_visitor' : id_visitor,*/
					'data' : data,
					/*'timestamp' : 0,*/
				},
				'preloader' : {
					'divs' : {
						0 : 'chatactionbuttons_ajax_load_span',
					},
					'type' : 2,
					'style' : 3,
				}
			};


			lcpAjaxController(params, function(result) {		
				
				/*$('#chat_buttons_'+key).hide();

				$('#chat_messages_tr_'+key).show();

				$('#content-'+key).css('height', '184px');

				$("#in_chat_"+key).val('Y');

				$('#userchat_span_'+key).trigger('click');*/

				syncChatDialog('chatactionbuttons_ajax_load_span');
				
				$('a[href="#tabs-chat-'+key+'"] >span').removeClass('blink-container');

				$('a[href="#tabs-chat-'+key+'"] >span').removeClass('blink');

				stopSound('newchat');

			}, true);



	});


	$('[id$="_languages"]').on('change', function(){
	//$('#message_text_languages, #more_info_text_languages, #got_it_button_text_languages, #more_info_button_text_languages').on('change', function(){

		var field = $(this).attr('id').split('_languages')[0];
		var iso_code = $(this).find('option:selected').text();

		$('[id^="'+field+'"]').hide();

		$('#'+field+'_'+iso_code).show();

		$(this).show();

		$('#'+field+'_'+iso_code).trigger('change');

	});


	$(document.body).on('click', 'input[id^="deny_chat"]', function(){

		var key = $(this).attr('id').split('_')[2];

		$('#remove_tab_'+key).trigger('click');

	});


	$(document.body).on('click', 'span[id^="remove_tab"]', function(){

		var panelId = $( this ).closest( "li" ).remove().attr( "aria-controls" );

		$( "#" + panelId ).remove();

		$( "#tabs-chat" ).tabs( "refresh" );

		if ( $('#tabs-chat > ul > li').size() == 0)
		{
			$("#no_chats").show();
			$('#tabs-visitor-userchat-'+key).hide();
			$('#tabs-visitor-details').hide();
			$('#tabs-visitor-visitedpageshistory').hide();
			$('#tabs-visitor-geotracking').hide();
			$('#tabs-visitor-archive').hide();
			$('#tabs-visitor-messages').hide();
			$('#tabs-visitor-ratings').hide();
			$('#tabs-visitor-logs').hide();
			$('#ajax_chats_textarea_div').hide();
		}
		else
			$("#no_chats").hide();

		$('#ajax_chats_table').removeClass('border-without-bottom'); $('#ajax_chats_table').addClass('border-full');
		$('#ajax_chats_table').removeClass('radius5-top'); $('#ajax_chats_table').addClass('radius5');

		var key = $(this).attr('id').split('_')[2];

		var id_visitor = $('#id_visitor_'+key).val();

		var data =  { 
				'id_visitor' : id_visitor,
				'id_staffprofile' : $('#id_staffprofile').val(),
				'internal' : $('#internal').val(),
				'action' : 'chatClosedFromStaff',
			};

			var params = {

				'load' : 'chatClosedFromStaff',
				'divs' : null,
				'params' : {
					/*'action' : 'chatClosedFromStaff',
					'id_visitor' : id_visitor,*/
					'data' : data,
					/*'timestamp' : 0,*/
				},
				/*'preloader' : {
					'divs' : {
						0 : 'start_chat_ajax_load_span',
					},
					'type' : 2,
					'style' : 3,
				}*/
			};

			stopSound('newchat');

			lcpAjaxController(params, function(result){		
				
				//syncChatDialog();

			}, true);

	});



	$(document.body).on('click', 'input[id^="invite_to_chat"]', function(){

		var key = $(this).attr('id').split('_')[3];

		var id_visitor = $('#id_visitor_'+key).val();

		/*console.log(id_visitor); return;*/

		var data =  { 
				'id_visitor' : id_visitor,
				'id_staffprofile' : $('#id_staffprofile').val(),
				//'internal' : $('#internal').val(),
			};

		/*$('#msg').val('');*/

			var params = {

				'load' : 'chatRequestFromStaff',
				'divs' : null,
				'params' : {
					'data' : data,
				},
				/*'preloader' : {
					'divs' : {
						0 : 'start_chat_ajax_load_span',
					},
					'type' : 2,
					'style' : 3,
				}*/
			};

			$(this).val('Invitation sent, please wait...');

			$(this).prop( "disabled", true );
			/*$('#chat_request_from_'+key).val('staff');*/
			lcpAjaxController(params, function(result){		

			}, true);



	});




 $(document.body).on('keydown', 'textarea[id^="msg_admin"]', function(event){

 	/*$('#msg_admin_aux').val( $(this).val() );*/
    var keypressed = event.keyCode || event.which;

	try 
	{
	    if (keypressed == 13) 
	    {
			/*var key = $(this).attr('id').split('_')[2];*/
			var key = $('#active_chat_subtab').val().split('_')[2];

			var staff_name = ($("#show_names").val() == 'Y') ? ' ('+ $('#internal').val() + ')' : '';

	    	var html = 
	    	'<table border="0" style="width: 100%; margin-bottom: 10px; border-bottom: solid 0px #AAAAAA;">'+
				'<tr>'+
					'<td rowspan="2" valign="top" style="width: 40px; padding-right: 5px;"><img border="0" src="'+lcp_path+'views/img/avatars/'+$("#staff_avatar").val()+'" width="40" height="40"></td>'+
					'<td style="text-align: left;"><b>'+l('Staff')+staff_name+':</b></td>'+
					'<td style="text-align: right; color: #AAAAAA;">'+getDateTime()+'</td>'+
				'</tr>'+
				'<tr>'+
					'<td colspan="2" style="text-align: left;">'+parseChatText($(this).val())+'</td>'+
				'</tr>'+
			'</table>';


			$('#chat_messages_'+key).append( html );

			//$('#content-'+key).scrollTop($('#content-'+key)[0].scrollHeight);
			$('#content-'+key).scrollTop($('#content-'+key).prop('scrollHeight'));

			/*$('#msg_admin_aux').val( $(this).val() );*/
			var data =  { 
					'msg' : $(this).val(),
					'messages' : html,//$('#chat_messages_'+key).html(),
					'id_visitor' : $('#id_visitor_'+key).val(),
					'id_staffprofile' : $('#id_staffprofile').val(),
					'staff_avatar' : $('#staff_avatar').val(),
					/*'key' : key,*/
					'action' : 'chatMessageFromStaff',
				};

				var params = {

					'load' : 'chatMessageFromStaff',
					/*'complete' : 'loop',
					'append' : true,*/
					'divs' : null,
					'params' : {
						/*'action' : 'chatMessageFromStaff',
						'id_visitor' : $('#id_visitor').val(),*/
						'data' : data,
						/*'timestamp' : 0,*/
					},
					/*'preloader' : {
						'divs' : {
							0 : 'send_msg_ajax_load_span',
						},
						'type' : 2,
						'style' : 3,
					}*/
				};

				/*console.log(parseEmoticons( 'sadfasdfa sdf :)' ));*/
				$(this).val('');
				/*var timestamp = new Date().getTime();*/
				lcpAjaxController(params, function(result){		
				}, true);
	    	
	    	return false;
	    }

	} catch(e){}

 });


	$(document.body).on('click', 'a[id^="show_hide_emoticons"]', function(){

		/*var type = $(this).attr('id').split('_')[1];
		var type_nr = $(this).attr('id').split('_')[4];*/
		var button_id = $(this).attr('id');/*//console.log( $(e.currentTarget).attr('id') );*/
		var position = $('#'+button_id).offset(); /*//console.log( position );*/
		
		var posX = position.left - $("#menu-emoticons").width();
		var posY = position.top - 100;

		$("#menu-emoticons").toggle();
		/*$("#menu-emoticons").css('z-index', '9999');*/
		$("#menu-emoticons").offset({ left:posX,top:posY });
		/*alert(type);*/


});


	$('#delete_settings').on('click', function(){

		if ( $(this).attr('class') == 'button-disabled' ) return false;

		var q = confirm(l("Are you sure you want to delete the setting")+" `"+$('#settings option:selected').text()+"`?");

		if (q == true) {
		    
			var data = { 	
					'id_setting' : $('#settings').val(),
			};

			/*ajax aici:*/
				var params = {

					'load' : 'deleteSettings',
					'divs' : {
						0 : 'settings_ajax_span',
					},
					'params' : {
						'data' : data,
					},
					'preloader' : {
						'divs' : {
							0 : 'settings_ajax_load_span',
						},
						'type' : 2,
						'style' : 3,
					}
				};


			lcpAjaxController(params, function(result){

				var res = JSON.parse(result);

				if (res.success == true)
					$("#settings").trigger("change");
				else
					alert( res.response );
				
			});


		} else {
		    return false;
		}

	});


	$(document.body).on('blur', 'input[id^="lcp_sync"]', function(){
	//$("#salary").blur(function(){
	   $(this).parseNumber({format:"###0", locale:"us"});
	   $(this).formatNumber({format:"###0", locale:"us"});
	   if ($(this).val() == '' || $(this).val() == 0) $(this).val(1);
	});


	$("#lcp_save_performance_settings").on('click', function(){

		if ( $(this).attr('class') == 'button-disabled' ) return false;

		if (lcp_employee_is_superadmin != 'Y') return alert(l("Only the admin can change this setting!"));

		var data = { 	
				'sync_chat_dialog_interval_admin' : $('#lcp_sync_chat_dialog_interval_admin').val(),
				'sync_chat_dialog_interval_front' : $('#lcp_sync_chat_dialog_interval_front').val(),
				'sync_online_visitors_interval_datatable_admin' : $('#lcp_sync_online_visitors_interval_datatable_admin').val(),
				'sync_online_visitors_interval_front' : $('#lcp_sync_online_visitors_interval_front').val(),
		};

		var params = {

			'load' : 'savePerformanceSettings',
			'divs' : null,
			'params' : {
				'data' : data,
			},
			'preloader' : {
				'divs' : {
					0 : 'save_performance_settings_ajax_load_span',
				},
				'type' : 2,
				'style' : 3,
			}
		};

		lcpAjaxController(params, function(result){

			var res = JSON.parse(result);

			alert( res.response );

		});	

	});




	$("#lcp_restore_performance_settings_defaults").on('click', function(){

		if ( $(this).attr('class') == 'button-disabled' ) return false;

		if (lcp_employee_is_superadmin != 'Y') return alert(l("Only the admin can change this setting!"));

		$('#lcp_sync_chat_dialog_interval_admin').val(5);
		$('#lcp_sync_chat_dialog_interval_front').val(5);
		$('#lcp_sync_online_visitors_interval_datatable_admin').val(30);
		$('#lcp_sync_online_visitors_interval_front').val(15);

		var data = { 	
				'sync_chat_dialog_interval_admin' : 5,
				'sync_chat_dialog_interval_front' : 5,
				'sync_online_visitors_interval_datatable_admin' : 30,
				'sync_online_visitors_interval_front' : 15,
		};

		var params = {

			'load' : 'savePerformanceSettings',
			'divs' : null,
			'params' : {
				'data' : data,
			},
			'preloader' : {
				'divs' : {
					0 : 'save_performance_settings_ajax_load_span',
				},
				'type' : 2,
				'style' : 3,
			}
		};

		lcpAjaxController(params, function(result){

			var res = JSON.parse(result);

			alert( res.response );

		});	

	});



	$("#lcp_clear_database").on('click', function(){

		if ( $(this).attr('class') == 'button-disabled' ) return false;

		var q = confirm(l("Are you sure you want to clear the database?"));

		if (q != true) return false;

		if (lcp_employee_is_superadmin != 'Y') return alert(l("Only the admin can clear the database!"));

			var params = {

				'load' : 'clearDatabase',
				'divs' : null,
				'params' : {
					'data' : null,
				},
				'preloader' : {
					'divs' : {
						0 : 'clear_database_ajax_load_span',
					},
					'type' : 2,
					'style' : 3,
				}
			};

			lcpAjaxController(params, function(result){

				alert( result );

			});	

	});




	$("#save_settings").on('click', function(){

		if ( $(this).attr('class') == 'button-disabled' ) return false;

/*		var q = confirm(l("Are you sure you want to save the settings to")+" `"+$('#settings option:selected').text()+"`?");
		if (q == true) {
*/
			var offline_header = {}, 
				online_header = {}, 
				offline_welcome_message = {},
				online_welcome_message = {},
				iso_codes = {},
				iso_code;

			var i = 0;
			$('input[id^="offline_header"]').each(function() {
				iso_code = $(this).attr('id').split('_')[2];
				offline_header[iso_code] = $(this).val();
				iso_codes[i] = iso_code;
				i++;
			});

			$('input[id^="online_header"]').each(function() {
				iso_code = $(this).attr('id').split('_')[2];
				online_header[iso_code] = $(this).val();
			});

			$('textarea[id^="offline_welcome_message"]').each(function() {
				iso_code = $(this).attr('id').split('_')[3];
				offline_welcome_message[iso_code] = $(this).val();
			});

			$('textarea[id^="online_welcome_message"]').each(function() {
				iso_code = $(this).attr('id').split('_')[3];
				online_welcome_message[iso_code] = $(this).val();
			});

			var name_field = $('input[type=radio][name=name_field]:checked').val();
			var email_field = $('input[type=radio][name=email_field]:checked').val();
			var phone_field = $('input[type=radio][name=phone_field]:checked').val();
			var department_field = $('input[type=radio][name=department_field]:checked').val();
			var question_field = $('input[type=radio][name=question_field]:checked').val();
			var chat_type = $('input[type=radio][name=chat_type]:checked').val();
			var orientation = ( $('input[type=radio][name=chat_type]:checked').val() == 'Slide' ) ? $('#orientation_slide_select').val() : $('#orientation_popup_select').val();
			var start_minimized = $('input[type=radio][name=start_minimized]:checked').val();
			var fields_are_not_mandatory = $('input[type=radio][name=fields_are_not_mandatory]:checked').val();
			var hide_when_offline = $('input[type=radio][name=hide_when_offline]:checked').val();
			var show_names = $('input[type=radio][name=show_names]:checked').val();
			var staff_qualification = $('input[type=radio][name=staff_qualification]:checked').val();
			var position = ( $('input[type=radio][name=fixed_position]:checked').val() == 'Y' ) ? 'Fixed' : '';
			var position_options = $('input[type=radio][name=position_options]:checked').val();

			var data = { 	
					'id_setting' : $('#settings').val(),
					'id_iconset' : $('#iconsets').val(),
					'id_theme' : $('#themes').val(),
					'offline_messages_go_to' : $('#offline_messages_go_to').val(),
					'new_chat_sound' : $('#new_chat_sound').val(),
					'new_message_sound' : $('#new_message_sound').val(),
					'name_field' : name_field,
					'email_field' : email_field,
					'phone_field' : phone_field,
					'department_field' : department_field,
					'question_field' : question_field,
					'chat_type' : chat_type,
					'orientation' : orientation,
					'offset' : $('#offset').val(),
					'start_minimized' : start_minimized,
					'fields_are_not_mandatory' : fields_are_not_mandatory,
					'hide_when_offline' : hide_when_offline,
					'show_names' : show_names,
					'staff_qualification' : staff_qualification,
					'position' : position,
					'position_options' : position_options,
					'code' :$('#code').val(),
					'hook' : $('#hooks').val(),
					'offline_header_message' : offline_header,
					'online_header_message' : online_header,
					'offline_welcome_message' : offline_welcome_message,
					'online_welcome_message' : online_welcome_message,
					'iso_codes' : iso_codes,
			};

			var params = {

				'load' : 'saveSettings',
				'divs' : null,
				'params' : {
					'data' : data,
				},
				'preloader' : {
					'divs' : {
						0 : 'settings_ajax_load_span',
					},
					'type' : 2,
					'style' : 3,
				}
			};

				lcpAjaxController(params, function(result){

				var res = JSON.parse(result);

				if (res.success == true)
				{
					/*salvez si iconset*/
					$("#save_iconset").trigger("click");

					/*salvez si theme*/
					$("#save_theme").trigger("click");
				}
				else
					alert( res.response );

				});		
/*		
		}
		else
		{
			return false;
		}
*/
	});




	$("#save_as_settings").on('click', function(){

		var settings_name = prompt(l('Enter name'),'mycustomsettings1');

		if (settings_name != null)
		{
			if (validateInput(settings_name) != false)
			{

				var offline_header = {}, 
					online_header = {}, 
					offline_welcome_message = {},
					online_welcome_message = {},
					iso_codes = {},
					iso_code;

				var i = 0;
				$('input[id^="offline_header"]').each(function() {
					iso_code = $(this).attr('id').split('_')[2];
					offline_header[iso_code] = $(this).val();
					iso_codes[i] = iso_code;
					i++;
				});

				$('input[id^="online_header"]').each(function() {
					iso_code = $(this).attr('id').split('_')[2];
					online_header[iso_code] = $(this).val();
				});

				$('textarea[id^="offline_welcome_message"]').each(function() {
					iso_code = $(this).attr('id').split('_')[3];
					offline_welcome_message[iso_code] = $(this).val();
				});

				$('textarea[id^="online_welcome_message"]').each(function() {
					iso_code = $(this).attr('id').split('_')[3];
					online_welcome_message[iso_code] = $(this).val();
				});

				var name_field = $('input[type=radio][name=name_field]:checked').val();
				var email_field = $('input[type=radio][name=email_field]:checked').val();
				var phone_field = $('input[type=radio][name=phone_field]:checked').val();
				var department_field = $('input[type=radio][name=department_field]:checked').val();
				var question_field = $('input[type=radio][name=question_field]:checked').val();
				var chat_type = $('input[type=radio][name=chat_type]:checked').val();
				var orientation = ( $('input[type=radio][name=chat_type]:checked').val() == 'Slide' ) ? $('#orientation_slide_select').val() : $('#orientation_popup_select').val();
				var start_minimized = $('input[type=radio][name=start_minimized]:checked').val();
				var fields_are_not_mandatory = $('input[type=radio][name=fields_are_not_mandatory]:checked').val();
				var hide_when_offline = $('input[type=radio][name=hide_when_offline]:checked').val();
				var show_names = $('input[type=radio][name=show_names]:checked').val();
				var staff_qualification = $('input[type=radio][name=staff_qualification]:checked').val();
				var position = ( $('input[type=radio][name=fixed_position]:checked').val() == 'Y' ) ? 'Fixed' : '';
				var position_options = $('input[type=radio][name=position_options]:checked').val();

				var data = { 	
					'id_iconset' : $('#iconsets').val(),
					'id_theme' : $('#themes').val(),
					'name' : settings_name,
					'offline_messages_go_to' : $('#offline_messages_go_to').val(),
					'new_chat_sound' : $('#new_chat_sound').val(),
					'new_message_sound' : $('#new_message_sound').val(),
					'name_field' : name_field,
					'email_field' : email_field,
					'phone_field' : phone_field,
					'department_field' : department_field,
					'question_field' : question_field,
					'chat_type' : chat_type,
					'orientation' : orientation,
					'offset' : $('#offset').val(),
					'start_minimized' : start_minimized,
					'fields_are_not_mandatory' : fields_are_not_mandatory,
					'hide_when_offline' : hide_when_offline,
					'show_names' : show_names,
					'staff_qualification' : staff_qualification,
					'position' : position,
					'position_options' : position_options,
					'code' :$('#code').val(),
					'hook' : $('#hooks').val(),
					'offline_header_message' : offline_header,
					'online_header_message' : online_header,
					'offline_welcome_message' : offline_welcome_message,
					'online_welcome_message' : online_welcome_message,
					'iso_codes' : iso_codes,
				};

				var params = {

					'load' : 'saveAsSettings',
					'divs' : {
						0 : 'settings_ajax_span',
					},
					'params' : {
						'data' : data,
					},
					'preloader' : {
						'divs' : {
							0 : 'settings_ajax_load_span',
						},
						'type' : 2,
						'style' : 3,
					}
				};



				lcpAjaxController(params, function(result){

					/*salvez si iconset*/
					$("#save_iconset").trigger("click");

					/*salvez si theme*/
					$("#save_theme").trigger("click");

					/*$('#settings').val(template_name);*/

					$("#settings option").each(function() {
					  if( $(this).text() == settings_name) 
					  {
					    $(this).attr('selected', 'selected');            
					  }                        
					});
					/*load the settings from database

					$("#settings").trigger("change");*/
				});			
			}
			else
			{
				alert(l('You need to use only aplhanumeric characters.'));
			}
		} 

	});


	$('#delete_theme').on('click', function(){

		if ( $(this).attr('class') == 'button-disabled' ) return false;

		var q = confirm(l("Are you sure you want to delete the theme")+" `"+$('#themes option:selected').text()+"`?");

		if (q == true) {
		    
			var data = { 	
					'id_theme' : $('#themes').val(),
			};

			/*ajax aici:*/
				var params = {

					'load' : 'deleteTheme',
					'divs' : {
						0 : 'themes_ajax_span',
					},
					'params' : {
						'data' : data,
					},
					'preloader' : {
						'divs' : {
							0 : 'themes_ajax_load_span',
						},
						'type' : 2,
						'style' : 3,
					}
				};


			lcpAjaxController(params, function(result){
				
				var res = JSON.parse(result);

				if (res.success == true)
					$("#themes").trigger("change");
				else
					alert( res.response );
				
			});


		} else {
		    return false;
		}

	});




	$("#save_theme").on('click', function(){

		if ( $(this).attr('class') == 'button-disabled' ) return false;

		/*var q = confirm(l("Are you sure you want to save the theme to")+" `"+$('#themes option:selected').text()+"`?");

		if (q == true) {*/

			var chat_box_border = $('input[type=radio][name=chat_box_border]:checked').val();

			var data = { 	
					'id_theme' : $('#themes').val(),
						'width' : $('#chat_width').val(),
						'height' : $('#chat_height').val(),
						'corners_radius' : $('#corners_radius').val(),
						'chat_box_background' : $('#chat_box_background').val(),
						'chat_box_foreground' : $('#chat_box_foreground').val(),
						'chat_box_border' : chat_box_border,
						'chat_box_border_color' : $('#chat_box_border_color').val(),
						'header_offline_background' : $('#header_offline_background').val(),
						'header_online_background' : $('#header_online_background').val(),
						'header_offline_foreground' : $('#header_offline_foreground').val(),
						'header_online_foreground' : $('#header_online_foreground').val(),
						'submit_button_background' : $('#submit_button_background').val(),
						'submit_button_foreground' : $('#submit_button_foreground').val(),
			};

			var params = {

				'load' : 'saveTheme',
				'divs' : null,
				'params' : {
					'data' : data,
				},
				'preloader' : {
					'divs' : {
						0 : 'themes_ajax_load_span',
					},
					'type' : 2,
					'style' : 3,
				}
			};

				lcpAjaxController(params, function(result){

					var res = JSON.parse(result);

					if (res.success == true)
						return;
					else
						alert( res.response );
				});		
/*		}
		else
		{
			return false;
		}*/


	});





	$("#save_as_theme").on('click', function(){

		var theme_name = prompt(l('Enter name'),'mycustomtheme1');

		if (theme_name != null)
		{
			if (validateInput(theme_name) != false)
			{
				var chat_box_border = $('input[type=radio][name=chat_box_border]:checked').val();

				var data = { 	
						'name' : theme_name,
						'width' : $('#chat_width').val(),
						'height' : $('#chat_height').val(),
						'corners_radius' : $('#corners_radius').val(),
						'chat_box_background' : $('#chat_box_background').val(),
						'chat_box_foreground' : $('#chat_box_foreground').val(),
						'chat_box_border' : chat_box_border,
						'chat_box_border_color' : $('#chat_box_border_color').val(),
						'header_offline_background' : $('#header_offline_background').val(),
						'header_online_background' : $('#header_online_background').val(),
						'header_offline_foreground' : $('#header_offline_foreground').val(),
						'header_online_foreground' : $('#header_online_foreground').val(),
						'submit_button_background' : $('#submit_button_background').val(),
						'submit_button_foreground' : $('#submit_button_foreground').val(),
				};

				var params = {

					'load' : 'saveAsTheme',
					'divs' : {
						0 : 'themes_ajax_span',
					},
					'params' : {
						'data' : data,
					},
					'preloader' : {
						'divs' : {
							0 : 'themes_ajax_load_span',
						},
						'type' : 2,
						'style' : 3,
					}
				};



				lcpAjaxController(params, function(result){

					/*$('#settings').val(template_name);*/
					$("#themes option").each(function() {
					  if( $(this).text() == theme_name) 
					  {
					    $(this).attr('selected', 'selected');            
					  }                        
					});
					/*load the settings from database
					$("#themes").trigger("change");*/
				});			

			}
			else
			{
				alert(l('You need to use only aplhanumeric characters.'));
			}
		} 

	});




	$('#delete_iconset').on('click', function(){

		if ( $(this).attr('class') == 'button-disabled' ) return false;

		var q = confirm(l("Are you sure you want to delete the iconset")+" `"+$('#iconsets option:selected').text()+"`?");

		if (q == true) {
		    
			var data = { 	
					'id_iconset' : $('#iconsets').val(),
			};

			/*ajax aici:*/
				var params = {

					'load' : 'deleteIconset',
					'divs' : {
						0 : 'iconsets_ajax_span',
					},
					'params' : {
						'data' : data,
					},
					'preloader' : {
						'divs' : {
							0 : 'iconsets_ajax_load_span',
						},
						'type' : 2,
						'style' : 3,
					}
				};


			lcpAjaxController(params, function(result){

				var res = JSON.parse(result);

				if (res.success == true)
					$("#iconsets").trigger("change");
				else
					alert( res.response );				
				
			});


		} else {
		    return false;
		}

	});
	


	$("#save_iconset").on('click', function(){

		if ( $(this).attr('class') == 'button-disabled' ) return false;

		/*var q = confirm(l("Are you sure you want to save the below iconset to")+" `"+$('#iconsets option:selected').text()+"`?");

		if (q == true) {*/
			var offline_img = {}, 
				online_img = {}, 
				iso_codes = {},
				iso_code,
				offline_img_index,
				offline_img_file,
				online_img_index,
				online_img_file;

			var i = 0;
			$('img[id^="offline_img"]').each(function() {
				offline_img_index = $(this).attr('src').lastIndexOf("/") + 1;
				offline_img_file = $(this).attr('src').substr(offline_img_index);
				iso_code = $(this).attr('id').split('_')[2];
				offline_img[iso_code] = offline_img_file;
				iso_codes[i] = iso_code;
				i++;
			});

			$('img[id^="online_img"]').each(function() {
				online_img_index = $(this).attr('src').lastIndexOf("/") + 1;
				online_img_file = $(this).attr('src').substr(online_img_index);
				iso_code = $(this).attr('id').split('_')[2];
				online_img[iso_code] = online_img_file;
			});

			/*console.log(offline_img_file);
			console.log(online_img_file);*/

			var data = { 	
					'id_iconset' : $('#iconsets').val(),
					'offline_img' : offline_img,
					'online_img' : online_img,
					'iso_codes' : iso_codes,
			};

			var params = {

				'load' : 'saveIconset',
				'divs' : null,
				'params' : {
					'data' : data,
				},
				'preloader' : {
					'divs' : {
						0 : 'iconsets_ajax_load_span',
					},
					'type' : 2,
					'style' : 3,
				}
			};

				lcpAjaxController(params, function(result){

					var res = JSON.parse(result);

					if (res.success == true)
						return;
					else
						alert( res.response );

				});		


		/*}
		else
		{
			return false;
		}*/


	});




	$("#save_as_iconset").on('click', function(){

		var iconset_name = prompt(l('Enter name'),'mycustomiconset1');

		if (iconset_name != null)
		{
			if (validateInput(iconset_name) != false)
			{
				var offline_img = {}, 
					online_img = {}, 
					iso_codes = {},
					iso_code,
					offline_img_index,
					offline_img_file,
					online_img_index,
					online_img_file;

				var i = 0;
				$('img[id^="offline_img"]').each(function() {
					offline_img_index = $(this).attr('src').lastIndexOf("/") + 1;
					offline_img_file = $(this).attr('src').substr(offline_img_index);
					iso_code = $(this).attr('id').split('_')[2];
					offline_img[iso_code] = offline_img_file;
					iso_codes[i] = iso_code;
					i++;
				});

				$('img[id^="online_img"]').each(function() {
					online_img_index = $(this).attr('src').lastIndexOf("/") + 1;
					online_img_file = $(this).attr('src').substr(online_img_index);
					iso_code = $(this).attr('id').split('_')[2];
					online_img[iso_code] = online_img_file;
				});

				var data = { 	
						'name' : iconset_name,
						'offline_img' : offline_img,
						'online_img' : online_img,
						'iso_codes' : iso_codes,
				};

				var params = {

					'load' : 'saveAsIconset',
					'divs' : {
						0 : 'iconsets_ajax_span',
					},
					'params' : {
						'data' : data,
					},
					'preloader' : {
						'divs' : {
							0 : 'iconsets_ajax_load_span',
						},
						'type' : 2,
						'style' : 3,
					}
				};



				lcpAjaxController(params, function(result){

					/*$('#settings').val(template_name);*/

					$("#iconsets option").each(function() {
					  if( $(this).text() == iconset_name) 
					  {
					    $(this).attr('selected', 'selected');            
					  }                        
					});
					/*load the settings from database

					$("#iconsets").trigger("change");*/



				});			

			}
			else
			{
				alert(l('You need to use only aplhanumeric characters.'));
			}
		} 

	});




	$(document.body).on('click', "#messages_reply_send_button", function(){

		//$(this).prop('disabled', true);

		var data = { 	
				'id_message' : $('#messages_id').val(),
				'messages_reply' : $('#messages_reply').val(),
		};

		var params = {

			'load' : 'replyToMessage',
			'divs' : null,
			'params' : {
				'data' : data,
			},
			'preloader' : {
				'divs' : {
					0 : 'statistics_ajax_load_span',
				},
				'type' : 2,
				'style' : 3,
			}
		};

		lcpAjaxController(params, function(result){

			var res = JSON.parse(result);

			try {
				messages_datatable.api().ajax.reload();
			} catch(e){}

			alert(l('The reply has been succesfully sent!'))

		});



	});

	/*$(document.body).on('change', "#avatar_sp", function(){

		$("#avatar_preview_sp").html('<img border="0" src="'+lcp_path+'views/img/avatars/'+$(this).val()+'" width="40" height="40">');

	});*/



	$(document.body).on('change', 'input[id^="departments_sp"]', function(){

		var text = '';
		$('input[id^="departments_sp"]').each(function(){ 

			/*console.log( $(this).val() );*/
			if ( $(this).prop('checked') == true ) 
			{
				text += $(this).val()+',';
			}

		});

		$("#departments_ids_sp").val( text.substr(0, text.length - 1) );
		
	});



	$(document.body).on('change', "#themes", function(){


		var data = { 	
				'id_theme' : $('#themes').val(),
		};

		/*fac request ajax sa iau setarile*/
		var params = {

			'load' : 'getTheme',
			'divs' : null,
			'params' : {
				'data' : data,
			},
			'preloader' : {
				'divs' : {
					0 : 'themes_ajax_load_span',
				},
				'type' : 2,
				'style' : 3,
			}
		};


		lcpAjaxController(params, function(result){

			/*console.log(result);*/
			var res = JSON.parse(result);
			/*console.log(res);*/
			$("#chat_width").val( res.width ).trigger('change');
			$("#chat_height").val( res.height ).trigger('change');
			$("#corners_radius").val( res.corners_radius ).trigger('change');
			$('input[type=radio][name=chat_box_border]').val([res.chat_box_border]).filter('[value='+res.chat_box_border+']').prop('checked', true).trigger('change');
			$("#chat_box_border_color").val( res.chat_box_border_color ).trigger('focus').trigger('blur').trigger('change');
			$("#chat_box_background").val( res.chat_box_background ).trigger('focus').trigger('blur').trigger('change');
			$("#chat_box_foreground").val( res.chat_box_foreground ).trigger('focus').trigger('blur').trigger('change');
			$("#header_offline_background").val( res.header_offline_background ).trigger('focus').trigger('blur').trigger('change');
			$("#header_online_background").val( res.header_online_background ).trigger('focus').trigger('blur').trigger('change');
			$("#header_offline_foreground").val( res.header_offline_foreground ).trigger('focus').trigger('blur').trigger('change');
			$("#header_online_foreground").val( res.header_online_foreground ).trigger('focus').trigger('change');
			$("#submit_button_background").val( res.submit_button_background ).trigger('focus').trigger('blur').trigger('change');
			$("#submit_button_foreground").val( res.submit_button_foreground ).trigger('focus').trigger('blur').trigger('change');
			
		});



	});




	$(document.body).on('change', "#iconsets", function(){


		var data = { 	
				'id_iconset' : $('#iconsets').val(),
		};

		/*fac request ajax sa iau setarile*/
		var params = {

			'load' : 'getIconset',
			'divs' : null,
			'params' : {
				'data' : data,
			},
			'preloader' : {
				'divs' : {
					0 : 'iconsets_ajax_load_span',
				},
				'type' : 2,
				'style' : 3,
			}
		};


		lcpAjaxController(params, function(result){

			var res = JSON.parse(result);
			//console.log(res);
			/*$("#online_img").attr('src', lcp_path + 'views/img/iconsets/'+res.online_img );
			$("#offline_img").attr('src', lcp_path + 'views/img/iconsets/'+res.offline_img );*/

			for (var k in res.online_img)
			    $("#online_img_"+k).attr('src', lcp_path + 'views/img/iconsets/'+res.online_img[k] );
			
			for (var k in res.offline_img)
				$("#offline_img_"+k).attr('src', lcp_path + 'views/img/iconsets/'+res.offline_img[k] );

			$('[id$="img_languages"]').each(function() {
				$(this).val($(this).find('option:first').val()).trigger('change');
			});

		});



	});





	$(document.body).on('change', "#settings", function(){

		var data = { 	
				'id_setting' : $('#settings').val(),
		};

		/*fac request ajax sa iau setarile*/
		var params = {

			'load' : 'getSetting',
			'divs' : null,
			'params' : {
				'data' : data,
			},
			'preloader' : {
				'divs' : {
					0 : 'settings_ajax_load_span',
				},
				'type' : 2,
				'style' : 3,
			}
		};


		lcpAjaxController(params, function(result){

			try {

				var res = JSON.parse(result);
				//console.log(res);
				$("#offline_messages_go_to").val(res.offline_messages_go_to);
				$("#new_chat_sound").val(res.new_chat_sound);
				$("#new_message_sound").val(res.new_message_sound);
				$('input[type=radio][name=name_field]').val([res.name_field]).filter('[value='+res.name_field+']').prop('checked', true).trigger('change');
				$('input[type=radio][name=email_field]').val([res.email_field]).filter('[value='+res.email_field+']').prop('checked', true).trigger('change');
				$('input[type=radio][name=phone_field]').val([res.phone_field]).filter('[value='+res.phone_field+']').prop('checked', true).trigger('change');
				$('input[type=radio][name=department_field]').val([res.department_field]).filter('[value='+res.department_field+']').prop('checked', true).trigger('change');
				$('input[type=radio][name=question_field]').val([res.question_field]).filter('[value='+res.question_field+']').prop('checked', true).trigger('change');
				$('input[type=radio][name=chat_type]').val([res.chat_type]).filter('[value='+res.chat_type+']').prop('checked', true).trigger('change');
				$('input[type=radio][name=hide_when_offline]').val([res.hide_when_offline]).filter('[value='+res.hide_when_offline+']').prop('checked', true).trigger('change');

				if ( res.chat_type == 'Slide' ) 
				{ 
					$("#orientation_slide_select").val( res.orientation );
				} 
				else 
				{  
					$("#iconsets").val( res.id_iconset ).trigger('change'); 

					var fixed_position = (res.position == 'Fixed') ? 'Y' : 'N';
					$('input[type=radio][name=fixed_position]').val([fixed_position]).filter('[value='+fixed_position+']').prop('checked', true).trigger('change');

					if ( res.position != 'Fixed' ) 
						$('input[type=radio][name=position_options]').val([res.position_options]).filter('[value='+res.position_options+']').prop('checked', true).trigger('change');

					$("#orientation_popup_select").val( res.orientation ); 
					$("#code").val( res.code );
					$("#hooks").val( res.hook );
				}
		
				$('input[type=radio][name=show_names]').val([res.show_names]).filter('[value='+res.show_names+']').prop('checked', true).trigger('change');
				$('input[type=radio][name=staff_qualification]').val([res.staff_qualification]).filter('[value='+res.staff_qualification+']').prop('checked', true).trigger('change');
				$('input[type=radio][name=start_minimized]').val([res.start_minimized]).filter('[value='+res.start_minimized+']').prop('checked', true).trigger('change');
				$('input[type=radio][name=fields_are_not_mandatory]').val([res.fields_are_not_mandatory]).filter('[value='+res.fields_are_not_mandatory+']').prop('checked', true).trigger('change');

				$("#offset").val( res.offset );
				$("#themes").val( res.id_theme ).trigger("change");
				
				for (var k in res.offline_header_message)
				    $("#offline_header_"+k).val(res.offline_header_message[k]).trigger('change');
				
				for (var k in res.online_header_message)
					$("#online_header_"+k).val(res.online_header_message[k]).trigger('change');

				for (var k in res.offline_welcome_message)
					$("#offline_welcome_message_"+k).val(res.offline_welcome_message[k]).trigger('change');

				for (var k in res.online_welcome_message)
					$("#online_welcome_message_"+k).val(res.online_welcome_message[k]).trigger('change');

				$('[id$="_languages"]').each(function() {
					$(this).val($(this).find('option:first').val()).trigger('change');
				});

			} catch(e) {}

		});

	

	});





$('#chat_width').on('keyup change', function(){

	$("#preview_offline_chat_table").css('width', $(this).val()+'px' );
	$("#preview_online_chat_table").css('width', $(this).val()+'px' );

	$("#popup_preview_offline_chat_table").css('width', $(this).val()+'px' );
	$("#popup_preview_online_chat_table").css('width', $(this).val()+'px' );

});

$('#chat_height').on('keyup change', function(){

	//$("#preview_offline_chat_table").css('height', $(this).val()+'px' );
	//$("#preview_online_chat_table").css('height', $(this).val()+'px' );

	$("#popup_preview_offline_chat_table").css('height', $(this).val()+'px' );
	$("#popup_preview_online_chat_table").css('height', $(this).val()+'px' );


});

$('#corners_radius').on('keyup change', function(){

	$("#preview_offline_chat_table").css('-webkit-border-top-left-radius', $(this).val()+'px' );
	$("#preview_offline_chat_table").css('-moz-border-top-left-radius', $(this).val()+'px' );
	$("#preview_offline_chat_table").css('border-top-left-radius', $(this).val()+'px' );
	$("#preview_offline_chat_table").css('-webkit-border-top-right-radius', $(this).val()+'px' );
	$("#preview_offline_chat_table").css('-moz-border-top-right-radius', $(this).val()+'px' );
	$("#preview_offline_chat_table").css('border-top-right-radius', $(this).val()+'px' );
	$("#preview_offline_chat_table").find("th").css('-webkit-border-top-left-radius', $(this).val()+'px' );
	$("#preview_offline_chat_table").find("th").css('-moz-border-top-left-radius', $(this).val()+'px' );
	$("#preview_offline_chat_table").find("th").css('border-top-left-radius', $(this).val()+'px' );
	$("#preview_offline_chat_table").find("th").css('-webkit-border-top-right-radius', $(this).val()+'px' );
	$("#preview_offline_chat_table").find("th").css('-moz-border-top-right-radius', $(this).val()+'px' );
	$("#preview_offline_chat_table").find("th").css('border-top-right-radius', $(this).val()+'px' );

	$("#preview_online_chat_table").css('-webkit-border-top-left-radius', $(this).val()+'px' );
	$("#preview_online_chat_table").css('-moz-border-top-left-radius', $(this).val()+'px' );
	$("#preview_online_chat_table").css('border-top-left-radius', $(this).val()+'px' );
	$("#preview_online_chat_table").css('-webkit-border-top-right-radius', $(this).val()+'px' );
	$("#preview_online_chat_table").css('-moz-border-top-right-radius', $(this).val()+'px' );
	$("#preview_online_chat_table").css('border-top-right-radius', $(this).val()+'px' );
	$("#preview_online_chat_table").find("th").css('-webkit-border-top-left-radius', $(this).val()+'px' );
	$("#preview_online_chat_table").find("th").css('-moz-border-top-left-radius', $(this).val()+'px' );
	$("#preview_online_chat_table").find("th").css('border-top-left-radius', $(this).val()+'px' );
	$("#preview_online_chat_table").find("th").css('-webkit-border-top-right-radius', $(this).val()+'px' );
	$("#preview_online_chat_table").find("th").css('-moz-border-top-right-radius', $(this).val()+'px' );
	$("#preview_online_chat_table").find("th").css('border-top-right-radius', $(this).val()+'px' );	

});


$('input[type=radio][name=chat_box_border]').on('change', function(){

	if ( $(this).val() == 'Y' )
	{
		$("#preview_offline_chat_inner_table").css('border', '1px solid #' + $('#chat_box_border_color').val() );
		$("#preview_online_chat_inner_table").css('border', '1px solid #' + $('#chat_box_border_color').val() );	
	}
	else
	{
		$("#preview_offline_chat_inner_table").css('border', '0px' );
		$("#preview_online_chat_inner_table").css('border', '0px' );	
	}
});


$('#chat_box_border_color').on('keyup change', function(){

	$("#preview_offline_chat_inner_table").css('border-color', '#' + $(this).val() );
	$("#preview_online_chat_inner_table").css('border-color', '#' + $(this).val() );

});


$('#chat_box_background').on('keyup change', function(){

	$("#preview_offline_chat_table").css('background-color', '#' + $(this).val(), 'important' );
	$("#preview_online_chat_table").css('background-color', '#' + $(this).val(), 'important' );

	$("#popup_preview_offline_chat_table").css('background-color', '#' + $(this).val(), 'important' );
	$("#popup_preview_online_chat_table").css('background-color', '#' + $(this).val(), 'important' );

});

$('#chat_box_foreground').on('keyup change', function(){

	$("#preview_offline_chat_table").find("td").css('color', '#' + $(this).val(), 'important' );
	$("#preview_online_chat_table").find("td").css('color', '#' + $(this).val(), 'important' );

	$("#popup_preview_offline_chat_table").find("td").css('color', '#' + $(this).val(), 'important' );
	$("#popup_preview_online_chat_table").find("td").css('color', '#' + $(this).val(), 'important' );
});

$('#header_offline_background').on('keyup change', function(){

	$("#preview_offline_chat_table th").css('background-color', '#' + $(this).val(), 'important' );

	$("#popup_preview_offline_chat_table th").css('background-color', '#' + $(this).val(), 'important' );
});

$('#header_online_background').on('keyup change', function(){

	$("#preview_online_chat_table th").css('background-color', '#' + $(this).val(), 'important' );

	$("#popup_preview_online_chat_table th").css('background-color', '#' + $(this).val(), 'important' );
});


$('#header_offline_foreground').on('keyup change', function(){

	$("#preview_offline_chat_table th").css('color', '#' + $(this).val(), 'important' );

	$("#popup_preview_offline_chat_table th").css('color', '#' + $(this).val(), 'important' );
});

$('#header_online_foreground').on('keyup change', function(){

	$("#preview_online_chat_table th").css('color', '#' + $(this).val(), 'important' );

	$("#popup_preview_online_chat_table th").css('color', '#' + $(this).val(), 'important' );
});


$('#submit_button_background').on('keyup change', function(){

	$("#preview_offline_chat_table").find("a.chat-button").css('background-color', '#' + $(this).val(), 'important' );
	$("#preview_online_chat_table").find("a.chat-button").css('background-color', '#' + $(this).val(), 'important' );

	$("#popup_preview_offline_chat_table").find("a.chat-button").css('background-color', '#' + $(this).val(), 'important' );
	$("#popup_preview_online_chat_table").find("a.chat-button").css('background-color', '#' + $(this).val(), 'important' );

});

$('#submit_button_foreground').on('keyup change', function(){

	$("#preview_offline_chat_table").find("a.chat-button").css('color', '#' + $(this).val(), 'important' );
	$("#preview_online_chat_table").find("a.chat-button").css('color', '#' + $(this).val(), 'important' );

	$("#popup_preview_offline_chat_table").find("a.chat-button").css('color', '#' + $(this).val(), 'important' );
	$("#popup_preview_online_chat_table").find("a.chat-button").css('color', '#' + $(this).val(), 'important' );

});


$('input[id^="offline_header"]').on('keyup change', function(){

	$("#preview_offline_header_message").html( $(this).val() );

	$("#popup_preview_offline_header_message").html( $(this).val() );
});


$('input[id^="online_header"]').on('keyup change', function(){

	$("#preview_online_header_message").html( $(this).val() );

	$("#popup_preview_online_header_message").html( $(this).val() );
});


$('textarea[id^="offline_welcome_message"]').on('keyup change', function(){

	$("#preview_offline_welcome_message").html( $(this).val() );

	$("#popup_preview_offline_welcome_message").html( $(this).val() );
});


$('textarea[id^="online_welcome_message"]').on('keyup change', function(){

	$("#preview_online_welcome_message").html( $(this).val() );

	$("#popup_preview_online_welcome_message").html( $(this).val() );
});



$('input[type=radio][name=name_field]').on('change', function(){
	//console.log($(this).val());
	if ( $(this).val() == 'Y' ) 
	{
		$("#preview_offline_name_field").show();
		$("#preview_online_name_field").show();

		$("#popup_preview_offline_name_field").show();
		$("#popup_preview_online_name_field").show();
	}
	else
	{
		$("#preview_offline_name_field").hide();
		$("#preview_online_name_field").hide();

		$("#popup_preview_offline_name_field").hide();
		$("#popup_preview_online_name_field").hide();
	}

});


$('input[type=radio][name=email_field]').on('change', function(){

	if ( $(this).val() == 'Y' ) 
	{
		$("#preview_offline_email_field").show();
		$("#preview_online_email_field").show();

		$("#popup_preview_offline_email_field").show();
		$("#popup_preview_online_email_field").show();
	}
	else
	{
		$("#preview_offline_email_field").hide();
		$("#preview_online_email_field").hide();

		$("#popup_preview_offline_email_field").hide();
		$("#popup_preview_online_email_field").hide();
	}

});


$('input[type=radio][name=phone_field]').on('change', function(){

	if ( $(this).val() == 'Y' ) 
	{
		$("#preview_offline_phone_field").show();
		$("#preview_online_phone_field").show();

		$("#popup_preview_offline_phone_field").show();
		$("#popup_preview_online_phone_field").show();
	}
	else
	{
		$("#preview_offline_phone_field").hide();
		$("#preview_online_phone_field").hide();

		$("#popup_preview_offline_phone_field").hide();
		$("#popup_preview_online_phone_field").hide();
	}

});


$('input[type=radio][name=department_field]').on('change', function(){

	if ( $(this).val() == 'Y' ) 
	{
		$("#preview_offline_department_field").show();
		$("#preview_online_department_field").show();

		$("#popup_preview_offline_department_field").show();
		$("#popup_preview_online_department_field").show();
	}
	else
	{
		$("#preview_offline_department_field").hide();
		$("#preview_online_department_field").hide();

		$("#popup_preview_offline_department_field").hide();
		$("#popup_preview_online_department_field").hide();
	}

});

$('input[type=radio][name=question_field]').on('change', function(){

	if ( $(this).val() == 'Y' ) 
	{
		$("#preview_offline_question_field").show();
		$("#preview_online_question_field").show();

		$("#popup_preview_offline_question_field").show();
		$("#popup_preview_online_question_field").show();
	}
	else
	{
		$("#preview_offline_question_field").hide();
		$("#preview_online_question_field").hide();

		$("#popup_preview_offline_question_field").hide();
		$("#popup_preview_online_question_field").hide();
	}

});


$('input[type=radio][name=chat_type]').on('change', function(){

	if ( $(this).val() == 'Slide' ) 
	{
		/*previewul din dreapta*/
		$("#preview_slide").show();
		$("#preview_popup").hide();

		$("#orientation_slide_select").show();
		$("#orientation_popup_select").hide();
		//$("#hide_chat_window_tr").show();
		$("#icons_tbody").hide();
		$("#position_tr").hide();
		$("#position_options_tr").hide();
		$("#code_tr").hide();
		//$("#hook_tr").hide();
		$("#corners_radius_tr").show();
		$("#chat_box_border_tr").show();
		$("#chat_box_border_color_tr").show();
		$("#header_tbody").show();
		$("#orientation_tr").show();
		$("#offset_tr").show();
		
		/*$("#icons option[value='no']").remove(); 
		$("#icons").append(new Option('-select-', 'no'));
		$("#icons").val('no'); $("#icons").prop('disabled', true);

		$("#preview_slide").show();
		$("#preview_popup").hide();*/
	}
	else
	{
		//$('input[type=radio][name=position_options]').trigger("change");

		$('#code').val( getChatCode() );

		/*previewul din dreapta*/
		$("#preview_slide").hide();
		$("#preview_popup").show();

		$("#orientation_slide_select").hide();
		$("#orientation_popup_select").show();
		//$("#hide_chat_window_tr").hide();
		$("#icons_tbody").show();
		$("#position_tr").show();
				
		if ( $('input[type=radio][name=fixed_position]:checked').val() != 'Y' ) 
		{ 
			$("#orientation_tr").hide();
			$("#offset_tr").hide();
			$("#position_options_tr").show();
			$("#position_options_tr").show();

			if ( $('input[type=radio][name=position_options]:checked').val() == 'Code' )
			//if ( $('#position_options_copy_code_mannually').prop('checked') == true ) 
			{ 
				$("#code_tr").show(); 
				//$("#hook_tr").hide(); 
			} 
			else 
			{ 
				$("#code_tr").hide(); 
				//$("#hook_tr").show();  
			}
		}
		else
		{
			$("#orientation_tr").show();
			$("#offset_tr").show();
			$("#position_options_tr").hide();
			$("#code_tr").hide();
			$("#hook_tr").hide();
		}

		$("#corners_radius_tr").hide();
		$("#chat_box_border_tr").hide();
		$("#chat_box_border_color_tr").hide();
		$("#header_tbody").hide();
		
		/*$("#iconsets").trigger("change");
		$("#icons option[value='no']").remove(); $("#icons").prop('disabled', false);
		$("#preview_slide").hide();
		$("#preview_popup").show();*/
	}
});




$('input[type=radio][name=position_options]').on('change', function(){

	if ( $(this).val() == 'Code' ) 
	{
		$("#code_tr").show();
		$("#hook_tr").hide();
		$('#code').val( getChatCode() );
	}
	else
	{
		$("#code_tr").hide();
		$("#hook_tr").show();

	}

});



$('input[type=radio][name=fixed_position]').on('change', function(){

	if ( $(this).val() == 'N'  )
	{
		$("#orientation_tr").hide();
		$("#offset_tr").hide();
		$("#position_options_tr").show();
		$("#code_tr").show();
		/*$("#hook_tr").show();*/
		$('#code').val( getChatCode() );
	}
	else
	{
		$("#orientation_tr").show();
		$("#offset_tr").show();		
		$("#position_options_tr").hide();
		$("#code_tr").hide();
		$("#hook_tr").hide();
	}

});




/*$("#menu-visitors-copyreferrer").on('click', function(){
	//alert('aa');
	var id_visitor = $("#menu-visitors-id").val();

    // Apply clipboard click event
    $(this).clipboard({
        path: lcp_path+'views/js/jquery.clipboard.swf',

        // copy: function() {
        //     var this_sel = $(this);

        //     // Hide "Copy" and show "Copied, copy again?" message in link
        //     //this_sel.find('.code-copy-first').hide();
        //     //this_sel.find('.code-copy-done').show();

        //     // Return text in closest element (useful when you have multiple boxes that can be copied)
        //     return this_sel.closest('.code-block').text();
        // }
    });

});*/



$("#menu-visitors-mousetracking").on('click', function(){

	/*alert('aa');*/

	var id_visitor = $("#menu-visitors-id").val();


	var data = { 	
			'id_visitor' : id_visitor,
	};


	var params = {

		'load' : 'showMouseTracking',
		'divs' : {
			0 : 'ajax_chats_div',
		},
		'params' : {
			'data' : data,
		},
		'preloader' : {
			'divs' : {
				0 : 'statistics_ajax_load_span',
			},
			'type' : 2,
			'style' : 3,
		}
	};


	lcpAjaxController(params, function(result){

		$('#tabs-chat > ul > li > a.'+id_visitor).trigger('click');
		
		var key = $('#tabs-chat > ul > li > a.'+id_visitor).attr('href').split('-')[2];
		
		$('#mousetracking_span_'+key).trigger('click');
		/*$("#history_span").trigger('click');*/


	}, true);

});



	/*$(document.body).on('click', 'td[id^="online_external_users_td"]', function(){

		var type = $(this).attr('id').split('_')[1];
		var type_nr = $(this).attr('id').split('_')[4];
		var id_visitor = $("#id_"+type+"_visitor_"+type_nr).val();
		//var id_user = $("#id_"+type+"_user_"+type_nr).val();

		showVisitorDetails(id_visitor);
	})*/;


	$(document.body).on('click', 'td[id^="online_internal_users_td"]', function(){

		var type = $(this).attr('id').split('_')[1];
		var type_nr = $(this).attr('id').split('_')[4];
		var id_staffprofile = $("#id_"+type+"_staffprofile_"+type_nr).val();
		//var id_user = $("#id_"+type+"_user_"+type_nr).val();

		if (id_staffprofile == $('#id_staffprofile').val())
			return;

		var data =  { 
				'id_visitor' : 'i'+id_staffprofile,
				'id_staffprofile' : $('#id_staffprofile').val(),
				//'internal' : $('#internal').val(),
			};

		var params = {

			'load' : 'chatRequestFromStaffToStaff',
			'divs' : null,
			'params' : {
				'data' : data,
			},
			'preloader' : {
				'divs' : {
					0 : 'users_ajax_load_span',
				},
				'type' : 2,
				'style' : 3,
			}
		};

		lcpAjaxController(params, function(result){		
			syncChatDialog('users_ajax_load_span');
		}, true);

	});


	$(document.body).on('click', '#predefined_messages', function(){

		//var key = $(this).attr('id').split('_')[2];

		$( "#dialog-predefined-messages" ).dialog( "open" );

	});

	$(document.body).on('click', '#transfer_visitor', function(){

		//var key = $(this).attr('id').split('_')[2];
		var key = $("#tabs-chat").tabs('option', 'active');

		var id_visitor = $('#id_visitor_'+key).val();

		//console.log(id_visitor);

		if (!$.isNumeric(id_visitor))
			return alert(l('You cannot transfer a staff member!'));

		$( "#dialog-online-internal-users" ).dialog( "open" );

		var data = { 	
				'id_visitor' : id_visitor,
		};

		var params = {

			'load' : 'showOnlineInternalUsers',
			'divs' : {
				0 : 'ajax_online_internal_users_div',
			},
			'params' : {
				'data' : data,
			},
			'preloader' : {
				'divs' : {
					0 : 'ajax_online_internal_users_div',
				},
				'type' : 1,
				'style' : 3,
			}
		};


		lcpAjaxController(params, function(result){
			
		});

	});



	$(document.body).on('click', 'span[id^="userchat_span"], span[id^="details_span"], span[id^="visitedpageshistory_span"], span[id^="geotracking_span"], span[id^="archive_span"], span[id^="messages_span"], span[id^="ratings_span"], span[id^="logs_span"], span[id^="mousetracking_span"]', function(){

		//console.log( $(this).attr('id') );
		var tab_active = $(this).attr('id').split('_')[0];
		var key = $(this).attr('id').split('_')[2];
		var id_visitor = $('#id_visitor_'+key).val();

		// stergem clasa tab-selected de la toate butoanele
		$('#userchat_span_'+key).removeClass('tab-selected'); 
		$('#details_span_'+key).removeClass('tab-selected'); 
		$('#visitedpageshistory_span_'+key).removeClass('tab-selected'); 
		$('#geotracking_span_'+key).removeClass('tab-selected'); 
		$('#archive_span_'+key).removeClass('tab-selected'); 
		$('#messages_span_'+key).removeClass('tab-selected'); 
		$('#ratings_span_'+key).removeClass('tab-selected'); 
		$('#logs_span_'+key).removeClass('tab-selected'); 
		$('#mousetracking_span_'+key).removeClass('tab-selected'); 

		// ascundem toate tab-urile butoanelor
		$('#tabs-visitor-userchat-'+key).hide();
		$('#tabs-visitor-details').hide();
		$('#tabs-visitor-visitedpageshistory').hide();
		$('#tabs-visitor-geotracking').hide();
		$('#tabs-visitor-archive').hide();
		$('#tabs-visitor-messages').hide();
		$('#tabs-visitor-ratings').hide();
		$('#tabs-visitor-logs').hide();
		$('#ajax_chats_textarea_div').hide();

		// facem activ tab-ul selectat
		$(this).addClass('lcp tab-selected'); 

		// pun valoarea in campul hidden "clicked_chat_subtab"
		$("#active_chat_subtab").val( $(this).attr('id') );

		// scoatem border full si bagam border without bottom
		//$('#ajax_chats_table').removeClass('border-without-bottom'); $('#ajax_chats_table').addClass('border-full');
		$('#ajax_chats_table').removeClass('border-full'); $('#ajax_chats_table').addClass('border-without-bottom');
		$('#ajax_chats_table').removeClass('radius5'); $('#ajax_chats_table').addClass('radius5-top'); 

		/*if ( !$.localStorage.isEmpty('visitor_details') && $.localStorage.get('visitor_details') == id_visitor) console.log('is set visitor details');
		else $.localStorage.set( 'visitor_details', id_visitor);*/

		//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		if (tab_active == 'userchat')
		{
			$("#tabs-visitor-"+tab_active+"-"+key).show();

			if ( $("#in_chat_"+key).val() == 'Y' )
				$('#ajax_chats_textarea_div').show();
			else
			{
				$('#ajax_chats_table').removeClass('border-without-bottom'); $('#ajax_chats_table').addClass('border-full');
				$('#ajax_chats_table').removeClass('radius5-top'); $('#ajax_chats_table').addClass('radius5'); 
			}
		}
		/*else if (tab_active == 'visitedpageshistory' || tab_active == 'details')
		{
			//$("#tabs-chat-a-"+key).trigger('click');
			$("#tabs-visitor-"+tab_active).show();
		}*/
		else
			$("#tabs-visitor-"+tab_active).show();
			
		/*if (tab_active == 'mousetracking')
			$('#open_mouse_tracking_a').trigger('click');
		*/
		
	});


$('#open_mouse_tracking_a').on('click', function(){

	$( "#dialog-mousetracking" ).dialog({
		autoOpen: false,
		width: parseInt($(window).width()) - 20,
        height: parseInt($(window).height()) - 50,
        position: ['top', 40],
		modal: true,
		close: function() {
			/* allFields.val( "" ).removeClass( "ui-state-error" ); */
		}
	});


	if ( $('#dialog-mousetracking').is(":visible")  )
	{
		$( "#dialog-mousetracking" ).dialog( "close" );	
	}
	else 
	{
		$( "#dialog-mousetracking" ).dialog( "open" );

		var id_visitor = 44;


		var data = { 	
				'id_visitor' : id_visitor,
		};


		var params = {

			'load' : 'showMouseTracking',
			'divs' : {
				0 : 'dialog-mousetracking',
			},
			'params' : {
				'data' : data,
			},
			'preloader' : {
				'divs' : {
					0 : 'dialog-mousetracking',
				},
				'type' : 1,
				'style' : 3,
			}
		};


		lcpAjaxController(params, function(result){

		});
	}

});






/*$("#status").on('change', function(){*/
$(document.body).on('change', '#status_select', function(){

	/*console.log($(this).val());*/
	$.localStorage.set( 'status_select', $(this).val() );

	var data = { 	
			'id_staffprofile' : $('#id_staffprofile').val(),
			'status' : $(this).val(),
	};

	var params = {

		'load' : 'changeStaffStatus',
		'divs' : {
			0 : 'ajax_onlineusers_div',
		},
		'params' : {
			'data' : data,
		},
		'preloader' : {
			'divs' : {
				0 : 'status_ajax_load_span',
			},
			'type' : 2,
			'style' : 3,
		}
	};

		var status = $(this).val();

		lcpAjaxController(params, function(result){

			var res = JSON.parse(result);

			if (res.success == true)
			{
				$("#status_ajax_load_span").html('<img id="status_img" border="0" src="'+lcp_path+'views/img/' + $('#status_select').val().toLowerCase() +'-ico.png" width="20" height="20">');
				/*$("#status_img").attr('src', lcp_path + 'views/img/' + $('#status').val().toLowerCase() +'-ico.png' );*/
				if (status == 'Offline')
				{
					if(lcp_ps_version == '1.4')	$('#dialog_chat_a').css('color', '#000000');
					else if(lcp_ps_version == '1.5') $('#dialog_chat_a').css('color', '#ffffff');
					else $('#dialog_chat_a').css('color', '#b3b3b3');
				}
				else
					$('#dialog_chat_a').css('color', '#7ab726');
			}
			else
				alert( res.response );

		}, true);		


});




var emoticons = $.ajax({

	  url: lcp_path+"emoticons.json",

	  async: false,

	  dataType: 'json',

	  success: function (json) {
	    
	  	/*console.log(json);*/

	  }
});

var emoticons_obj = emoticons.responseJSON || JSON.parse(emoticons.responseText);

$('#emoticons_obj').data('emoticons_obj',emoticons_obj);


}); /*end document ready*/




