/**
* ProQuality (c) All rights reserved.
*
* DISCLAIMER
*
* Do not edit, modify or copy this file.
* If you wish to customize it, contact us at addons4prestashop@gmail.com.
*
* @author    Andrei Cimpean (ProQuality) <addons4prestashop@gmail.com>
* @copyright 2015-2016 ProQuality
* @license   Do not edit, modify or copy this file
*/

var lcp_request, lcp_requests = []; 
/*new ajax controller function, better than the old one; v2.2*/
function lcpAjaxController(params, callback, abort_active_requests) {

/*
params.load*           = type: string (required)
                       = desc: php switch to load

params.divs*           = type: object (required)
                       = desc: object of divs to be populated

params.params*         = type: object (required)
                       = desc: object of vars to be sent to the php switch

params.preloader       = type: object (optional)
                       = desc: object of preloader proprietes
(
	params.preloader.divs  = type: object (required if preloader active)
	                       = desc: object of divs to populate the preloader

	params.preloader.type  = type: string (optional: 1 ; 2)
	                       = desc: type of preloader (when preloader is in the same div as the response ; when preloader is in the other div as the response)

	params.preloader.style = type: string (optional: 1 ; 2)
	                       = desc: style of preloader (style of animated image)
)

params.append          = type: boolean (true|false) (optional)
                       = desc: if is set to true it will append instead of replace content of divs

params.complete          = type: string (optional)
                       = desc: if is set to "loop" then it loops trough this function again (used to comet push)

callback               = type: callback function (optional)
					   = desc: function to put the ajax result

abort_active_requests  = type: boolean (true|false) (optional)
					   = desc: if is set to true it will abort all current ajax requests runned trough this function
*/	

	/*verifying null args*/
	params.divs = typeof(params.divs) != 'undefined' ? params.divs : null;
	params.preloader = typeof(params.preloader) != 'undefined' ? params.preloader : null;
	callback = typeof(callback) != 'undefined' ? callback : null;
	abort_active_requests = typeof(abort_active_requests) != 'undefined' ? abort_active_requests : null;
	//json = typeof(json) != 'undefined' ? json : null;

	var timestamp = Math.round(new Date().getTime() / 1000);

	/*controller and params*/
	var load_url  = lcp_url+'ajax.php?time='+ timestamp;

	/*extending the params*/
	params.params = $.extend({'type': params.load, 'token': lcp_token, 'id_employee': lcp_id_employee}, params.params);

 	/*preloader start*/
  	if (params.preloader && params.preloader.divs != null) { preload(params.preloader.divs, 'on', params.preloader.style); }

  	/*delete active requests*/
  	if (abort_active_requests != null) abortActiveRequests();

	lcp_request = $.ajax({

				url: load_url, 

				type: 'POST',

				data: params.params,

				//dataType: function() { return (json != null) ? 'json' : 'html'; },

				success:function(result) {

					if (params.divs != null)  
					{
						if (isJson(result))
						{
							var res = JSON.parse(result);
						
							if (typeof(res.response) != 'undefined')
							{
								if (res.success === true)
								{
								    $.each(params.divs, function(k,v) {
								    	if (params.append == true) $('#'+v).append(res.response);
								    	else $('#'+v).html(res.response);
									});
								}
							}
							else
							{
							    $.each(params.divs, function(k,v) {
							    	if (params.append == true) $('#'+v).append(result);
							    	else $('#'+v).html(result);
								});
							}
						}
						else
						{
						    $.each(params.divs, function(k,v) {
						    	if (params.append == true) $('#'+v).append(result);
						    	else $('#'+v).html(result);
							});
			        	}
					}
		          	
		          	/*preloader end*/
			        if (params.preloader && params.preloader.type == 2) { preload(params.preloader.divs, 'off', params.preloader.style); }  

		            /*callback*/
		            if(typeof(callback) === "function") callback(result);

		            if (params.complete == 'loop') 
		            { 
		            	/*console.log('am ajuns in (if loop) : '+params.params.timestamp);*/
		            	if (result)
		            	{
		            		try {
							    var res = JSON.parse(result); 
							    params.params.timestamp = res.timestamp;
							    /*params.params.action = res.action;
							    console.log('am ajuns in (if result) : '+params.params.timestamp);*/
							} catch(e) {
							    /*JSON parse error, this is not json (or JSON isn't in your browser)*/
							}
		            	}
		            	else
		            	{
		            		/*console.log('am ajuns in (if NOT result) : '+params.params.timestamp);*/
		            		params.params.data = '';
		            		/*params.params.timestamp = 0;*/
		            	}
			    	}
		            return true;
			  	},

		        complete: function() {

		          	if (params.complete == 'loop') 
		          	{
		          	 	lcpAjaxController(params, callback); 
		          	 	/*params.complete = '';*/
		          	}

		          	return true;

		        },

			  	error:function() {

			  		if (params.complete == 'loop') 
			  		{
			  			/*if(typeof(callback) === "function") callback(result);
		          	 	lcpAjaxController(params, callback);*/
		          	}
			  		return false;
			  	},
		  });

	lcp_requests.push( lcp_request );

}






function preload(divs, action, style) {

  if (style == 1) { var html = '<div style="height: 100%; width: 100%;" align="center"><img border="0" src="'+lcp_path+'views/img/ajax-loader.gif"></div>'; }
  else if (style == 2) { var html = '<table cellpadding="0" cellspacing="0"><tr><td>Loading...&nbsp;&nbsp;</td><td><img border="0" src="'+lcp_path+'views/img/ajax-loader.gif"></td></tr></table>'; }
  else if (style == 3) { var html = '<img border="0" src="'+lcp_path+'views/img/ajax-loader.gif">'; }

      if (action == 'on') {

		    $.each(divs, function(k,v){

		    	$('#'+v).html(html);
		    });

      } else {

		    $.each(divs, function(k,v){

		    	$('#'+v).html('');
		    });

      }

}


function abortActiveRequests()
{
	//req = typeof(req) != 'undefined' ? req : null;
	for (i=0; i < lcp_requests.length; i++)
	{
		lcp_requests[i].abort();
	}
	lcp_requests = [];
}



function getRatingStars() {

	var full_stars = $( "#rating_table").find("img[src*='star-full']").length;
	var half_stars = $( "#rating_table").find("img[src*='star-half']").length;
	var empty_stars = $( "#rating_table").find("img[src*='star-empty']").length;

	return full_stars + (half_stars / 2);
	/*console.log(full_stars + (half_stars / 2));*/

}





function replaceURLWithHTMLLinks(text) {

    var re = /(\(.*?)?\b((?:https?|ftp|file):\/\/[-a-z0-9+&@#\/%?=~_()|!:,.;]*[-a-z0-9+&@#\/%=~_()|])/ig;
    return text.replace(re, function(match, lParens, url) {
        var rParens = '';
        lParens = lParens || '';

        // Try to strip the same number of right parens from url
        // as there are left parens.  Here, lParenCounter must be
        // a RegExp object.  You cannot use a literal
        //     while (/\(/g.exec(lParens)) { ... }
        // because an object is needed to store the lastIndex state.
        var lParenCounter = /\(/g;
        while (lParenCounter.exec(lParens)) {
            var m;
            // We want m[1] to be greedy, unless a period precedes the
            // right parenthesis.  These tests cannot be simplified as
            //     /(.*)(\.?\).*)/.exec(url)
            // because if (.*) is greedy then \.? never gets a chance.
            if (m = /(.*)(\.\).*)/.exec(url) ||
                    /(.*)(\).*)/.exec(url)) {
                url = m[1];
                rParens = m[2] + rParens;
            }
        }
        return lParens + "<a href='" + url + "' target='_blank'>" + url + "</a>" + rParens;
    });
}

function escapeHtml(text) {
  var map = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#039;'
  };

  return text.replace(/[&<>"']/g, function(m) { return map[m]; });
}

function parseChatText(string)
{
	string = escapeHtml(string);
	string = replaceURLWithHTMLLinks(string);
	string = parseEmoticons(string);
	return string;
}


function parseEmoticons(string) {

	var emoticons_obj = $('#emoticons_obj').data('emoticons_obj');
	/*var string = [];*/
	string = typeof(string) != 'undefined' ? string : null;

	for( i = 0; i < emoticons_obj.length; i++ )
	{
		/*console.log(emoticons_obj[i]);*/

		if (string.toLowerCase().indexOf(emoticons_obj[i].code) != '-1')
		{
			var string_code = string.substr( string.toLowerCase().indexOf(emoticons_obj[i].code),  emoticons_obj[i].code.length );

			string = string.replace(string_code, '<img border="0" src="'+lcp_path+'views/img/emoticons/'+emoticons_obj[i].filename+'">');
			/*console.log(string);*/
		}
	}
	return string;
}





function isJson(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}




function updateTips( t ) {
	var tips = $( ".validateTips" );
	tips.text( t ).addClass( "ui-state-highlight" );

	setTimeout(function() {
		tips.removeClass( "ui-state-highlight", 1500 );
	}, 500 );
}

function checkLength( o, n, min, max ) {
	if ( o.val().length > max || o.val().length < min ) {
		o.addClass( "ui-state-error" );
		updateTips( l("Length of ") + n + l(" must be between ") +
		min + l(" and ") + max + "." );
		return false;
	} else {
		return true;
	}
}

function checkRegexp( o, regexp, n ) {
	if ( !( regexp.test( o.val() ) ) ) {
		o.addClass( "ui-state-error" );
		updateTips( n );
		return false;
	} else {
		return true;
	}
}



function getTrackingData() {

	var data = { 	
			'id_visitor' : 44, 
	};

	/*ajax aici:*/
		var params = {

			'load' : 'getMouseTracking',
			'divs' : null,
			'params' : {
				'data' : data,
			}
		};

	try {
	lcpAjaxController(params, function(result){
		
		/*var res = JSON.parse(result);*/
		var res = $.parseJSON(result);
		var tracking_data = $.parseJSON(res.tracking_data);

		$("#url_a").attr('href', res.current_page);	
		$("#url_a").html(res.current_page);	
		/*$("#url_iframe").attr('src', res.current_page);*/	

		var time = 0;
		var xp = 0, yp = 0;

		$.each(tracking_data, function(i, val) {

			var that = $(this);

		    setTimeout(function(){
			  
			    setInterval(function(){
			    	xp += Math.round((val.posX - xp) / 10);
    				yp += Math.round((val.posY - yp) / 10);

			    	$("#client_coursor_img").css({ left:xp, top:yp });
					console.log(xp+' '+yp);
				}, 50);

			}, time);

		time += 1000;
		});


	});
	} catch(e) {}



}



function getUrlParameter(sParam)
{
    var sPageURL = window.location.search.substring(1);
    var sURLVariables = sPageURL.split('&');
    for (var i = 0; i < sURLVariables.length; i++) 
    {
        var sParameterName = sURLVariables[i].split('=');
        if (sParameterName[0] == sParam) 
        {
            return sParameterName[1];
        }
    }
}  




function syncChatDialog(preloader)
{
	preloader = typeof(preloader) != 'undefined' ? preloader : null;
	/*var typing_msg_admin = getTypingMsgAdmin();
	console.log(typing_msg_admin);*/
	/*if ( $('#dialog_chat').is(":visible")  )
	{*/
		var data = { 	
				'action' : 'syncChatDialog',
				'id_employee' : $('#id_employee').val(),
				/*'clicked_chat_tab' : $('#clicked_chat_tab').val(),
				'clicked_chat_subtab' : $('#clicked_chat_subtab').val(),*/
		};

		if (preloader != null)
		{
			var params = {
				'load' : 'syncChatDialog',
				'divs' : null,
				'params' : {
					'data' : data,
				},
				'preloader' : {
					'divs' : {
						0 : preloader,
					},
					'type' : 2,
					'style' : 3,
				}
			};
		}
		else
		{
			var params = {
				'load' : 'syncChatDialog',
				'divs' : null,
				'params' : {
					'data' : data,
				},
			};
		}

		lcpAjaxController(params, function(result){

			var res = JSON.parse(result);
			//console.log(result);
			$("#ajax_chats_div").html(res.response['ajax.chats.tpl']);
			setTimeout(function() { $("#ajax_onlineusers_div").html(res.response['ajax.onlineusers.tpl']); }, 750 );
			$("#awaiting_response_chat_dialogs").html(res.response['ajax.header_chats_counter.tpl']);
			/*if (res.visitor_typing == 'Y')
				$('#admin_typing_span').html(l('Visitor is typing...'));*/

		});	
	/*}*/


}


function syncOnlineUsers()
{
		/*var typing_msg_admin = getTypingMsgAdmin();
		console.log(typing_msg_admin);*/

		var data = { 	
				'action' : 'syncOnlineUsers',
				'id_employee' : $('#id_employee').val(),
				/*'clicked_chat_tab' : $('#clicked_chat_tab').val(),
				'clicked_chat_subtab' : $('#clicked_chat_subtab').val(),*/
		};

		var params = {

			'load' : 'syncOnlineUsers',
			'divs' : {
				0 : 'ajax_onlineusers_div',
			},
			'params' : {
				'data' : data,
			},
			/*'preloader' : {
				'divs' : {
					0 : 'dialog_chat_window_span',
				},
				'type' : 1,
				'style' : 3,
			}*/
		};

		try {
			//request.abort();
			//$.when( request ).done(function(r) {
			lcpAjaxController(params, function(result){

				/*$('#tabs-visitors-a').trigger('click');
				console.log('aaa');*/

			});	
			//});	
		} catch(e) {}
}




var loop = false;
function syncOnlineVisitors()
{
	var data = { 	
			'id_visitor' : $('#id_visitor').val(),
	};
	//console.log($('#id_visitor').val());
	var params = {

		'load' : 'syncOnlineVisitors',
		'divs' : null,
		'params' : {
			'data' : data,
		},
		/*'preloader' : {
			'divs' : {
				0 : 'dialog_chat_window_span',
			},
			'type' : 1,
			'style' : 3,
		}*/
	};

	try {

		lcpAjaxController(params, function(result){

			var res = JSON.parse(result);

				if ($("#chat_status_data").data('status') != res.response.status)
					$("#chat_div").html(res.response['ajax.chat.tpl']);


				if (res.response['is_chat_invitation'] == true && $('#dialog_chat_invitation').is(":hidden"))
				{
					//console.log('Invitation to chat!');

					$( "#dialog_chat_invitation" ).dialog({
						autoOpen: false,
						closeOnEscape: false,
    					dialogClass: "noclose",
						width: 300,
				        /*height: 200,*/
				        position: ['top', 320],
						modal: true,
						buttons: [
					        { text: l("Accept"), click: function () { 

										if ($('#chat_container').is(":hidden"))
											$("#minimize_chat").trigger('click');

										$("#error_tr").hide();

										/*all_fields.val( "" ).removeClass( "ui-state-error" );	*/
										$("#before_chat_div").hide();
										$("#start_chat_div").show();
										$("#chat_msg_textarea_div").show();
										$("#be_patient").show();
										/*$("#start_chat_time").html(getDateTime(false, false, false));*/
										//var chat_height = parseInt($('#content')[0].style.height) - parseInt($('#chat_msg_textarea_div')[0].style.height);
										//$('#content').css('height',  chat_height+'px' );

										var data2 = { 	
												'id_visitor' : $('#id_visitor').val(),
										};

										var params2 = {

											'load' : 'chatAcceptedFromClient',
											'divs' : null,
											'params' : {
												'data' : data2,
											},
											/*'preloader' : {
												'divs' : {
													0 : 'dialog_chat_window_span',
												},
												'type' : 1,
												'style' : 3,
											}*/
										};

										lcpAjaxController(params2, function(result){


										});

					        			$( this ).dialog( "close" );
									}, 
						        class:"", 
						        style:"color: black" 
						    },
						    { text: l("Deny"), click: function () { 

										var data2 = { 	
												'id_visitor' : $('#id_visitor').val(),
										};

										var params2 = {

											'load' : 'chatDeniedFromClient',
											'divs' : null,
											'params' : {
												'data' : data2,
											},
											/*'preloader' : {
												'divs' : {
													0 : 'dialog_chat_window_span',
												},
												'type' : 1,
												'style' : 3,
											}*/
										};

										lcpAjaxController(params2, function(result){

										});

										$( this ).dialog( "close" );
									}, 
						        class:"", 
						        style:"color: red" 
						    },

					        //{ text: l("Cancel"), click: function () { $( this ).dialog( "close" ); }, class:"", style:"color: black" }
						],
						/*close: function() {

						}*/
					});

					$( "#dialog_chat_invitation" ).dialog( "open" );
				}

		});

	} catch(e) {}	
}




function syncFrontChatDialog()
{
	if ( $('#start_chat_div').is(":visible")  )
	{
		var data = { 	
			'action' : 'syncFrontChatDialog',
			'id_visitor' : $('#id_visitor').val(),
		};

		var params = {

			'load' : 'syncFrontChatDialog',
			'divs' : null,
			'params' : {
				'data' : data,
			},
			/*'preloader' : {
				'divs' : {
					0 : 'dialog_chat_window_span',
				},
				'type' : 1,
				'style' : 3,
			}*/
		};

		lcpAjaxController(params, function(result){

			var res = JSON.parse(result);

			//$("#chat_div").html(res.response['chat_window.tpl']);
			$("#start_chat_div").html(res.response['ajax.start_chat.tpl']);

			//populez div-ul cu typing
			if (res.staff_typing == 'Y')
				$('#front_typing_span').html(l('Staff is typing...'));

		});	
	}
}


	function initSwapTextBoxes() {

		var swap_text_boxes = [];

		  /*Store the default value for each box*/
		  $('input[type=text][value].swaptextbox, textarea.swaptextbox').each(function() {
		    swap_text_boxes[$(this).attr('id')] = $(this).val();
		  });

		  /*Add focus and blur events to set or clear the value*/
		  $('input[type=text][value].swaptextbox, textarea.swaptextbox').bind('focus', function() {
		    if($(this).val() == swap_text_boxes[$(this).attr('id')]) {
		      $(this).val('');
		    }
		  });
		  $('input[type=text][value].swaptextbox, textarea.swaptextbox').bind('blur', function() {
		    if($(this).val() == '') {
		      $(this).val(swap_text_boxes[$(this).attr('id')]);
		    }
		  });
	 }



function getChatCode() {

	var position = ( $('input[type=radio][name=fixed_position]:checked').val() == 'Y'  ) ? 'position: fixed;' : '';
	//var orientation = ( $('#chat_type_slide').prop('checked') == true ) ? $('#orientation_slide_select').val() : $('#orientation_popup_select').val();
	var orientation = ( $('input[type=radio][name=chat_type]:checked').val() == 'Slide' ) ? $('#orientation_slide_select').val() : $('#orientation_popup_select').val();
	
		 if (orientation == 'left-top') { var offset = 'top: '+$('#offset').val()+'px; left: 0px;'; }
	else if (orientation == 'left-bottom') { var offset = 'bottom: 0px; left: '+$('#offset').val()+'px;'; }
	else if (orientation == 'right-top') { var offset = 'top: '+$('#offset').val()+'px; right: 0px;'; }
	else if (orientation == 'right-bottom') { var offset = 'bottom: 0px; right: '+$('#offset').val()+'px;'; }
	else if (orientation == 'bottom-left') { var offset = 'left: '+$('#offset').val()+'px; bottom: 0px;'; }
	else if (orientation == 'bottom-right') { var offset = 'right: '+$('#offset').val()+'px; bottom: 0px;'; }

	var width = $('#chat_width').val();
	var height = $('#chat_height').val();	
	/*var img = '5426c51189d98.png';*/

	var code = 
	'<div style="cursor: hand; cursor: pointer; z-index: 9999; '+position+' '+offset+'">'+
	      '<a onclick=\'popupWindow("'+lcp_path+'ajax.php?type=popupChat", "Chat", "'+width+'", "'+height+'");\' href="javascript:{}">'+
	      '<img id="lcp_popup_img" border="0">'+
	    '</a>'+
	    '</div>';

	return code;
}



function popupWindow(url, title, w, h) {
  var left = (screen.width/2)-(w/2);
  var top = (screen.height/2)-(h/2);
  return window.open(url, title, 'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width='+w+', height='+h+', top='+top+', left='+left);
} 



function lcpAddToolbarBtn(type)
{
	if (type == 'video')
		$('div.btn-toolbar > ul').prepend('<li><a id="desc-module-video" class="lcp toolbar_btn" title="Module Video Tutorial" href="'+lcp_video_link+'" target="_blank"><i style="margin-top: 2px !important;" class="fa fa-youtube fa-2x"></i><div style="margin-top: 4px !important;">Module Video</div></a></li>');

	if (type == 'documentation')
		$('div.btn-toolbar > ul').prepend('<li><a id="desc-module-documentation" class="lcp toolbar_btn" title="Module Documentation" href="'+lcp_doc_link+'" target="_blank"><i style="margin-top: 2px !important;" class="fa fa-life-ring fa-2x"></i><div style="margin-top: 4px !important;">Documentation</div></a></li>');

	if (type == 'contact')
		$('div.btn-toolbar > ul').prepend('<li><a id="desc-module-contact" class="lcp toolbar_btn" title="Contact Developer" href="'+lcp_support_link+'" target="_blank"><i style="margin-top: 2px !important;" class="fa fa-code fa-2x"></i><div style="margin-top: 4px !important;">Contact Dev.</div></a></li>');

	if (type == 'modules')
		$('div.btn-toolbar > ul').prepend('<li><a id="desc-module-modules" class="lcp toolbar_btn" title="Modules by this developer" href="'+lcp_dev_modules_link+'" target="_blank"><i style="margin-top: 2px !important;" class="fa fa-puzzle-piece fa-2x"></i><div style="margin-top: 4px !important;">Dev. Modules</div></a></li>');

	if (type == 'separator')
		$('div.btn-toolbar > ul').prepend('<li style="line-height: 40px; vertical-align: middle; color: #222222 !important; opacity: 0.3; filter: alpha(opacity=30);">|</li>');

}




function showVisitorDetails(id_visitor, dialog)
{
	dialog = typeof(dialog) != 'undefined' ? dialog : null;
	is_dialog = (dialog != null) ? 'y' : 'n';

	var data = { 	
			'id_visitor' : id_visitor,
			'key' : is_dialog + $("#active_chat_tab").val(),
		};

	var params = {

		'load' : 'showVisitorDetails',
		'divs' : null/*{
			0 : 'tabs-visitor-details',
		}*/,
		'params' : {
			'data' : data,
		},
		'preloader' : {
			'divs' : {
				0 : 'statistics_ajax_load_span',
			},
			'type' : 2,
			'style' : 3,
		}
	};

	lcpAjaxController(params, function(result){
		
		var res = JSON.parse(result);
		//console.log('showed');
		if (dialog != null)
		{
			$("#tabs-visitordetails-details").html(res.response['ajax.visitor_details.tpl']);
			$("#tabs-visitordetails-visitedpageshistory").html(res.response['ajax.visitor_visited_pages_history.tpl']);
			$("#tabs-visitordetails-geotracking").html(res.response['ajax.visitor_geotracking.tpl']);
			//$('#visitor_details_showed').val('false');
		}
		else
		{
			$("#tabs-visitor-details").html(res.response['ajax.visitor_details.tpl']);
			$("#tabs-visitor-visitedpageshistory").html(res.response['ajax.visitor_visited_pages_history.tpl']);
			$("#tabs-visitor-geotracking").html(res.response['ajax.visitor_geotracking.tpl']);
			$('#visitor_details_showed').val(id_visitor);
			//console.log('visitor_details_showed: SET');
		}

		//init_map(id_visitor);
		//console.log(id_visitor);
	});
}



function showVisitorArchive(id_visitor)
{
			//console.log($.fn.DataTable.isDataTable( '#visitor_archive_grid' ));
			if ( ! $.fn.DataTable.isDataTable( '#visitor_archive_grid' ) )
			{
				var archive_table = lcp_db_prefix+lcp_module_name+'_archive';
				var departments_table = lcp_db_prefix+lcp_module_name+'_departments';

			    var visitor_archive_editor = new $.fn.dataTable.Editor( {
			        ajax: lcp_grid_path+'visitorarchive',
			        table: "#visitor_archive_grid",
			        fields: [ 
				        { label: l("Name:"), name: archive_table+".name", }, 
			        ]
			    } );


			    var visitor_archive_editor_view_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('View details'),
			                    action: function ( e, dt, node, config ) {
			                        if ( visitor_archive_datatable.api().row('.selected').length !== 0 ) {
			                            
			                        	var id_archive = visitor_archive_datatable.api().row('.selected').data()[archive_table].id_archive;

										var data = { 	
												'id_archive' : id_archive,
												'id_visitor': id_visitor,
										};

										var params = {

											'load' : 'getArchive',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};


										lcpAjaxController(params, function(result){

											var res = JSON.parse(result);
											/*console.log(res); return;*/
											$("#archive_message").html(res.messages);

											$( "#dialog-form-archive" ).dialog( "open" );

										});

			                        }
			                    }
			                };

			    var visitor_archive_editor_remove_button = { extend: "remove", editor: visitor_archive_editor };

			    var visitor_archive_editor_buttons = [];

			    if (lcp_employee_is_superadmin == 'Y') 
			    {
			    	visitor_archive_editor_buttons.push(visitor_archive_editor_view_button);
					visitor_archive_editor_buttons.push(visitor_archive_editor_remove_button);
			    }
			    else
			    {
			    	visitor_archive_editor_buttons.push(visitor_archive_editor_view_button);
			    }


				var visitor_archive_datatable = $('#visitor_archive_grid').dataTable( {

			        dom: "Bfrtip",
			        //"processing": true,
			        //"serverSide": true,
			        //"scrollX": true,
			        "pageLength": 5,
			        "autoWidth": false,
			        ajax: {
			            url: lcp_grid_path+'visitorarchive',
			            type: 'POST',
			            "data": {
        					"id_visitor": id_visitor
    					}
			        },

			        columns: [
			            { data: archive_table+".date_add", className: "dt-body-center" },
			            { data: archive_table+".id_chat", className: "dt-body-center" },
			            { data: archive_table+".name", className: "dt-body-center" },
			            { data: archive_table+".internal", className: "dt-body-center" },
			            { data: departments_table+".name", className: "dt-body-center" },
			            { data: archive_table+".email", className: "dt-body-center" },
			            { data: archive_table+".company", className: "dt-body-center" },
			            { data: archive_table+".language", className: "dt-body-center" },
			            { data: archive_table+".country", className: "dt-body-center" },
			            { data: archive_table+".ip", className: "dt-body-center" },
			            { data: archive_table+".host", className: "dt-body-center" },
			            { data: archive_table+".duration", className: "dt-body-center" },
			            { data: archive_table+".log_entries", className: "dt-body-center" },
			        ],

			        select: true,

       				buttons : visitor_archive_editor_buttons,

			    });

			}
			else
			{
				try {
					//visitor_archive_datatable.api().ajax.reload();
				} catch(e){}
			}
}





function showVisitorMessages(id_visitor)
{
	if ( ! $.fn.DataTable.isDataTable( '#visitor_messages_grid' ) )
			{
				var messages_table = lcp_db_prefix+lcp_module_name+'_messages';

				var visitor_messages_editor = new $.fn.dataTable.Editor( {
			        ajax: lcp_grid_path+'visitormessages',
			        table: "#visitor_messages_grid",
			        fields: [ 
				        { label: l("Name:"), name: messages_table+".name", }, 
			        ]
			    } );


			    var visitor_messages_editor_remove_button = { extend: "remove", editor: visitor_messages_editor };

				var visitor_messages_editor_reply_button = {
							                    extend: 'selectedSingle',
							                    //sButtonClass: 'marginLeft',
							                    text: l('Reply'),
							                    action: function ( e, dt, node, config ) {
							                        if ( visitor_messages_datatable.api().row('.selected').length !== 0 ) {
							                        	
							                        	var id_message = visitor_messages_datatable.api().row('.selected').data()[messages_table].id_message;

														var data = { 	
																'id_message' : id_message,
																'id_visitor': id_visitor,
														};

														var params = {

															'load' : 'replyToMessage',
															'divs' : null,
															'params' : {
																'data' : data,
															},
															'preloader' : {
																'divs' : {
																	0 : 'statistics_ajax_load_span',
																},
																'type' : 2,
																'style' : 3,
															}
														};

														lcpAjaxController(params, function(result){

															var res = JSON.parse(result);

															$("#messages_id").val(res.id_message);
															$("#messages_date").html(res.date_add);
															$("#messages_department").html(res.department_name);
															$("#messages_sender_name").html(res.name);
															$("#messages_sender_email").html(res.email);
															$("#messages_sender_phone").html(res.phone);
															$("#messages_sender_company").html(res.company);
															$("#messages_message").html(res.question);
															$("#messages_reply_tr").show();
															$( "#dialog-form-messages" ).dialog( "open" );

														});
														
							                        }
							                    }
							                };


			    var visitor_messages_editor_view_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('View details'),
			                    action: function ( e, dt, node, config ) {
			                        if ( visitor_messages_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_message = visitor_messages_datatable.api().row('.selected').data()[messages_table].id_message;

										var data = { 	
												'id_message' : id_message,
												'id_visitor': id_visitor,
										};

										var params = {

											'load' : 'getMessage',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){

											var res = JSON.parse(result);
											/*console.log(res); return;*/

											$("#messages_id").val(res.id_message);
											$("#messages_date").html(res.date_add);
											$("#messages_department").html(res.department_name);
											$("#messages_sender_name").html(res.name);
											$("#messages_sender_email").html(res.email);
											$("#messages_sender_phone").html(res.phone);
											$("#messages_sender_company").html(res.company);
											$("#messages_message").html(res.question);

											$( "#dialog-form-messages" ).dialog( "open" );

										});
			                        }
			                    }
			                };

			    var visitor_messages_editor_mark_as_read_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('Mark as read'),
			                    action: function ( e, dt, node, config ) {
			                        if ( visitor_messages_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_message = visitor_messages_datatable.api().row('.selected').data()[messages_table].id_message;
			                        	//console.log(messages_datatable.api().row('.selected').data()); 
										var data = { 	
												'id_message' : id_message,
												'status' : 'Read',
												'id_visitor': id_visitor,
										};

										var params = {

											'load' : 'updateMessage',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){
											visitor_messages_datatable.api().ajax.reload();
										});
			                        }
			                    }
			                };

			        var visitor_messages_editor_mark_as_unread_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('Mark as unread'),
			                    action: function ( e, dt, node, config ) {
			                        if ( visitor_messages_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_message = visitor_messages_datatable.api().row('.selected').data()[messages_table].id_message;

										var data = { 	
												'id_message' : id_message,
												'status' : 'Unread',
												'id_visitor': id_visitor,
										};

										var params = {

											'load' : 'updateMessage',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){
											visitor_messages_datatable.api().ajax.reload();
										});
			                        }
			                    }
			                };

			    var visitor_messages_editor_buttons = [];

			    if (lcp_employee_is_superadmin == 'Y') 
			    {
			    	visitor_messages_editor_buttons.push(visitor_messages_editor_remove_button);
					visitor_messages_editor_buttons.push(visitor_messages_editor_view_button);
					//visitor_messages_editor_buttons.push(visitor_messages_editor_reply_button);
					visitor_messages_editor_buttons.push(visitor_messages_editor_mark_as_read_button);
					visitor_messages_editor_buttons.push(visitor_messages_editor_mark_as_unread_button);
			    }
			    else
			    {
			    	visitor_messages_editor_buttons.push(visitor_messages_editor_view_button);
			    	//visitor_messages_editor_buttons.push(visitor_messages_editor_reply_button);
					visitor_messages_editor_buttons.push(visitor_messages_editor_mark_as_read_button);
					visitor_messages_editor_buttons.push(visitor_messages_editor_mark_as_unread_button);
			    }


				var visitor_messages_datatable = $('#visitor_messages_grid').dataTable( {

			        dom: "Bfrtip",
			        //"processing": true,
			        //"serverSide": true,
			        //"scrollX": true,
			        "pageLength": 5,
			        "autoWidth": false,
			        ajax: {
			            url: lcp_grid_path+'visitormessages',
			            type: 'POST',
			            "data": {
        					"id_visitor": id_visitor
    					}
			        },

			        columns: [
			            { data: messages_table+".date_add", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".name", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".email", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".phone", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".department", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".question", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data.substring(0,20)+' [...]</span>'; else return data.substring(0,20)+' [...]'; } },
			            { data: messages_table+".ip", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: messages_table+".status", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[messages_table].status == 'Unread') return '<span style="font-weight: bold;">'+l(data)+'</span>'; else return l(data); } },
			        ],

			        select: true,

       				buttons : visitor_messages_editor_buttons,

			    });

			}
			else
			{
				try{
					//visitor_messages_datatable.api().ajax.reload();
				} catch(e){}
			}

}



function showVisitorRatings(id_visitor)
{
		if ( ! $.fn.DataTable.isDataTable( '#visitor_ratings_grid' ) )
			{
				var ratings_table = lcp_db_prefix+lcp_module_name+'_ratings';

				var visitor_ratings_editor = new $.fn.dataTable.Editor( {
			        ajax: lcp_grid_path+'visitorratings',
			        table: "#visitor_ratings_grid",
			        fields: [ 
				        { label: l("Name:"), name: ratings_table+".name", }, 
			        ]
			    } );


				var visitor_ratings_editor_remove_button = { extend: "remove", editor: visitor_ratings_editor };

			    var visitor_ratings_editor_view_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('View details'),
			                    action: function ( e, dt, node, config ) {
			                        if ( visitor_ratings_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_rating = visitor_ratings_datatable.api().row('.selected').data()[ratings_table].id_rating;

										var data = { 	
												'id_rating' : id_rating,
												'id_visitor': id_visitor,
										};

										var params = {

											'load' : 'getRating',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){

											var res = JSON.parse(result);
											/*console.log(res); return;*/

											$("#ratings_politness").html( generateRatingStars( res.politness ) );
											$("#ratings_qualification").html( generateRatingStars( res.qualification ) );
											$("#ratings_date").html(res.date_add);
											$("#ratings_internal").html(res.internal);
											$("#ratings_sender_name").html(res.name);
											$("#ratings_sender_email").html(res.email);
											$("#ratings_sender_phone").html(res.phone);
											$("#ratings_sender_company").html(res.company);
											$("#ratings_comment").html(res.comment);

											$( "#dialog-form-ratings" ).dialog( "open" );

										});
			                        }
			                    }
			                };

			    var visitor_ratings_editor_mark_as_read_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('Mark as read'),
			                    action: function ( e, dt, node, config ) {
			                        if ( visitor_ratings_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_rating = visitor_ratings_datatable.api().row('.selected').data()[ratings_table].id_rating;

										var data = { 	
												'id_rating' : id_rating,
												'status' : 'Read',
												'id_visitor': id_visitor,
										};

										var params = {

											'load' : 'updateRating',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){
											visitor_ratings_datatable.api().ajax.reload();
										});
			                        }
			                    }
			                };

			    var visitor_ratings_editor_mark_as_unread_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('Mark as unread'),
			                    action: function ( e, dt, node, config ) {
			                        if ( visitor_ratings_datatable.api().row('.selected').length !== 0 ) {

										var id_rating = visitor_ratings_datatable.api().row('.selected').data()[ratings_table].id_rating;

										var data = { 	
												'id_rating' : id_rating,
												'status' : 'Unread',
												'id_visitor': id_visitor,
										};

										var params = {

											'load' : 'updateRating',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){
											visitor_ratings_datatable.api().ajax.reload();
										});
			                        }
			                    }
			                };
			    
			    var visitor_ratings_editor_view_matching_chat_button = {
			                    extend: 'selectedSingle',
			                    //sButtonClass: 'marginLeft',
			                    text: l('View matching chat'),
			                    action: function ( e, dt, node, config ) {
			                        if ( visitor_ratings_datatable.api().row('.selected').length !== 0 ) {

			                        	var id_rating = visitor_ratings_datatable.api().row('.selected').data()[ratings_table].id_rating;

										var data = { 	
												'id_rating' : id_rating,
												'id_visitor': id_visitor,
										};

										var params = {

											'load' : 'getRating',
											'divs' : null,
											'params' : {
												'data' : data,
											},
											'preloader' : {
												'divs' : {
													0 : 'statistics_ajax_load_span',
												},
												'type' : 2,
												'style' : 3,
											}
										};

										lcpAjaxController(params, function(result){

											var res = JSON.parse(result);

											var id_archive = res.id_archive;

											var data2 = { 	
													'id_archive' : id_archive,
											};


											var params2 = {

												'load' : 'getArchive',
												'divs' : null,
												'params' : {
													'data' : data2,
												},
												'preloader' : {
													'divs' : {
														0 : 'statistics_ajax_load_span',
													},
													'type' : 2,
													'style' : 3,
												}
											};

											lcpAjaxController(params2, function(result2){

												var res2 = JSON.parse(result2);

												$("#archive_message").html(res2.messages);

												$( "#dialog-form-archive" ).dialog( "open" );

											});

										});

			                        }
			                    }
			                };

			    var visitor_ratings_editor_buttons = [];

			    if (lcp_employee_is_superadmin == 'Y') 
			    {
			    	visitor_ratings_editor_buttons.push(visitor_ratings_editor_remove_button);
					visitor_ratings_editor_buttons.push(visitor_ratings_editor_view_button);
					visitor_ratings_editor_buttons.push(visitor_ratings_editor_mark_as_read_button);
					visitor_ratings_editor_buttons.push(visitor_ratings_editor_mark_as_unread_button);
					visitor_ratings_editor_buttons.push(visitor_ratings_editor_view_matching_chat_button);
			    }
			    else
			    {
			    	visitor_ratings_editor_buttons.push(visitor_ratings_editor_view_button);
					visitor_ratings_editor_buttons.push(visitor_ratings_editor_mark_as_read_button);
					visitor_ratings_editor_buttons.push(visitor_ratings_editor_mark_as_unread_button);
					visitor_ratings_editor_buttons.push(visitor_ratings_editor_view_matching_chat_button);
			    }


				var visitor_ratings_datatable = $('#visitor_ratings_grid').dataTable( {

			        dom: "Bfrtip",
			        //"processing": true,
			        //"serverSide": true,
			        //"scrollX": true,
			        "pageLength": 5,
			        "autoWidth": false,
			        ajax: {
			            url: lcp_grid_path+'visitorratings',
			            type: 'POST',
			            "data": {
        					"id_visitor": id_visitor
    					}
			        },

			        columns: [
			            { data: ratings_table+".politness", className: "dt-body-center", render: function ( data, type, row, meta ) { return generateRatingStars(data); } },
			            { data: ratings_table+".qualification", className: "dt-body-center", render: function ( data, type, row, meta ) { return generateRatingStars(data); } },
			            { data: ratings_table+".date_add", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: ratings_table+".internal", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: ratings_table+".name", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: ratings_table+".email", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: ratings_table+".company", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data+'</span>'; else return data; } },
			            { data: ratings_table+".comment", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+data.substring(0,20)+' [...]</span>'; else return data.substring(0,20)+' [...]'; } },
			            { data: ratings_table+".status", className: "dt-body-center", render: function ( data, type, row, meta ) { if (row[ratings_table].status == 'Unread') return '<span style="font-weight: bold;">'+l(data)+'</span>'; else return l(data); } },
			        ],

			        select: true,

       				buttons : visitor_ratings_editor_buttons,

			    });
	
			}
			else
			{
				try{
					//visitor_ratings_datatable.api().ajax.reload();
				} catch(e){}
			}
}

function checkLibraryConflict()
{
	if (getUrlParameter('configure') == 'pm_abfighting' || 
		getUrlParameter('configure') == 'pm_advancedbackgroundchanger' || 
		getUrlParameter('configure') == 'pm_advancedsearch4' || 
		getUrlParameter('configure') == 'pm_advancedtrackingwizard' || 
		getUrlParameter('configure') == 'pm_cachemanager' || 
		getUrlParameter('configure') == 'pm_seointernallinking' || 
		getUrlParameter('configure') == 'pm_termsoninvoice')
		return true;
	else
		return false;
}

function showVisitorLogs(id_visitor)
{
	if ( ! $.fn.DataTable.isDataTable( '#visitor_logs_grid' ) )
			{
				var logs_table = lcp_db_prefix+lcp_module_name+'_logs';

				var visitor_logs_editor = new $.fn.dataTable.Editor( {
			        ajax: lcp_grid_path+'visitorlogs',
			        table: "#visitor_logs_grid",
			        fields: [ 
				        { label: l("Name:"), name: logs_table+".name", }, 
			        ]
			    } );

			    var visitor_logs_editor_create_button = {};

			    var visitor_logs_editor_edit_button = {};

			    var visitor_logs_editor_remove_button = { extend: "remove", editor: visitor_logs_editor };

			    var visitor_logs_editor_buttons = [];

			    if (lcp_employee_is_superadmin == 'Y') 
			    {
			    	visitor_logs_editor_buttons.push(visitor_logs_editor_remove_button);
			    }
			    else
			    {
			    	visitor_logs_editor_buttons = [];
			    }

				var visitor_logs_datatable = $('#visitor_logs_grid').dataTable( {

			        dom: "Bfrtip",
			        //"processing": true,
			        //"serverSide": true,
			        //"scrollX": true,
			        "pageLength": 5,
			        "autoWidth": false,
			        ajax: {
			            url: lcp_grid_path+'visitorlogs',
			            type: 'POST',
			            "data": {
        					"id_visitor": id_visitor
    					}
			        },

			        columns: [
			            { data: logs_table+".date_add", className: "dt-body-center" },
			            { data: logs_table+".message" },
			        ],

			        select: true,

       				buttons : visitor_logs_editor_buttons,

			    });

			}
			else
			{
				try{
					//visitor_logs_datatable.api().ajax.reload();
				} catch(e){}
			}

}




function generateRatingStars( stars ) {

	var html = '';

	var full_stars = Math.floor( stars ); 

	/*full stars*/
	for ( i = 1; i <= full_stars; i++ )
	{
		html += '<img class="lcp star" border="0" src="'+lcp_path+'views/img/star-full.gif" style="float:left; cursor: hand; cursor: pointer;">';
	}


	/*half stars*/
	if ( stars % 1 != 0 )
	{
		var half_stars = 1;
		html += '<img class="lcp star" border="0" src="'+lcp_path+'views/img/star-half.gif" style="float:left; cursor: hand; cursor: pointer;">';
	}
	else
	{
		var half_stars = 0;
	}


	/*empty stars*/
	var empty_stars = 5 - Math.ceil( stars ); 

	for ( i = 1; i <= empty_stars; i++ )
	{
		html += '<img class="lcp star" border="0" src="'+lcp_path+'views/img/star-empty.gif" style="float:left; cursor: hand; cursor: pointer;">';
	}

	return html;

}

/*---------------------------------------------------------------------------------*/

function playSound(type, loop, mute)
{
	type = typeof(type) != 'undefined' ? type : 'newmessage';
	loop = typeof(loop) != 'undefined' ? loop : false;
	mute = typeof(mute) != "undefined" ? mute : false;

	if (mute == false)
	{
		if (type == 'newmessage') { var sound_src = lcp_path+'sounds/new-message-default.mp3'; }
		else { var sound_src = lcp_path+'sounds/new-chat-default.mp3'; }
		
		$("#"+type).get(0).loop = loop;

		if ( $("#"+type).attr('src') == '')
		{
			$("#"+type).attr('src', sound_src);
	    	//sound.setAttribute('autoplay', 'autoplay');
		} 

		$("#"+type).get(0).play();
		//But for Chrome you cant use .play() and .pause(). You must use .Play() and .Stop()	
	}
}

function stopSound(type)
{
	type = typeof(type) != 'undefined' ? type : 'newmessage';
	
	$("#"+type).get(0).pause();
}

/*---------------------------------------------------------------------------------*/



 function getDateTime(is_day, is_month, is_year, is_hour, is_minute, is_second) {

 	is_day = typeof(is_day) != 'undefined' ? is_day : true;
 	is_month = typeof(is_month) != 'undefined' ? is_month : true;
 	is_year = typeof(is_year) != 'undefined' ? is_year : true;
 	is_hour = typeof(is_hour) != 'undefined' ? is_hour : true;
 	is_minute = typeof(is_minute) != 'undefined' ? is_minute : true;
 	is_second = typeof(is_second) != 'undefined' ? is_second : true;

 	var now     = new Date(); 
    var year    = now.getFullYear();
    var month   = now.getMonth()+1; 
    var day     = now.getDate();
    var hour    = now.getHours();
    var minute  = now.getMinutes();
    var second  = now.getSeconds(); 

    if(month.toString().length == 1) {
        var month = '0'+month;
    }
    if(day.toString().length == 1) {
        var day = '0'+day;
    }   
    if(hour.toString().length == 1) {
        var hour = '0'+hour;
    }
    if(minute.toString().length == 1) {
        var minute = '0'+minute;
    }
    if(second.toString().length == 1) {
        var second = '0'+second;
    }   

    /*console.log(is_day+', '+is_month+', '+is_year+', '+is_hour+', '+is_minute+', '+is_second); */  

    var dateTime = '';

    if (is_day == true) dateTime += day;
    if (is_month == true) dateTime += '/'+month;
    if (is_year == true) dateTime += '/'+year;
    if (is_hour == true) dateTime += ' '+hour;
    if (is_minute == true) dateTime += ':'+minute;
    if (is_second == true) dateTime += ':'+second;

    /*var dateTime = day+'/'+month+'/'+year+' '+hour+':'+minute+':'+second;  */ 
    return dateTime;
}




function l(name) {
	if (LANG.translations.hasOwnProperty(name))
		return LANG.translations[name];
	else
	{
		console.warn('Js translation ' + name + ' do not exists.')
		return name;
	}
}


function validateInput(text){

    if( /[^a-zA-Z0-9]/.test( text ) ) {
       return false;
    }
    return true;     
 }


function ucfirst(string)
{
    return string.charAt(0).toUpperCase() + string.slice(1);
}



