<?php

class Paypalrec extends PaymentModule
{
	private	$_html = '';
	private $_postErrors = array();

	public function __construct()
	{
		$this->name = 'paypalrec';
		$this->tab = 'payments_gateways';
		$this->version = '1.4';
		
		$this->currencies = true;
		$this->currencies_mode = 'radio';

        parent::__construct();

		$this->page = basename(__FILE__, '.php');
                $this->displayName = $this->l('PayPal Recurring');
                $this->description = $this->l('Accepts recurring payments by PayPal');
                $this->confirmUninstall = $this->l('Are you sure you want to delete your details ?');
	}

	public function getPaypalUrl()
	{
			return Configuration::get('PAYPALREC_SANDBOX') ? 'https://www.sandbox.paypal.com/cgi-bin/webscr' : 'https://www.paypal.com/cgi-bin/webscr';
	}

	public function install()
	{
		if (!parent::install()
			OR !Configuration::updateValue('PAYPALREC_BUSINESS', 'paypal@prestashop.com')
			OR !Configuration::updateValue('PAYPALREC_SANDBOX', '0')
                        OR !Configuration::updateValue('PAYPALREC_TIMES', '3')
                        OR !Configuration::updateValue('PAYPALREC_TRIG', '0')
			OR !$this->registerHook('payment')
			OR !$this->registerHook('paymentReturn'))
			return false;

                        //Paiement 1 - commande validée - envoi de mail - facture
                        $qi_p1 = 'INSERT INTO '. _DB_PREFIX_ .'order_state (id_order_state, invoice, send_email, color, unremovable, logable, delivery) VALUES (NULL, "1", "1", "#DDEEFF", "1", "1", "0")';
                        Db::getInstance()->Execute($qi_p1);
                        $qs_p1 = 'SELECT MAX(id_order_state) as id_order_state FROM '. _DB_PREFIX_.'order_state';
                        $rpos = Db::getInstance()->ExecuteS($qs_p1);
                        $qi_p1 = 'INSERT INTO '. _DB_PREFIX_ .'order_state_lang (id_order_state, id_lang, name, template) VALUES ("'.$rpos[0]['id_order_state'].'", "2", "Paiements récurrents commencés", "payment")';
                        Db::getInstance()->Execute($qi_p1);
                        Configuration::updateValue('PAYPALREC_START', $rpos[0]['id_order_state']);
                        $qi_p1 = 'INSERT INTO '. _DB_PREFIX_ .'order_state_lang (id_order_state, id_lang, name, template) VALUES ("'.$rpos[0]['id_order_state'].'", "1", "Reccuring payments started", "payment")';
                        Db::getInstance()->Execute($qi_p1);


                        //Paiement récurents
                        $qi_p1 = 'INSERT INTO '. _DB_PREFIX_ .'order_state (id_order_state, invoice, send_email, color, unremovable, logable, delivery) VALUES (NULL, "0", "0", "#DDEEFF", "1", "1", "0")';
                        Db::getInstance()->Execute($qi_p1);
                        $qs_p1 = 'SELECT MAX(id_order_state) as id_order_state FROM '. _DB_PREFIX_.'order_state';
                        $rpos = Db::getInstance()->ExecuteS($qs_p1);
                        $qi_p1 = 'INSERT INTO '. _DB_PREFIX_ .'order_state_lang (id_order_state, id_lang, name, template) VALUES ("'.$rpos[0]['id_order_state'].'", "2", "Paiement récurrent effectué", "")';
                        Db::getInstance()->Execute($qi_p1);
                        Configuration::updateValue('PAYPALREC_DONE', $rpos[0]['id_order_state']);
                        $qi_p1 = 'INSERT INTO '. _DB_PREFIX_ .'order_state_lang (id_order_state, id_lang, name, template) VALUES ("'.$rpos[0]['id_order_state'].'", "1", "Reccuring payment done", "")';
                        Db::getInstance()->Execute($qi_p1);


                        //Dernier paiement
                        $qi_p1 = 'INSERT INTO '. _DB_PREFIX_ .'order_state (id_order_state, invoice, send_email, color, unremovable, logable, delivery) VALUES (NULL, "0", "0", "#DDEEFF", "1", "1", "0")';
                        Db::getInstance()->Execute($qi_p1);
                        $qs_p1 = 'SELECT MAX(id_order_state) as id_order_state FROM '. _DB_PREFIX_.'order_state';
                        $rpos = Db::getInstance()->ExecuteS($qs_p1);
                        $qi_p1 = 'INSERT INTO '. _DB_PREFIX_ .'order_state_lang (id_order_state, id_lang, name, template) VALUES ("'.$rpos[0]['id_order_state'].'", "2", "Paiements récurrents terminés", "")';
                        Db::getInstance()->Execute($qi_p1);
                        Configuration::updateValue('PAYPALREC_END', $rpos[0]['id_order_state']);
                        $qi_p1 = 'INSERT INTO '. _DB_PREFIX_ .'order_state_lang (id_order_state, id_lang, name, template) VALUES ("'.$rpos[0]['id_order_state'].'", "1", "Reccuring payments ended", "")';
                        Db::getInstance()->Execute($qi_p1);

		return true;
	}

	public function uninstall()
	{
		if (!Configuration::deleteByName('PAYPALREC_BUSINESS')
			OR !Configuration::deleteByName('PAYPALREC_SANDBOX')
                        OR !Configuration::deleteByName('PAYPALREC_TIMES')
                        OR !Configuration::deleteByName('PAYPALREC_TRIG')
                        OR !Configuration::deleteByName('PAYPALREC_START')
                        OR !Configuration::deleteByName('PAYPALREC_DONE')
                        OR !Configuration::deleteByName('PAYPALREC_END')
			OR !parent::uninstall())
			return false;
		return true;
	}

	public function getContent()
	{
		$this->_html = '';
		if (isset($_POST['submitPaypal']))
		{
			if (empty($_POST['business']))
				$this->_postErrors[] = $this->l('Paypal business e-mail address is required.');
			elseif (!Validate::isEmail($_POST['business']))
				$this->_postErrors[] = $this->l('Paypal business must be an e-mail address.');
			if (!isset($_POST['sandbox']))
				$_POST['sandbox'] = 1;
                        if($_POST['installements'] < 3)
                                $this->_postErrors[] = $this->l('3 is min recurring payments.');
                        if($_POST['installements'] > 52)
                                $this->_postErrors[] = $this->l('52 is max recurring payments.');
			if (!sizeof($this->_postErrors))
			{
				Configuration::updateValue('PAYPALREC_BUSINESS', strval($_POST['business']));
				Configuration::updateValue('PAYPALREC_SANDBOX', intval($_POST['sandbox']));
                                Configuration::updateValue('PAYPALREC_TIMES', intval($_POST['installements']));
				Configuration::updateValue('PAYPALREC_TRIG', strval($_POST['trigger']));
				$this->displayConf();
			}
			else
				$this->displayErrors();
		}

		$this->displayPayPal();
		$this->displayFormSettings();
		return $this->_html;
	}

	public function displayConf()
	{
		$this->_html .= '
		<div class="conf confirm">
			<img src="../img/admin/ok.gif" alt="'.$this->l('Confirmation').'" />
			'.$this->l('Settings updated').'
		</div>';
	}

	public function displayErrors()
	{
		$nbErrors = sizeof($this->_postErrors);
		$this->_html .= '
		<div class="alert error">
			<h3>'.($nbErrors > 1 ? $this->l('There are') : $this->l('There is')).' '.$nbErrors.' '.($nbErrors > 1 ? $this->l('errors') : $this->l('error')).'</h3>
			<ol>';
		foreach ($this->_postErrors AS $error)
			$this->_html .= '<li>'.$error.'</li>';
		$this->_html .= '
			</ol>
		</div>';
	}
	
	
	public function displayPayPal()
	{
		$this->_html .= '
		<img src="../modules/paypalrec/paypallogo.gif" style="float:left; margin-right:15px;" />
		<b>'.$this->l('This module allows you to accept recurring payments by PayPal.').'</b><br /><br />
		'.$this->l('If the client chooses this payment mode, your PayPal account will be automatically credited.').'<br />
		'.$this->l('You need to configure your PayPal account first before using this module.').'
		<div style="clear:both;">&nbsp;</div>';
	}

	public function displayFormSettings()
	{
		$conf = Configuration::getMultiple(array('PAYPALREC_BUSINESS', 'PAYPALREC_SANDBOX', 'PAYPALREC_HEADER', 'PAYPALREC_TIMES', 'PAYPALREC_TRIG'));
		$business = array_key_exists('business', $_POST) ? $_POST['business'] : (array_key_exists('PAYPALREC_BUSINESS', $conf) ? $conf['PAYPALREC_BUSINESS'] : '');
		$sandbox = array_key_exists('sandbox', $_POST) ? $_POST['sandbox'] : (array_key_exists('PAYPALREC_SANDBOX', $conf) ? $conf['PAYPALREC_SANDBOX'] : '');
                $installements = array_key_exists('installements', $_POST) ? $_POST['installements'] : (array_key_exists('PAYPALREC_TIMES', $conf) ? $conf['PAYPALREC_TIMES'] : '');
                $trigger = array_key_exists('trigger', $_POST) ? $_POST['trigger'] : (array_key_exists('PAYPALREC_TRIG', $conf) ? $conf['PAYPALREC_TRIG'] : '');

		$this->_html .= '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post" style="clear: both;">
		<fieldset>
		<legend><img src="../img/admin/contact.gif" />'.$this->l('Settings').'</legend>
		<label>'.$this->l('PayPal business e-mail').'</label>
			<div class="margin-form">
                                <input type="text" size="33" name="business" value="'.htmlentities($business, ENT_COMPAT, 'UTF-8').'" />
                        </div><br>
		<label>'.$this->l('Sandbox mode').'</label>
			<div class="margin-form">
				<input type="radio" name="sandbox" value="1" '.($sandbox ? 'checked="checked"' : '').' /> '.$this->l('Yes').'
				<input type="radio" name="sandbox" value="0" '.(!$sandbox ? 'checked="checked"' : '').' /> '.$this->l('No').'
                                <p class="hint clear" style="display: block; width: 501px;">'.$this->l('The sandbox mode help you to test paypal').'</p>
			</div><br /><br /><br />
                <label>'.$this->l('Installments').'</label>
			<div class="margin-form">
                                <input type="text" size="2" name="installements" value="'.$installements.'"/> x
                                <p class="hint clear" style="display: block; width: 501px;">'.$this->l('This is the number of recurring payments you want (between 3 and 52)').'</p>
                        </div><br /><br /><br />
               <label>'.$this->l('Trigger').'</label>
                        <div class="margin-form">
                                <input type="text" size="5" name="trigger" value="'.htmlentities($trigger, ENT_COMPAT, 'UTF-8').'" />&nbsp;
                                <p class="hint clear" style="display: block; width: 501px;">'.$this->l('This is the minimum order value to display this recurring payment (0 = always diplayed)').'</p>
                        </div><br /><br /><br />
                <center><input type="submit" name="submitPaypal" value="'.$this->l('Update settings').'" class="button" /></center>
		</form>
                </fieldset><br /><br />
		<div class="path_bar"><img src="../img/t/AdminModules.gif" />&nbsp;<a href="http://www.rioo.fr" target="_blank">Module développé par la société RIOO</a><br/>
                </div>';
	}

	public function hookPayment($params)
	{
		if (!$this->active)
			return ;

		global $smarty;

		$address = new Address(intval($params['cart']->id_address_invoice));
		$customer = new Customer(intval($params['cart']->id_customer));
		$business = Configuration::get('PAYPALREC_BUSINESS');
                $installements = Configuration::get('PAYPALREC_TIMES');
		$currency = $this->getCurrency();

                //$amount = number_format(Tools::convertPrice($params['cart']->getOrderTotal(true, 4), $currency), 2, '.', '');
                $amount = number_format(Tools::convertPrice($params['cart']->getOrderTotal(true, 3), $currency), 2, '.', '');

		if (!Validate::isEmail($business))
			return $this->l('Paypal error: (invalid or undefined business account email)');

		if (!Validate::isLoadedObject($address) OR !Validate::isLoadedObject($customer) OR !Validate::isLoadedObject($currency))
			return $this->l('Paypal error: (invalid address or customer)');
			
		$products = $params['cart']->getProducts();

		foreach ($products as $key => $product)
		{
			$products[$key]['name'] = str_replace('"', '\'', $product['name']);
			if (isset($product['attributes']))
				$products[$key]['attributes'] = str_replace('"', '\'', $product['attributes']);
			$products[$key]['name'] = htmlentities(utf8_decode($product['name']));
			$products[$key]['paypalAmount'] = number_format(Tools::convertPrice($product['price_wt'], $currency), 2, '.', '');
		}

                  if($installements > 1 ){
                    $sNbrEch = $installements;

                    for ($i=1; $i<=$installements;$i++) {
                        $sMontantEcheance[$i] =  number_format($amount / $installements, 2, '.', '');
                    }

                    //SI problème d'arrondi
                    if($amount != array_sum($sMontantEcheance)){

                      $diff = $amount - array_sum($sMontantEcheance);
                      $sMontantEcheance[$i-1] = number_format($sMontantEcheance[$i-1] + $diff, 2, '.', '');

                    }
                  }

		$smarty->assign(array(
			'address' => $address,
			'country' => new Country(intval($address->id_country)),
			'customer' => $customer,
			'business' => $business,
			'currency' => $currency,
			'paypalUrl' => $this->getPaypalUrl(),
                        'installements' => $installements-1,
                        'amountterm1' => $sMontantEcheance[$i-1],
                        'amountterm' => $sMontantEcheance[1],
			// products + discounts - shipping cost
			'amount' => $amount,
			// shipping cost + wrapping
			'shipping' =>  number_format(Tools::convertPrice(($params['cart']->getOrderShippingCost() + $params['cart']->getOrderTotal(true, 6)), $currency), 2, '.', ''),
			'discounts' => $params['cart']->getDiscounts(),
			'products' => $products,
			// products + discounts + shipping cost
			'total' => number_format(Tools::convertPrice($params['cart']->getOrderTotal(true, 3), $currency), 2, '.', ''),
                        'trigger' => Configuration::get('PAYPALREC_TRIG'),
			'id_cart' => intval($params['cart']->id),
                        'goBackUrl' => 'http://'.htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'paypalrec-confirmation.php',
			'notify' => 'http://'.htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'modules/paypalrec/validation.php',
			'this_path' => $this->_path
		));

		return $this->display(__FILE__, 'paypalrec.tpl');
	}

	public function hookPaymentReturn($params)
	{

                if (!$this->active)
			return ;

                if($params['ok'] == 1){
                   return $this->display(__FILE__, 'confirmation.tpl');
                }
                else{
                   return $this->display(__FILE__, 'annulation.tpl');
                }
	}

	public function getL($key)
	{
		$translations = array(
			'mc_gross' => $this->l('Paypal key \'mc_gross\' not specified, can\'t control amount paid.'),
			'payment_status' => $this->l('Paypal key \'payment_status\' not specified, can\'t control payment validity'),
			'payment' => $this->l('Payment: '),
			'custom' => $this->l('Paypal key \'custom\' not specified, can\'t rely to cart'),
			'txn_id' => $this->l('Paypal key \'txn_id\' not specified, transaction unknown'),
			'mc_currency' => $this->l('Paypal key \'mc_currency\' not specified, currency unknown'),
			'cart' => $this->l('Cart not found'),
			'order' => $this->l('Order has already been placed'),
			'transaction' => $this->l('Paypal Transaction ID: '),
			'verified' => $this->l('The PayPal transaction could not be VERIFIED.'),
			'connect' => $this->l('Problem connecting to the PayPal server.'),
			'nomethod' => $this->l('No communications transport available.'),
			'socketmethod' => $this->l('Verification failure (using fsockopen). Returned: '),
			'curlmethod' => $this->l('Verification failure (using cURL). Returned: '),
			'curlmethodfailed' => $this->l('Connection using cURL failed'),
		);
		return $translations[$key];
	}

	function updateOrder($id_order, $id_order_state, $amountPaid)
	{
                    /* Modification hisdtorique */
                    $history = new OrderHistory();
	  	    $history->id_order = (int)$id_order;
                    $history->changeIdOrderState((int)$id_order_state, (int)$id_order);
                    $history->addWithemail(true, '');

		   /* Modification de la commande */
		    $order=new Order((int)$id_order);
                    $order->total_paid_real += $amountPaid;
                    $order->save();
        }

        function validateOrderPart1($id_cart, $id_order_state, $amountPaid, $paymentMethod = 'Unknown', $message = NULL, $extraVars = array(), $currency_special = NULL, $dont_touch_amount = false, $secure_key = false)
	{
		global $cart;

		$cart = new Cart((int)($id_cart));
		// Does order already exists ?
		if (Validate::isLoadedObject($cart) AND $cart->OrderExists() === 0)
		{
			if ($secure_key !== false AND $secure_key != $cart->secure_key)
				die(Tools::displayError());

			// Copying data from cart
			$order = new Order();
			$order->id_carrier = (int)($cart->id_carrier);
			$order->id_customer = (int)($cart->id_customer);
			$order->id_address_invoice = (int)($cart->id_address_invoice);
			$order->id_address_delivery = (int)($cart->id_address_delivery);
			$vat_address = new Address((int)($order->id_address_delivery));
			$order->id_currency = ($currency_special ? (int)($currency_special) : (int)($cart->id_currency));
			$order->id_lang = (int)($cart->id_lang);
			$order->id_cart = (int)($cart->id);
			$customer = new Customer((int)($order->id_customer));
			$order->secure_key = ($secure_key ? pSQL($secure_key) : pSQL($customer->secure_key));
			$order->payment = Tools::substr($paymentMethod, 0, 32);
			if (isset($this->name))
				$order->module = $this->name;
			$order->recyclable = $cart->recyclable;
			$order->gift = (int)($cart->gift);
			$order->gift_message = $cart->gift_message;
			$currency = new Currency($order->id_currency);
			$order->conversion_rate = $currency->conversion_rate;
			$amountPaid = !$dont_touch_amount ? Tools::ps_round((float)($amountPaid), 2) : $amountPaid;
			$order->total_paid_real = $amountPaid;
			$order->total_products = (float)($cart->getOrderTotal(false, Cart::ONLY_PRODUCTS));
			$order->total_products_wt = (float)($cart->getOrderTotal(true, Cart::ONLY_PRODUCTS));
			$order->total_discounts = (float)(abs($cart->getOrderTotal(true, Cart::ONLY_DISCOUNTS)));
			$order->total_shipping = (float)($cart->getOrderShippingCost());
			$order->carrier_tax_rate = (float)Tax::getCarrierTaxRate($cart->id_carrier, (int)$cart->{Configuration::get('PS_TAX_ADDRESS_TYPE')});
			$order->total_wrapping = (float)(abs($cart->getOrderTotal(true, Cart::ONLY_WRAPPING)));
			$order->total_paid = (float)(Tools::ps_round((float)($cart->getOrderTotal(true, Cart::BOTH)), 2));
			$order->invoice_date = '0000-00-00 00:00:00';
			$order->delivery_date = '0000-00-00 00:00:00';

                        //seul modif pour ne pas mettre le paiiement en erreur
			// Amount paid by customer is not the right one -> Status = payment error
			/*if ($order->total_paid != $order->total_paid_real)
				$id_order_state = _PS_OS_ERROR_;*/

			// Creating order
			if ($cart->OrderExists() === 0)
				$result = $order->add();
			else
			{
				$errorMessage = Tools::displayError('An order has already been placed using this cart.');
				Logger::addLog($errorMessage, 4, '0000001', 'Cart', intval($order->id_cart));
				die($errorMessage);
			}

			// Next !
			if ($result AND isset($order->id))
			{
				if (!$secure_key)
					$message .= $this->l('Warning : the secure key is empty, check your payment account before validation');
				// Optional message to attach to this order
				if (isset($message) AND !empty($message))
				{
					$msg = new Message();
					$message = strip_tags($message, '<br>');
					if (!Validate::isCleanHtml($message))
						$message = $this->l('Payment message is not valid, please check your module!');
					$msg->message = $message;
					$msg->id_order = (int)($order->id);
					$msg->private = 1;
					$msg->add();
				}

				// Insert products from cart into order_detail table
				$products = $cart->getProducts();
				$productsList = '';
				$db = Db::getInstance();
				$query = 'INSERT INTO `'._DB_PREFIX_.'order_detail`
					(`id_order`, `product_id`, `product_attribute_id`, `product_name`, `product_quantity`, `product_quantity_in_stock`, `product_price`, `reduction_percent`, `reduction_amount`, `group_reduction`, `product_quantity_discount`, `product_ean13`, `product_upc`, `product_reference`, `product_supplier_reference`, `product_weight`, `tax_name`, `tax_rate`, `ecotax`, `ecotax_tax_rate`, `discount_quantity_applied`, `download_deadline`, `download_hash`)
				VALUES ';

				$customizedDatas = Product::getAllCustomizedDatas((int)($order->id_cart));
				Product::addCustomizationPrice($products, $customizedDatas);
				$outOfStock = false;
				foreach ($products AS $key => $product)
				{
					$productQuantity = (int)(Product::getQuantity((int)($product['id_product']), ($product['id_product_attribute'] ? (int)($product['id_product_attribute']) : NULL)));
					$quantityInStock = ($productQuantity - (int)($product['cart_quantity']) < 0) ? $productQuantity : (int)($product['cart_quantity']);
					if ($id_order_state != _PS_OS_CANCELED_ AND $id_order_state != _PS_OS_ERROR_)
					{
						if (Product::updateQuantity($product, (int)$order->id))
							$product['stock_quantity'] -= $product['cart_quantity'];

						if ($product['stock_quantity'] < 0)
							$outOfStock = true;

						Hook::updateQuantity($product, $order);
						Product::updateDefaultAttribute($product['id_product']);
					}
					$price = Product::getPriceStatic((int)($product['id_product']), false, ($product['id_product_attribute'] ? (int)($product['id_product_attribute']) : NULL), 6, NULL, false, true, $product['cart_quantity'], false, (int)($order->id_customer), (int)($order->id_cart), (int)($order->{Configuration::get('PS_TAX_ADDRESS_TYPE')}));
					$price_wt = Product::getPriceStatic((int)($product['id_product']), true, ($product['id_product_attribute'] ? (int)($product['id_product_attribute']) : NULL), 2, NULL, false, true, $product['cart_quantity'], false, (int)($order->id_customer), (int)($order->id_cart), (int)($order->{Configuration::get('PS_TAX_ADDRESS_TYPE')}));
					// Add some informations for virtual products
					$deadline = '0000-00-00 00:00:00';
					$download_hash = NULL;
					if ($id_product_download = ProductDownload::getIdFromIdProduct((int)($product['id_product'])))
					{
						$productDownload = new ProductDownload((int)($id_product_download));
						$deadline = $productDownload->getDeadLine();
						$download_hash = $productDownload->getHash();
					}

					// Exclude VAT
					if (Tax::excludeTaxeOption())
					{
						$product['tax'] = 0;
						$product['rate'] = 0;
						$tax_rate = 0;
					}
					else
						$tax_rate = Tax::getProductTaxRate((int)($product['id_product']), $cart->{Configuration::get('PS_TAX_ADDRESS_TYPE')});

                    $ecotaxTaxRate = 0;
                    if (!empty($product['ecotax']))
                        $ecotaxTaxRate = Tax::getProductEcotaxRate($order->{Configuration::get('PS_TAX_ADDRESS_TYPE')});

					$quantityDiscount = SpecificPrice::getQuantityDiscount((int)$product['id_product'], Shop::getCurrentShop(), (int)$cart->id_currency, (int)$vat_address->id_country, (int)$customer->id_default_group, (int)$product['cart_quantity']);
					$unitPrice = Product::getPriceStatic((int)$product['id_product'], true, ($product['id_product_attribute'] ? intval($product['id_product_attribute']) : NULL), 2, NULL, false, true, 1, false, (int)$order->id_customer, NULL, (int)$order->{Configuration::get('PS_TAX_ADDRESS_TYPE')});
					$quantityDiscountValue = $quantityDiscount ? ((Product::getTaxCalculationMethod((int)$order->id_customer) == PS_TAX_EXC ? Tools::ps_round($unitPrice, 2) : $unitPrice) - $quantityDiscount['price'] * (1 + $tax_rate / 100)) : 0.00;
					$query .= '('.(int)($order->id).',
						'.(int)($product['id_product']).',
						'.(isset($product['id_product_attribute']) ? (int)($product['id_product_attribute']) : 'NULL').',
						\''.pSQL($product['name'].((isset($product['attributes']) AND $product['attributes'] != NULL) ? ' - '.$product['attributes'] : '')).'\',
						'.(int)($product['cart_quantity']).',
						'.$quantityInStock.',
						'.(float)(Product::getPriceStatic((int)($product['id_product']), false, ($product['id_product_attribute'] ? (int)($product['id_product_attribute']) : NULL), (Product::getTaxCalculationMethod((int)($order->id_customer)) == PS_TAX_EXC ? 2 : 6), NULL, false, false, $product['cart_quantity'], false, (int)($order->id_customer), (int)($order->id_cart), (int)($order->{Configuration::get('PS_TAX_ADDRESS_TYPE')}), $specificPrice, FALSE)).',
						'.(float)(($specificPrice AND $specificPrice['reduction_type'] == 'percentage') ? $specificPrice['reduction'] * 100 : 0.00).',
						'.(float)(($specificPrice AND $specificPrice['reduction_type'] == 'amount') ? (!$specificPrice['id_currency'] ? Tools::convertPrice($specificPrice['reduction'], $order->id_currency) : $specificPrice['reduction']) : 0.00).',
						'.(float)(Group::getReduction((int)($order->id_customer))).',
						'.$quantityDiscountValue.',
						'.(empty($product['ean13']) ? 'NULL' : '\''.pSQL($product['ean13']).'\'').',
						'.(empty($product['upc']) ? 'NULL' : '\''.pSQL($product['upc']).'\'').',
						'.(empty($product['reference']) ? 'NULL' : '\''.pSQL($product['reference']).'\'').',
						'.(empty($product['supplier_reference']) ? 'NULL' : '\''.pSQL($product['supplier_reference']).'\'').',
						'.(float)($product['id_product_attribute'] ? $product['weight_attribute'] : $product['weight']).',
						\''.(empty($tax_rate) ? '' : pSQL($product['tax'])).'\',
						'.(float)($tax_rate).',
						'.(float)Tools::convertPrice(floatval($product['ecotax']), intval($order->id_currency)).',
						'.(float)$ecotaxTaxRate.',
						'.(($specificPrice AND $specificPrice['from_quantity'] > 1) ? 1 : 0).',
						\''.pSQL($deadline).'\',
						\''.pSQL($download_hash).'\'),';

					$customizationQuantity = 0;
					if (isset($customizedDatas[$product['id_product']][$product['id_product_attribute']]))
					{
						$customizationText = '';
						foreach ($customizedDatas[$product['id_product']][$product['id_product_attribute']] AS $customization)
							if (isset($customization['datas'][_CUSTOMIZE_TEXTFIELD_]))
								foreach ($customization['datas'][_CUSTOMIZE_TEXTFIELD_] AS $text)
									$customizationText .= $text['name'].$this->l(':').' '.$text['value'].', ';
						$customizationText = rtrim($customizationText, ', ');

						$customizationQuantity = (int)($product['customizationQuantityTotal']);
						$productsList .=
						'<tr style="background-color: '.($key % 2 ? '#DDE2E6' : '#EBECEE').';">
							<td style="padding: 0.6em 0.4em;">'.$product['reference'].'</td>
							<td style="padding: 0.6em 0.4em;"><strong>'.$product['name'].(isset($product['attributes_small']) ? ' '.$product['attributes_small'] : '').' - '.$this->l('Customized').(!empty($customizationText) ? ' - '.$customizationText : '').'</strong></td>
							<td style="padding: 0.6em 0.4em; text-align: right;">'.Tools::displayPrice(Product::getTaxCalculationMethod() == PS_TAX_EXC ? $price : $price_wt, $currency, false, false).'</td>
							<td style="padding: 0.6em 0.4em; text-align: center;">'.$customizationQuantity.'</td>
							<td style="padding: 0.6em 0.4em; text-align: right;">'.Tools::displayPrice($customizationQuantity * (Product::getTaxCalculationMethod() == PS_TAX_EXC ? $price : $price_wt), $currency, false, false).'</td>
						</tr>';
					}

					if (!$customizationQuantity OR (int)$product['cart_quantity'] > $customizationQuantity)
						$productsList .=
						'<tr style="background-color: '.($key % 2 ? '#DDE2E6' : '#EBECEE').';">
							<td style="padding: 0.6em 0.4em;">'.$product['reference'].'</td>
							<td style="padding: 0.6em 0.4em;"><strong>'.$product['name'].(isset($product['attributes_small']) ? ' '.$product['attributes_small'] : '').'</strong></td>
							<td style="padding: 0.6em 0.4em; text-align: right;">'.Tools::displayPrice(Product::getTaxCalculationMethod() == PS_TAX_EXC ? $price : $price_wt, $currency, false, false).'</td>
							<td style="padding: 0.6em 0.4em; text-align: center;">'.((int)($product['cart_quantity']) - $customizationQuantity).'</td>
							<td style="padding: 0.6em 0.4em; text-align: right;">'.Tools::displayPrice(((int)($product['cart_quantity']) - $customizationQuantity) * (Product::getTaxCalculationMethod() == PS_TAX_EXC ? $price : $price_wt), $currency, false, false).'</td>
						</tr>';
				} // end foreach ($products)
				$query = rtrim($query, ',');
				$result = $db->Execute($query);

				// Insert discounts from cart into order_discount table
				$discounts = $cart->getDiscounts();
				$discountsList = '';
				$total_discount_value = 0;
				$shrunk = false;
				foreach ($discounts AS $discount)
				{
					$objDiscount = new Discount((int)$discount['id_discount'], $order->id_lang);
					$value = $objDiscount->getValue(sizeof($discounts), $cart->getOrderTotal(true, Cart::ONLY_PRODUCTS), $order->total_shipping, $cart->id);
					if ($objDiscount->id_discount_type == 2 AND in_array($objDiscount->behavior_not_exhausted, array(1,2)))
						$shrunk = true;

					if ($shrunk AND ($total_discount_value + $value) > ($order->total_products + $order->total_shipping + $order->total_wrapping))
					{
						$amount_to_add = ($order->total_products + $order->total_shipping + $order->total_wrapping) - $total_discount_value;
						if ($objDiscount->id_discount_type == 2 AND $objDiscount->behavior_not_exhausted == 2)
						{
							$voucher = new Discount();
							foreach ($objDiscount AS $key => $discountValue)
								$voucher->$key = $discountValue;
							$voucher->name = 'VSRK'.(int)$order->id_customer.'O'.(int)$order->id;
							$voucher->value = (float)$value - $amount_to_add;
							$voucher->add();
							$params['{voucher_amount}'] = Tools::displayPrice($voucher->value, $currency, false, false);
							$params['{voucher_num}'] = $voucher->name;
							@Mail::Send((int)$order->id_lang, 'voucher', Mail::l('New voucher regarding your order #').$order->id, $params, $customer->email, $customer->firstname.' '.$customer->lastname);
						}
					}
					else
						$amount_to_add = $value;
					$order->addDiscount($objDiscount->id, $objDiscount->name, $amount_to_add);
					$total_discount_value += $amount_to_add;
					if ($id_order_state != _PS_OS_ERROR_ AND $id_order_state != _PS_OS_CANCELED_)
						$objDiscount->quantity = $objDiscount->quantity - 1;
					$objDiscount->update();

					$discountsList .=
					'<tr style="background-color:#EBECEE;">
							<td colspan="4" style="padding: 0.6em 0.4em; text-align: right;">'.$this->l('Voucher code:').' '.$objDiscount->name.'</td>
							<td style="padding: 0.6em 0.4em; text-align: right;">'.($value != 0.00 ? '-' : '').Tools::displayPrice($value, $currency, false, false).'</td>
					</tr>';
				}

				// Specify order id for message
				$oldMessage = Message::getMessageByCartId((int)($cart->id));
				if ($oldMessage)
				{
					$message = new Message((int)$oldMessage['id_message']);
					$message->id_order = (int)$order->id;
					$message->update();
				}

				// Hook new order
				$orderStatus = new OrderState((int)$id_order_state, (int)$order->id_lang);
				if (Validate::isLoadedObject($orderStatus))
				{
					Hook::newOrder($cart, $order, $customer, $currency, $orderStatus);
					foreach ($cart->getProducts() AS $product)
						if ($orderStatus->logable)
							ProductSale::addProductSale((int)$product['id_product'], (int)$product['cart_quantity']);
				}

				if (isset($outOfStock) AND $outOfStock)
				{
					$history = new OrderHistory();
					$history->id_order = (int)$order->id;
					$history->changeIdOrderState(_PS_OS_OUTOFSTOCK_, (int)$order->id);
					$history->addWithemail();
				}

				// Set order state in order history ONLY even if the "out of stock" status has not been yet reached
				// So you migth have two order states
				$new_history = new OrderHistory();
				$new_history->id_order = (int)$order->id;
				$new_history->changeIdOrderState((int)$id_order_state, (int)$order->id);
				$new_history->addWithemail(true, $extraVars);

				// Order is reloaded because the status just changed
				$order = new Order($order->id);

				// Send an e-mail to customer
				if ($id_order_state != _PS_OS_ERROR_ AND $id_order_state != _PS_OS_CANCELED_ AND $customer->id)
				{
					$invoice = new Address((int)($order->id_address_invoice));
					$delivery = new Address((int)($order->id_address_delivery));
					$carrier = new Carrier((int)($order->id_carrier), $order->id_lang);
					$delivery_state = $delivery->id_state ? new State((int)($delivery->id_state)) : false;
					$invoice_state = $invoice->id_state ? new State((int)($invoice->id_state)) : false;

					$data = array(
					'{firstname}' => $customer->firstname,
					'{lastname}' => $customer->lastname,
					'{email}' => $customer->email,
					'{delivery_company}' => $delivery->company,
					'{delivery_firstname}' => $delivery->firstname,
					'{delivery_lastname}' => $delivery->lastname,
					'{delivery_address1}' => $delivery->address1,
					'{delivery_address2}' => $delivery->address2,
					'{delivery_city}' => $delivery->city,
					'{delivery_postal_code}' => $delivery->postcode,
					'{delivery_country}' => $delivery->country,
					'{delivery_state}' => $delivery->id_state ? $delivery_state->name : '',
					'{delivery_phone}' => ($delivery->phone) ? $delivery->phone : $delivery->phone_mobile,
					'{delivery_other}' => $delivery->other,
					'{invoice_company}' => $invoice->company,
					'{invoice_vat_number}' => $invoice->vat_number,
					'{invoice_firstname}' => $invoice->firstname,
					'{invoice_lastname}' => $invoice->lastname,
					'{invoice_address2}' => $invoice->address2,
					'{invoice_address1}' => $invoice->address1,
					'{invoice_city}' => $invoice->city,
					'{invoice_postal_code}' => $invoice->postcode,
					'{invoice_country}' => $invoice->country,
					'{invoice_state}' => $invoice->id_state ? $invoice_state->name : '',
					'{invoice_phone}' => ($invoice->phone) ? $invoice->phone : $invoice->phone_mobile,
					'{invoice_other}' => $invoice->other,
					'{order_name}' => sprintf("#%06d", (int)($order->id)),
					'{date}' => Tools::displayDate(date('Y-m-d H:i:s'), (int)($order->id_lang), 1),
					'{carrier}' => $carrier->name,
					'{payment}' => $order->payment,
					'{products}' => $productsList,
					'{discounts}' => $discountsList,
					'{total_paid}' => Tools::displayPrice($order->total_paid, $currency, false, false),
					'{total_products}' => Tools::displayPrice($order->total_paid - $order->total_shipping - $order->total_wrapping + $order->total_discounts, $currency, false, false),
					'{total_discounts}' => Tools::displayPrice($order->total_discounts, $currency, false, false),
					'{total_shipping}' => Tools::displayPrice($order->total_shipping, $currency, false, false),
					'{total_wrapping}' => Tools::displayPrice($order->total_wrapping, $currency, false, false));

					if (is_array($extraVars))
						$data = array_merge($data, $extraVars);

					// Join PDF invoice
					if ((int)(Configuration::get('PS_INVOICE')) AND Validate::isLoadedObject($orderStatus) AND $orderStatus->invoice AND $order->invoice_number)
					{
						$fileAttachment['content'] = PDF::invoice($order, 'S');
						$fileAttachment['name'] = Configuration::get('PS_INVOICE_PREFIX', (int)($order->id_lang)).sprintf('%06d', $order->invoice_number).'.pdf';
						$fileAttachment['mime'] = 'application/pdf';
					}
					else
						$fileAttachment = NULL;

					if (Validate::isEmail($customer->email))
						Mail::Send((int)($order->id_lang), 'order_conf', Mail::l('Order confirmation'), $data, $customer->email, $customer->firstname.' '.$customer->lastname, NULL, NULL, $fileAttachment);
				}
				$this->currentOrder = (int)($order->id);
				return true;
			}
			else
			{
				$errorMessage = Tools::displayError('Order creation failed');
				Logger::addLog($errorMessage, 4, '0000002', 'Cart', intval($order->id_cart));
				die($errorMessage);
			}
		}
		else
		{
			$errorMessage = Tools::displayError('Cart can\'t be loaded or an order has already been placed using this cart');
			Logger::addLog($errorMessage, 4, '0000001', 'Cart', intval($cart->id));
			die($errorMessage);
		}
	}

}
