<?php

if(file_exists (dirname(__FILE__).'/../subscriptionsmanager/subscriptionsmanager.php'))
    require_once (dirname(__FILE__).'/../subscriptionsmanager/subscriptionsmanager.php');


class PaypalSubscriptionsProcess_PaymentModuleFrontController extends ModuleFrontController {

    public function initContent() {

	parent :: initContent();
	
	try {
	    	    
	    if(!Tools::isEmpty('validation') && Tools::getValue('validation') == 1){
		
		if(PSTools::detectSubscriptionsManager())
		    $this->context->smarty->assign('isSubscription', 1);
		else	   
		    $this->context->smarty->assign('isSubscription', 0);
	    
		$this->context->smarty->assign('validation', 1);
	    

		$this->setTemplate('payment_return.tpl');
		return true;
	    
	    }
	    
	    
	    $paypalSubscriptions = new PaypalSubscriptions();

	    $paypalUrlNvp = 'https://api-3t.paypal.com/nvp';
	    $paypalMerchantUserName =  Configuration::get('paypal_merchant_user_name');
	    $paypalMerchantPassword =   Configuration::get('paypal_merchant_password');
	    $paypalMerchantSignature =  Configuration::get('paypal_merchant_signature');
	    
	    // la première partie des étapes a été faite dans paypalsubscriptions
	    // Step 1: Set Up the Payment Authorization
	    // Step 2: Redirect the Customer to PayPal for Authorization
	    // la suite se fait ici, en retour d'ident du client chez Paypal :

	    $paypalToken = Tools::getValue('token'); // paypal nous envoit la token du départ, pour racrocher les wagons..

	    $currentPaypalRow = PSTools::getLastPaypalSubscriptions($paypalToken);
	    if (empty($currentPaypalRow)) {
		throw new Exception($paypalSubscriptions->l('This order can not be found in the store'));
	    }
	    if($currentPaypalRow['paypal_payer_id']) {
		throw new Exception($paypalSubscriptions->l('This order was already processed'));
	    }

	    
	    
	    // Init des variables
	    $cart = new Cart($currentPaypalRow['id_cart']);
	    $currency_obj = new Currency($cart->id_currency);
	    $customer = new Customer($cart->id_customer);
	    $currency = $currency_obj->iso_code;
	    $total = (float) $cart->getOrderTotal(true, Cart::BOTH);
	    $id_default_country = $this->context->country->id;	    
	    $country = Country::getIsoById($id_default_country);

	    $profile_description = PSTools::getProductName($currentPaypalRow['id_cart']);
	    $profile_start_date = date("Y-m-d") . "T00:00:00Z";

	    $billing_max_failed_payments = Configuration::get('billing_max_failed_payments');
	    if($billing_max_failed_payments == NULL)
		$billing_max_failed_payments = 1;
	    
	    
	    if (PSTools::detectSubscriptionsManager())		
		$SMDetection = true;
	    else
		$SMDetection = false;
	    
	    $isSubscription = FALSE; // Variable servant à déterminer si le panier est un abonnement ou non
	    
	    // Si le module Gestion des abonnements est détecté
	    if($SMDetection){		
		$schema = SMTools::getSchemaFromIdCart($currentPaypalRow['id_cart']); // Récupération du schéma associé
		
		if(!empty($schema)){ // Si il a bien un shécma
		    
		    if($schema['one_shot'] == 1) // Si le paiement est direct
			$isSubscription = FALSE;
		    else
			$isSubscription = TRUE;
		}
		else
		    $isSubscription = FALSE;	    
	    }
	    else
		$isSubscription = TRUE;
	    
	    $billing_trial_amount = NULL;
	    
	    if($SMDetection && $isSubscription){
		
		$schema = new SMSchema($schema['id_schema']);
		
		$billing_period = 'Month'; // avec le module de gestion d'abonement, on travaille toujours au mois
		$billing_frequency = $schema->frequency; // la fréquence entre 2 renouvellements
		if($schema->duration == 0)
		    $billing_nb_cycles = 0;
		else
		    $billing_nb_cycles = floor($schema->duration / $schema->frequency);  // nombre de cycle à effectuer	
		
		$isDiscount = FALSE;
		
		if($schema->discount_mode != NULL){
		    $isDiscount = TRUE;

		    $billing_trial_duration = $schema->discount_nb_months;
		    
		    
		    if($schema->duration != 0)
			$billing_nb_cycles -= $billing_trial_duration;
		    
		    if($schema->discount_mode == SMSchema::$DISCOUNT_MONTHS_OFFER){
				
			$billing_trial_amount = 0;
			
		    }
		    elseif($schema->discount_mode == SMSchema::$DISCOUNT_OFFER){
			
			$products = $cart->getProducts();
			
			$product = new Product($products[0]['id_product']);
			
			$billing_trial_amount = $total;
			$total = $product->getPriceWithoutReduct(false, $products[0]['id_product_attribute']);
		    }
		    
		    
		}
	    }
	    elseif(!$SMDetection){
		$billing_period = Configuration::get('billing_period');
		$billing_frequency = Configuration::get('billing_frequency');
		$billing_nb_cycles = Configuration::get('billing_nb_cycles');
	    }
	    
	   
	    // Récupération des données d'une transaction    
	    $postFields = array();
	    $postFields['USER'] = $paypalMerchantUserName;
	    $postFields['PWD'] = $paypalMerchantPassword;
	    $postFields['SIGNATURE'] = $paypalMerchantSignature;
	    $postFields['METHOD'] = 'GetExpressCheckoutDetails';
	    $postFields['VERSION'] = 86;
	    $postFields['TOKEN'] = $paypalToken;
	    
	    $postFields = PSTools::serializePostFields($postFields);

	    $response = PSTools::curlGet($paypalUrlNvp, $postFields);
	     

	    
	    
	    if (empty($response['TOKEN'])){
		PSLog::addLog('get_paypal_error', $response);
		throw new Exception($paypalSubscriptions->l('token is missing'));
	    }
	    
	    if (empty($response['ACK'])){
		PSLog::addLog('get_paypal_error', $response);
		throw new Exception($paypalSubscriptions->l('ack is missing'));
	    }
	    
	    if ($response['ACK'] != 'Success'){ 
		PSLog::addLog('get_paypal_error', $response);
		throw new Exception($paypalSubscriptions->l('Connection to Paypal failed'));
	    }
	   	   	    
	    if (empty($response['PAYERID'])){
		PSLog::addLog('get_paypal_error', $response);
		throw new Exception($paypalSubscriptions->l('payer_id is missing'));
	    }
	    
	    PSLog::addLog('get_paypal_ok', $response);
	    
	    $token = $response['TOKEN'];
		    
		    	    
	    //Si c'est un abonnement
	    switch ($isSubscription) {
		case TRUE:
		    
		    if (empty($response['BILLINGAGREEMENTACCEPTEDSTATUS']) || $response['BILLINGAGREEMENTACCEPTEDSTATUS'] != 1) 
			throw new Exception($paypalSubscriptions->l('approval of payment missing or refused'));
		    	   

		    $PSPaypalSubscription = new PSPaypalSubscription($currentPaypalRow['id_paypal_subscription']);

		    $PSPaypalSubscription->paypal_payer_id = $response['PAYERID'];  
		    $PSPaypalSubscription->paypal_profile_start_date = $profile_start_date;
		    $PSPaypalSubscription->paypal_desc = $profile_description;
		    $PSPaypalSubscription->paypal_billing_period = $billing_period;
		    $PSPaypalSubscription->paypal_billing_frequency = $billing_frequency;
		    $PSPaypalSubscription->paypal_total_billing_cycles = $billing_nb_cycles;
		    $PSPaypalSubscription->paypal_billing_amt = $total;
		    $PSPaypalSubscription->paypal_currency_code = $currency;
		    $PSPaypalSubscription->paypal_country_code = $country;
		    $PSPaypalSubscription->paypal_max_failed_payments = $billing_max_failed_payments;

		    $PSPaypalSubscription->update();
		    
		    
		    $postFields = array(); // purge..
		    $postFields['USER'] = $paypalMerchantUserName;
		    $postFields['PWD'] = $paypalMerchantPassword;
		    $postFields['SIGNATURE'] = $paypalMerchantSignature;
		    $postFields['VERSION'] = 86;
		    $postFields['TOKEN'] = $response['TOKEN'];
		    $postFields['PAYERID'] = $response['PAYERID']; #Identifies the customer's account
		    $postFields['METHOD'] = 'CreateRecurringPaymentsProfile';
		    $postFields['PROFILESTARTDATE'] = $profile_start_date; #Billing date start, in UTC/GMT format
		    $postFields['DESC'] = $profile_description; #Profile description - same as billing agreement description
		    $postFields['BILLINGPERIOD'] = $billing_period; #Period of time between billings
		    $postFields['BILLINGFREQUENCY'] = $billing_frequency; #Frequency of charges
		    $postFields['TOTALBILLINGCYCLES'] = $billing_nb_cycles; # Number of billing cycles for payment period.
		    $postFields['AMT'] = $total; #The amount the buyer will pay in a payment period
		    if(isset($isDiscount) && $isDiscount){
			$postFields['TRIALBILLINGPERIOD'] = $billing_period; #Period of time in one trial period
			$postFields['TRIALBILLINGFREQUENCY'] = $billing_frequency; #Frequency of charges, if any, during the trial period
			$postFields['TRIALTOTALBILLINGCYCLES'] = $billing_trial_duration;    #Length of trial period
			$postFields['TRIALAMT'] = $billing_trial_amount;    #Payment amount (can be 0) during the trial period
		    }
		    $postFields['CURRENCYCODE'] = $currency; #The currency, e.g. US dollars
		    $postFields['COUNTRYCODE'] = $country; #The country code, e.g. US
		    $postFields['MAXFAILEDPAYMENTS'] = $billing_max_failed_payments; #Maximum failed payments before suspension of the profile
	    
		    $postFields = PSTools::serializePostFields($postFields);
		    $response = PSTools::curlGet($paypalUrlNvp, $postFields);
		    	
		    
		    /*    		    
		    TODO - Multi subscriptions
		    $postFields = array(); // purge..
		    $postFields['USER'] = $paypalMerchantUserName;
		    $postFields['PWD'] = $paypalMerchantPassword;
		    $postFields['SIGNATURE'] = $paypalMerchantSignature;
		    $postFields['VERSION'] = 86;
		    $postFields['TOKEN'] = $response['TOKEN'];
		    $postFields['PAYERID'] = $response['PAYERID']; #Identifies the customer's account
		    $postFields['METHOD'] = 'CreateRecurringPaymentsProfile';
		    $postFields['PROFILESTARTDATE'] = $profile_start_date; #Billing date start, in UTC/GMT format
		    $postFields['DESC'] = "TEST"; #Profile description - same as billing agreement description
		    $postFields['BILLINGPERIOD'] = $billing_period; #Period of time between billings
		    $postFields['BILLINGFREQUENCY'] = 2; #Frequency of charges
		    $postFields['TOTALBILLINGCYCLES'] = 6; # Number of billing cycles for payment period.
		    $postFields['AMT'] = 50; #The amount the buyer will pay in a payment period
		    if($isDiscount){
			$postFields['TRIALBILLINGPERIOD'] = $billing_period; #Period of time in one trial period
			$postFields['TRIALBILLINGFREQUENCY'] = $billing_frequency; #Frequency of charges, if any, during the trial period
			$postFields['TRIALTOTALBILLINGCYCLES'] = $billing_trial_duration;    #Length of trial period
			$postFields['TRIALAMT'] = $billing_trial_amount;    #Payment amount (can be 0) during the trial period
		    }
		    $postFields['CURRENCYCODE'] = $currency; #The currency, e.g. US dollars
		    $postFields['COUNTRYCODE'] = $country; #The country code, e.g. US
		    $postFields['MAXFAILEDPAYMENTS'] = $billing_max_failed_payments; #Maximum failed payments before suspension of the profile
	    
		    $postFields = PSTools::serializePostFields($postFields);
		    $responseee = PSTools::curlGet($paypalUrlNvp, $postFields);
		    		   		    
		    + Paiement direct :)
		    $postFields = array(); // purge..
		    $postFields['USER'] = $paypalMerchantUserName;
		    $postFields['PWD'] = $paypalMerchantPassword;
		    $postFields['SIGNATURE'] = $paypalMerchantSignature;
		    $postFields['VERSION'] = 86;
		    $postFields['TOKEN'] = $response['TOKEN']; 
		    $postFields['PAYERID'] = $response['PAYERID']; #Identifies the customer's account	    
		    $postFields['METHOD'] = 'DoExpressCheckoutPayment';
		    $postFields['PAYMENTREQUEST_0_PAYMENTACTION'] = 'SALE';
		    $postFields['PAYMENTREQUEST_0_AMT'] = 11;             
		    $postFields['PAYMENTREQUEST_0_CURRENCYCODE'] = $currency;   
		    
		    $postFields = PSTools::serializePostFields($postFields);
		    $response = PSTools::curlGet($paypalUrlNvp, $postFields);
		    */
		    
		
		    if ($response['ACK'] == 'Failure') {
			PSLog::addLog('create_paypal_profile_error', $response);
			throw new Exception($response['L_ERRORCODE0'].' '.$response['L_SHORTMESSAGE0'].' '.$response['L_LONGMESSAGE0']);
		    }
		    
		    if (empty($response['PROFILEID'])){			
			PSLog::addLog('create_paypal_profile_error', $response);
			throw new Exception($paypalSubscriptions->l('profile_id is missing'));
		    }
		    		    
		    
		    PSLog::addLog('create_paypal_profile_ok', $response);
		    $PSPaypalSubscription->paypal_profile_id = $response['PROFILEID'];

		break;
		case FALSE:
		    
		    $PSPaypalSubscription = new PSPaypalSubscription($currentPaypalRow['id_paypal_subscription']);

		    $PSPaypalSubscription->paypal_payer_id = $response['PAYERID'];  
		    $PSPaypalSubscription->paypal_profile_start_date = $profile_start_date;
		    $PSPaypalSubscription->paypal_desc = $profile_description;
		    $PSPaypalSubscription->paypal_billing_amt = $total;
		    $PSPaypalSubscription->paypal_currency_code = $currency;
		    $PSPaypalSubscription->paypal_country_code = $country;

		    $PSPaypalSubscription->update();
		    
		    $postFields = array(); // purge..
		    $postFields['USER'] = $paypalMerchantUserName;
		    $postFields['PWD'] = $paypalMerchantPassword;
		    $postFields['SIGNATURE'] = $paypalMerchantSignature;
		    $postFields['VERSION'] = 86;
		    $postFields['TOKEN'] = $response['TOKEN']; 
		    $postFields['PAYERID'] = $response['PAYERID']; #Identifies the customer's account	    
		    $postFields['METHOD'] = 'DoExpressCheckoutPayment';
		    $postFields['PAYMENTREQUEST_0_PAYMENTACTION'] = 'SALE';
		    $postFields['PAYMENTREQUEST_0_AMT'] = $total;             
		    $postFields['PAYMENTREQUEST_0_CURRENCYCODE'] = $currency;   
		    
		    $postFields = PSTools::serializePostFields($postFields);
		    $response = PSTools::curlGet($paypalUrlNvp, $postFields);
		    
		    PSLog::addLog('create_direct_payment', $response);
		    
		break;
	    }
	
	    
	    
	    if (empty($response['ACK'])){
		PSLog::addLog('paypal_return_error', $response);
		throw new Exception($paypalSubscriptions->l('ack is missing'));
	    }
	    
	    
	    $PSPaypalSubscription->paypal_ack = $response['ACK'];
	    $PSPaypalSubscription->update();
	    
	    
	    if ($response['ACK'] != 'Success'){
		PSLog::addLog('paypal_return_error', $response);
		throw new Exception($paypalSubscriptions->l('Connection to Paypal failed'));
	    }
	    

	    $mailVars = array();
	    
	    if($isSubscription)
		$status = Configuration::get('PSPS_OS_PENDING');
	    else
		$status = Configuration::get('PS_OS_PAYMENT');
	    
	    if($SMDetection && $isSubscription && SMTools::isCartFree($cart, $schema)){
		
		$tempo_cart = $cart->duplicate(); // Duplication du panier
		$new_cart = $tempo_cart ['cart']; // Récupération de l'objet
		$new_cart->deleteAssociations(); // Suppression des produits du panier

		$products = $cart->getProducts();


		$new_cart->updateQty(1, $products [0] ['id_product'], $products [0] ['id_product_attribute']); // On l'ajoute dans le panier
		$new_cart->update(); // Sauvegarde du panier
					
		SMTools::addCartRule($new_cart, NULL, $schema); // Ajout de la réduction		
					
		require_once (dirname(__FILE__) . '/../../../../controllers/front/ParentOrderController.php');

		$modulePayment = new FreeOrder(); // Nouvelle instance
		$modulePayment->validateOrder($new_cart->id, Configuration::get('PS_OS_PAYMENT'), 0, $paypalSubscriptions->l('Free Order'), NULL, array(), (int) $currency_obj->id); // Validation de la commande
	    		
		if($modulePayment->currentOrder > 0){
		    $PSPaypalSubscription->id_order = $modulePayment->currentOrder;
		    $PSPaypalSubscription->update();
		    $cart->delete();
		}
	    }
	    else{	   
		if($billing_trial_amount != NULL)
		    $total = $billing_trial_amount;
		$paypalSubscriptions->validateOrder((int) $cart->id, $status, $total, $paypalSubscriptions->displayName, NULL, $mailVars, (int) $currency_obj->id, false, $customer->secure_key);

		$PSPaypalSubscription->id_order = $paypalSubscriptions->currentOrder;
		$PSPaypalSubscription->update();
	    }
	    
	    
	    if ($this->context->customer->id == 0)
		Tools::redirect('index.php');
	    
	    
	    if(PSTools::detectSubscriptionsManager())
		$this->context->smarty->assign('isSubscription', 1);
	    else
		$this->context->smarty->assign('isSubscription', 0);
	    
	   
	    
	    $this->context->smarty->assign('token', $token);
	    

	    $this->setTemplate('payment_return.tpl');
	    
	    
	} catch (Exception $e) { // on capture toutes les erreurs et on les redirige vers le template, incluent le mesage d'erreur
	   //die('Aie..'.$e->getMessage());
	   $this->context->smarty->assign('error_msg', $e->getMessage());
	   $this->setTemplate('payment_return.tpl');
	   return;
	}

    }

}