<?php

/**
 * Log les données recues par Paypal
 */
class PSLog extends ObjectModelCore {

      
    /**
    * ID du log
    * @var integer
    */
    public $id_log;
     
    /**
    * Type de donnée IPN
    * @var integer
    */
    public $log_txn_type;
    
    /**
    * Données sérialisées
    * @var integer
    */
    public $serialized_data;
    
    /**
    * Date de réception des données
    * @var integer
    */
    public $log_date;   
   
		      
    
			  
    public static $definition = array('table' => 'PS_log', 'primary' => 'id_log', 'multilang' => false,
	'fields' => array(	    
	    'id_log' => array('type' => self::TYPE_INT),
	    'log_txn_type' => array('type' =>  self::TYPE_STRING),
	    'serialized_data' => array('type' =>  self::TYPE_STRING),
	    'log_date' => array('type' =>  self::TYPE_DATE)	    
	)
    );

    
    public function __construct($id_paypal_subscription = NULL) {
	parent::__construct($id_paypal_subscription);

	$this->log_date = date('Y-m-d h:i:s'); // Aujourd'hui
	
    }

    /**
    * Renvoie la liste des logs
    */
    static public function getList($params = array()) {

	    $sql = new DbQuery ();
	    $sql->select ( '*' );
	    $sql->from ( 'PS_log');
      
	    if (isset ( $params ['token'] )) {
		    $sql->where ( 'serialized_data LIKE "%' . $params['token'] . '%"' );
	    }
	    return Db::getInstance ()->executeS ( $sql );
    }
    
    /**
    * Renvoie la liste des logs
    */
    static public function getListFormatted($params = array()) {

	$logs = self::getList($params);
	
	return array_reverse($logs);
    }
    
    static public function addLog($action, $data = NULL){
	
		
	// Log des données
	$PSLog = new PSLog(); // Instance
	
	$PSLog->log_txn_type = $action; // Type de transaction
	
	
	if($data == NULL){
	    
	}
	elseif(is_array($data)){ // Si la variable data est un tableau
	    $array = array();
	     foreach ($data as $key => $value){
		 $array[$key] = utf8_encode($value);
	     }
	     
	    $data = serialize($array);	 
	}
	else{
	    $data = serialize($data);
	}
	$PSLog->serialized_data = $data; // Données sérialisées
	
	$PSLog->log_date = date('Y-m-d h:i:s'); // Maintenant
	
	$PSLog->save(); // Sauvegarde
	
    }

    
    
}




