<?php

/**
 * Log les actions faites par le module de gestion d'abonnement
 */
class PSPaypalSubscription extends ObjectModelCore {

    /**
    * ID de l'abonnement Paypal
    * @var integer
    */
    public $id_paypal_subscription;
     
    /**
    * ID du client
    * @var integer
    */
    public $id_customer;
    
    /**
    * ID du panier
    * @var integer
    */
    public $id_cart;
    
    /**
    * ID de la commande
    * @var integer
    */
    public $id_order = NULL;
    
    /**
    * ID de l'abonnement coté Paypal
    * @var varchar(20)
    */
    public $paypal_payer_id = NULL;
    
    /**
    * Date de départ de l'abonnement
    * @var varchar(20)
    */
    public $paypal_profile_start_date = NULL;
    
    /**
    * Description de l'abonnement
    * @var varchar(255)
    */
    public $paypal_desc = NULL;
    
    /**
    * Période de l'abonnement
    * @var varchar(20)
    */
    public $paypal_billing_period = NULL;
    
    /**
    * Fréquence de l'abonnement
    * @var tinyint(2)
    */
    public $paypal_billing_frequency = NULL;
    
    /**
    * Nombre de cycle de l'abonnement
    * @var tinyint(2)
    */
    public $paypal_total_billing_cycles = NULL;
    
    /**
    * Montant de l'abonnement
    * @var decimal(5,2)
    */
    public $paypal_billing_amt = NULL;
    
    /**
    * Devise de l'abonnement
    * @var char(3)
    */
    public $paypal_currency_code = NULL;
    
    /**
    * Pays de l'abonnement
    * @var char(2)
    */
    public $paypal_country_code = NULL;
    
    /**
    * Nombre maximum d'échec de prélèvement
    * @var tinyint(1)
    */
    public $paypal_max_failed_payments = NULL;
    
    /**
    * Token de Paypal
    * @var varchar(20)
    */
    public $paypal_token;
    
    /**
    * Id du profil Paypal
    * @var varchar(20)
    */
    public $paypal_profile_id = NULL;
    
    /**
    * Réponse de Paypal
    * @var varchar(20)
    */
    public $paypal_ack = NULL;
    
    /**
    * Date de création
    * @var datetime
    */
    public $create_datetime;
    
    /**
    * Date de résiliation coté Prestashop
    * @var datetime
    */
    public $cancel_from_presta_datetime;
    
    /**
    * Date de résiliation coté Paypal
    * @var datetime
    */
    public $cancel_from_paypal_datetime;
    
			  
    public static $definition = array('table' => 'PS_paypal_subscription', 'primary' => 'id_paypal_subscription', 'multilang' => false,
	'fields' => array(	    
	    'id_paypal_subscription' => array('type' => self::TYPE_INT),
	    'id_customer' => array('type' =>  self::TYPE_INT),
	    'id_cart' => array('type' =>  self::TYPE_INT),
	    'id_order' => array('type' =>  self::TYPE_INT),
	    'paypal_payer_id' => array('type' =>  self::TYPE_STRING),
	    'paypal_profile_start_date' => array('type' =>  self::TYPE_STRING),
	    'paypal_desc' => array('type' =>  self::TYPE_STRING),
	    'paypal_billing_period' => array('type' =>  self::TYPE_STRING),
	    'paypal_billing_frequency' => array('type' =>  self::TYPE_INT),
	    'paypal_total_billing_cycles' => array('type' =>  self::TYPE_INT),
	    'paypal_billing_amt' => array('type' =>  self::TYPE_FLOAT),
	    'paypal_currency_code' => array('type' =>  self::TYPE_STRING),
	    'paypal_country_code' => array('type' =>  self::TYPE_STRING),
	    'paypal_max_failed_payments' => array('type' =>  self::TYPE_INT),
	    'paypal_token' => array('type' =>  self::TYPE_STRING),
	    'paypal_profile_id' => array('type' =>  self::TYPE_STRING),
	    'paypal_ack' => array('type' =>  self::TYPE_STRING),
	    'create_datetime' => array('type' =>  self::TYPE_DATE),
	    'cancel_from_presta_datetime' => array('type' =>  self::TYPE_DATE),
	    'cancel_from_paypal_datetime' => array('type' =>  self::TYPE_DATE)
	)
    );

    
    public function __construct($id_paypal_subscription = NULL) {
	parent::__construct($id_paypal_subscription);

	$this->create_datetime = date('Y-m-d h:i:s'); // Aujourd'hui
	
    }

    /**
    * Renvoie la liste de tous les schémas
    */
    public static function getList($params = array()) {

	    $sql = new DbQuery ();
	    $sql->select ( '*' );
	    $sql->from ( 'PS_paypal_subscription');

	    if (isset ( $params ['paypal_token'] )) {
		    $sql->where ( 'paypal_token LIKE "' . $params['paypal_token'] . '"' );
	    }
	    if (isset ( $params ['paypal_profile'] )) {
		    $sql->where ( 'paypal_profile_id LIKE "' . $params['paypal_profile'] . '"' );
	    }
	    if (isset ( $params ['id_cart'] )) {
		    $sql->where ( 'id_cart = ' . $params['id_cart']);
	    }
	    if (isset ( $params ['id_order'] )) {
		    $sql->where ( 'id_order = ' . $params['id_order']);
	    }
	    
	    

	    return Db::getInstance ()->executeS ( $sql );
    }

    
    
}




