<?php

/* -----------------------------------------
   Module Prestashop PrestacreaThemeManager
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ----------------------------------------- */

class PrestacreaThemeManager extends Module
{
	public function __construct()
	{
		$this->name = 'prestacreathememanager';
		$this->tab = 'administration';
		$this->version = '1.0';
		$this->author = 'PRESTACREA';
		
		$this->bootstrap = true;
		$this->need_instance = 0;
		parent::__construct();

		$this->displayName = ('PRESTACREA - Theme Manager');
		$this->description = $this->l('Management module for your Prestacrea template');
		
		if (version_compare(_PS_VERSION_, '1.5.0.0', '<')) {
			global $smarty;
			if (!function_exists('smartyHook')) {
				function smartyHook($params, &$smarty)
				{
					if (!empty($params['h']))
					{
						$id_module = null;
						$hook_params = $params;
						$hook_params['smarty'] = $smarty;
						if (!empty($params['mod']))
						{
							$module = Module::getInstanceByName($params['mod']);
							if ($module && $module->id)
								$id_module = $module->id;
							unset($hook_params['mod']);
						}
						unset($hook_params['h']);
						return Hook::exec($params['h'], $hook_params, $id_module);
					}
				}
				smartyRegisterFunction($smarty, 'function', 'hook', 'smartyHook');
			}
		}
	}

	public function install()
	{
		if (file_exists(dirname(__FILE__).'/theme/install/theme-install.php'))
			require_once(dirname(__FILE__).'/theme/install/theme-install.php');
			
		if (file_exists(dirname(__FILE__).'/theme/less/theme-global.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-global.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/theme-responsive.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-responsive.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache');
		
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcart.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcart.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered-15.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocklayered-15.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockstore.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockstore.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocktags.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocktags.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-crossselling.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling-css.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-crossselling-css.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-editorial.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-editorial.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-editorial-css.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-editorial-css.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-homeslider.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider-16.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-homeslider-16.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-productcomments.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-productcomments.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-productscategory.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory-css.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-productscategory-css.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache');
			
		if (file_exists(dirname(__FILE__).'/theme/install/modules-install.php'))
			require_once(dirname(__FILE__).'/theme/install/modules-install.php');
		
		Db::getInstance()->Execute('INSERT IGNORE INTO '._DB_PREFIX_.'hook (`id_hook`, `name`, `title`, `description`, `position`, `live_edit`) VALUES (null, "topColumn", "Top Column", "Display a column above defaults columns", "1", "1")');
		
		if (!parent::install()
		OR !$this->registerHook('header'))
			return false;
		return true;
	}

	public function uninstall()
	{
		if (file_exists(dirname(__FILE__).'/theme/install/theme-uninstall.php'))
			require_once(dirname(__FILE__).'/theme/install/theme-uninstall.php');
		
		if (file_exists(dirname(__FILE__).'/theme/less/theme-global.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-global.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/theme-responsive.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-responsive.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache');
		
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcart.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcart.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered-15.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocklayered-15.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockstore.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockstore.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocktags.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocktags.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-crossselling.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling-css.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-crossselling-css.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-editorial.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-editorial.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-editorial-css.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-editorial-css.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-homeslider.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider-16.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-homeslider-16.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-productcomments.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-productcomments.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-productscategory.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory-css.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-productscategory-css.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache');
		if (file_exists(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache'))
			unlink(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache');
		
		if (file_exists(dirname(__FILE__).'/theme/install/modules-install.php'))
			require_once(dirname(__FILE__).'/theme/install/modules-install.php');
		
		if (!parent::uninstall())
			return false;
		return true;
	}

	public function getContent()
	{
		$this->_html .= '<h2>'.$this->displayName.' - '.Configuration::get('PTM_THEMENAME').' v.'.Configuration::get('PTM_THEMEVERSION').'</h2>
		<div id="lnkDocContainer">
			<a class="lnk" target="_blank" href="'.$this->_path.'theme/doc/documentation.pdf">'.$this->l('PDF documentation').'</a>
			<a class="lnk" target="_blank" href="'.$this->_path.'theme/doc/changelog.txt">'.$this->l('Changelog').'</a>
		</div>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post"><input style="margin:0 0 20px;" type="submit" name="submitCache" value="'.$this->l('Clear module cache').'" class="button" /></form>';
		if (Tools::isSubmit('submitGeneral')) {
			Configuration::updateValue('PTM_RESPONSIVE', pSQL(Tools::getValue('ptm_responsive')));
			Configuration::updateValue('PTM_COLUMN', pSQL(Tools::getValue('ptm_column')));
			Configuration::updateValue('PTM_LISTDISPLAY', pSQL(Tools::getValue('ptm_listdisplay')));
			Configuration::updateValue('PTM_QUICKVIEW', pSQL(Tools::getValue('ptm_quickview')));
			Configuration::updateValue('PTM_LISTBUTTONS', pSQL(Tools::getValue('ptm_listbuttons')));
			Configuration::updateValue('PTM_HOMEBUTTONS', pSQL(Tools::getValue('ptm_homebuttons')));
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		if (Tools::isSubmit('submitStyle')) {
			Configuration::updateValue('PTM_GOOGLEFONT', pSQL(Tools::getValue('ptm_googlefont')));
			if (Tools::getValue('ptm_basefontfamily') AND Validate::isName(Tools::getValue('ptm_basefontfamily')))
				Configuration::updateValue('PTM_BASEFONTFAMILY', pSQL(Tools::getValue('ptm_basefontfamily')));
			else
				$this->_html .= $this->displayError($this->l('Invalid base font family'));
			if (Tools::getValue('ptm_altfontfamily') AND Validate::isName(Tools::getValue('ptm_altfontfamily')))
				Configuration::updateValue('PTM_ALTFONTFAMILY', pSQL(Tools::getValue('ptm_altfontfamily')));
			else
				$this->_html .= $this->displayError($this->l('Invalid alt font family'));
			if (Tools::getValue('ptm_pricesfontfamily') AND Validate::isName(Tools::getValue('ptm_pricesfontfamily')))
				Configuration::updateValue('PTM_PRICESFONTFAMILY', pSQL(Tools::getValue('ptm_pricesfontfamily')));
			else
				$this->_html .= $this->displayError($this->l('Invalid prices font family'));
			if (Tools::getValue('ptm_basefontsize') AND Validate::isInt(Tools::getValue('ptm_basefontsize')))
				Configuration::updateValue('PTM_BASEFONTSIZE', pSQL(Tools::getValue('ptm_basefontsize')));
			else
				$this->_html .= $this->displayError($this->l('Invalid base font size'));
			if (Tools::getValue('ptm_altfontsize') AND Validate::isInt(Tools::getValue('ptm_altfontsize')))
				Configuration::updateValue('PTM_ALTFONTSIZE', pSQL(Tools::getValue('ptm_altfontsize')));
			else
				$this->_html .= $this->displayError($this->l('Invalid alt font size'));
			if (Tools::getValue('ptm_pricesfontsize') AND Validate::isInt(Tools::getValue('ptm_pricesfontsize')))
				Configuration::updateValue('PTM_PRICESFONTSIZE', pSQL(Tools::getValue('ptm_pricesfontsize')));
			else
				$this->_html .= $this->displayError($this->l('Invalid prices font size'));
			if (Tools::getValue('ptm_basecolor'))
				Configuration::updateValue('PTM_BASECOLOR', pSQL(Tools::getValue('ptm_basecolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid base color'));
			if (Tools::getValue('ptm_altcolor'))
				Configuration::updateValue('PTM_ALTCOLOR', pSQL(Tools::getValue('ptm_altcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid alt color'));
			if (Tools::getValue('ptm_basefontcolor'))
				Configuration::updateValue('PTM_BASEFONTCOLOR', pSQL(Tools::getValue('ptm_basefontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid base font color'));
			if (Tools::getValue('ptm_pricesfontcolor'))
				Configuration::updateValue('PTM_PRICESFONTCOLOR', pSQL(Tools::getValue('ptm_pricesfontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid prices font color'));

			if (file_exists(dirname(__FILE__).'/theme/less/theme-global.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-global.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/theme-responsive.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-responsive.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache');
		
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcart.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcart.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered-15.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocklayered-15.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockstore.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockstore.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocktags.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocktags.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-crossselling.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling-css.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-crossselling-css.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-editorial.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-editorial.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-editorial-css.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-editorial-css.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-homeslider.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider-16.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-homeslider-16.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-productcomments.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-productcomments.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-productscategory.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory-css.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-productscategory-css.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache');
			
			if (file_exists(dirname(__FILE__).'/theme/install/modules-install.php'))
				require_once(dirname(__FILE__).'/theme/install/modules-install.php');

			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		if (Tools::isSubmit('submitCSS')) {
			if ($this->putFileContents())
				$this->_html .= $this->displayConfirmation($this->l('CSS file updated'));
			else
				$this->_html .= $this->displayError($this->l('No CSS file selected'));
		}
		if (Tools::isSubmit('submitCache')) {
			if (file_exists(dirname(__FILE__).'/theme/less/theme-global.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-global.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/theme-responsive.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-responsive.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/theme-maintenance.less.cache');
		
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockbestsellers.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcart.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcart.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcontact.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockcurrencies.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocklanguages.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocklayered.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocklayered-15.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocklayered-15.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocknewproducts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocknewsletter.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockreinsurance.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocksearch.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockspecials.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockstore.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockstore.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocktags.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocktags.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blocktopmenu.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockuserinfo.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockviewed.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-blockwishlist.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-carriercompare.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-crossselling.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-crossselling-css.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-crossselling-css.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-editorial.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-editorial.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-editorial-css.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-editorial-css.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-favoriteproducts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-homeslider.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-homeslider-16.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-homeslider-16.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-mailalerts.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-productcomments.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-productcomments.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-productscategory.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-productscategory-css.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-productscategory-css.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-sendtoafriend.less.cache');
			if (file_exists(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache'))
				unlink(dirname(__FILE__).'/theme/less/module-themeconfigurator.less.cache');
			
			if (file_exists(dirname(__FILE__).'/theme/install/modules-install.php'))
				require_once(dirname(__FILE__).'/theme/install/modules-install.php');
			
			$this->_html .= $this->displayConfirmation($this->l('Module cache cleared'));
		}
		$this->displayForm();
		return $this->_html;
	}

	public function displayForm()
	{
		global $cookie;
		$iso = Language::getIsoById((int)($cookie->id_lang));
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$this->_html .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'admin/css/admin.css" />
		<link rel="stylesheet" type="text/css" href="'.$this->_path.'admin/colorpicker/css/colorpicker.css" />
		<script type="text/javascript" src="'.$this->_path.'admin/js/admin.js"></script>
		<script type="text/javascript" src="'.$this->_path.'admin/colorpicker/js/colorpicker.js"></script>
		<div id="tab_container">
			<script type="text/javascript">var id_tab = '.'1'.';changeTab(id_tab);</script>
			<ul class="tabs">
				<li id="tab_1" class="tab active" onclick="changeTab(1);">'.$this->l('General configuration').'</li>
				<li id="tab_2" class="tab" onclick="changeTab(2);">'.$this->l('Graphical configuration').'</li>
				<li id="tab_3" class="tab" onclick="changeTab(3);">'.$this->l('CSS Editor').'</li>
			</ul>
			<div id="content_1" class="content" style="display:block">';
				$this->configGeneral();
			$this->_html .= '</div>
			<div id="content_2" class="content" style="display:none">';
				$this->configStyle();
			$this->_html .= '</div>
			<div id="content_3" class="content" style="display:none">';
				$this->configCSS();
			$this->_html .= '</div>
		</div>';
		
		$isoTinyMCE = (file_exists(_PS_ROOT_DIR_.'/js/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en');
		$ad = dirname($_SERVER["PHP_SELF"]);
		$this->_html .= '<script type="text/javascript">	
			var iso = \''.$isoTinyMCE.'\' ;
			var pathCSS = \''._THEME_CSS_DIR_.'\' ;
			var ad = \''.$ad.'\' ;
		</script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tiny_mce/tiny_mce.js"></script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce.inc.js"></script>';
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$this->_html .= '<script type="text/javascript">
				$(document).ready(function(){
					tinySetup({
						theme_advanced_buttons1 : "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
						theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,,|,forecolor,backcolor",
						theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,|,ltr,rtl,|,fullscreen",
						theme_advanced_buttons4 : "styleprops,|,cite,abbr,acronym,del,ins,attribs,pagebreak",
						theme_advanced_resizing : false
					});
				});
			</script>';
		}
	}
	
	public function configGeneral()
	{
		global $cookie;
		$base_admin_uri = is_dir($_SERVER['REQUEST_URI']);
		$languages = Language::getLanguages();
		$this->_html .= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<h3>'.$this->l('Useful links for theme configuration').'</h3>
				<div class="block mini">
					<label>'.$this->l('Logo configuration').'</label>
					<div class="lnkContainer">
						<a class="lnk" target="_blank" href="'.$base_admin_uri.'?tab=AdminThemes&token='.Tools::getAdminToken('AdminThemes'.intval(Tab::getIdFromClassName('AdminThemes')).intval($cookie->id_employee)).'">'.$this->l('Configure logo').'</a>
					</div>
					<p>'.$this->l('Link towards the logo configuration space').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Theme translations').'</label>
					<div class="lnkContainer">';
						foreach ($languages as $language) {
							if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
								$this->_html .= '<a target="_blank" style="margin-right:5px" href="'.$base_admin_uri.'?lang='.$language['iso_code'].'&tab=AdminTranslations&token='.Tools::getAdminToken('AdminTranslations'.intval(Tab::getIdFromClassName('AdminTranslations')).intval($cookie->id_employee)).'&type=front&theme='.Configuration::get('PTM_THEMEPATH').'"><img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" /></a>';
							else
								$this->_html .= '<a target="_blank" style="margin-right:5px" href="'.$base_admin_uri.'?lang='.$language['iso_code'].'&tab=AdminTranslations&token='.Tools::getAdminToken('AdminTranslations'.intval(Tab::getIdFromClassName('AdminTranslations')).intval($cookie->id_employee)).'&type=front&theme_name='.Configuration::get('PTM_THEMEPATH').'"><img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" /></a>';
						}
					$this->_html .= '</div>
					<p>'.$this->l('Link towards the theme translation space').'</p>
				</div>
				<div class="block mini">
					<label>'.$this->l('Images configuration').'</label>
					<div class="lnkContainer">
						<a class="lnk" target="_blank" href="'.$base_admin_uri.'?tab=AdminImages&token='.Tools::getAdminToken('AdminImages'.intval(Tab::getIdFromClassName('AdminImages')).intval($cookie->id_employee)).'">'.$this->l('Configure images').'</a>
					</div>
					<p>'.$this->l('Link towards the images configuration space').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Modules configuration').'</label>
					<div class="lnkContainer">
						<a class="lnk" target="_blank" href="'.$base_admin_uri.'?tab=AdminModules&token='.Tools::getAdminToken('AdminModules'.intval(Tab::getIdFromClassName('AdminModules')).intval($cookie->id_employee)).'">'.$this->l('Configure modules').'</a>
					</div>
					<p>'.$this->l('Link towards the modules configuration space').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Modules positions').'</label>
					<div class="lnkContainer">
						<a class="lnk" target="_blank" href="'.$base_admin_uri.'?tab=AdminModulesPositions&token='.Tools::getAdminToken('AdminModulesPositions'.intval(Tab::getIdFromClassName('AdminModulesPositions')).intval($cookie->id_employee)).'">'.$this->l('Configure modules positions').'</a>
					</div>
					<p>'.$this->l('Link towards the modules positions configuration space').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Theme modules translations').'</label>
					<div class="lnkContainer">';
						foreach ($languages as $language) {
							if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
								$this->_html .= '<a target="_blank" style="margin-right:5px" href="'.$base_admin_uri.'index.php?tab=AdminTranslations&lang='.$language['iso_code'].'&type=modules&theme='.Configuration::get('PTM_THEMEPATH').'&token='.Tools::getAdminToken('AdminTranslations'.intval(Tab::getIdFromClassName('AdminTranslations')).intval($cookie->id_employee)).'"><img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" /></a>';
							else
								$this->_html .= '<a target="_blank" style="margin-right:5px" href="'.$base_admin_uri.'index.php?tab=AdminTranslations&lang='.$language['iso_code'].'&type=modules&token='.Tools::getAdminToken('AdminTranslations'.intval(Tab::getIdFromClassName('AdminTranslations')).intval($cookie->id_employee)).'#'.Configuration::get('PTM_THEMEPATH').'"><img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" /></a>';
						}
					$this->_html .= '</div>
					<p>'.$this->l('Link towards the theme modules translation space').'</p>
				</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('General configuration options').'</h3>
				<div class="block mini high">
					<label>'.$this->l('Activate responsive mode').'</label>
					<div class="inputContainer">
						<input type="radio" name="ptm_responsive" value="1" '.(Configuration::get('PTM_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ptm_responsive" value="0" '.(!Configuration::get('PTM_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the responsive mode is activated or not').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Columns layout').'</label>
					<div class="inputContainer">
						<input type="radio" name="ptm_column" value="1" '.(Configuration::get('PTM_COLUMN') ? 'checked="checked"' : '').' />'.$this->l('Left column').'
						<input type="radio" name="ptm_column" value="0" '.(!Configuration::get('PTM_COLUMN') ? 'checked="checked"' : '').' />'.$this->l('Right column').'
					</div>
					<p>'.$this->l('Set the columns layout (applicable only to two columns themes)').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Products lists display').'</label>
					<div class="inputContainer">
						<input type="radio" name="ptm_listdisplay" value="1" '.(Configuration::get('PTM_LISTDISPLAY') ? 'checked="checked"' : '').' />'.$this->l('Grid').'
						<input type="radio" name="ptm_listdisplay" value="0" '.(!Configuration::get('PTM_LISTDISPLAY') ? 'checked="checked"' : '').' />'.$this->l('List').'
					</div>
					<p>'.$this->l('Set the default products lists display type').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Enable products quick view').'</label>
					<div class="inputContainer">
						<input type="radio" name="ptm_quickview" value="1" '.(Configuration::get('PTM_QUICKVIEW') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ptm_quickview" value="0" '.(!Configuration::get('PTM_QUICKVIEW') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the products quick view is enabled or not').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Display products lists buttons').'</label>
					<div class="inputContainer">
						<input type="radio" name="ptm_listbuttons" value="1" '.(Configuration::get('PTM_LISTBUTTONS') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ptm_listbuttons" value="0" '.(!Configuration::get('PTM_LISTBUTTONS') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the products lists buttons are displayed or not').'</p>
				</div>
				<div class="block mini high">
					<label>'.$this->l('Display featured products buttons').'</label>
					<div class="inputContainer">
						<input type="radio" name="ptm_homebuttons" value="1" '.(Configuration::get('PTM_HOMEBUTTONS') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="ptm_homebuttons" value="0" '.(!Configuration::get('PTM_HOMEBUTTONS') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the featured products buttons are displayed or not').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitGeneral" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function configStyle()
	{
		$googleFontsSerialized = file_get_contents('http://phat-reaction.com/googlefonts.php?format=php');
		$googleFontsArray = unserialize($googleFontsSerialized);
		$this->_html .= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<h3>'.$this->l('Graphical configuration options').'</h3>
				<div class="block high">
					<label>'.$this->l('Import Google Web Font').'</label>
					<span class="label">'.$this->l('Imported font').' :</span>
					<select name="ptm_googlefont" id="ptm_googlefont" onchange="fontPreview();">';
						foreach ($googleFontsArray as $googleFont) {
							$this->_html .= '<option value="'.$googleFont['css-name'].'" '.($googleFont['css-name'] == Configuration::get('PTM_GOOGLEFONT') ? 'selected="selected"' : '').'>'.$googleFont['font-name'].'</option>';
						}
					$this->_html .= '</select>
					<div style="height:20px;line-height:20px;margin:8px 0 10px 5px">
						<link id="googleFontLink" href="http://fonts.googleapis.com/css?family='.Configuration::get('PTM_GOOGLEFONT').'" rel="stylesheet" type="text/css" />
						<span id="googleFontPreview" style="font-family:'.str_replace("+", " ", Configuration::get('PTM_GOOGLEFONT')).';font-size:16px;font-weight:300">'.str_replace("+", " ", Configuration::get('PTM_GOOGLEFONT')).'</span>
					</div>
					<p>'.$this->l('Import a Google Web Font to be able to use it in the shop').'</p>
				</div>
				<div class="block small higher">
					<label>'.$this->l('Fonts family').'</label>
					<span class="label">'.$this->l('Base font').' :</span>
					<input type="text" size="16" name="ptm_basefontfamily" value="'.Configuration::get('PTM_BASEFONTFAMILY').'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Alt font').' :</span>
					<input type="text" size="16" name="ptm_altfontfamily" value="'.Configuration::get('PTM_ALTFONTFAMILY').'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Prices font').' :</span>
					<input type="text" size="16" name="ptm_pricesfontfamily" value="'.Configuration::get('PTM_PRICESFONTFAMILY').'" />
					<p>'.$this->l('Set the family of the theme fonts').'</p>
				</div>
				<div class="block small higher">
					<label>'.$this->l('Fonts size').'</label>
					<span class="label">'.$this->l('Base font').' :</span>
					<input type="text" size="4" maxlength="2" name="ptm_basefontsize" value="'.Configuration::get('PTM_BASEFONTSIZE').'" /><span class="unity">px</span>
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Alt font').' :</span>
					<input type="text" size="4" maxlength="2" name="ptm_altfontsize" value="'.Configuration::get('PTM_ALTFONTSIZE').'" /><span class="unity">px</span>
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Prices font').' :</span>
					<input type="text" size="4" maxlength="2" name="ptm_pricesfontsize" value="'.Configuration::get('PTM_PRICESFONTSIZE').'" /><span class="unity">px</span>
					<p>'.$this->l('Set the size of the theme fonts').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Theme colors').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Base color').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ptm_basecolor" value="'.Configuration::get('PTM_BASECOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('PTM_BASECOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Alt color').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ptm_altcolor" value="'.Configuration::get('PTM_ALTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('PTM_ALTCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the base color and the alt color of the theme').'</p>
				</div>
				<div class="block small high">
					<label>'.$this->l('Fonts colors').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Base font').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ptm_basefontcolor" value="'.Configuration::get('PTM_BASEFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('PTM_BASEFONTCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Prices font').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="ptm_pricesfontcolor" value="'.Configuration::get('PTM_PRICESFONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('PTM_PRICESFONTCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the color of the theme fonts').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitStyle" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function configCSS()
	{
		$dir = dirname(__FILE__)."/theme/less/";
        $files = scandir($dir) ;
        $cnt = count($files) ;
        $this->_html .= '<script type="text/javascript">var baseDir = "'.$this->_path.'theme/less/";</script>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<h3>'.$this->l('Warning').'</h3>
				<div class="warning">'.$this->l('Editing CSS file is only for experienced users. Edit these files only if you know what you are doing.').'<br />'.$this->l('Do not use any accent when you modify those CSS files, even in the comments.').'</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('List of CSS files (LESS files)').'</h3>
				<div style="max-width:350px;height:245px;overflow:auto;margin-top:10px">
					<table class="table" style="margin-top:0">
						<th>'.$this->l('Filename').'</th>
						<th class="center">'.$this->l('Edit').'</th>';
						for ($i = 0; $i < $cnt; $i++)
							if (preg_match('/.less$/', $files[$i])) {
								$link = '<a href="#editor" onclick="loadFile('.$i.');">';
								$link .= '<img src="'._PS_ADMIN_IMG_.'edit.gif" /></a>
								<input type="hidden" name="fileId" id="fileId" value="'.$i.'" />
								<input type="hidden" name="fileName_'.$i.'" id="fileName_'.$i.'" value="'.$files[$i].'" />';
								$this->_html .= '<tr>
									<td>'.$files[$i].'</td>
									<td class="center">'.$link.'</td>
								</tr>';
							}
					$this->_html .= '</table>
				</div>
				<div>';
					$this->_html .= '<div id="editor">
						<textarea class="rte" cols="80" rows="30" id="contentCSS" name="contentCSS"></textarea>
						<input type="hidden" name="fileName" id="fileName" value="" />
					</div>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitCSS" value="'.$this->l('Update the CSS file').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function putFileContents()
    {
        $filename = Tools::getValue('fileName');
		$file = dirname(__FILE__)."/theme/less/".$filename;
		$balises = array('<br />', '<p>', '</p>');
		$replace = array("\n", "", "");
		$data = str_replace($balises, $replace, Tools::getValue('contentCSS'));
        $contents = htmlspecialchars_decode($data);
        if ($filename) {
			file_put_contents($file,$contents);
			return true;
		}
		else
			return false;
    }

	public function cacheCompileLess($inputFile, $outputFile) {
		if (!class_exists('lessc'))
			require_once dirname(__FILE__).'/lessc.inc.php';
		
		$cacheFile = $inputFile.'.cache';
		if (file_exists($cacheFile))
			$cache = unserialize(file_get_contents($cacheFile));
		else
			$cache = $inputFile;

		$less = new lessc;
		$less->setVariables(array(
			'ptm_basefontfamily' => Configuration::get('PTM_BASEFONTFAMILY'),
			'ptm_altfontfamily' => Configuration::get('PTM_ALTFONTFAMILY'),
			'ptm_pricesfontfamily' => Configuration::get('PTM_PRICESFONTFAMILY'),
			'ptm_basefontsize' => Configuration::get('PTM_BASEFONTSIZE').'px',
			'ptm_altfontsize' => Configuration::get('PTM_ALTFONTSIZE').'px',
			'ptm_pricesfontsize' => Configuration::get('PTM_PRICESFONTSIZE').'px',
			'ptm_basecolor' => '#'.Configuration::get('PTM_BASECOLOR'),
			'ptm_altcolor' => '#'.Configuration::get('PTM_ALTCOLOR'),
			'ptm_basefontcolor' => '#'.Configuration::get('PTM_BASEFONTCOLOR'),
			'ptm_pricesfontcolor' => '#'.Configuration::get('PTM_PRICESFONTCOLOR')
		));
		
		$less->setFormatter("classic");
		$newCache = $less->cachedCompile($cache);

		if (!is_array($cache) || $newCache['updated'] > $cache['updated']) {
			file_put_contents($cacheFile, serialize($newCache));
			file_put_contents($outputFile, $newCache['compiled']);
		}
	}

	public function hookHeader($params)
	{
		global $smarty;
		$smarty->assign(array(
			'ptm_responsive' => Configuration::get('PTM_RESPONSIVE'),
			'ptm_column' => Configuration::get('PTM_COLUMN'),
			'ptm_listdisplay' => Configuration::get('PTM_LISTDISPLAY'),
			'ptm_quickview' => Configuration::get('PTM_QUICKVIEW'),
			'ptm_listbuttons' => Configuration::get('PTM_LISTBUTTONS'),
			'ptm_homebuttons' => Configuration::get('PTM_HOMEBUTTONS'),
			'ptm_googlefont' => Configuration::get('PTM_GOOGLEFONT')
		));
		
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$smarty->assign(array('HOOK_TOP_COLUMN' => Hook::exec('topColumn')));
		else
			$smarty->assign(array('HOOK_TOP_COLUMN' => Module::hookExec('topColumn')));
		
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/theme-global.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/global.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/theme-responsive.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/responsive.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/theme-maintenance.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/maintenance.css');
		
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockbestsellers.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockbestsellers/blockbestsellers.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockcart.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockcart/blockcart.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockcontact.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockcontact/blockcontact.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockcurrencies.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockcurrencies/blockcurrencies.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocklanguages.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blocklanguages/blocklanguages.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocklayered.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blocklayered/blocklayered.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocklayered-15.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blocklayered/blocklayered-15.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockmyaccountfooter.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockmyaccountfooter/blockmyaccount.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocknewproducts.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blocknewproducts/blocknewproducts.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocknewsletter.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blocknewsletter/blocknewsletter.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockpermanentlinks.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockpermanentlinks/blockpermanentlinks.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockreinsurance.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockreinsurance/style.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocksearch.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blocksearch/blocksearch.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockspecials.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockspecials/blockspecials.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockstore.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockstore/blockstore.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocktags.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blocktags/blocktags.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blocktopmenu.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blocktopmenu/css/superfish-modified.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockuserinfo.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockuserinfo/blockuserinfo.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockviewed.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockviewed/blockviewed.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-blockwishlist.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/blockwishlist/blockwishlist.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-carriercompare.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/carriercompare/style.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-crossselling.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/crossselling/crossselling.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-crossselling-css.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/crossselling/css/crossselling.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-editorial.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/editorial/editorial.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-editorial-css.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/editorial/css/editorial.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-favoriteproducts.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/favoriteproducts/favoriteproducts.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-homeslider.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/homeslider/bx_styles.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-homeslider-16.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/homeslider/homeslider.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-mailalerts.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/mailalerts/mailalerts.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-productcomments.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/productcomments/productcomments.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-productscategory.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/productscategory/productscategory.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-productscategory-css.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/productscategory/css/productscategory.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-sendtoafriend.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/sendtoafriend/sendtoafriend.css');
		$this->cacheCompileLess(dirname(__FILE__).'/theme/less/module-themeconfigurator.less', _PS_ALL_THEMES_DIR_.''.Configuration::get('PTM_THEMEPATH').'/css/modules/themeconfigurator/css/hooks.css');
		
		if (file_exists(dirname(__FILE__).'/theme/install/modules-compile.php'))
			require_once(dirname(__FILE__).'/theme/install/modules-compile.php');
	}
}