<?php

/* -----------------------------------------
   Module Prestashop PrettySlider
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ----------------------------------------- */

class PrettySlider extends Module
{
 	public function __construct()
 	{
		$this->name = 'prettyslider';
		$this->tab = 'front_office_features';
		$this->version = '2.3';
		$this->author = 'PRESTACREA';
		$this->module_key = '30a4dfc6828d7e94839dd9badaaeb9e2';
		
		$this->bootstrap = true;
		$this->need_instance = 0;
		parent::__construct();

		$this->displayName = ('PRESTACREA - Pretty Slider');
		$this->description = $this->l('Adds a slideshow with texts and links on your homepage');
		$this->confirmUninstall = $this->l('Uninstalling the module will delete all its data. Do you want to continue uninstalling the module ?');
 	}

 	public function install()
 	{
		if (file_exists(dirname(__FILE__).'/install/prettyslider-install.php'))
			require_once(dirname(__FILE__).'/install/prettyslider-install.php');
		
		if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
			unlink(dirname(__FILE__).'/css/less/default.less.cache');
		if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
			unlink(dirname(__FILE__).'/css/less/responsive.less.cache');
		
		if (!parent::install() 
		OR !$this->registerHook('header') 
		OR !$this->registerHook('home'))
			return false;
		return true;
  	}

	public function uninstall()
	{
		if (file_exists(dirname(__FILE__).'/install/prettyslider-uninstall.php'))
			require_once(dirname(__FILE__).'/install/prettyslider-uninstall.php');
		
		if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
			unlink(dirname(__FILE__).'/css/less/default.less.cache');
		if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
			unlink(dirname(__FILE__).'/css/less/responsive.less.cache');
		
		if (!parent::uninstall())
			return false;
		return true;
	}

	public function addSlide()
	{
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'prettyslider VALUES ()') OR !$lastId = Db::getInstance()->Insert_ID())
				return false;
			$id_shop = $this->context->shop->id;
			foreach ($languages as $language) {
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$subtitle = Tools::getValue('subtitle_'.$language['id_lang']) ? Tools::getValue('subtitle_'.$language['id_lang']) : Tools::getValue('subtitle_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				$active = Tools::getValue('active_'.$defaultLanguage);
				if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'prettyslider_lang VALUES ('.$lastId.', \''.(int)$id_shop.'\', '.$language['id_lang'].', \''.addslashes($title).'\', \''.addslashes($subtitle).'\', \''.addslashes($link).'\', \''.addslashes($position).'\', \''.addslashes($active).'\')'))
					return false;
			}
			if (isset($_FILES['slide_img']) AND isset($_FILES['slide_img']['tmp_name']) AND !empty($_FILES['slide_img']['tmp_name'])) {
				Configuration::set('PS_IMAGE_GENERATION_METHOD', 0);
				if (!copy($_FILES['slide_img']['tmp_name'], dirname(__FILE__).'/img/slide_img_'.$lastId.'_'.(int)$id_shop.'.png'))
					$this->_html .= $this->displayError($this->l('An error occurred during the image upload'));
			}
			return true;
		}
		else {
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'prettyslider VALUES ()') OR !$lastId = mysql_insert_id())
				return false;
			foreach ($languages as $language) {
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$subtitle = Tools::getValue('subtitle_'.$language['id_lang']) ? Tools::getValue('subtitle_'.$language['id_lang']) : Tools::getValue('subtitle_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				$active = Tools::getValue('active_'.$defaultLanguage);
				if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'prettyslider_lang VALUES ('.$lastId.', "1", '.$language['id_lang'].', \''.addslashes($title).'\' , \''.addslashes($subtitle).'\', \''.addslashes($link).'\', \''.addslashes($position).'\', \''.addslashes($active).'\')'))
				return false;
			}
			if (isset($_FILES['slide_img']) AND isset($_FILES['slide_img']['tmp_name']) AND !empty($_FILES['slide_img']['tmp_name'])) {
				Configuration::set('PS_IMAGE_GENERATION_METHOD', 0);
				if (!copy($_FILES['slide_img']['tmp_name'], dirname(__FILE__).'/img/slide_img_'.$lastId.'_1.png'))
					$this->_html .= $this->displayError($this->l('An error occurred during the image upload'));
			}
			return true;
		}
	}

	public function editSlide()
	{
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			foreach ($languages as $language) {
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$subtitle = Tools::getValue('subtitle_'.$language['id_lang']) ? Tools::getValue('subtitle_'.$language['id_lang']) : Tools::getValue('subtitle_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				$active = Tools::getValue('active_'.$defaultLanguage);
				$id_slide = (int)(Tools::getValue('id'));
				if (!Db::getInstance()->Execute('REPLACE '._DB_PREFIX_.'prettyslider_lang VALUES (\''.($id_slide).'\', \''.(int)$id_shop.'\', \''.$language['id_lang'].'\', \''.addslashes($title).'\', \''.addslashes($subtitle).'\', \''.addslashes($link).'\', \''.addslashes($position).'\', \''.addslashes($active).'\')'))
					return false;
			}
			if (isset($_FILES['slide_img']) AND isset($_FILES['slide_img']['tmp_name']) AND !empty($_FILES['slide_img']['tmp_name'])) {
				Configuration::set('PS_IMAGE_GENERATION_METHOD', 0);
				if (!copy($_FILES['slide_img']['tmp_name'], dirname(__FILE__).'/img/slide_img_'.$id_slide.'_'.(int)$id_shop.'.png'))
					$this->_html .= $this->displayError($this->l('An error occurred during the image upload'));
			}
			return true;
		}
		else {
			foreach ($languages as $language) {
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$subtitle = Tools::getValue('subtitle_'.$language['id_lang']) ? Tools::getValue('subtitle_'.$language['id_lang']) : Tools::getValue('subtitle_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				$active = Tools::getValue('active_'.$defaultLanguage);
				$id_slide = (int)(Tools::getValue('id'));
				if (!Db::getInstance()->Execute('REPLACE '._DB_PREFIX_.'prettyslider_lang VALUES (\''.($id_slide).'\', "1", \''.$language['id_lang'].'\', \''.addslashes($title).'\', \''.addslashes($subtitle).'\', \''.addslashes($link).'\', \''.addslashes($position).'\', \''.addslashes($active).'\')'))
					return false;
			}
			if (isset($_FILES['slide_img']) AND isset($_FILES['slide_img']['tmp_name']) AND !empty($_FILES['slide_img']['tmp_name'])) {
				Configuration::set('PS_IMAGE_GENERATION_METHOD', 0);
				if (!copy($_FILES['slide_img']['tmp_name'], dirname(__FILE__).'/img/slide_img_'.$id_slide.'_1.png'))
					$this->_html .= $this->displayError($this->l('An error occurred during the image upload'));
			}
			return true;
		}
	}

	public function deleteSlide()
	{
		$id_slide = (int)(Tools::getValue('id'));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			@unlink (dirname(__FILE__).'/img/slide_img_'.$id_slide.'_'.(int)$id_shop.'.png');
		}
		else
			@unlink (dirname(__FILE__).'/img/slide_img_'.$id_slide.'_1.png');
		if (Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'prettyslider WHERE `id_slide`='.$id_slide))
			return Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'prettyslider_lang WHERE `id_slide`='.$id_slide);
		return false;
	}
	
	public function getEditor($lang)
	{
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$result = Db::getInstance()->getRow('SELECT `editor` FROM '._DB_PREFIX_.'prettyslider_editor WHERE `id_shop`='.(int)$id_shop.' AND `id_lang`='.$lang))
				return false;
			return $result;
		}
		else {
			if (!$result = Db::getInstance()->getRow('SELECT `editor` FROM '._DB_PREFIX_.'prettyslider_editor WHERE `id_lang`='.$lang))
				return false;
			return $result;
		}
	}

	public function getContent()
	{
		$this->_html .= '<h2>'.$this->displayName.' - v.'.$this->version.'</h2>
		<div id="lnkDocContainer">
			<a class="lnk" target="_blank" href="'.$this->_path.'doc/documentation.pdf">'.$this->l('PDF documentation').'</a>
			<a class="lnk" target="_blank" href="'.$this->_path.'doc/changelog.txt">'.$this->l('Changelog').'</a>
		</div>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post"><input style="margin:0 0 20px;" type="submit" name="submitCache" value="'.$this->l('Clear module cache').'" class="button" /></form>';
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$position = Tools::getValue('position_'.$defaultLanguage);
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
		}
		if (Tools::isSubmit('submitGeneral')) {
			Configuration::updateValue('MPS_SCROLL', pSQL(Tools::getValue('mps_scroll')));
			Configuration::updateValue('MPS_EASING', pSQL(Tools::getValue('mps_easing')));
			if (Tools::getValue('mps_speed') AND Validate::isInt(Tools::getValue('mps_speed')))
				Configuration::updateValue('MPS_SPEED', pSQL(Tools::getValue('mps_speed')));
			else
				$this->_html .= $this->displayError($this->l('Invalid scroll speed'));
			Configuration::updateValue('MPS_AUTOSCROLL', pSQL(Tools::getValue('mps_autoscroll')));
			Configuration::updateValue('MPS_PAGINATION', pSQL(Tools::getValue('mps_pagination')));
			Configuration::updateValue('MPS_ARROWS', pSQL(Tools::getValue('mps_arrows')));
			Configuration::updateValue('MPS_RESPONSIVE', pSQL(Tools::getValue('mps_responsive')));
			Configuration::updateValue('MPS_EDITORIAL', pSQL(Tools::getValue('mps_editorial')));
			
			foreach ($languages as $language) {
				$editor = Tools::getValue('editor_'.$language['id_lang']) ? Tools::getValue('editor_'.$language['id_lang']) : Tools::getValue('editor_'.$defaultLanguage);
				if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'prettyslider_editor VALUES ('.$language['id_lang'].', \''.(int)$id_shop.'\', \''.addslashes($editor).'\')');
				else 
					Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'prettyslider_editor VALUES ('.$language['id_lang'].', "1", \''.addslashes($editor).'\')');
			}
			
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		elseif (Tools::isSubmit('submitAddSlide')) {
			if (empty($_FILES['slide_img']['tmp_name']))
				$this->_html .= $this->displayError($this->l('Slide image is required'));
			else {
				if (!$position OR $position <= 0 OR !Validate::isInt($position))
					$this->_html .= $this->displayError($this->l('Invalid position number'));
				else {
					if ($this->addSlide())
						$this->_html .= $this->displayConfirmation($this->l('The slide has been added successfully'));
					else
						$this->_html .= $this->displayError($this->l('An error occured during slide adding'));
				}
			}
		}
		elseif (Tools::isSubmit('submitEditSlide')) {
			if (!$position OR $position <= 0 OR !Validate::isInt($position))
				$this->_html .= $this->displayError($this->l('Invalid position number'));
			else {
				if (!Tools::getValue('id') OR !is_numeric(Tools::getValue('id')) OR !$this->editSlide())
					$this->_html .= $this->displayError($this->l('An error occured during slide editing'));
				else
					$this->_html .= $this->displayConfirmation($this->l('The slide has been edited successfully'));
			}
		}
		elseif (Tools::getValue('id')) {
			if (!is_numeric(Tools::getValue('id')) OR !$this->deleteSlide())
				$this->_html .= $this->displayError($this->l('An error occurred during slide deletion'));
			else
				$this->_html .= $this->displayConfirmation($this->l('The slide has been deleted successfully'));
		}
		if (Tools::isSubmit('submitStyle')) {
			Configuration::updateValue('MPS_INLINE', pSQL(Tools::getValue('mps_inline')));
			if (Tools::getValue('mps_height') AND Validate::isInt(Tools::getValue('mps_height')))
				Configuration::updateValue('MPS_HEIGHT', pSQL(Tools::getValue('mps_height')));
			else
				$this->_html .= $this->displayError($this->l('Invalid height'));
			if (Validate::isInt(Tools::getValue('mps_sliderwidth')))
				Configuration::updateValue('MPS_SLIDERWIDTH', pSQL(Tools::getValue('mps_sliderwidth')));
			else
				$this->_html .= $this->displayError($this->l('Invalid slideshow width'));
			if (Tools::getValue('mps_imgwidth') AND Validate::isInt(Tools::getValue('mps_imgwidth')))
				Configuration::updateValue('MPS_IMGWIDTH', pSQL(Tools::getValue('mps_imgwidth')));
			else
				$this->_html .= $this->displayError($this->l('Invalid images width'));
			if (Tools::getValue('mps_fontfamily') AND Validate::isName(Tools::getValue('mps_fontfamily')))
				Configuration::updateValue('MPS_FONTFAMILY', pSQL(Tools::getValue('mps_fontfamily')));
			else
				$this->_html .= $this->displayError($this->l('Invalid font family'));
			if (Tools::getValue('mps_fontsize') AND Validate::isInt(Tools::getValue('mps_fontsize')))
				Configuration::updateValue('MPS_FONTSIZE', pSQL(Tools::getValue('mps_fontsize')));
			else
				$this->_html .= $this->displayError($this->l('Invalid font size'));
			if (Tools::getValue('mps_maincolor'))
				Configuration::updateValue('MPS_MAINCOLOR', pSQL(Tools::getValue('mps_maincolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid main color'));
			if (Tools::getValue('mps_altcolor'))
				Configuration::updateValue('MPS_ALTCOLOR', pSQL(Tools::getValue('mps_altcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid alt color'));
			if (Tools::getValue('mps_fontcolor'))
				Configuration::updateValue('MPS_FONTCOLOR', pSQL(Tools::getValue('mps_fontcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid font color'));
			if (Tools::getValue('mps_sliderbgcolor'))
				Configuration::updateValue('MPS_SLIDERBGCOLOR', pSQL(Tools::getValue('mps_sliderbgcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid slideshow background color'));
			if (Tools::getValue('mps_captionbgcolor'))
				Configuration::updateValue('MPS_CAPTIONBGCOLOR', pSQL(Tools::getValue('mps_captionbgcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid caption background color'));
			if (Tools::getValue('mps_editorialbgcolor'))
				Configuration::updateValue('MPS_EDITORIALBGCOLOR', pSQL(Tools::getValue('mps_editorialbgcolor')));
			else
				$this->_html .= $this->displayError($this->l('Invalid editorial background color'));
			if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
				unlink(dirname(__FILE__).'/css/less/default.less.cache');
			if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
				unlink(dirname(__FILE__).'/css/less/responsive.less.cache');
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		}
		if (Tools::isSubmit('submitCSS')) {
			if ($this->putFileContents())
				$this->_html .= $this->displayConfirmation($this->l('CSS file updated'));
			else
				$this->_html .= $this->displayError($this->l('No CSS file selected'));
		}
		if (Tools::isSubmit('submitCache')) {
			if (file_exists(dirname(__FILE__).'/css/less/default.less.cache'))
				unlink(dirname(__FILE__).'/css/less/default.less.cache');
			if (file_exists(dirname(__FILE__).'/css/less/responsive.less.cache'))
				unlink(dirname(__FILE__).'/css/less/responsive.less.cache');
			$this->_html .= $this->displayConfirmation($this->l('Module cache cleared'));
		}
		$this->displayForm();
		return $this->_html;
    }
	
	public function displayForm()
	{
		global $cookie;
		$iso = Language::getIsoById((int)($cookie->id_lang));
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$this->_html .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'admin/css/admin.css" />
		<link rel="stylesheet" type="text/css" href="'.$this->_path.'admin/colorpicker/css/colorpicker.css" />
		<script type="text/javascript" src="'.$this->_path.'admin/js/admin.js"></script>
		<script type="text/javascript" src="'.$this->_path.'admin/colorpicker/js/colorpicker.js"></script>
		<div id="tab_container">
			<script type="text/javascript">var id_tab = '.'1'.';changeTab(id_tab);</script>
			<ul class="tabs">
				<li id="tab_1" class="tab active" onclick="changeTab(1);">'.$this->l('Slides configuration').'</li>
				<li id="tab_2" class="tab" onclick="changeTab(2);">'.$this->l('General configuration').'</li>
				<li id="tab_3" class="tab" onclick="changeTab(3);">'.$this->l('Graphical configuration').'</li>
				<li id="tab_4" class="tab" onclick="changeTab(4);">'.$this->l('CSS Editor').'</li>
			</ul>
			<div id="content_1" class="content" style="display:block">';
				$this->configSlides();
			$this->_html .= '</div>
			<div id="content_2" class="content" style="display:none">';
				$this->configGeneral();
			$this->_html .= '</div>
			<div id="content_3" class="content" style="display:none">';
				$this->configStyle();
			$this->_html .= '</div>
			<div id="content_4" class="content" style="display:none">';
				$this->configCSS();
			$this->_html .= '</div>
		</div>';
		
		$isoTinyMCE = (file_exists(_PS_ROOT_DIR_.'/js/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en');
		$ad = dirname($_SERVER["PHP_SELF"]);
		$this->_html .= '<script type="text/javascript">	
			var iso = \''.$isoTinyMCE.'\' ;
			var pathCSS = \''._THEME_CSS_DIR_.'\' ;
			var ad = \''.$ad.'\' ;
		</script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tiny_mce/tiny_mce.js"></script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce.inc.js"></script>';
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$this->_html .= '<script type="text/javascript">
				$(document).ready(function(){
					tinySetup({
						theme_advanced_buttons1 : "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
						theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,,|,forecolor,backcolor",
						theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,|,ltr,rtl,|,fullscreen",
						theme_advanced_buttons4 : "styleprops,|,cite,abbr,acronym,del,ins,attribs,pagebreak",
						theme_advanced_resizing : false
					});
				});
			</script>';
		}
	}
	public function configSlides()
	{
		global $cookie;
		$iso = Language::getIsoById((int)($cookie->id_lang));
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
		}
		$divLangName = 'title¤subtitle¤link';
		$this->_html .= '<script type="text/javascript">id_language = Number('.$defaultLanguage.');</script>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post" enctype="multipart/form-data">
			<fieldset>
				<h3 id="slideedit_h3">'.$this->l('Slides configuration').'</h3>
				<div id="slideedit" class="block auto block_item" style="margin-bottom:15px">
					<label>'.$this->l('Add or edit a slide').'</label>
					<span class="label label_items">'.$this->l('Position N&ordm;').' :</span>
					<div>';
						foreach ($languages as $language)
						$this->_html .= '<div id="position_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float:left">
							<input type="text" size="4" maxlength="2" name="position_'.$language['id_lang'].'" id="positionInput_'.$language['id_lang'].'" value="" />
						</div>';
					$this->_html .= '</div>
					<div class="clear"></div>
					<p class="legend_items">'.$this->l('Set the position of the slide').'</p>
					<div class="space"></div>
					<span class="label label_items">'.$this->l('Title').' :</span>
					<div>';
						foreach ($languages as $language)
						$this->_html .= '<div id="title_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
							<input type="text" size="20" name="title_'.$language['id_lang'].'" id="titleInput_'.$language['id_lang'].'" class="inputText float" value="" />
						</div>';
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'title', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p class="legend_items">'.$this->l('Set the title of the slide').'</p>
					<div class="space"></div>
					<span class="label label_items">'.$this->l('Subtitle').' :</span>
					<div>';
						foreach ($languages as $language)
						$this->_html .= '<div id="subtitle_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
							<input type="text" size="20" name="subtitle_'.$language['id_lang'].'" id="subtitleInput_'.$language['id_lang'].'" class="inputText float" value="" />
						</div>';
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'subtitle', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p class="legend_items">'.$this->l('Set the subtitle of the slide').'</p>
					<div class="space"></div>
					<span class="label label_items">'.$this->l('Image').' :</span>
					<input type="file" id="slide_img" name="slide_img" style="width:55%" />
					<div class="clear"></div>
					<img id="slide_image" class="imgPreview" src="" style="display:none"/>
					<p class="legend_items">'.$this->l('Set the image of the slide').'<br/>'.$this->l('Accepted formats :').' JPG, GIF, PNG</p>
					<div class="space"></div>
					<span class="label label_items">'.$this->l('Link').' :</span>
					<div>';
						foreach ($languages as $language)
						$this->_html .= '<div id="link_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'">
							<input type="text" size="20" name="link_'.$language['id_lang'].'" id="linkInput_'.$language['id_lang'].'" class="inputText float" value="" />
						</div>';
						$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'link', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p class="legend_items">'.$this->l('Set the link of the image').'</p>
					<div class="space"></div>
					<span class="label label_items">'.$this->l('Status').' :</span>
					<div>';
						foreach ($languages as $language)
						$this->_html .= '<div id="active_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float:left">
							<select name="active_'.$language['id_lang'].'" id="activeInput_'.$language['id_lang'].'">
								<option value="1">'.$this->l('Enabled').'</option>
								<option value="0">'.$this->l('Disabled').'</option>
							</select>
						</div>';
					$this->_html .= '</div>
					<div class="clear"></div>
					<p class="legend_items">'.$this->l('Set whether the slide is enabled or not').'</p>
					<div class="space"></div>';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
						$this->_html .= '<input type="hidden" name="ps_id_shop" id="ps_id_shop" value="'.(int)$id_shop.'" />';
					}
					else {
						$this->_html .= '<input type="hidden" name="ps_id_shop" id="ps_id_shop" value="1" />';
					}
					$this->_html .= '<input type="hidden" name="id" id="id" value="'.(Tools::getValue('id') ? Tools::getValue('id') : '').'" />
					<input type="submit" id="submitAddSlide" name="submitAddSlide" value="'.$this->l('Add this slide').'" class="button" />
					<input type="submit" id="submitEditSlide" name="submitEditSlide" value="'.$this->l('Edit this slide').'" class="button" style="display:none" />
				</div>
				<div class="block auto">';
					$this->listSlides();
				$this->_html .= '</div>
			</fieldset>
		</form>';
	}
	
	public function configGeneral()
	{
		global $cookie;
		$iso = Language::getIsoById((int)($cookie->id_lang));
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$divLangNameEditor = 'editor';
		$this->_html .= '<script type="text/javascript">id_language = Number('.$defaultLanguage.');</script>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post" enctype="multipart/form-data">
			<fieldset>
				<h3>'.$this->l('General configuration options').'</h3>
				<div class="block auto">
					<label>'.$this->l('Activate responsive mode').'</label>
					<div class="inputContainer">
						<input type="radio" name="mps_responsive" value="1" '.(Configuration::get('MPS_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="mps_responsive" value="0" '.(!Configuration::get('MPS_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the responsive mode is activated or not (the template used must be compatible, disable this option if the template is not responsive)').'</p>
				</div>
				<div class="block small higher">
					<label>'.$this->l('Slideshow scroll').'</label>
					<span class="label">'.$this->l('Transition type').' :</span>
					<select name="mps_scroll" id="mps_scroll">
						<option value="scroll" '.(Configuration::get('MPS_SCROLL') == "scroll" ? 'selected="selected"' : '').'>'.$this->l('Scroll').'</option>
						<option value="crossfade" '.(Configuration::get('MPS_SCROLL') == "crossfade" ? 'selected="selected"' : '').'>'.$this->l('Crossfade').'</option>
						<option value="cover" '.(Configuration::get('MPS_SCROLL') == "cover" ? 'selected="selected"' : '').'>'.$this->l('Cover').'</option>
						<option value="cover-fade" '.(Configuration::get('MPS_SCROLL') == "cover-fade" ? 'selected="selected"' : '').'>'.$this->l('Cover-fade').'</option>
						<option value="uncover" '.(Configuration::get('MPS_SCROLL') == "uncover" ? 'selected="selected"' : '').'>'.$this->l('Uncover').'</option>
						<option value="uncover-fade" '.(Configuration::get('MPS_SCROLL') == "uncover-fade" ? 'selected="selected"' : '').'>'.$this->l('Uncover-fade').'</option>
					</select>
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Effect').' :</span>
					<select name="mps_easing" id="mps_easing">
						<option value="swing" '.(Configuration::get('MPS_EASING') == "swing" ? 'selected="selected"' : '').'>'.$this->l('Swing').'</option>
						<option value="quadratic" '.(Configuration::get('MPS_EASING') == "quadratic" ? 'selected="selected"' : '').'>'.$this->l('Quadratic').'</option>
						<option value="cubic" '.(Configuration::get('MPS_EASING') == "cubic" ? 'selected="selected"' : '').'>'.$this->l('Cubic').'</option>
						<option value="elastic" '.(Configuration::get('MPS_EASING') == "elastic" ? 'selected="selected"' : '').'>'.$this->l('Elastic').'</option>
					</select>
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Speed').' :</span>
					<input type="text" size="4" maxlength="4" name="mps_speed" value="'.Configuration::get('MPS_SPEED').'" /><span class="unity">ms</span>
					<div class="spaceSmall" style="margin-top:8px"></div>
					<div class="inputContainer">
						<span class="label">'.$this->l('Automatic').' :</span>
						<input type="radio" name="mps_autoscroll" value="true" '.(Configuration::get('MPS_AUTOSCROLL') == "true" ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="mps_autoscroll" value="false" '.(Configuration::get('MPS_AUTOSCROLL') == "false" ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set the parameters of the slideshow scroll').'</p>
				</div>
				<div class="block small higher" style="margin-bottom:15px">
					<label>'.$this->l('Slideshow navigation').'</label>
					<div class="inputContainer">
						<span class="label" style="width:140px">'.$this->l('Display pagination').' :</span>
						<input type="radio" name="mps_pagination" value="1" '.(Configuration::get('MPS_PAGINATION') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="mps_pagination" value="0" '.(!Configuration::get('MPS_PAGINATION') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<div class="inputContainer">
						<span class="label" style="width:140px">'.$this->l('Display arrows').' :</span>
						<input type="radio" name="mps_arrows" value="1" '.(Configuration::get('MPS_ARROWS') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="mps_arrows" value="0" '.(!Configuration::get('MPS_ARROWS') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the scroll arrows and the pagination are displayed or not').'</p>
				</div>
				<div class="block auto editor_block" style="clear:both">
					<label>'.$this->l('Editorial').'</label>
					<div class="inputContainer">
						<span class="label">'.$this->l('Display editorial').' :</span>
						<input type="radio" name="mps_editorial" value="1" '.(Configuration::get('MPS_EDITORIAL') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="mps_editorial" value="0" '.(!Configuration::get('MPS_EDITORIAL') ? 'checked="checked"' : '').' />'.$this->l('No').'
						<p style="margin-top:5px">'.$this->l('Set whether the editorial is displayed or not').'</p>
					</div>';
					foreach ($languages as $language) {
						$editor = $this->getEditor($language['id_lang']);
						$this->_html .= '<div id="editor_'.$language['id_lang'].'" class="editor_space" style="display:'.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';margin:4px">
							<textarea class="rte" cols="80" rows="30" id="editorInput_'.$language['id_lang'].'" name="editor_'.$language['id_lang'].'">'.$editor['editor'].'</textarea>
						</div>';
					}
					$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangNameEditor, 'editor', true);
					$this->_html .= '<div class="clear"></div>
					<div class="spaceSmall"></div>
					<p>'.$this->l('Insert the informations of your choice (Images, texts, links...)').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitGeneral" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function configStyle()
	{
		$this->_html .= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<h3>'.$this->l('Graphical configuration options').'</h3>
				<div class="block small higher" style="height:235px">
					<label>'.$this->l('Slideshow display').'</label>
					<div class="inputContainer">
						<span class="label">'.$this->l('Inline display').' :</span>
						<input type="radio" name="mps_inline" value="1" '.(Configuration::get('MPS_INLINE') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="mps_inline" value="0" '.(!Configuration::get('MPS_INLINE') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<span class="label">'.$this->l('Height').' :</span>
					<input type="text" size="4" maxlength="4" name="mps_height" value="'.Configuration::get('MPS_HEIGHT').'" /><span class="unity">px</span>
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Slideshow width').' :</span>
					<input type="text" size="4" maxlength="4" name="mps_sliderwidth" value="'.Configuration::get('MPS_SLIDERWIDTH').'" /><span class="unity">px</span>
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Images width').' :</span>
					<input type="text" size="4" maxlength="4" name="mps_imgwidth" value="'.Configuration::get('MPS_IMGWIDTH').'" /><span class="unity">px</span>
					<p>'.$this->l('Set whether the slideshow and the editorial are displayed inline or not, their height and the maximum width of the slideshow and of the images').'<br/>'.$this->l('Set the slideshow width to 0 for 100% width').'</p>
				</div>
				<div class="block small higher" style="height:235px">
					<label>'.$this->l('Global font style').'</label>
					<span class="label">'.$this->l('Font family').' :</span>
					<input type="text" size="16" name="mps_fontfamily" value="'.Configuration::get('MPS_FONTFAMILY').'" />
					<div class="spaceSmall"></div>
					<span class="label">'.$this->l('Font size').' :</span>
					<input type="text" size="4" maxlength="2" name="mps_fontsize" value="'.Configuration::get('MPS_FONTSIZE').'" /><span class="unity">px</span>
					<p>'.$this->l('Set the font family and the font size of the slideshow').'</p>
				</div>
				<div class="block small higher">
					<label>'.$this->l('Slideshow colors').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Main color').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="mps_maincolor" value="'.Configuration::get('MPS_MAINCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('MPS_MAINCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Alt color').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="mps_altcolor" value="'.Configuration::get('MPS_ALTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('MPS_ALTCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Font color').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="mps_fontcolor" value="'.Configuration::get('MPS_FONTCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('MPS_FONTCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the colors of the slideshow').'</p>
				</div>
				<div class="block small higher">
					<label>'.$this->l('Slideshow background color').'</label>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Slideshow').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="mps_sliderbgcolor" value="'.Configuration::get('MPS_SLIDERBGCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('MPS_SLIDERBGCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Caption').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="mps_captionbgcolor" value="'.Configuration::get('MPS_CAPTIONBGCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('MPS_CAPTIONBGCOLOR').'"></span>
					</div>
					<div class="spaceSmall"></div>
					<div class="colorpickerSelect">
						<span class="label">'.$this->l('Editorial').' :</span>
						<span class="unity colorpickerSign">#</span><input type="text" size="6" maxlength="6" class="colorpickerInput" name="mps_editorialbgcolor" value="'.Configuration::get('MPS_EDITORIALBGCOLOR').'" />
						<span class="colorpickerPreview" style="background:#'.Configuration::get('MPS_EDITORIALBGCOLOR').'"></span>
					</div>
					<p>'.$this->l('Set the background colors of the slideshow').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitStyle" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function configCSS()
	{
		$dir = dirname(__FILE__)."/css/less/";
        $files = scandir($dir) ;
        $cnt = count($files) ;
        $this->_html .= '<script type="text/javascript">var baseDir = "'.$this->_path.'css/less/";</script>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<h3>'.$this->l('Warning').'</h3>
				<div class="warning">'.$this->l('Editing CSS file is only for experienced users. Edit these files only if you know what you are doing.').'<br />'.$this->l('Do not use any accent when you modify those CSS files, even in the comments.').'</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('List of CSS files (LESS files)').'</h3>
				<table class="table">
					<th>'.$this->l('Filename').'</th>
					<th class="center">'.$this->l('Edit').'</th>';
					for ($i = 0; $i < $cnt; $i++)
						if (preg_match('/.less$/', $files[$i])) {
							$link = '<a href="#editor" onclick="loadFile('.$i.');">';
							$link .= '<img src="'._PS_ADMIN_IMG_.'edit.gif" /></a>
							<input type="hidden" name="fileId" id="fileId" value="'.$i.'"/>
							<input type="hidden" name="fileName_'.$i.'" id="fileName_'.$i.'" value="'.$files[$i].'"/>';
							$this->_html .= '<tr>
								<td>'.$files[$i].'</td>
								<td class="center">'.$link.'</td>
							</tr>';
						}
				$this->_html .= '</table>
				<div>';
					$this->_html .= '<div id="editor">
						<textarea class="rte" cols="80" rows="30" id="contentCSS" name="contentCSS"></textarea>
						<input type="hidden" name="fileName" id="fileName" value=""/>
					</div>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitCSS" value="'.$this->l('Update the CSS file').'" class="button" /></div>
			</fieldset>
		</form>';
	}
	
	public function putFileContents()
    {
        $filename = Tools::getValue('fileName');
		$file = dirname(__FILE__)."/css/less/".$filename;
		$balises = array('<br />', '<p>', '</p>');
		$replace = array("\n", "", "");
		$data = str_replace($balises, $replace, Tools::getValue('contentCSS'));
        $contents = htmlspecialchars_decode($data);
        if ($filename) {
			file_put_contents($file,$contents);
			return true;
		}
		else
			return false;
    }

	public function getSlides($id_lang = null)
	{
		global $cookie;
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$slides = Db::getInstance()->ExecuteS('SELECT p.`id_slide`, pl.`position` FROM `'._DB_PREFIX_.'prettyslider` p JOIN `'._DB_PREFIX_.'prettyslider_lang` pl ON (p.`id_slide` = pl.`id_slide` AND `id_shop`='.(int)$id_shop.' AND pl.`id_lang` = '.intval($cookie->id_lang).') ORDER BY `position`'))
				return false;
		}
		else {
			if (!$slides = Db::getInstance()->ExecuteS('SELECT p.`id_slide`, pl.`position` FROM `'._DB_PREFIX_.'prettyslider` p JOIN `'._DB_PREFIX_.'prettyslider_lang` pl ON (p.`id_slide` = pl.`id_slide` AND pl.`id_lang` = '.intval($cookie->id_lang).') ORDER BY `position`'))
				return false;
		}
		$i = 0;
		foreach ($slides as $slide) {
			$result[$i]['id'] = $slide['id_slide'];
			if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
				$sql = 'SELECT `id_lang`, `title`, `subtitle`, `link`, `position`, `active` FROM '._DB_PREFIX_.'prettyslider_lang WHERE `id_slide`='.(int)($slide['id_slide']).' AND `id_shop`='.(int)$id_shop;
			else
				$sql = 'SELECT `id_lang`, `title`, `subtitle`, `link`, `position`, `active` FROM '._DB_PREFIX_.'prettyslider_lang WHERE `id_slide`='.(int)($slide['id_slide']);
			if (isset($id_lang) AND is_numeric($id_lang) AND (int)($id_lang) > 0)
				$sql .= ' AND `id_lang` = '.(int)($id_lang);
			if (!$texts = Db::getInstance()->ExecuteS($sql))
				return false;
			foreach ($texts as $text) {
				$result[$i]['title_'.$text['id_lang']] = $text['title'];
				$result[$i]['subtitle_'.$text['id_lang']] = $text['subtitle'];
				$result[$i]['link_'.$text['id_lang']] = $text['link'];
				$result[$i]['position_'.$text['id_lang']] = $text['position'];
				$result[$i]['active_'.$text['id_lang']] = $text['active'];
			}
			$i++;
		}
		return $result;
	}

	public function listSlides()
	{
		$slides = $this->getSlides();
		global $currentIndex, $cookie, $adminObj;
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$token = Tools::safeOutput(Tools::getValue('token'));
		if ($slides) {
			$this->_html .= '<script type="text/javascript">
				var currentUrl = \''.$currentIndex.'&configure='.$this->name.'\';';
				if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					$this->_html .= 'var token=\''.$token.'\';';
				else
					$this->_html .= 'var token=\''.$adminObj->token.'\';';
				$this->_html .= 'var slides = new Array();';
				$var = '';
				foreach ($slides as $slide) {
					$var .= 'slides['.$slide['id'].'] = new Array(';
					$i = 0;
					foreach ($languages as $language) {
						if ($i > 0)
						$var .= ",";
						$var .= $language['id_lang'];
						$title = isset($slide['title_'.$language['id_lang']]) ? $slide['title_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes(html_entity_decode($title, ENT_QUOTES, 'UTF-8')).'\'';
						$subtitle = isset($slide['subtitle_'.$language['id_lang']]) ? $slide['subtitle_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes(html_entity_decode($subtitle, ENT_QUOTES, 'UTF-8')).'\'';
						$link = isset($slide['link_'.$language['id_lang']]) ? $slide['link_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($link).'\'';
						$position = isset($slide['position_'.$language['id_lang']]) ? $slide['position_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($position).'\'';
						$active = isset($slide['active_'.$language['id_lang']]) ? $slide['active_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($active).'\'';
						$i++;
					}
					$var .= ');';
				}
			$var .= '</script>';
			$this->_html .= $var;
		}

		if (!$slides)
			$this->_html .= '<p>'.$this->l('No slides').'</p>';
		else {
			$this->_html .= '<table class="table table_items">
				<tr>
					<th class="table_id center" style="width:30px">'.$this->l('ID').'</th>
					<th class="table_position center" style="width:60px">'.$this->l('Position').'</th>
					<th class="table_title" style="width:150px">'.$this->l('Title').'</th>
					<th class="table_subtitle" style="width:350px">'.$this->l('Subtitle').'</th>
					<th class="table_image">'.$this->l('Image').'</th>
					<th class="table_status center" style="width:60px">'.$this->l('Status').'</th>
					<th class="table_actions center" style="width:60px">'.$this->l('Actions').'</th>
				</tr>';
				$i = 0;
				foreach ($slides as $slide) {
					$title = isset($slide['title_'.$cookie->id_lang]) ? $slide['title_'.$cookie->id_lang] : $slide['title_'.$defaultLanguage];
					$subtitle = isset($slide['subtitle_'.$cookie->id_lang]) ? $slide['subtitle_'.$cookie->id_lang] : $slide['subtitle_'.$defaultLanguage];
					$link = isset($slide['link_'.$cookie->id_lang]) ? $slide['link_'.$cookie->id_lang] : $slide['link_'.$defaultLanguage];
					$position = isset($slide['position_'.$cookie->id_lang]) ? $slide['position_'.$cookie->id_lang] : $slide['position_'.$defaultLanguage];
					$active = isset($slide['active_'.$cookie->id_lang]) ? $slide['active_'.$cookie->id_lang] : $slide['active_'.$defaultLanguage];
					$this->_html .= '<tr'.($i % 2 ? ' class="alternate"' : '').'>
						<td class="table_id center">'.$slide['id'].'</td>
						<td class="table_position center">'.$position.'</td>
						<td class="table_title">'.$title.'</td>
						<td class="table_subtitle">'.$subtitle.'</td>';
						if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
							$id_shop = $this->context->shop->id;
							$this->_html .= '<td class="table_image"><img src="'.$this->_path.'img/slide_img_'.$slide['id'].'_'.(int)$id_shop.'.png" style="margin:5px;height:50px" /><p>'.$link.'</p></td>';
						}
						else {
							$this->_html .= '<td class="table_image"><img src="'.$this->_path.'img/slide_img_'.$slide['id'].'_1.png" style="margin:5px;height:50px" /><p>'.$link.'</p></td>';
						}
						$this->_html .= '<td class="table_status center">'.($active == 1 ? '<img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" />' : '<img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" />').'</td>
						<td class="table_actions center">
							<a href="#slideedit_h3"><img src="'._PS_ADMIN_IMG_.'edit.gif" onclick="slideEdit('.$slide['id'].')" style="padding:0" title="'.$this->l('Edit').'" /></a>
							<a href="#"><img src="'._PS_ADMIN_IMG_.'delete.gif" onclick="slideDelete('.$slide['id'].');return false;" style="padding:0" title="'.$this->l('Delete').'" /></a>
						</td>
					</tr>';
					$i++;
				}
			$this->_html .= '</table>
			<input type="hidden" id="languageFirst" value="'.$languages[0]['id_lang'].'" />
			<input type="hidden" id="languageNb" value="'.sizeof($languages).'" />';
		}
	}
	
	public function cacheCompileLess($inputFile, $outputFile) {
		if (!class_exists('lessc'))
			require_once dirname(__FILE__).'/lessc.inc.php';
		
		$cacheFile = $inputFile.'.cache';
		if (file_exists($cacheFile))
			$cache = unserialize(file_get_contents($cacheFile));
		else
			$cache = $inputFile;

		$less = new lessc;
		$less->setVariables(array(
			'mps_inline' => Configuration::get('MPS_INLINE'),
			'mps_height' => Configuration::get('MPS_HEIGHT').'px',
			'mps_sliderwidth' => Configuration::get('MPS_SLIDERWIDTH') > 0 ? Configuration::get('MPS_SLIDERWIDTH').'px' : '100%',
			'mps_imgwidth' => Configuration::get('MPS_IMGWIDTH').'px',
			'mps_fontfamily' => Configuration::get('MPS_FONTFAMILY'),
			'mps_fontsize' => Configuration::get('MPS_FONTSIZE').'px',
			'mps_maincolor' => '#'.Configuration::get('MPS_MAINCOLOR'),
			'mps_altcolor' => '#'.Configuration::get('MPS_ALTCOLOR'),
			'mps_fontcolor' => '#'.Configuration::get('MPS_FONTCOLOR'),
			'mps_sliderbgcolor' => '#'.Configuration::get('MPS_SLIDERBGCOLOR'),
			'mps_captionbgcolor' => '#'.Configuration::get('MPS_CAPTIONBGCOLOR'),
			'mps_editorialbgcolor' => '#'.Configuration::get('MPS_EDITORIALBGCOLOR')
		));
		
		$less->setFormatter("classic");
		$newCache = $less->cachedCompile($cache);

		if (!is_array($cache) || $newCache['updated'] > $cache['updated']) {
			file_put_contents($cacheFile, serialize($newCache));
			file_put_contents($outputFile, $newCache['compiled']);
		}
	}
	
	public function hookHeader($params)
	{
		$this->cacheCompileLess(dirname(__FILE__).'/css/less/default.less', dirname(__FILE__).'/css/prettyslider.css');
		$this->cacheCompileLess(dirname(__FILE__).'/css/less/responsive.less', dirname(__FILE__).'/css/prettyslider-responsive.css');
		
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$page_name = Dispatcher::getInstance()->getController();
			if ($page_name=='index') {
				$this->context->controller->addCSS(($this->_path).'css/prettyslider.css', 'all');
				$this->context->controller->addJS(($this->_path).'js/prettyslider.js');
				if (Configuration::get('MPS_RESPONSIVE') == 1)
					$this->context->controller->addCSS(($this->_path).'css/prettyslider-responsive.css', 'all');
			}
		}
		else {
			if (basename($_SERVER['SCRIPT_NAME'])=='index.php') {
				Tools::addCSS($this->_path.'css/prettyslider.css', 'all');
				Tools::addJS(($this->_path).'js/prettyslider.js');
				if (Configuration::get('MPS_RESPONSIVE') == 1)
					Tools::addCSS($this->_path.'css/prettyslider-responsive.css', 'all');
			}
		}
	}

	public function hookHome($params)
	{
		global $smarty, $cookie;
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT p.`id_slide` AS id, pl.`title` AS title, pl.`subtitle` AS subtitle, pl.`link` AS link
			FROM `'._DB_PREFIX_.'prettyslider` p
			JOIN `'._DB_PREFIX_.'prettyslider_lang` pl ON (p.`id_slide` = pl.`id_slide` AND `id_shop`='.(int)$id_shop.' AND pl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `active` = 1
			ORDER BY `position`';
			$smarty->assign('id_shop', $id_shop);
		}
		else {
			$sql = 'SELECT p.`id_slide` AS id, pl.`title` AS title, pl.`subtitle` AS subtitle, pl.`link` AS link
			FROM `'._DB_PREFIX_.'prettyslider` p
			JOIN `'._DB_PREFIX_.'prettyslider_lang` pl ON (p.`id_slide` = pl.`id_slide` AND pl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `active` = 1
			ORDER BY `position`';
		}
		$slides = Db::getInstance()->ExecuteS($sql);
		$editor = $this->getEditor($cookie->id_lang);
		$smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'slides' => $slides,
			'mps_scroll' => Configuration::get('MPS_SCROLL'),
			'mps_easing' => Configuration::get('MPS_EASING'),
			'mps_speed' => Configuration::get('MPS_SPEED'),
			'mps_autoscroll' => Configuration::get('MPS_AUTOSCROLL'),
			'mps_pagination' => Configuration::get('MPS_PAGINATION'),
			'mps_arrows' => Configuration::get('MPS_ARROWS'),
			'mps_responsive' => Configuration::get('MPS_RESPONSIVE'),
			'mps_editorial' => Configuration::get('MPS_EDITORIAL'),
			'editor' => $editor['editor']
		));
		return $this->display(__FILE__, 'prettyslider.tpl');
	}
	
	public function hookTopColumn($params)
	{
		return $this->hookHome($params);
	}
}