{* ----------------------------------------
   Template Prestashop DiscountShop
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ---------------------------------------- *}

{include file="$tpl_dir./breadcrumb.tpl"}
{include file="$tpl_dir./errors.tpl"}

{if isset($category)}
	{if $category->id AND $category->active}
		<h1>
			{strip}
				{$category->name|escape:'htmlall':'UTF-8'}
				{if isset($categoryNameComplement)}
					{$categoryNameComplement|escape:'htmlall':'UTF-8'}
				{/if}
				<span class="category-product-count">
					{include file="$tpl_dir./category-count.tpl"}
				</span>
			{/strip}
		</h1>
		
		{if $scenes || $category->description || $category->id_image}
		<div class="content_scene_cat">
			{if $scenes}
				<!-- Scenes -->
				{include file="$tpl_dir./scenes.tpl" scenes=$scenes}
			{else}
				<!-- Category image -->
				{if $category->id_image}
				<div class="cat_img">
					<img src="{$link->getCatImageLink($category->link_rewrite, $category->id_image, 'category')}" alt="{$category->name|escape:'htmlall':'UTF-8'}" title="{$category->name|escape:'htmlall':'UTF-8'}" id="categoryImage" />
				</div>
				{/if}
			{/if}

			{if $category->description}
				<div class="cat_desc">
					<p>{$category->description}</p>
				</div>
			{/if}
		</div>
		{/if}
		{if isset($subcategories)}
		<!-- Subcategories -->
		<div id="subcategories">
			{assign var='nbItemsPerLine' value=4}
			<ul class="inline_list">
			{foreach from=$subcategories item=subcategory name=subcategory}
				<li class="{if $smarty.foreach.subcategory.iteration%$nbItemsPerLine == 1}first_item_of_line {/if}span3">
					<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'htmlall':'UTF-8'}" title="{$subcategory.name|escape:'htmlall':'UTF-8'}" class="img">
						<img src="{$link->getCatImageLink($subcategory.link_rewrite, $subcategory.id_image, 'category')}" alt="{$subcategory.name|escape:'htmlall':'UTF-8'}" />
					</a>
					<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'htmlall':'UTF-8'}" class="cat_name" title="{$subcategory.name|escape:'htmlall':'UTF-8'}">{$subcategory.name|truncate:20:'...'|escape:'htmlall':'UTF-8'}</a>
					{*{if $subcategory.description}
						<p class="cat_desc">{$subcategory.description|strip_tags:'UTF-8'|truncate:120:'...'|escape:'htmlall':'UTF-8'}</p>
					{/if}*}
				</li>
			{/foreach}
			</ul>
		</div>
		{/if}

		{if $products}
			<div class="content_sortPagiBar">
				<div class="sortPagiBar">
					{include file="$tpl_dir./product-compare.tpl"}
					{include file="$tpl_dir./nbr-product-page.tpl"}
					{include file="$tpl_dir./product-sort.tpl"}
				</div>
			</div>
			
			{include file="$tpl_dir./product-list.tpl" products=$products}
			
			<div class="content_sortPagiBar">
				<div class="sortPagiBar">
					{include file="$tpl_dir./product-compare.tpl"}
					{include file="$tpl_dir./pagination.tpl"}
				</div>
			</div>
		{/if}
	{elseif $category->id}
		<p class="warning">{l s='This category is currently unavailable.'}</p>
	{/if}
{/if}