{* ----------------------------------------
   Template Prestashop DiscountShop
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ---------------------------------------- *}

{include file="$tpl_dir./breadcrumb.tpl"}

{include file="$tpl_dir./errors.tpl"}

{if !isset($errors) OR !sizeof($errors)}
	<h1>{l s='List of products by manufacturer'}&nbsp;{$manufacturer->name|escape:'htmlall':'UTF-8'}</h1>
	{if !empty($manufacturer->description) || !empty($manufacturer->short_description)}
		<div class="description_box">
			<img src="{$img_manu_dir}{if isset($manufacturer->id_manufacturer)}{$manufacturer->id_manufacturer|escape:'htmlall':'UTF-8'}{else}{$manufacturer->id|escape:'htmlall':'UTF-8'}{/if}-medium.jpg" alt="{$manufacturer->name|escape:'htmlall':'UTF-8'}" />
			{$manufacturer->description}
		</div>
	{/if}

	{if $products}
		<div class="content_sortPagiBar">
			<div class="sortPagiBar">
				{include file="$tpl_dir./product-compare.tpl"}
				{include file="$tpl_dir./nbr-product-page.tpl"}
				{include file="$tpl_dir./product-sort.tpl"}
			</div>
		</div>
	
		{include file="$tpl_dir./product-list.tpl" products=$products}
	
		<div class="content_sortPagiBar">
			<div class="sortPagiBar">
				{include file="$tpl_dir./product-compare.tpl"}
				{include file="$tpl_dir./pagination.tpl"}
			</div>
		</div>
	{else}
		<p class="warning">{l s='No products for this manufacturer.'}</p>
	{/if}
{/if}