{* ----------------------------------------
   Template Prestashop DiscountShop
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ---------------------------------------- *}

<!-- MODULE Crossselling -->
{if isset($orderProducts) && count($orderProducts)}
	<script type="text/javascript" src="{$js_dir}modules/crossselling/js/crossselling.js"></script>
	<h2 id="crossselling_h2">{l s='Customers who bought this product also bought :' mod='crossselling'}</h2>
	<div id="crossselling">
		<div id="crossselling_content">
			<div id="crossselling_container">
				{foreach from=$orderProducts item='orderProduct' name=orderProduct}
					<div class="crossselling_product_block">
						<p class="crossselling_img"><a href="{$orderProduct.link}" title="{$orderProduct.name|htmlspecialchars}"><img src="{$link->getImageLink($orderProduct.link_rewrite, $orderProduct.id_image, 'medium')}" alt="{$orderProduct.name|htmlspecialchars}" /></a></p>
						<p class="crossselling_name"><a href="{$orderProduct.link}" title="{$orderProduct.name|htmlspecialchars}">{$orderProduct.name|truncate:15:'...'|escape:'htmlall':'UTF-8'}</a></p>
						{if $crossDisplayPrice AND $orderProduct.show_price == 1 AND !$PS_CATALOG_MODE}
							<p class="crossselling_price">{convertPrice price=$orderProduct.displayed_price}</p>
						{/if}
					</div>
				{/foreach}
			</div>
			<div class="clear" style="clear:both"></div>
			{if $orderProducts AND $orderProducts|@count > 1}
				<a id="crossselling_prev" href="#">&lsaquo;</a>
				<a id="crossselling_next" href="#">&rsaquo;</a>
			{/if}
		</div>
	</div>
{/if}
<!-- /MODULE Crossselling -->