{* ----------------------------------------
   Template Prestashop DiscountShop
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ---------------------------------------- *}

<!-- MODULE Product category -->
{if $categoryProducts|@count > 0 && $categoryProducts != false}
	<h2 id="productscategory_h2">{$categoryProducts|@count} {l s='other products in the same category :' mod='productscategory'}</h2>
	<div id="productscategory">
		<div id="productscategory_content">
			<div id="productscategory_container">
				{foreach from=$categoryProducts item='categoryProduct' name=categoryProduct}
					<div class="productscategory_product_block">
						<p class="productscategory_img"><a href="{$link->getProductLink($categoryProduct.id_product, $categoryProduct.link_rewrite, $categoryProduct.category, $categoryProduct.ean13)}" title="{$categoryProduct.name|htmlspecialchars}"><img src="{$link->getImageLink($categoryProduct.link_rewrite, $categoryProduct.id_image, 'medium')}" alt="{$categoryProduct.name|htmlspecialchars}" /></a></p>
						<p class="productscategory_name"><a href="{$link->getProductLink($categoryProduct.id_product, $categoryProduct.link_rewrite, $categoryProduct.category, $categoryProduct.ean13)}" title="{$categoryProduct.name|htmlspecialchars}">{$categoryProduct.name|truncate:15:'...'|escape:'htmlall':'UTF-8'}</a></p>
						{if $ProdDisplayPrice AND $categoryProduct.show_price == 1 AND !$PS_CATALOG_MODE}
							<p class="productscategory_price">{convertPrice price=$categoryProduct.displayed_price}</p>
						{/if}
					</div>
				{/foreach}
			</div>
			<div class="clear" style="clear:both"></div>
			{if $categoryProducts AND $categoryProducts|@count > 1}
				<a id="productscategory_prev" href="#">&lsaquo;</a>
				<a id="productscategory_next" href="#">&rsaquo;</a>
			{/if}
		</div>
	</div>
{/if}
<!-- /MODULE Product category -->