<?php

/* Module Prestashop CategoriesTopMenu
 * Copyright Prestacrea
 * Author: Prestacrea
 * Website: http://www.prestacrea.com */

class CategoriesTopMenu extends Module
{
	function __construct()
	{
		$this->name = 'categoriestopmenu';
		$this->tab = 'front_office_features';
		$this->version = '2.7';
		$this->author = 'PRESTACREA';
		$this->need_instance = 0;
		parent::__construct();

		$this->displayName = ('PRESTACREA - Categories Top Menu');
		$this->description = $this->l('Adds a horizontal categories menu');
	}

	function install()
	{
		if (!parent::install() 
		OR !$this->registerHook('header')
		OR !$this->registerHook('top') 
		OR !Configuration::updateValue('CTM_MAX_DEPTH', 5) 
		OR !Configuration::updateValue('CTM_TABS', 0)
		OR !Configuration::updateValue('CTM_SPECIALS', 1) 
		OR !Configuration::updateValue('CTM_NEW_PRODUCTS', 1))
			return false;
		return true;
	}

	function uninstall()
	{
		if (!parent::uninstall()
		OR !Configuration::deleteByName('CTM_MAX_DEPTH')
		OR !Configuration::deleteByName('CTM_TABS')
		OR !Configuration::deleteByName('CTM_SPECIALS')
		OR !Configuration::deleteByName('CTM_NEW_PRODUCTS'))
			return false;
		return true;
	}

	function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitCategoriesTopMenu'))
		{
			if (isset($_POST['ctm_tabs']) AND VAlidate::isBool(intval($_POST['ctm_tabs'])))
				Configuration::updateValue('CTM_TABS', pSQL($_POST['ctm_tabs']));
			if (isset($_POST['ctm_specials']) AND VAlidate::isBool(intval($_POST['ctm_specials'])))
				Configuration::updateValue('CTM_SPECIALS', pSQL($_POST['ctm_specials']));
			if (isset($_POST['ctm_new_products']) AND VAlidate::isBool(intval($_POST['ctm_new_products'])))
				Configuration::updateValue('CTM_NEW_PRODUCTS', pSQL($_POST['ctm_new_products']));
			$ctm_max_depth = intval(Tools::getValue('ctm_max_depth'));
			if (!$ctm_max_depth OR $ctm_max_depth < 0 OR !Validate::isInt($ctm_max_depth))
				$this->_html = $this->displayError($this->l('Invalid number of levels'));
			else
			{
				Configuration::updateValue('CTM_MAX_DEPTH', intval($ctm_max_depth));
				$this->_html = $this->displayConfirmation($this->l('Settings updated'));
			}
		}
		$this->displayForm();
		return $this->_html;
	}

	function displayForm()
	{
		$this->_html.= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset style="margin-bottom:20px">
				<img src="'.$this->_path.'doc/pdf.gif"/><a style="font-size:12px;font-weight:bold" target="_blank" href="'.$this->_path.'doc/documentation.pdf">'.$this->l('Download module documentation').'</a>
			</fieldset>
			<fieldset><legend>'.$this->l('SETTINGS').'</legend>
				<label style="padding:0">'.$this->l('Categories levels').'</label>
				<div class="margin-form">
					<input type="text" size="5" name="ctm_max_depth" value="'.Configuration::get('CTM_MAX_DEPTH').'" />
					<p>'.$this->l('Set the number of categories levels displayed').'</p>
				</div>
				<label style="padding:0">'.$this->l('Menu style').'</label>
				<div class="margin-form" style="font-weight:bold">
					<input type="radio" name="ctm_tabs" style="margin-right:5px" value="1" '.(Configuration::get('CTM_TABS') ? 'checked="checked" ' : '').'/>'.$this->l('Tabs').'
					<input type="radio" name="ctm_tabs" style="margin-right:5px;margin-left:5px" value="0" '.(!Configuration::get('CTM_TABS') ? 'checked="checked" ' : '').'/>'.$this->l('Bar').'
					<p style="font-weight:normal">'.$this->l('Set the menu style').'</p>
				</div>
				<label style="padding:0">'.$this->l('Display Promotions').'</label>
				<div class="margin-form" style="font-weight:bold">
					<input type="radio" name="ctm_specials" style="margin-right:5px" value="1" '.(Configuration::get('CTM_SPECIALS') ? 'checked="checked" ' : '').'/>'.$this->l('Yes').'
					<input type="radio" name="ctm_specials" style="margin-right:5px;margin-left:5px" value="0" '.(!Configuration::get('CTM_SPECIALS') ? 'checked="checked" ' : '').'/>'.$this->l('No').'
					<p style="font-weight:normal">'.$this->l('Set whether the promotions link is displayed or not').'</p>
				</div>
				<label style="padding:0">'.$this->l('Display New products').'</label>
				<div class="margin-form" style="font-weight:bold">
					<input type="radio" name="ctm_new_products" style="margin-right:5px" value="1" '.(Configuration::get('CTM_NEW_PRODUCTS') ? 'checked="checked" ' : '').'/>'.$this->l('Yes').'
					<input type="radio" name="ctm_new_products" style="margin-right:5px;margin-left:5px" value="0" '.(!Configuration::get('CTM_NEW_PRODUCTS') ? 'checked="checked" ' : '').'/>'.$this->l('No').'
					<p style="font-weight:normal">'.$this->l('Set whether the new products link is displayed or not').'</p>
				</div>
				<div class="margin-form"><input type="submit" name="submitCategoriesTopMenu" value="'.$this->l('Update').'" class="button" style="width:150px"/></div>
			</fieldset>
		</form>';
	}

	function getTree($resultParents, $resultIds, $ctm_max_depth, $id_category = 1, $currentDepth = 0)
	{
		global $link;
		$children = array();
		if (isset($resultParents[$id_category]) AND sizeof($resultParents[$id_category]) AND ($ctm_max_depth == 0 OR $currentDepth < $ctm_max_depth))
			foreach ($resultParents[$id_category] as $subcat)
				$children[] = $this->getTree($resultParents, $resultIds, $ctm_max_depth, $subcat['id_category'], $currentDepth + 1);
		if (!isset($resultIds[$id_category]))
			return false;
		return array('id' => $id_category, 'link' => $link->getCategoryLink($id_category, $resultIds[$id_category]['link_rewrite']),
		'name' => $resultIds[$id_category]['name'], 'desc'=> $resultIds[$id_category]['description'],
		'children' => $children);
	}
	
	function getTree15($resultParents, $resultIds, $ctm_max_depth, $id_category = null, $currentDepth = 0)
	{
		if (is_null($id_category))
			$id_category = $this->context->shop->getCategory();
		$children = array();
		if (isset($resultParents[$id_category]) && count($resultParents[$id_category]) && ($ctm_max_depth == 0 || $currentDepth < $ctm_max_depth))
			foreach ($resultParents[$id_category] as $subcat)
				$children[] = $this->getTree15($resultParents, $resultIds, $ctm_max_depth, $subcat['id_category'], $currentDepth + 1);
		if (!isset($resultIds[$id_category]))
			return false;
		$return = array('id' => $id_category, 'link' => $this->context->link->getCategoryLink($id_category, $resultIds[$id_category]['link_rewrite']),
		'name' => $resultIds[$id_category]['name'], 'desc'=> $resultIds[$id_category]['description'],
		'children' => $children);
		return $return;
	}

	function hookHeader($params)
	{
		global $smarty;
		$smarty->assign(array('tabs_display' => Configuration::get('CTM_TABS')));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$this->context->controller->addCSS(($this->_path).'css/categoriestopmenu.css', 'all');
		else
			Tools::addCSS($this->_path.'css/categoriestopmenu.css','all');
	}

	function hookTop($params)
	{
		global $smarty, $cookie;
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$id_current_shop = $this->context->shop->id;
			$id_customer = (int)$params['cookie']->id_customer;
			$groups = $id_customer ? implode(', ', Customer::getGroupsStatic($id_customer)) : Configuration::get('PS_UNIDENTIFIED_GROUP');
			$id_product = (int)Tools::getValue('id_product', 0);
			$id_category = (int)Tools::getValue('id_category', 0);
			$id_lang = (int)$params['cookie']->id_lang;
			$ctm_max_depth = Configuration::get('CTM_MAX_DEPTH');
			if (!$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT c.id_parent, c.id_category, cl.name, cl.description, cl.link_rewrite
			FROM `'._DB_PREFIX_.'category` c
			LEFT JOIN `'._DB_PREFIX_.'category_lang` cl ON (c.`id_category` = cl.`id_category` AND cl.`id_lang` = '.$id_lang.Shop::addSqlRestrictionOnLang('cl').')
			LEFT JOIN `'._DB_PREFIX_.'category_group` cg ON (cg.`id_category` = c.`id_category`)
			LEFT JOIN `'._DB_PREFIX_.'category_shop` cs ON (cs.`id_category` = c.`id_category`)
			WHERE (c.`active` = 1 OR c.`id_category` = '.(int)Configuration::get('PS_HOME_CATEGORY').')
			AND c.`id_category` != '.(int)Configuration::get('PS_ROOT_CATEGORY').'
			'.((int)($ctm_max_depth) != 0 ? ' AND `level_depth` <= '.(int)($ctm_max_depth) : '').'
			AND cg.`id_group` IN ('.pSQL($groups).')
			AND cs.`id_shop` = '.(int)Context::getContext()->shop->id.'
			GROUP BY id_category
			ORDER BY `level_depth` ASC, cs.`position` ASC'))
				return;
		}
		else
		{
			$id_customer = intval($params['cookie']->id_customer);
			$ctm_max_depth = Configuration::get('CTM_MAX_DEPTH');
			if (!$result = Db::getInstance()->ExecuteS('
			SELECT DISTINCT c.*, cl.*
			FROM `'._DB_PREFIX_.'category` c
			LEFT JOIN `'._DB_PREFIX_.'category_lang` cl ON (c.`id_category` = cl.`id_category` AND `id_lang` = '.intval($params['cookie']->id_lang).')
			LEFT JOIN `'._DB_PREFIX_.'category_group` ctg ON (ctg.`id_category` = c.`id_category`)
			'.($id_customer ? 'INNER JOIN `'._DB_PREFIX_.'customer_group` cg ON (cg.`id_group` = ctg.`id_group` AND cg.`id_customer` = '.intval($id_customer).')' : '' ).'
			WHERE 1'.(intval($ctm_max_depth) != 0 ? ' AND `level_depth` <= '.intval($ctm_max_depth) : '').'
			AND (c.`active` = 1 OR c.`id_category` = 1)
			'.(!$id_customer ? 'AND ctg.`id_group` = 1' : '' ).'
			ORDER BY `level_depth` ASC, c.`position` ASC'))
				return;
		}
		$resultParents = array();
		$resultIds = array();
		foreach ($result as $row)
		{
			$row['name'] = $row['name'];
			$resultParents[$row['id_parent']][] = $row;
			$resultIds[$row['id_category']] = $row;
		}
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$blockCategTree = $this->getTree15($resultParents, $resultIds, Configuration::get('CTM_MAX_DEPTH'));
		else
			$blockCategTree = $this->getTree($resultParents, $resultIds, Configuration::get('CTM_MAX_DEPTH'));
		$smarty->assign('currentCategoryId', intval(@$_GET['id_category']));
		if (isset($_GET['id_product']))
		{
			if (!isset($cookie->last_visited_category) OR !Product::idIsOnCategoryId(intval($_GET['id_product']), array('0' => array('id_category' => $cookie->last_visited_category))))
			{
				$product = new Product(intval($_GET['id_product']));
				if (isset($product) AND Validate::isLoadedObject($product))
					$cookie->last_visited_category = intval($product->id_category_default);
			}
			$smarty->assign('currentCategoryId', intval($cookie->last_visited_category));
		}
		$smarty->assign(array(
			'blockCategTree' => $blockCategTree,
			'specials_display' => Configuration::get('CTM_SPECIALS'),
			'new_products_display' => Configuration::get('CTM_NEW_PRODUCTS')
		));
		$smarty->assign('branche_tpl_path', _PS_MODULE_DIR_.'categoriestopmenu/categoriestopmenu-list.tpl');
		return $this->display(__FILE__, 'categoriestopmenu.tpl');
	}
}
?>