<?php

/* Module Prestashop FooterCustom
 * Copyright Prestacrea
 * Author: Prestacrea
 * Website: http://www.prestacrea.com */

class FooterCustom extends Module
{
	function __construct()
	{
		$this->name = 'footercustom';
		$this->tab = 'front_office_features';
		$this->version = '2.7';
		$this->author = 'PRESTACREA';
		$this->module_key = 'ac1b7c852095415433426bad93a47c6b';
		$this->need_instance = 0;
		parent::__construct();

		$this->displayName = ('PRESTACREA - Footer Custom');
		$this->description = $this->l('Adds a large customizable footer');
		$this->confirmUninstall = $this->l('Uninstalling the module will delete all its entries in the database. To keep your data, delete the folder "install" of the module before uninstall it. Do you want to continue uninstalling the module ?');
	}

	function install()
	{
		if (file_exists(dirname(__FILE__).'/install/footercustom-install.php'))
			require_once(dirname(__FILE__).'/install/footercustom-install.php');

		if (!parent::install()
		OR !$this->registerHook('header') 
		OR !$this->registerHook('footer')
		OR !Configuration::updateValue('FC_IMG', 1)
		OR !Configuration::updateValue('FC_NEWS', 1)
		OR !Configuration::updateValue('FC_SOCIAL', 1)
		OR !Configuration::updateValue('FC_LINKS', 1)
		OR !Configuration::updateValue('FC_EDITOR', 1))
			return false;
		return true;
	}

	function uninstall()
	{
		if (file_exists(dirname(__FILE__).'/install/footercustom-uninstall.php'))
			require_once(dirname(__FILE__).'/install/footercustom-uninstall.php');

		if (!parent::uninstall()
		OR !Configuration::deleteByName('FC_IMG')
		OR !Configuration::deleteByName('FC_NEWS')
		OR !Configuration::deleteByName('FC_SOCIAL')
		OR !Configuration::deleteByName('FC_LINKS')
		OR !Configuration::deleteByName('FC_EDITOR'))
			return false;
		return true;
	}

	function getCustomers()
	{
		$rq = Db::getInstance()->ExecuteS('
		SELECT c.`id_customer`, c.`lastname`, c.`firstname`, c.`email`, c.`ip_registration_newsletter`, c.`newsletter_date_add`
		FROM `'._DB_PREFIX_.'customer` c
		WHERE c.`newsletter` = 1
		GROUP BY c.`id_customer`');
		$header = array('id_customer', 'lastname', 'firstname', 'email', 'ip_address', 'newsletter_date_add');
		$result = (is_array($rq) ? array_merge(array($header), $rq) : $header);
		return $result;
	}

	function getFooterCustom()
	{
		$rq = Db::getInstance()->ExecuteS('
		SELECT * FROM `'._DB_PREFIX_.'footercustom_newsletter`');
		$header = array('id_customer', 'email', 'newsletter_date_add', 'ip_address');
		$result = (is_array($rq) ? array_merge(array($header), $rq) : $header);
		return $result;
	}

	function putCSV($fd, $array)
	{
		$line = implode(';', $array);
		$line .= "\n";
		if (!fwrite($fd, utf8_decode($line), 4096))
			$this->_postErrors[] = $this->l('Cannot write to').' '.dirname(__FILE__).'/'.$this->_file.' !';
	}

 	function isNewsletterRegistered($customerEmail)
 	{
		if (Db::getInstance()->getRow('SELECT `email` FROM '._DB_PREFIX_.'footercustom_newsletter WHERE `email` = \''.pSQL($customerEmail).'\''))
			return 1;
		if (!$registered = Db::getInstance()->getRow('SELECT `newsletter` FROM '._DB_PREFIX_.'customer WHERE `email` = \''.pSQL($customerEmail).'\''))
			return -1;
		if ($registered['newsletter'] == '1')
			return 2;
		return 0;
 	}
 	
 	function newsletterRegistration()
 	{
		$this->error = false;
		$this->valid = false;
		if (!Validate::isEmail(pSQL($_POST['email'])))
			return $this->error = $this->l('Invalid mail address');
		else
		{
			$registerStatus = $this->isNewsletterRegistered(pSQL($_POST['email']));
			if ($registerStatus > 0)
				return $this->error = $this->l('Mail address already registered');
			elseif ($registerStatus == -1)
			{
				global $cookie;
				if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'footercustom_newsletter VALUES (\'\', \''.pSQL($_POST['email']).'\', NOW(), \''.pSQL($_SERVER['REMOTE_ADDR']).'\', 
				(SELECT c.http_referer FROM '._DB_PREFIX_.'connections c WHERE c.id_guest = '.intval($cookie->id_guest).' ORDER BY c.date_add DESC LIMIT 1))'))
					return $this->error = $this->l('Error during subscription');
				return $this->valid = $this->l('Subscription successful');
			}
			elseif ($registerStatus == 0)
			{
				if (!Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'customer SET `newsletter` = 1, newsletter_date_add = NOW(), `ip_registration_newsletter` = \''.pSQL($_SERVER['REMOTE_ADDR']).'\' WHERE `email` = \''.pSQL($_POST['email']).'\''))
					return $this->error = $this->l('Error during subscription');
				return $this->valid = $this->l('Subscription successful');
			}
		}
 	}

	function addBlockTitle()
	{
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$context = Context::getContext();
			$id_shop = $context->shop->id;
			if (!$languages)
				return false;
			foreach ($languages AS $language)
			{
				$title1 = Tools::getValue('title1_'.$language['id_lang']) ? Tools::getValue('title1_'.$language['id_lang']) : Tools::getValue('title1_'.$defaultLanguage);
				$title2 = Tools::getValue('title2_'.$language['id_lang']) ? Tools::getValue('title2_'.$language['id_lang']) : Tools::getValue('title2_'.$defaultLanguage);
				$title3 = Tools::getValue('title3_'.$language['id_lang']) ? Tools::getValue('title3_'.$language['id_lang']) : Tools::getValue('title3_'.$defaultLanguage);
				$query = 'REPLACE INTO '._DB_PREFIX_.'footercustom_blocktitles
				VALUES ('.$language['id_lang'].', \''.(int)$id_shop.'\', \''.addslashes($title1).'\', \''.addslashes($title2).'\', \''.addslashes($title3).'\')';
				if (!Db::getInstance()->Execute($query))
					return false;
			}
			return true;
		}
		else
		{
			if (!$languages)
				return false;
			foreach ($languages AS $language)
			{
				$title1 = Tools::getValue('title1_'.$language['id_lang']) ? Tools::getValue('title1_'.$language['id_lang']) : Tools::getValue('title1_'.$defaultLanguage);
				$title2 = Tools::getValue('title2_'.$language['id_lang']) ? Tools::getValue('title2_'.$language['id_lang']) : Tools::getValue('title2_'.$defaultLanguage);
				$title3 = Tools::getValue('title3_'.$language['id_lang']) ? Tools::getValue('title3_'.$language['id_lang']) : Tools::getValue('title3_'.$defaultLanguage);
				$query = 'REPLACE INTO '._DB_PREFIX_.'footercustom_blocktitles
				VALUES ('.$language['id_lang'].', "1", \''.addslashes($title1).'\', \''.addslashes($title2).'\', \''.addslashes($title3).'\')';
				if (!Db::getInstance()->Execute($query))
					return false;
			}
			return true;
		}
	}

	function getBlockTitle1($lang)
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$this->context = Context::getContext();
			$id_shop = $this->context->shop->id;
			$result = array();
			if (!$result = Db::getInstance()->getRow('SELECT `title1` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_shop`='.(int)$id_shop.' AND `id_lang`='.$lang))
				return false;
			return $result;
		}
		else
		{
			$result = array();
			if (!$result = Db::getInstance()->getRow('SELECT `title1` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_lang`='.$lang))
				return false;
			return $result;
		}
	}

	function getBlockTitle2($lang)
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$this->context = Context::getContext();
			$id_shop = $this->context->shop->id;
			$result = array();
			if (!$result = Db::getInstance()->getRow('SELECT `title2` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_shop`='.(int)$id_shop.' AND `id_lang`='.$lang))
				return false;
			return $result;
		}
		else
		{
			$result = array();
			if (!$result = Db::getInstance()->getRow('SELECT `title2` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_lang`='.$lang))
				return false;
			return $result;
		}
	}

	function getBlockTitle3($lang)
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$this->context = Context::getContext();
			$id_shop = $this->context->shop->id;
			$result = array();
			if (!$result = Db::getInstance()->getRow('SELECT `title3` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_shop`='.(int)$id_shop.' AND `id_lang`='.$lang))
				return false;
			return $result;
		}
		else
		{
			$result = array();
			if (!$result = Db::getInstance()->getRow('SELECT `title3` FROM '._DB_PREFIX_.'footercustom_blocktitles WHERE `id_lang`='.$lang))
				return false;
			return $result;
		}
	}

	function addBlock()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'footercustom VALUES ()') OR !$lastId = Db::getInstance()->Insert_ID())
				return false;
			$languages = Language::getLanguages();
			$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
			$context = Context::getContext();
			$id_shop = $context->shop->id;
			if (!$languages)
				return false;
			foreach ($languages AS $language)
			{
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$inblock = Tools::getValue('inblock_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				$query = 'INSERT INTO '._DB_PREFIX_.'footercustom_lang
				VALUES ('.$lastId.', \''.(int)$id_shop.'\', '.$language['id_lang'].', \''.addslashes($title).'\' , \''.addslashes($link).'\', \''.addslashes($inblock).'\', \''.addslashes($position).'\')';
				if (!Db::getInstance()->Execute($query))
					return false;
			}
			return true;
		}
		else
		{
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'footercustom VALUES ()') OR !$lastId = mysql_insert_id())
				return false;
			$languages = Language::getLanguages();
			$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
			if (!$languages)
				return false;
			foreach ($languages AS $language)
			{
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$inblock = Tools::getValue('inblock_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				$query = 'INSERT INTO '._DB_PREFIX_.'footercustom_lang
				VALUES ('.$lastId.', "1", '.$language['id_lang'].', \''.addslashes($title).'\' , \''.addslashes($link).'\', \''.addslashes($inblock).'\', \''.addslashes($position).'\')';
				if (!Db::getInstance()->Execute($query))
					return false;
			}
			return true;
		}
	}

	function editBlock()
	{
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$context = Context::getContext();
			$id_shop = $context->shop->id;
			if (!$languages)
				return false;
			foreach ($languages AS $language)
			{
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$inblock = Tools::getValue('inblock_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				$id_block = (int)(Tools::getValue('id'));
				$query = 'REPLACE '._DB_PREFIX_.'footercustom_lang
				VALUES (\''.($id_block).'\', \''.(int)$id_shop.'\', \''.$language['id_lang'].'\', \''.addslashes($title).'\', \''.addslashes($link).'\', \''.addslashes($inblock).'\', \''.addslashes($position).'\')';
				if (!Db::getInstance()->Execute($query))
					return false;
			}
			return true;
		}
		else
		{
			if (!$languages)
				return false;
			foreach ($languages AS $language)
			{
				$title = Tools::getValue('title_'.$language['id_lang']) ? Tools::getValue('title_'.$language['id_lang']) : Tools::getValue('title_'.$defaultLanguage);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$defaultLanguage);
				$inblock = Tools::getValue('inblock_'.$defaultLanguage);
				$position = Tools::getValue('position_'.$defaultLanguage);
				$id_block = (int)(Tools::getValue('id'));
				$query = 'REPLACE '._DB_PREFIX_.'footercustom_lang
				VALUES (\''.($id_block).'\', "1", \''.$language['id_lang'].'\', \''.addslashes($title).'\', \''.addslashes($link).'\', \''.addslashes($inblock).'\', \''.addslashes($position).'\')';
				if (!Db::getInstance()->Execute($query))
					return false;
			}
			return true;
		}
	}

	function deleteBlock()
	{
		$id_block = (int)(Tools::getValue('id'));
		if (Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'footercustom WHERE `id_block`='.$id_block))
			return Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'footercustom_lang WHERE `id_block`='.$id_block);
		return false;
	}

	function addEditor()
	{
		$languages = Language::getLanguages();
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$context = Context::getContext();
			$id_shop = $context->shop->id;
			if (!$languages)
				return false;
			foreach ($languages AS $language)
			{
				$editor = Tools::getValue('editor_'.$language['id_lang']) ? Tools::getValue('editor_'.$language['id_lang']) : Tools::getValue('editor_'.$defaultLanguage);
				$query = 'REPLACE INTO '._DB_PREFIX_.'footercustom_editor
				VALUES ('.$language['id_lang'].', \''.(int)$id_shop.'\', \''.addslashes($editor).'\')';
				if (!Db::getInstance()->Execute($query))
					return false;
			}
			return true;
		}
		else
		{
			if (!$languages)
				return false;
			foreach ($languages AS $language)
			{
				$editor = Tools::getValue('editor_'.$language['id_lang']) ? Tools::getValue('editor_'.$language['id_lang']) : Tools::getValue('editor_'.$defaultLanguage);
				$query = 'REPLACE INTO '._DB_PREFIX_.'footercustom_editor
				VALUES ('.$language['id_lang'].', "1", \''.addslashes($editor).'\')';
				if (!Db::getInstance()->Execute($query))
					return false;
			}
			return true;
		}
	}

	function getEditor($lang)
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$this->context = Context::getContext();
			$id_shop = $this->context->shop->id;
			$result = array();
			if (!$result = Db::getInstance()->getRow('SELECT `editor` FROM '._DB_PREFIX_.'footercustom_editor WHERE `id_shop`='.(int)$id_shop.' AND `id_lang`='.$lang))
				return false;
			return $result;
		}
		else
		{
			$result = array();
			if (!$result = Db::getInstance()->getRow('SELECT `editor` FROM '._DB_PREFIX_.'footercustom_editor WHERE `id_lang`='.$lang))
				return false;
			return $result;
		}
	}

	function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.'</h2>
		<script type="text/javascript" src="'.$this->_path.'js/footercustom.js"></script>';
		$defaultLanguage = Configuration::get('PS_LANG_DEFAULT');
		if (isset($_POST['submitExportFC']))
		{
			$this->_file = ''.date('dmY').'.csv';
				$result = $this->getFooterCustom();
			if (!$nb = intval(Db::getInstance()->NumRows()))
				$this->_html .= $this->displayError($this->l('No customers were found'));
			elseif ($fd = @fopen(dirname(__FILE__).'/export/FooterCustomRegistered_'.$this->_file, 'w'))
			{
				foreach ($result AS $tab)
					$this->putCSV($fd, $tab);
				fclose($fd);
				$this->_html .= $this->displayConfirmation($this->l('The CSV file has been successfully exported').' ('.$nb.' '.$this->l('customers found').')<br />>> <a href="../modules/footercustom/export/FooterCustomRegistered_'.$this->_file.'"><b>'.$this->l('Download the file').'</b></a>');
			}
			else
				$this->_html .= $this->displayError($this->l('Cannot write to').' '.dirname(__FILE__).'/FooterCustomRegistered_'.$this->_file.' !');
		}
		elseif (isset($_POST['submitExportFCCustomers']))
		{
			$this->_file = ''.date('dmY').'.csv';
				$result = $this->getCustomers();
			if (!$nb = intval(Db::getInstance()->NumRows()))
				$this->_html .= $this->displayError($this->l('No customers were found'));
			elseif ($fd = @fopen(dirname(__FILE__).'/export/CustomersRegistered_'.$this->_file, 'w'))
			{
				foreach ($result AS $tab)
					$this->putCSV($fd, $tab);
				fclose($fd);
				$this->_html .= $this->displayConfirmation($this->l('The CSV file has been successfully exported').' ('.$nb.' '.$this->l('customers found').')<br />>> <a href="../modules/footercustom/export/CustomersRegistered_'.$this->_file.'"><b>'.$this->l('Download the file').'</b></a>');
			}
			else
				$this->_html .= $this->displayError($this->l('Cannot write to').' '.dirname(__FILE__).'/CustomersRegistered_'.$this->_file.' !');
		}
		elseif (Tools::isSubmit('submitUpdate'))
		{
			if (isset($_POST['fc_img']) AND VAlidate::isBool(intval($_POST['fc_img'])))
				Configuration::updateValue('FC_IMG', pSQL($_POST['fc_img']));
			if (isset($_POST['fc_news']) AND VAlidate::isBool(intval($_POST['fc_news'])))
				Configuration::updateValue('FC_NEWS', pSQL($_POST['fc_news']));
			if (isset($_POST['fc_social']) AND VAlidate::isBool(intval($_POST['fc_social'])))
				Configuration::updateValue('FC_SOCIAL', pSQL($_POST['fc_social']));
			if (isset($_POST['fc_links']) AND VAlidate::isBool(intval($_POST['fc_links'])))
				Configuration::updateValue('FC_LINKS', pSQL($_POST['fc_links']));
			if (isset($_POST['fc_editor']) AND VAlidate::isBool(intval($_POST['fc_editor'])))
				Configuration::updateValue('FC_EDITOR', pSQL($_POST['fc_editor']));
			$this->_html .= $this->displayConfirmation($this->l('Settings updated'));
		}
		elseif (Tools::isSubmit('submitAddImage'))
		{
			if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			{
				$context = Context::getContext();
				$id_shop = $context->shop->id;
				if (isset($_FILES['footer_img']) AND isset($_FILES['footer_img']['tmp_name']) AND !empty($_FILES['footer_img']['tmp_name']))
				{
					Configuration::set('PS_IMAGE_GENERATION_METHOD', 0);
					if (!copy($_FILES['footer_img']['tmp_name'], dirname(__FILE__).'/img/footer_img_'.(int)$id_shop.'.png'))
						$this->_html .= $this->displayError($this->l('An error occurred during the image upload'));
				}
			}
			else
			{
				if (isset($_FILES['footer_img']) AND isset($_FILES['footer_img']['tmp_name']) AND !empty($_FILES['footer_img']['tmp_name']))
				{
					Configuration::set('PS_IMAGE_GENERATION_METHOD', 0);
					if (!copy($_FILES['footer_img']['tmp_name'], dirname(__FILE__).'/img/footer_img_1.png'))
						$this->_html .= $this->displayError($this->l('An error occurred during the image upload'));
				}
			}
			$this->_html .= $this->displayConfirmation($this->l('Image updated'));
		}
		elseif (Tools::isSubmit('submitCompanyInfos'))
		{
			$company_name = Tools::getValue('company_name');
			$company_street = Tools::getValue('company_street');
			$company_city = Tools::getValue('company_city');
			$company_phone = Tools::getValue('company_phone');
			$company_mail = Tools::getValue('company_mail');
			if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			{
				$context = Context::getContext();
				$id_shop = $context->shop->id;
				Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_company (id, id_shop, name, street, city, phone, mail) VALUES (\''.(1).'\', \''.(int)$id_shop.'\', \''.addslashes($company_name).'\', \''.addslashes($company_street).'\', \''.addslashes($company_city).'\', \''.addslashes($company_phone).'\', \''.addslashes($company_mail).'\')');
			}
			else
			{
				Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_company (id, id_shop, name, street, city, phone, mail) VALUES (\''.(1).'\', \''.(1).'\', \''.addslashes($company_name).'\', \''.addslashes($company_street).'\', \''.addslashes($company_city).'\', \''.addslashes($company_phone).'\', \''.addslashes($company_mail).'\')');
			}
			$this->_html .= $this->displayConfirmation($this->l('Settings updated'));
		}
		elseif (Tools::isSubmit('submitSocial'))
		{
			$facebook_url = Tools::getValue('facebook_url');
			$twitter_url = Tools::getValue('twitter_url');
			$rss_url = Tools::getValue('rss_url');
			if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			{
				$context = Context::getContext();
				$id_shop = $context->shop->id;
				Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_social (id, id_shop, facebook, twitter, rss) VALUES (\''.(1).'\', \''.(int)$id_shop.'\', \''.addslashes($facebook_url).'\', \''.addslashes($twitter_url).'\', \''.addslashes($rss_url).'\')');
			}
			else
			{
				Db::getInstance()->Execute('REPLACE INTO '._DB_PREFIX_.'footercustom_social (id, id_shop, facebook, twitter, rss) VALUES (\''.(1).'\', \''.(1).'\', \''.addslashes($facebook_url).'\', \''.addslashes($twitter_url).'\', \''.addslashes($rss_url).'\')');
			}
			$this->_html .= $this->displayConfirmation($this->l('Settings updated'));
		}
		elseif (Tools::isSubmit('submitAddEditor'))
		{
			if ($this->addEditor())
				$this->_html .= $this->displayConfirmation($this->l('Editor updated'));
		}
		elseif (Tools::isSubmit('submitAddBlockTitle'))
		{
			if ($this->addBlockTitle())
				$this->_html .= $this->displayConfirmation($this->l('Blocks titles updated'));
		}
		elseif (Tools::isSubmit('submitAddBlock'))
		{
			$position = Tools::getValue('position_'.$defaultLanguage);
			if (!$position OR $position <= 0 OR !Validate::isInt($position))
				$this->_html .= $this->displayError($this->l('Invalid position number'));
			else
			{
				if ($this->addBlock())
					$this->_html .= $this->displayConfirmation($this->l('The link has been added successfully'));
				else
					$this->_html .= $this->displayError($this->l('An error occured during link adding'));
			}
		}
		elseif (Tools::isSubmit('submitEditBlock'))
		{
			$position = Tools::getValue('position_'.$defaultLanguage);
			if (!$position OR $position <= 0 OR !Validate::isInt($position))
				$this->_html .= $this->displayError($this->l('Invalid position number'));
			else
			{
				if (!Tools::getValue('id') OR !is_numeric(Tools::getValue('id')) OR !$this->editBlock())
					$this->_html .= $this->displayError($this->l('An error occured during link editing'));
				else
					$this->_html .= $this->displayConfirmation($this->l('The link has been edited successfully'));
			}
		}
		elseif (Tools::getValue('id'))
		{
			if (!is_numeric(Tools::getValue('id')) OR !$this->deleteBlock())
				$this->_html .= $this->displayError($this->l('An error occurred during link deletion'));
			else
				$this->_html .= $this->displayConfirmation($this->l('The link has been deleted successfully'));
		}
		$this->displayForm();
		return $this->_html;
	}
    
	function displayForm()
	{
		global $cookie;
		$iso = Language::getIsoById((int)($cookie->id_lang));
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$divLangName = 'title¤link';
		$divLangNameTitles = 'title1¤title2¤title3';
		$divLangNameEditor = 'editor';
		$this->_fieldsExport = array(
		'SUSCRIBERS' => array(
		'title' => $this->l('Customers'),
		'type' => 'select',
		'value' => array(0 => $this->l('All customers'), 2 => $this->l('Subscribers'), 1 => $this->l('Non-subscribers')),
		'value_default' => 2));
		$this->_html.= '<script type="text/javascript">id_language = Number('.$defaultLanguage.');</script>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<img src="'.$this->_path.'doc/pdf.gif"/><a style="font-size:12px;font-weight:bold" target="_blank" href="'.$this->_path.'doc/documentation.pdf">'.$this->l('Download module documentation').'</a>
			</fieldset>
			<fieldset class="space" style="float:left;width:300px;height:230px;margin-right:20px"><legend>'.$this->l('SETTINGS').'</legend>
				<label style="text-align:left;width:210px;padding:0">'.$this->l('Display image').'</label>
				<div class="margin-form" style="border-bottom:1px solid #DFD5C3;font-weight:bold;margin-bottom:10px;padding:0 0 10px 120px">
					<input type="radio" style="margin-right:5px" name="fc_img" value="1" '.(Configuration::get('FC_IMG') ? 'checked="checked" ' : '').'/>'.$this->l('Yes').'
					<input type="radio" style="margin-right:5px;margin-left:5px" name="fc_img" value="0" '.(!Configuration::get('FC_IMG') ? 'checked="checked" ' : '').'/>'.$this->l('No').'
				</div>
				<label style="text-align:left;width:210px;padding:0">'.$this->l('Display newsletter').'</label>
				<div class="margin-form" style="border-bottom:1px solid #DFD5C3;font-weight:bold;margin-bottom:10px;padding:0 0 10px 120px">
					<input type="radio" style="margin-right:5px" name="fc_news" value="1" '.(Configuration::get('FC_NEWS') ? 'checked="checked" ' : '').'/>'.$this->l('Yes').'
					<input type="radio" style="margin-right:5px;margin-left:5px" name="fc_news" value="0" '.(!Configuration::get('FC_NEWS') ? 'checked="checked" ' : '').'/>'.$this->l('No').'
				</div>
				<label style="text-align:left;width:210px;padding:0">'.$this->l('Display social networks').'</label>
				<div class="margin-form" style="border-bottom:1px solid #DFD5C3;font-weight:bold;margin-bottom:10px;padding:0 0 10px 120px">
					<input type="radio" style="margin-right:5px" name="fc_social" value="1" '.(Configuration::get('FC_SOCIAL') ? 'checked="checked" ' : '').'/>'.$this->l('Yes').'
					<input type="radio" style="margin-right:5px;margin-left:5px" name="fc_social" value="0" '.(!Configuration::get('FC_SOCIAL') ? 'checked="checked" ' : '').'/>'.$this->l('No').'
				</div>
				<label style="text-align:left;width:210px;padding:0">'.$this->l('Display links block').'</label>
				<div class="margin-form" style="border-bottom:1px solid #DFD5C3;font-weight:bold;margin-bottom:10px;padding:0 0 10px 120px">
					<input type="radio" style="margin-right:5px" name="fc_links" value="1" '.(Configuration::get('FC_LINKS') ? 'checked="checked" ' : '').'/>'.$this->l('Yes').'
					<input type="radio" style="margin-right:5px;margin-left:5px" name="fc_links" value="0" '.(!Configuration::get('FC_LINKS') ? 'checked="checked" ' : '').'/>'.$this->l('No').'
				</div>
				<label style="text-align:left;width:210px;padding:0">'.$this->l('Display editor block').'</label>
				<div class="margin-form" style="font-weight:bold;margin-bottom:10px;padding:0 0 10px 120px">
					<input type="radio" style="margin-right:5px" name="fc_editor" value="1" '.(Configuration::get('FC_EDITOR') ? 'checked="checked" ' : '').'/>'.$this->l('Yes').'
					<input type="radio" style="margin-right:5px;margin-left:5px" name="fc_editor" value="0" '.(!Configuration::get('FC_EDITOR') ? 'checked="checked" ' : '').'/>'.$this->l('No').'
				</div>
				<div class="margin-form" style="padding:0"><input type="submit" name="submitUpdate" value="'.$this->l('Update').'" class="button" style="width:150px"/></div>
			</fieldset>
		</form>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post" enctype="multipart/form-data">
			<fieldset class="space" style="float:left;width:222px;height:230px;margin-right:20px"><legend>'.$this->l('IMAGE').'</legend>
				<div class="margin-form" style="padding:0">';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					{
						$context = Context::getContext();
						$id_shop = $context->shop->id;
						$this->_html.= '<img src="'.$this->_path.'img/footer_img_'.(int)$id_shop.'.png" style="width:180px;height:50px"/><br />';
					}
					else
					{
						$this->_html.= '<img src="'.$this->_path.'img/footer_img_1.png" style="width:180px;height:50px"/><br />';
					}
					$this->_html.= '<input type="file" name="footer_img" style="margin-top:20px" />
					<p>'.$this->l('Set the image of the footer').'<br/>'.$this->l('Accepted formats :').' JPG, GIF, PNG</p>
				</div>
				<div class="margin-form" style="margin-top:10px;padding:0"><input type="submit" name="submitAddImage" value="'.$this->l('Update').'" class="button" style="width:150px"/></div>
			</fieldset>
		</form>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset class="space" style="float:left;width:280px;height:230px"><legend>'.$this->l('COMPANY').'</legend>
				<label style="width:50px;text-align:left;padding:0">'.$this->l('Name').'</label>
				<div class="margin-form" style="padding:0 0 15px 50px">';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					{
						$context = Context::getContext();
						$id_shop = $context->shop->id;
						$company = Db::getInstance()->getRow('SELECT `name` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
					}
					else
					{
						$company = Db::getInstance()->getRow('SELECT `name` FROM '._DB_PREFIX_.'footercustom_company');
					}
					$this->_html.= '<input type="text" name="company_name" id="company_name" value="'.$company['name'].'" style="width:200px"/>
				</div>
				<label style="width:50px;text-align:left;padding:0">'.$this->l('Street').'</label>
				<div class="margin-form" style="padding:0 0 15px 50px">';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					{
						$context = Context::getContext();
						$id_shop = $context->shop->id;
						$company = Db::getInstance()->getRow('SELECT `street` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
					}
					else
					{
						$company = Db::getInstance()->getRow('SELECT `street` FROM '._DB_PREFIX_.'footercustom_company');
					}
					$this->_html.= '<input type="text" name="company_street" id="company_street" value="'.$company['street'].'" style="width:200px"/>
				</div>
				<label style="width:50px;text-align:left;padding:0">'.$this->l('City').'</label>
				<div class="margin-form" style="padding:0 0 15px 50px">';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					{
						$context = Context::getContext();
						$id_shop = $context->shop->id;
						$company = Db::getInstance()->getRow('SELECT `city` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
					}
					else
					{
						$company = Db::getInstance()->getRow('SELECT `city` FROM '._DB_PREFIX_.'footercustom_company');
					}
					$this->_html.= '<input type="text" name="company_city" id="company_city" value="'.$company['city'].'" style="width:200px"/>
				</div>
				<label style="width:50px;text-align:left;padding:0">'.$this->l('Phone').'</label>
				<div class="margin-form" style="padding:0 0 15px 50px">';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					{
						$context = Context::getContext();
						$id_shop = $context->shop->id;
						$company = Db::getInstance()->getRow('SELECT `phone` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
					}
					else
					{
						$company = Db::getInstance()->getRow('SELECT `phone` FROM '._DB_PREFIX_.'footercustom_company');
					}
					$this->_html.= '<input type="text" name="company_phone" id="company_phone" value="'.$company['phone'].'" style="width:200px"/>
				</div>
				<label style="width:50px;text-align:left;padding:0">'.$this->l('Mail').'</label>
				<div class="margin-form" style="padding:0 0 15px 50px">';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					{
						$context = Context::getContext();
						$id_shop = $context->shop->id;
						$company = Db::getInstance()->getRow('SELECT `mail` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
					}
					else
					{
						$company = Db::getInstance()->getRow('SELECT `mail` FROM '._DB_PREFIX_.'footercustom_company');
					}
					$this->_html.= '<input type="text" name="company_mail" id="company_mail" value="'.$company['mail'].'" style="width:200px"/>
				</div>
				<div class="margin-form" style="padding:0 0 0 50px"><input type="submit" name="submitCompanyInfos" value="'.$this->l('Update').'" class="button" style="width:150px"/></div>
			</fieldset>
		</form>	
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset class="space" style="clear:both;float:left;width:899px"><legend>'.$this->l('ADD OR EDIT A LINK').'</legend>
				<label style="width:40px;text-align:left;padding:2px 0">'.$this->l('Title').'</label>
				<div class="margin-form" style="float:left;width:220px;padding:0">';
					foreach ($languages as $language)
					$this->_html.= '<div id="title_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
						<input type="text" name="title_'.$language['id_lang'].'" id="titleInput_'.$language['id_lang'].'" value="" style="width:160px"/>
						<p>'.$this->l('Set the title of the link').'</p>
					</div>';
					$this->_html.= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'title', true);
				$this->_html.= '</div>
				<label style="width:40px;text-align:left;padding:2px 0">'.$this->l('URL').'</label>
				<div class="margin-form" style="float:left;width:220px;padding:0">';
					foreach ($languages as $language)
					$this->_html.= '<div id="link_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
						<input type="text" name="link_'.$language['id_lang'].'" id="linkInput_'.$language['id_lang'].'" value="" style="width:160px"/>
						<p>'.$this->l('Set the url of the link').'</p>
					</div>';
					$this->_html.= $this->displayFlags($languages, $defaultLanguage, $divLangName, 'link', true);
				$this->_html.= '</div>
				<div class="margin-form" style="float:left;width:240px;font-size:12px;font-weight:bold;padding:0">';
					foreach ($languages as $language)
					$this->_html.= '<div id="inblock_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
						<span>'.$this->l('Block N&ordm;').'</span>
						<select name="inblock_'.$language['id_lang'].'" id="inblockInput_'.$language['id_lang'].'" style="width:40px;height:20px;line-height:20px">
							<option value="1">'.$this->l('1').'</option>
							<option value="2">'.$this->l('2').'</option>
							<option value="3">'.$this->l('3').'</option>
						</select>
						<span style="margin-left:15px">'.$this->l('Position N&ordm;').'</span>
						<input type="text" name="position_'.$language['id_lang'].'" id="positionInput_'.$language['id_lang'].'" value="" style="width:25px;vertical-align:top"/>
						<p style="font-size:11px;font-weight:normal">'.$this->l('Set the location of the link').'</p>
					</div>';
				$this->_html.= '</div>
				<div class="margin-form" style="float:left;width:120px;padding:0">
					<input type="hidden" name="id" id="id" value="'.(isset($_POST['id']) ? $_POST['id'] : '').'"/>
					<input type="submit" id="submitAddBlock" name="submitAddBlock" value="'.$this->l('Add this link').'" class="button"/>
					<input type="submit" id="submitEditBlock" name="submitEditBlock" value="'.$this->l('Edit this link').'" class="button" style="display:none"/>
				</div>
			</fieldset>
		</form>';
		$this->listBlocks();
		$this->_html.= '<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset class="space" style="clear:both;float:left;width:274px;margin-right:10px"><legend>'.$this->l('BLOCK N&ordm;1').'</legend>
				<label style="width:40px;text-align:left;padding:0">'.$this->l('Title').'</label>
				<div class="margin-form" style="padding:0 0 0 40px">';
					foreach ($languages as $language)
					{
						$blocktitle1 = $this->getBlockTitle1($language['id_lang']);
						$this->_html.= '<div id="title1_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
							<input type="text" name="title1_'.$language['id_lang'].'" id="title1Input_'.$language['id_lang'].'" value="'.$blocktitle1['title1'].'" style="width:140px"/>
						</div>';
					}
					$this->_html.= $this->displayFlags($languages, $defaultLanguage, $divLangNameTitles, 'title1', true);
				$this->_html.= '</div>
				<div class="margin-form" style="clear:both;padding:10px 0 10px 40px"><input type="submit" name="submitAddBlockTitle" value="'.$this->l('Update').'" class="button" style="width:150px"/></div>';
				$this->displayBlocksList1();
			$this->_html.= '</fieldset>
			<fieldset class="space" style="float:left;width:274px;margin-right:10px"><legend>'.$this->l('BLOCK N&ordm;2').'</legend>
				<label style="width:40px;text-align:left;padding:0">'.$this->l('Title').'</label>
				<div class="margin-form" style="padding:0 0 0 40px">';
					foreach ($languages as $language)
					{
						$blocktitle2 = $this->getBlockTitle2($language['id_lang']);
						$this->_html.= '<div id="title2_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
							<input type="text" name="title2_'.$language['id_lang'].'" id="title2Input_'.$language['id_lang'].'" value="'.$blocktitle2['title2'].'" style="width:140px"/>
						</div>';
					}
					$this->_html.= $this->displayFlags($languages, $defaultLanguage, $divLangNameTitles, 'title2', true);
				$this->_html.= '</div>
				<div class="margin-form" style="clear:both;padding:10px 0 10px 40px"><input type="submit" name="submitAddBlockTitle" value="'.$this->l('Update').'" class="button" style="width:150px"/></div>';
				$this->displayBlocksList2();
			$this->_html.= '</fieldset>
			<fieldset class="space" style="float:left;width:274px"><legend>'.$this->l('BLOCK N&ordm;3').'</legend>
				<label style="width:40px;text-align:left;padding:0">'.$this->l('Title').'</label>
				<div class="margin-form" style="padding:0 0 0 40px">';
					foreach ($languages as $language)
					{
						$blocktitle3 = $this->getBlockTitle3($language['id_lang']);
						$this->_html.= '<div id="title3_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
							<input type="text" name="title3_'.$language['id_lang'].'" id="title3Input_'.$language['id_lang'].'" value="'.$blocktitle3['title3'].'" style="width:140px"/>
						</div>';
					}
					$this->_html.= $this->displayFlags($languages, $defaultLanguage, $divLangNameTitles, 'title3', true);
				$this->_html.= '</div>
				<div class="margin-form" style="clear:both;padding:10px 0 10px 40px"><input type="submit" name="submitAddBlockTitle" value="'.$this->l('Update').'" class="button" style="width:150px"/></div>';
				$this->displayBlocksList3();
			$this->_html.= '</fieldset>
		</form>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset class="space" style="clear:both;float:left;width:430px;margin-right:20px;height:160px"><legend>'.$this->l('NEWSLETTER').'</legend>
				<p style="margin:0;padding:0 0 2px">'.$this->l('Export list of visitors who have registered to the newsletter :').'</p>';
				$this->_html .= '<div class="margin-form" style="padding:0"><input type="submit" class="button" style="width:150px" name="submitExportFC" value="'.$this->l('Export CSV file').'"/></div>
				<p style="margin:10px 0 0;padding:0 0 2px">'.$this->l('Export list of customers who have registered to the newsletter :').'</p>';
				$this->_html .= '<div class="margin-form" style="padding:0"><input type="submit" class="button" style="width:150px" name="submitExportFCCustomers" value="'.$this->l('Export CSV file').'"/></div>
				<div class="margin-form" style="padding:0">
					<p style="margin:15px 0 0;padding:0">'.$this->l('Warning : do not use the default block newsletter of Prestashop if you use the newsletter of the FooterCustom').'</p>
				</div>
			</fieldset>
		</form>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset class="space" style="float:left;width:421px;height:160px"><legend>'.$this->l('SOCIAL NETWORKS').'</legend>
				<label style="width:110px;text-align:left;padding:0">'.$this->l('URL Facebook').'</label>
				<div class="margin-form" style="padding:0 0 15px 50px">';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					{
						$context = Context::getContext();
						$id_shop = $context->shop->id;
						$facebook = Db::getInstance()->getRow('SELECT `facebook` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
					}
					else
					{
						$facebook = Db::getInstance()->getRow('SELECT `facebook` FROM '._DB_PREFIX_.'footercustom_social');
					}
					$this->_html.= '<input type="text" name="facebook_url" id="facebook_url" value="'.$facebook['facebook'].'" style="width:280px"/>
				</div>
				<label style="width:110px;text-align:left;padding:0">'.$this->l('URL Twitter').'</label>
				<div class="margin-form" style="padding:0 0 15px 50px">';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					{
						$context = Context::getContext();
						$id_shop = $context->shop->id;
						$twitter = Db::getInstance()->getRow('SELECT `twitter` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
					}
					else
					{
						$twitter = Db::getInstance()->getRow('SELECT `twitter` FROM '._DB_PREFIX_.'footercustom_social');
					}
					$this->_html.= '<input type="text" name="twitter_url" id="twitter_url" value="'.$twitter['twitter'].'" style="width:280px"/>
				</div>
				<label style="width:110px;text-align:left;padding:0">'.$this->l('URL RSS feed').'</label>
				<div class="margin-form" style="padding:0 0 15px 50px">';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					{
						$context = Context::getContext();
						$id_shop = $context->shop->id;
						$rss = Db::getInstance()->getRow('SELECT `rss` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
					}
					else
					{
						$rss = Db::getInstance()->getRow('SELECT `rss` FROM '._DB_PREFIX_.'footercustom_social');
					}
					$this->_html.= '<input type="text" name="rss_url" id="rss_url" value="'.$rss['rss'].'" style="width:280px"/>
				</div>
				<div class="margin-form" style="padding:0 0 0 110px"><input type="submit" name="submitSocial" value="'.$this->l('Update').'" class="button" style="width:150px"/></div>
			</fieldset>
		</form>	
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post" enctype="multipart/form-data">
			<fieldset class="space" style="clear:both;float:left;width:899px"><legend>'.$this->l('EDITOR').'</legend>
				<label style="width:160px;text-align:left;padding:0">'.$this->l('Insert the informations of your choice (Images, texts, links...)').'</label>
				<div class="margin-form" style="padding:0 0 10px 180px">';
					foreach ($languages as $language)
					{
						$editor = $this->getEditor($language['id_lang']);
						$this->_html.= '<div id="editor_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float: left;">
							<textarea class="rte" cols="80" rows="30" id="editorInput_'.$language['id_lang'].'" name="editor_'.$language['id_lang'].'">'.$editor['editor'].'</textarea>
						</div>';
					}
					$this->_html.= $this->displayFlags($languages, $defaultLanguage, $divLangNameEditor, 'editor', true);
					$this->_html.= '<p class="clear"></p>
				</div>
				<div class="margin-form" style="padding:0 0 10px 180px"><input type="submit" name="submitAddEditor" value="'.$this->l('Update').'" class="button" style="width:150px"/></div>
			</fieldset>
		</form>';

		$isoTinyMCE = (file_exists(_PS_ROOT_DIR_.'/js/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en');
		$ad = dirname($_SERVER["PHP_SELF"]);
		$this->_html.= '<script type="text/javascript">	
			var iso = \''.$isoTinyMCE.'\' ;
			var pathCSS = \''._THEME_CSS_DIR_.'\' ;
			var ad = \''.$ad.'\' ;
		</script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tiny_mce/tiny_mce.js"></script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce.inc.js"></script>';
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$this->_html.= '<script type="text/javascript">$(document).ready(function(){tinySetup();});</script>';
	}

	function getBlocks($id_lang = NULL)
	{
		global $cookie;
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$this->context = Context::getContext();
			$id_shop = $this->context->shop->id;
			$result = array();
			if (!$blocks = Db::getInstance()->ExecuteS('SELECT f.`id_block`, fl.`position`
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND `id_shop`='.(int)$id_shop.' AND fl.`id_lang` = '.intval($cookie->id_lang).')
			ORDER BY `position`'))
				return false;
		}
		else
		{
			$result = array();
			if (!$blocks = Db::getInstance()->ExecuteS('SELECT f.`id_block`, fl.`position`
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND fl.`id_lang` = '.intval($cookie->id_lang).')
			ORDER BY `position`'))
				return false;
		}
		$i = 0;
		foreach ($blocks AS $block)
		{
			$result[$i]['id'] = $block['id_block'];
			if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			{
				$this->context = Context::getContext();
				$id_shop = $this->context->shop->id;
				$sql = 'SELECT `id_lang`, `title`, `link`, `inblock`, `position`
				FROM '._DB_PREFIX_.'footercustom_lang
				WHERE `id_block`='.(int)($block['id_block']).'
				AND `id_shop`='.(int)$id_shop;
			}
			else
			{
				$sql = 'SELECT `id_lang`, `title`, `link`, `inblock`, `position`
				FROM '._DB_PREFIX_.'footercustom_lang
				WHERE `id_block`='.(int)($block['id_block']);
			}
			if (isset($id_lang) AND is_numeric($id_lang) AND (int)($id_lang) > 0)
				$sql .= ' AND `id_lang` = '.(int)($id_lang);
			if (!$texts = Db::getInstance()->ExecuteS($sql))
				return false;
			foreach ($texts AS $text)
			{
				$result[$i]['title_'.$text['id_lang']] = $text['title'];
				$result[$i]['link_'.$text['id_lang']] = $text['link'];
				$result[$i]['inblock_'.$text['id_lang']] = $text['inblock'];
				$result[$i]['position_'.$text['id_lang']] = $text['position'];
			}
			$i++;
		}
		return $result;
	}

	function listBlocks()
	{
		$blocks = $this->getBlocks();
		global $currentIndex, $cookie, $adminObj;
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$token = Tools::safeOutput(Tools::getValue('token'));
		if ($blocks)
		{
			$this->_html.= '<script type="text/javascript">
				var currentUrl = \''.$currentIndex.'&configure='.$this->name.'\';';
				if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					$this->_html.= 'var token=\''.$token.'\';';
				else
					$this->_html.= 'var token=\''.$adminObj->token.'\';';
				$this->_html.= 'var blocks = new Array();';
				$var='';
				foreach ($blocks AS $block)
				{
					$var .= 'blocks['.$block['id'].'] = new Array(';
					$i=0;
					foreach ($languages AS $language)
					{
						if ($i>0)
						$var .= ",";
						$var .= $language['id_lang'];
						$title = isset($block['title_'.$language['id_lang']]) ? $block['title_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($title).'\'';
						$link = isset($block['link_'.$language['id_lang']]) ? $block['link_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($link).'\'';
						$inblock = isset($block['inblock_'.$language['id_lang']]) ? $block['inblock_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($inblock).'\'';
						$position = isset($block['position_'.$language['id_lang']]) ? $block['position_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($position).'\'';
						$i++;
					}
					$var .= ');';
				}
			$var .= '</script>';
			$this->_html.= $var;
		}
	}

	function displayBlocksList1()
	{
		$blocks = $this->getBlocks();
		global $cookie;
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		if (!$blocks)
			$this->_html.= '<p>'.$this->l('No links').'</p>';
		else
		{
			$this->_html.= '<table class="table" cellspacing="0" style="background:#FFF;border-bottom:none;width:274px;font-size:13px">
				<tr>
					<th style="border-bottom:1px solid #DFD5C3;width:12px;font-weight:bold;text-align:center"></th>
					<th style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3;font-weight:bold">'.$this->l('Title').'</th>
					<th style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3;width:45px;font-weight:bold;text-align:center">'.$this->l('Actions').'</th>
				</tr>';
				foreach ($blocks AS $block)
				{
					$position = isset($block['position_'.$cookie->id_lang]) ? $block['position_'.$cookie->id_lang] : $block['position_'.$defaultLanguage];
					$title = isset($block['title_'.$cookie->id_lang]) ? $block['title_'.$cookie->id_lang] : $block['title_'.$defaultLanguage];
					if ($block['inblock_'.$cookie->id_lang] == 1)
					{
						$this->_html.= '<tr>
							<td style="border-bottom:1px solid #DFD5C3;text-align:center">'.$position.'</td>
							<td style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3">'.$title.'</td>
							<td style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3;text-align:center">
								<img src="'._PS_ADMIN_IMG_.'edit.gif" onclick="blockEdit('.$block['id'].')" style="cursor:pointer;padding:0" title="'.$this->l('Edit').'"/>
								<img src="'._PS_ADMIN_IMG_.'delete.gif" onclick="blockDelete('.$block['id'].')" style="cursor:pointer;padding:0" title="'.$this->l('Delete').'"/>
							</td>
						</tr>';
					}
				}
			$this->_html.= '</table>
			<input type="hidden" id="languageFirst" value="'.$languages[0]['id_lang'].'"/>
			<input type="hidden" id="languageNb" value="'.sizeof($languages).'"/>';
		}
	}

	function displayBlocksList2()
	{
		$blocks = $this->getBlocks();
		global $cookie;
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		if (!$blocks)
			$this->_html.= '<p>'.$this->l('No links').'</p>';
		else
		{
			$this->_html.= '<table class="table" cellspacing="0" style="background:#FFF;border-bottom:none;width:274px;font-size:13px">
				<tr>
					<th style="border-bottom:1px solid #DFD5C3;width:12px;font-weight:bold;text-align:center"></th>
					<th style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3;font-weight:bold">'.$this->l('Title').'</th>
					<th style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3;width:45px;font-weight:bold;text-align:center">'.$this->l('Actions').'</th>
				</tr>';
				foreach ($blocks AS $block)
				{
					$position = isset($block['position_'.$cookie->id_lang]) ? $block['position_'.$cookie->id_lang] : $block['position_'.$defaultLanguage];
					$title = isset($block['title_'.$cookie->id_lang]) ? $block['title_'.$cookie->id_lang] : $block['title_'.$defaultLanguage];
					if ($block['inblock_'.$cookie->id_lang] == 2)
					{
						$this->_html.= '<tr>
							<td style="border-bottom:1px solid #DFD5C3;text-align:center">'.$position.'</td>
							<td style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3">'.$title.'</td>
							<td style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3;text-align:center">
								<img src="'._PS_ADMIN_IMG_.'edit.gif" onclick="blockEdit('.$block['id'].')" style="cursor:pointer;padding:0" title="'.$this->l('Edit').'"/>
								<img src="'._PS_ADMIN_IMG_.'delete.gif" onclick="blockDelete('.$block['id'].')" style="cursor:pointer;padding:0" title="'.$this->l('Delete').'"/>
							</td>
						</tr>';
					}
				}
			$this->_html.= '</table>
			<input type="hidden" id="languageFirst" value="'.$languages[0]['id_lang'].'"/>
			<input type="hidden" id="languageNb" value="'.sizeof($languages).'"/>';
		}
	}

	function displayBlocksList3()
	{
		$blocks = $this->getBlocks();
		global $cookie;
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		if (!$blocks)
			$this->_html.= '<p>'.$this->l('No links').'</p>';
		else
		{
			$this->_html.= '<table class="table" cellspacing="0" style="background:#FFF;border-bottom:none;width:274px;font-size:13px">
				<tr>
					<th style="border-bottom:1px solid #DFD5C3;width:12px;font-weight:bold;text-align:center"></th>
					<th style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3;font-weight:bold">'.$this->l('Title').'</th>
					<th style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3;width:45px;font-weight:bold;text-align:center">'.$this->l('Actions').'</th>
				</tr>';
				foreach ($blocks AS $block)
				{
					$position = isset($block['position_'.$cookie->id_lang]) ? $block['position_'.$cookie->id_lang] : $block['position_'.$defaultLanguage];
					$title = isset($block['title_'.$cookie->id_lang]) ? $block['title_'.$cookie->id_lang] : $block['title_'.$defaultLanguage];
					if ($block['inblock_'.$cookie->id_lang] == 3)
					{
						$this->_html.= '<tr>
							<td style="border-bottom:1px solid #DFD5C3;text-align:center">'.$position.'</td>
							<td style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3">'.$title.'</td>
							<td style="border-bottom:1px solid #DFD5C3;border-left:1px solid #DFD5C3;text-align:center">
								<img src="'._PS_ADMIN_IMG_.'edit.gif" onclick="blockEdit('.$block['id'].')" style="cursor:pointer;padding:0" title="'.$this->l('Edit').'"/>
								<img src="'._PS_ADMIN_IMG_.'delete.gif" onclick="blockDelete('.$block['id'].')" style="cursor:pointer;padding:0" title="'.$this->l('Delete').'"/>
							</td>
						</tr>';
					}
				}
			$this->_html.= '</table>
			<input type="hidden" id="languageFirst" value="'.$languages[0]['id_lang'].'"/>
			<input type="hidden" id="languageNb" value="'.sizeof($languages).'"/>';
		}
	}

	function hookHeader($params)
	{
		global $smarty;
		$smarty->assign(array('this_path' => $this->_path));
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$this->context->controller->addCSS(($this->_path).'css/footercustom.css', 'all');
		else
			Tools::addCSS($this->_path.'css/footercustom.css','all');
	}

	function hookFooter($params)
	{
		global $smarty, $cookie;
		if (Tools::isSubmit('submitFCNewsletter'))
		{
			$this->newsletterRegistration();
			if ($this->error)
			{
				$smarty->assign(array(
					'msg' => $this->error,
					'nw_value' => isset($_POST['email']) ? pSQL($_POST['email']) : false,
					'nw_error' => true
				));
			}
			elseif ($this->valid)
			{
				$smarty->assign(array(
					'msg' => $this->valid,
					'nw_error' => false
				));
			}
		}
		$blocktitle1 = $this->getBlockTitle1($cookie->id_lang);
		$blocktitle2 = $this->getBlockTitle2($cookie->id_lang);
		$blocktitle3 = $this->getBlockTitle3($cookie->id_lang);
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			$this->context = Context::getContext();
			$id_shop = $this->context->shop->id;
			$sql1 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND `id_shop`='.(int)$id_shop.' AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 1
			ORDER BY `position`';
			$blocks1 = Db::getInstance()->ExecuteS($sql1);
			$sql2 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND `id_shop`='.(int)$id_shop.' AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 2
			ORDER BY `position`';
			$blocks2 = Db::getInstance()->ExecuteS($sql2);
			$sql3 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND `id_shop`='.(int)$id_shop.' AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 3
			ORDER BY `position`';
			$blocks3 = Db::getInstance()->ExecuteS($sql3);
			$company_name = Db::getInstance()->getRow('SELECT `name` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
			$company_street = Db::getInstance()->getRow('SELECT `street` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
			$company_city = Db::getInstance()->getRow('SELECT `city` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
			$company_phone = Db::getInstance()->getRow('SELECT `phone` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
			$company_mail = Db::getInstance()->getRow('SELECT `mail` FROM '._DB_PREFIX_.'footercustom_company WHERE `id_shop`='.(int)$id_shop.'');
			$facebook_url = Db::getInstance()->getRow('SELECT `facebook` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
			$twitter_url = Db::getInstance()->getRow('SELECT `twitter` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
			$rss_url = Db::getInstance()->getRow('SELECT `rss` FROM '._DB_PREFIX_.'footercustom_social WHERE `id_shop`='.(int)$id_shop.'');
			$smarty->assign('id_shop', $id_shop);
		}
		else
		{
			$sql1 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 1
			ORDER BY `position`';
			$blocks1 = Db::getInstance()->ExecuteS($sql1);
			$sql2 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 2
			ORDER BY `position`';
			$blocks2 = Db::getInstance()->ExecuteS($sql2);
			$sql3 = 'SELECT f.`id_block` AS id, fl.`title` AS title, fl.`link` AS link
			FROM `'._DB_PREFIX_.'footercustom` f
			JOIN `'._DB_PREFIX_.'footercustom_lang` fl ON (f.`id_block` = fl.`id_block` AND fl.`id_lang` = '.intval($cookie->id_lang).')
			WHERE `inblock` = 3
			ORDER BY `position`';
			$blocks3 = Db::getInstance()->ExecuteS($sql3);
			$company_name = Db::getInstance()->getRow('SELECT `name` FROM '._DB_PREFIX_.'footercustom_company');
			$company_street = Db::getInstance()->getRow('SELECT `street` FROM '._DB_PREFIX_.'footercustom_company');
			$company_city = Db::getInstance()->getRow('SELECT `city` FROM '._DB_PREFIX_.'footercustom_company');
			$company_phone = Db::getInstance()->getRow('SELECT `phone` FROM '._DB_PREFIX_.'footercustom_company');
			$company_mail = Db::getInstance()->getRow('SELECT `mail` FROM '._DB_PREFIX_.'footercustom_company');
			$facebook_url = Db::getInstance()->getRow('SELECT `facebook` FROM '._DB_PREFIX_.'footercustom_social');
			$twitter_url = Db::getInstance()->getRow('SELECT `twitter` FROM '._DB_PREFIX_.'footercustom_social');
			$rss_url = Db::getInstance()->getRow('SELECT `rss` FROM '._DB_PREFIX_.'footercustom_social');
		}
		$editor = $this->getEditor($cookie->id_lang);
		$smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'fc_img' => Configuration::get('FC_IMG'),
			'fc_news' => Configuration::get('FC_NEWS'),
			'fc_social' => Configuration::get('FC_SOCIAL'),
			'fc_links' => Configuration::get('FC_LINKS'),
			'fc_editor' => Configuration::get('FC_EDITOR'),
			'blocktitle1' => $blocktitle1['title1'],
			'blocktitle2' => $blocktitle2['title2'],
			'blocktitle3' => $blocktitle3['title3'],
			'blocks1' => $blocks1,
			'blocks2' => $blocks2,
			'blocks3' => $blocks3,
			'company_name' => $company_name,
			'company_street' => $company_street,
			'company_city' => $company_city,
			'company_phone' => $company_phone,
			'company_mail' => $company_mail,
			'facebook_url' => $facebook_url,
			'twitter_url' => $twitter_url,
			'rss_url' => $rss_url,
			'editor' => $editor['editor']
		));
		return $this->display(__FILE__, 'footercustom.tpl');
	}
}
?>