{* Template Prestashop DiscountShop
 * Copyright Prestacrea
 * Author: Prestacrea
 * Website: http://www.prestacrea.com *}

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="{$lang_iso}">

<!-- 
 * Template Prestashop DiscountShop V.2.9
 * Copyright Prestacrea
 * Author: Prestacrea
 * Website: http://www.prestacrea.com
-->

	<head>
		<title>{$meta_title|escape:'htmlall':'UTF-8'}</title>
{if isset($meta_description) AND $meta_description}
		<meta name="description" content="{$meta_description|escape:html:'UTF-8'}" />
{/if}
{if isset($meta_keywords) AND $meta_keywords}
		<meta name="keywords" content="{$meta_keywords|escape:html:'UTF-8'}" />
{/if}
		<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=utf-8" />
		{if isset($meta_language)}<meta http-equiv="content-language" content="{$meta_language}" />{/if}
		<meta name="generator" content="PrestaShop" />
		<meta name="robots" content="{if isset($nobots)}no{/if}index,{if isset($nofollow) && $nofollow}no{/if}follow" />
		<link rel="icon" type="image/vnd.microsoft.icon" href="{if isset($favicon_url)}{$favicon_url}?{$img_update_time}{else}{$img_ps_dir}favicon.ico?{$img_update_time}{/if}" />
		<link rel="shortcut icon" type="image/x-icon" href="{if isset($favicon_url)}{$favicon_url}?{$img_update_time}{else}{$img_ps_dir}favicon.ico?{$img_update_time}{/if}" />
		<script type="text/javascript">
			var baseDir = '{$content_dir}';
			{if isset($base_uri)}var baseUri = '{$base_uri}';{/if}
			var static_token = '{$static_token}';
			var token = '{$token}';
			var priceDisplayPrecision = {$priceDisplayPrecision*$currency->decimals};
			var priceDisplayMethod = {$priceDisplay};
			var roundMode = {$roundMode};
			var prestashop_version = {if isset($b2b_enable)}1.5{else}1.4{/if};
		</script>

{if isset($css_files)}
	{foreach from=$css_files key=css_uri item=media}
	<link href="{$css_uri}" rel="stylesheet" type="text/css" media="{$media}" />
	{/foreach}
{/if}
{if isset($js_files)}
	{foreach from=$js_files item=js_uri}
	<script type="text/javascript" src="{$js_uri}"></script>
	{/foreach}
{/if}
<script type="text/javascript" src="{$js_dir}formstyle.js"></script>
		{$HOOK_HEADER}
	</head>
	
	<body {if isset($page_name)}id="{$page_name|escape:'htmlall':'UTF-8'}"{/if}>
	{if !$content_only}
		{if isset($restricted_country_mode) && $restricted_country_mode}
		<div id="restricted-country">
			<p>{l s='You cannot place a new order from your country.'}</p>
		</div>
		{/if}
		<div id="page" class="clearfix">

			<!-- Header -->
			<div id="header">
				<a id="header_logo" href="{$base_dir}" title="{$shop_name|escape:'htmlall':'UTF-8'}">
					<img class="logo" src="{if isset($logo_url)}{$logo_url}{else}{$img_ps_dir}logo.jpg{/if}" alt="{$shop_name|escape:'htmlall':'UTF-8'}" />
				</a>
				{$HOOK_TOP}
			</div>

			<div id="columns" class="clearfix">
				<!-- Left -->
				<div id="left_column" class="column">
					{$HOOK_LEFT_COLUMN}
				</div>

				<!-- Center -->
				<div id="center_column" class="column">
	{/if}