{* Template Prestashop DiscountShop
 * Copyright Prestacrea
 * Author: Prestacrea
 * Website: http://www.prestacrea.com *}

{capture name=path}{l s='Manufacturers'}{/capture}
{include file="$tpl_dir./breadcrumb.tpl"}

<h1>{l s='Manufacturers'}</h1>

{if isset($errors) AND $errors}
	{include file="$tpl_dir./errors.tpl"}
{else}
	<p class="nbrmanufacturer">{strip}
		<span>
			{if $nbManufacturers == 0}{l s='There are no manufacturers.'}
			{else}
				{if $nbManufacturers == 1}{l s='There is'}{else}{l s='There are'}{/if}&nbsp;
				{$nbManufacturers}&nbsp;
				{if $nbManufacturers == 1}{l s='manufacturer.'}{else}{l s='manufacturers.'}{/if}
			{/if}
		</span>{/strip}
	</p>

	{if $nbManufacturers > 0}
	
		<div class="content_sortPagiBar">
			{include file="$tpl_dir./pagination.tpl"}
		</div>
		
		<ul id="manufacturers_list">
		{foreach from=$manufacturers item=manufacturer name=manufacturers}
			<li class="clearfix {if $smarty.foreach.manufacturers.first}first_item{elseif $smarty.foreach.manufacturers.last}last_item{else}item{/if}"> 
				<div class="left_side">
					<!-- logo -->
					<div class="logo">
					{if $manufacturer.nb_products > 0}<a href="{$link->getmanufacturerLink($manufacturer.id_manufacturer, $manufacturer.link_rewrite)|escape:'htmlall':'UTF-8'}" title="{$manufacturer.name|escape:'htmlall':'UTF-8'}" class="lnk_img">{/if}
						<img src="{$img_manu_dir}{$manufacturer.id_manufacturer|escape:'htmlall':'UTF-8'}-medium.jpg" alt="{$manufacturer.name|escape:'htmlall':'UTF-8'}" width="80" height="80" />
					{if $manufacturer.nb_products > 0}</a>{/if}
					</div>
					<!-- name -->
					<h3>
						{if $manufacturer.nb_products > 0}<a href="{$link->getmanufacturerLink($manufacturer.id_manufacturer, $manufacturer.link_rewrite)|escape:'htmlall':'UTF-8'}" title="{$manufacturer.name|escape:'htmlall':'UTF-8'}">{/if}
						{$manufacturer.name|strip_tags:'UTF-8'|escape:'htmlall':'UTF-8'|truncate:60:'...'}
						{if $manufacturer.nb_products > 0}</a>{/if}
					</h3>
						{$manufacturer.description|strip_tags:'UTF-8'|escape:'htmlall':'UTF-8'|truncate:180:'...'}
				</div>
				<span class="bold">{if $manufacturer.nb_products == 0}{l s='No products'}{else}{$manufacturer.nb_products|intval}&nbsp;{if $manufacturer.nb_products == 1}{l s='product'}{else}{l s='products'}{/if}{/if}</span>

				<div class="right_side">
				{if $manufacturer.nb_products > 0}
					<a class="button" href="{$link->getmanufacturerLink($manufacturer.id_manufacturer, $manufacturer.link_rewrite)|escape:'htmlall':'UTF-8'}" title="{l s='View products'}">{l s='View products'}</a>
				{/if}
				</div>
				<div class="clear"></div>
			</li>
		{/foreach}
		</ul>
		
		<div class="content_sortPagiBar">
			{include file="$tpl_dir./pagination.tpl"}
		</div>
		
	{/if}
{/if}