{* Template Prestashop DiscountShop
 * Copyright Prestacrea
 * Author: Prestacrea
 * Website: http://www.prestacrea.com *}

{capture name=path}{l s='Our stores'}{/capture}
{include file="$tpl_dir./breadcrumb.tpl"}

<h1>{l s='Our stores'}</h1>

{if $simplifiedStoresDiplay}
	{if $stores|@count}
	{foreach $stores as $store}
		<div class="store-small clearfix">
			{if $store.has_picture}<p><img src="{$img_store_dir}{$store.id_store}.jpg" alt="{$store.name|escape:'htmlall':'UTF-8'}" /></p>{/if}
				<p class="bold">{$store.name|escape:'htmlall':'UTF-8'}</p><br />
				<p>{$store.address1|escape:'htmlall':'UTF-8'}</p>
				{if $store.address2}<p>{$store.address2|escape:'htmlall':'UTF-8'}</p>{/if}
				<p>{$store.postcode} {$store.city|escape:'htmlall':'UTF-8'}{if $store.state}, {$store.state}{/if}</p>
				<p>{$store.country|escape:'htmlall':'UTF-8'}</p>
				{if $store.phone}<br /><p><span class="bold">{l s='Phone :' js=0}</span> {$store.phone}</p>{/if}
				{if isset($store.working_hours)}
					{$store.working_hours}
				{else}
					{$sh = unserialize($store.hours)}
					{if $sh[0] OR $sh[1] OR $sh[2] OR $sh[3] OR $sh[4] OR $sh[5] OR $sh[6]}
						<div class="clear"></div>
						<br />
						<span class="store_hours bold">{l s='Store hours :'}</span>
						<br />
						<table>
							{if $sh[0]}<tr><td class="first_item bold">{l s='Monday'}</td><td>{$sh[0]}</td></tr>{/if}
							{if $sh[1]}<tr><td class="first_item bold">{l s='Tuesday'}</td><td>{$sh[1]}</td></tr>{/if}
							{if $sh[2]}<tr><td class="first_item bold">{l s='Wednesday'}</td><td>{$sh[2]}</td></tr>{/if}
							{if $sh[3]}<tr><td class="first_item bold">{l s='Thursday'}</td><td>{$sh[3]}</td></tr>{/if}
							{if $sh[4]}<tr><td class="first_item bold">{l s='Friday'}</td><td>{$sh[4]}</td></tr>{/if}
							{if $sh[5]}<tr><td class="first_item bold">{l s='Saturday'}</td><td>{$sh[5]}</td></tr>{/if}
							{if $sh[6]}<tr><td class="first_item bold">{l s='Sunday'}</td><td>{$sh[6]}</td></tr>{/if}
						</table>
					{/if}
				{/if}
		</div>
	{/foreach}
	{/if}
{else}
	<script type="text/javascript">
		// <![CDATA[
		var map;
		var markers = [];
		var infoWindow;
		var locationSelect;

		var defaultLat = '{$defaultLat}';
		var defaultLong = '{$defaultLong}';
		
		var translation_1 = '{l s='No stores found, try selecting a wider radius.' js=1}';
		var translation_2 = '{l s='store found - see details :' js=1}';
		var translation_3 = '{l s='stores found - see all results :' js=1}';
		var translation_4 = '{l s='Phone :' js=1}';
		var translation_5 = '{l s='Get Directions' js=1}';
		var translation_6 = '{l s='Not found' js=1}';
		
		var hasStoreIcon = '{$hasStoreIcon}';
		var distance_unit = '{$distance_unit}';
		var img_store_dir = '{$img_store_dir}';
		var img_ps_dir = '{$img_ps_dir}';
		var searchUrl = '{$searchUrl}';
		var logo_store = '{if isset($logo_store)}{$logo_store}{/if}';
		//]]>
	</script>

	<p>{l s='Enter a location (e.g. zip/postal code, address, city or country) in order to find the nearest stores.'}</p>
	<p>
		<label for="addressInput">{l s='Your location :'}</label>
		<input type="text" name="location" id="addressInput" value="{l s='Address, zip/postal code, city, state or country'}" onclick="this.value='';" />
	</p>
	<p>
		<label for="radiusSelect">{l s='Radius :'}</label> 
		<select name="radius" id="radiusSelect">
			<option value="15">15</option>
			<option value="25">25</option>
			<option value="50">50</option>
			<option value="100">100</option>
		</select> {$distance_unit}
		<img src="{$img_ps_dir}loader.gif" class="middle" alt="" id="stores_loader" />
	</p>
	<p class="clearfix">
		<input type="button" class="button" onclick="searchLocations();" value="{l s='Search'}" /> 
	</p>
	<div><select id="locationSelect"><option></option></select></div>
    <div id="map"></div>
	<table cellpadding="0" cellspacing="0" border="0" id="stores-table" class="table_block">
		<tr>
			<th>{l s='#'}</th>
			<th>{l s='Store'}</th>
			<th>{l s='Address'}</th>
			<th class="center">{l s='Distance'}</th>
		</tr>		
	</table>
{/if}