<?php
/**
 * Module opartdevis
 *
 * @category Prestashop
 * @category Module
 * @author    Olivier CLEMENCE <manit4c@gmail.com>
 * @copyright Op'art
 * @license   Tous droits réservés / Le droit d'auteur s'applique (All rights reserved / French copyright law applies)
 */

require_once(_PS_MODULE_DIR_.'opartdevis/models/OpartQuotation.php');

if (!defined('_PS_VERSION_'))
	exit;

class Opartdevis extends PaymentModule {

	public function __construct()
	{
		$this->name = 'opartdevis';
		$this->tab = 'payments_gateways';
		$this->version = '15.05.12';
		$this->author = 'Op\'art - Olivier CLEMENCE';
		$this->module_key = '5165c4489bcc64253b1c1cd98926a8a4';
		$this->need_instance = 0;
		$this->erreurs = array();
		$this->bootstrap = true;
		parent::__construct();

		$this->displayName = $this->l('Op\'art devis');
		$this->description = $this->l('This module allows your customers to create a quotation.');
		$this->confirmUninstall = $this->l('Are you sure you want to delete these details?');

		$this->context->smarty->assign(array(
			'module_name' => $this->name,
			'moduledir' => _MODULE_DIR_.$this->name.'/'
		));
		if (!extension_loaded('curl'))
			$this->warning = $this->l(' To properly display PDF, Php Curl extensions have to be loaded.');
	}

	public function install()
	{
		if (version_compare(_PS_VERSION_, '1.5.0', '<'))
			return false;
		$sql = array();
		include(dirname(__FILE__).'/sql/install.php');
		foreach ($sql as $s)
			if (!Db::getInstance()->execute($s))
				return false;

		// Install Tabs
		$this->installQuotationModuleTab();

		//Init
		$rand_key = Tools::substr(md5(rand(0, 1000000)), 0, 7);
		Configuration::updateValue('PS_OPART_DEVIS_SECURE_KEY', $rand_key);
		Configuration::updateValue('OPARTDEVIS_EXPIRETIME', 0);
		Configuration::updateValue('OPARTDEVIS_MAXPRODFIRSTPAGE', 7);
		Configuration::updateValue('OPARTDEVIS_MAXPRODPAGE', 10);

		if (!parent::install() ||
			!$this->registerHook('payment') ||
			!$this->registerHook('displayLeftColumn') ||
			!$this->registerHook('displayShoppingCart') ||
			!$this->registerHook('displayCustomerAccount') ||
			!$this->registerHook('header') ||
			!$this->registerHook('displayAdminView'))
			return false;
		return true;
	}

	public function uninstall()
	{
		Configuration::deleteByName('PS_OPART_DEVIS_SECURE_KEY');
		Configuration::deleteByName('OPARTDEVIS_SENDMAILTOCUSTOMER');
		Configuration::deleteByName('OPARTDEVIS_SENDMAILTOADMIN');
		Configuration::deleteByName('OPARTDEVIS_ADMINCONTACTID');
		Configuration::deleteByName('OPARTDEVIS_MAXPRODFIRSTPAGE');
		Configuration::deleteByName('OPARTDEVIS_MAXPRODPAGE');
		Configuration::deleteByName('OPARTDEVIS_EXPIRETIME');

		$sql = array();
		include(dirname(__FILE__).'/sql/uninstall.php');
		foreach ($sql as $s)
			if (!Db::getInstance()->execute($s))
				return false;

		/* Uninstall Tabs */
		$tab = new Tab((int)Tab::getIdFromClassName('AdminOpartdevis'));
		$tab->delete();

		if (!parent::uninstall())
			return false;
		return true;
	}

	private function installQuotationModuleTab()
	{
		$tab = new Tab();
		$tab->class_name = 'AdminOpartdevis';
		$tab->module = 'opartdevis';
		$tab->id_parent = (int)Tab::getIdFromClassName('AdminOrders');
		$tab->position = Tab::getNewLastPosition($tab->id_parent);
		foreach (Language::getLanguages(false) as $lang)
			$tab->name[(int)$lang['id_lang']] = 'Quotations';
		$tab->save();
	}

	public function hookPayment()
	{
		$this->smarty->assign(array(
			'this_path' => $this->_path,
			'this_path_opartdevis' => $this->_path,
		));
		if (version_compare(_PS_VERSION_, '1.6.0', '<'))
			return $this->display(__FILE__, 'views/templates/hook/payment_15.tpl');
		else
			return $this->display(__FILE__, 'views/templates/hook/payment.tpl');
	}

	public function hookHeader()
	{
		$this->context->controller->addCSS(_MODULE_DIR_.'opartdevis/views/css/opartdevis_1.css');
	}

	public function hookDisplayShoppingCart()
	{
		return $this->display(__FILE__, 'views/templates/hook/displayButtonCart.tpl');
	}

	public function hookDisplayLeftColumn()
	{
		/* $this->smarty->assign('idCart',$this->context->cart->id); */
		$html = $this->display(__FILE__, 'views/templates/hook/displayButton.tpl');
		$html .= $this->display(__FILE__, 'views/templates/hook/displayButton2.tpl');
		return $html;
	}

	public function hookDisplayRightColumn()
	{
		return $this->hookDisplayLeftColumn();
	}

	public function hookDisplayFooter()
	{
		return $this->hookDisplayLeftColumn();
	}

	public function hookDisplayTop()
	{
		$this->smarty->assign('this_path', dirname(__FILE__));
		return $this->display(__FILE__, 'views/templates/hook/displayTop.tpl');
	}

	public function hookDisplayCustomerAccount()
	{
		if (version_compare(_PS_VERSION_, '1.6.0', '<'))
			return $this->display(__FILE__, 'views/templates/front/myaccount_15.tpl');
		else
			return $this->display(__FILE__, 'views/templates/front/myaccount.tpl');
	}

	public function hookDisplayAdminView()
	{
		$controller_name = Tools::getValue('controller');

		if ($controller_name == 'AdminCarts')
		{
			$token = Tools::getAdminToken('AdminOpartdevis'.(int)Tab::getIdFromClassName('AdminOpartdevis').(int)Context::getContext()->employee->id);
			$id_cart = Tools::getValue('id_cart');
			$href = 'index.php?controller=AdminOpartdevis&transformThisCartId='.$id_cart.'&token='.$token;
			return '<a class="btn btn-default" href="'.$href.'"><i class="icon-shopping-cart"></i> '.$this->l('Create a quotation from this cart').'</a>';
		}
	}

	public function getContent()
	{
		$fields_value = array();
		$this->postProcess();

		$fields_value['sendMailtoCustomer'] = Configuration::get('OPARTDEVIS_SENDMAILTOCUSTOMER');
		$fields_value['sendMailtoAdmin'] = Configuration::get('OPARTDEVIS_SENDMAILTOADMIN');
		$fields_value['adminContactId'] = Configuration::get('OPARTDEVIS_ADMINCONTACTID');
		$fields_value['freeText'] = OpartQuotation::getQuotationText(0);
		$fields_value['validationText'] = OpartQuotation::getQuotationText(1);
		$fields_value['goodforagrementText'] = OpartQuotation::getQuotationText(2);
		$fields_value['maxProdFirstPage'] = Configuration::get('OPARTDEVIS_MAXPRODFIRSTPAGE');
		$fields_value['maxProdPage'] = Configuration::get('OPARTDEVIS_MAXPRODPAGE');
		$fields_value['expireTime'] = Configuration::get('OPARTDEVIS_EXPIRETIME');

		if (isset($fields_value))
			$this->context->smarty->assign('fieldsValue', $fields_value);

		/* 1.5 compatibility */
		$languages = Language::getLanguages();
		foreach (Language::getLanguages() as $key => $lang)
			$languages[$key]['is_default'] = ($lang['id_lang'] == Context::getContext()->language->id) ? 1 : 0;

		$this->context->smarty->assign(array(
			'adminModuleUrl' => 'index.php?controller=AdminModules&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
			'erreurs' => $this->erreurs,
			'languages' => $languages,
			'defaultLangId' => $this->context->language->id,
			'contacts' => Contact::getContacts($this->context->language->id)
		));

		$html = $this->display(__FILE__, 'views/templates/admin/header.tpl');

		if (version_compare(_PS_VERSION_, '1.6.0', '<'))
		{
			$html .= $this->display(__FILE__, 'views/templates/admin/form_15.tpl');
			$this->context->controller->addJS(_PS_JS_DIR_.'tiny_mce/tiny_mce.js');
			$this->context->controller->addJS(_PS_JS_DIR_.'tinymce.inc.js');
		}
		else
			$html .= $this->display(__FILE__, 'views/templates/admin/form.tpl');

		$html .= $this->display(__FILE__, 'views/templates/admin/help.tpl');
		return $html;
	}

	public function postProcess()
	{
		if (Tools::isSubmit('submitSettings'))
		{
			Configuration::updateValue('OPARTDEVIS_SENDMAILTOCUSTOMER', (Tools::getValue('sendMailtoCustomer') == 1) ? 1 : 0);
			Configuration::updateValue('OPARTDEVIS_SENDMAILTOADMIN', (Tools::getValue('sendMailtoAdmin') == 1) ? 1 : 0);

			Configuration::updateValue('OPARTDEVIS_ADMINCONTACTID', Tools::getValue('adminContactId'));

			$max_prod_first_page = Tools::getValue('maxProdFirstPage');
			if (is_numeric($max_prod_first_page))
				Configuration::updateValue('OPARTDEVIS_MAXPRODFIRSTPAGE', $max_prod_first_page);
			else
				$this->erreurs[] = Tools::displayError($this->l('max product on first page have to be a number'));

			$max_prod_page = Tools::getValue('maxProdPage');
			if (is_numeric($max_prod_page))
				Configuration::updateValue('OPARTDEVIS_MAXPRODPAGE', $max_prod_page);
			else
				$this->erreurs[] = Tools::displayError($this->l('max product on pages have to be a number'));

			$expire_time = Tools::getValue('expireTime');
			if (is_numeric($max_prod_page))
				Configuration::updateValue('OPARTDEVIS_EXPIRETIME', $expire_time);
			else
				$this->erreurs[] = Tools::displayError($this->l('Expiration time have to be a number'));

			/* delete all text */
			$sql = 'DELETE FROM '._DB_PREFIX_.'opartdevis_text';
			db::getInstance()->execute($sql);
			$insert = '';
			foreach (Language::getLanguages() as $lang)
			{
				//freetext
				$values = '"'.pSQL(Tools::getValue('freeText_'.$lang['id_lang']), true).'",0,'.(int)$lang['id_lang'];
				$insert .= ($insert == '') ? '('.$values.')' : ',('.$values.')';
				//validationText
				$values = "'".pSQL(Tools::getValue('validationText_'.$lang['id_lang']), true)."',1,".(int)$lang['id_lang'];
				$insert .= ($insert == '') ? '('.$values.')' : ',('.$values.')';
				//goodforagrementText
				$values = "'".pSQL(Tools::getValue('goodforagrementText_'.$lang['id_lang']), true)."',2,".(int)$lang['id_lang'];
				$insert .= ($insert == '') ? '('.$values.')' : ',('.$values.')';
			}
			$sql = 'INSERT INTO '._DB_PREFIX_.'opartdevis_text (text_value,text_type,id_lang) VALUES '.$insert;

			db::getInstance()->execute($sql);
		}
	}

}

?>