﻿<?php
// PROCESS POUR LES PS 1.5..

class PaypalSubscriptionsIpnModuleFrontController extends ModuleFrontController {

    
    public function initContent() {
		
        parent :: initContent();
        
	
	PSLog::addLog(Tools::getValue('txn_type'), $_POST);
		
	
	if (Tools::isEmpty('txn_type'))
	    die('txn_type missing');
		
	if (Tools::isEmpty('recurring_payment_id'))
	    die('recurring_payment_id missing');
	
	$txn_type = Tools::getValue('txn_type');
	$paypal_profile_id = Tools::getValue('recurring_payment_id');
	
	
	$SMDetected = PSTools::detectSubscriptionsManager();
	
	$PSPaypalSubscriptionGet = PSPaypalSubscription::getList(array('paypal_profile' => $paypal_profile_id));
	
	if(empty($PSPaypalSubscriptionGet))
	    die('unable to load subscription');
	
	$PSPaypalSubscription = new PSPaypalSubscription($PSPaypalSubscriptionGet[0]['id_paypal_subscription']);
		
	
	switch ($txn_type) {
	   
	    case 'recurring_payment_profile_created': //Création d'un abonnement

		// Fait dans le process_payment.php
		
	    break;	   
	    case 'recurring_payment': // Réception du paiement
		
		if($PSPaypalSubscription->paypal_payer_id != Tools::getValue('payer_id') || $PSPaypalSubscription->paypal_profile_id != Tools::getValue('recurring_payment_id'))
		    die('Unable to find subscription of the shop');
		
		
		$url = 'https://api-3t.paypal.com/nvp';	

		$l_paypal_merchant_user_name =	Configuration::get('paypal_merchant_user_name');
		$l_paypal_merchant_password =	Configuration::get('paypal_merchant_password');
		$l_paypal_merchant_signature =	Configuration::get('paypal_merchant_signature');

		$postFields = array();
		$postFields['USER'] = $l_paypal_merchant_user_name;
		$postFields['PWD'] = $l_paypal_merchant_password;
		$postFields['SIGNATURE'] = $l_paypal_merchant_signature;
		$postFields['METHOD'] = 'GetRecurringPaymentsProfileDetails';
		$postFields['PROFILEID'] = $paypal_profile_id;
		$postFields['VERSION'] = 94;


		$postFields = PSTools::serializePostFields($postFields);

		$response = PSTools::curlGet($url, $postFields);
		
		if($response['ACK'] != 'Success')
		    die('Error while getting informations');

		if($response['NUMCYCLESCOMPLETED'] == 1 && $response['NUMCYCLESREMAINING'] > 0){
		    $employeeList = Employee::getEmployees();
		    $id_employee = $employeeList[0]['id_employee'];

		    // Déclenchement d'un nouvel état de commande pour l'abonnement sélectionné
		    $order = new Order($PSPaypalSubscription->id_order);

		    $orderHistory = new OrderHistoryCore();
		    $orderHistory->id_order = $order->id;
		    $orderHistory->id_employee = $id_employee;
		    $orderHistory->changeIdOrderState(Configuration::get('PS_OS_PAYMENT'), $order->id, true); // Payé
		    $orderHistory->save();
		}
		elseif($response['NUMCYCLESCOMPLETED'] > 1 && $response['NUMCYCLESREMAINING'] > 0){
		    if($SMDetected){
			
			$subscriptionGet = SMSubscription::getList(array('id_order' => (int)$PSPaypalSubscription->id_order));
			$subscription = new SMSubscription($subscriptionGet->id_subscription);
			
			// Duplique l'ancienne commande et en cree une nouvelle
			$id_order = SubscriptionsManager::processOrderAndCreateInvoice($subscription);

			SMSAutomaticBilling::addAutomaticBilling($subscription, $id_order); // Generation d'un etat de paiement

			// Met a jour la prochaine date de passage	
			$subscription->date_check = $subscription->getNextDateCheck();
			$subscription->update();

			SMLog::addLog('check_SMSubscription', $subscription, 0);
		    }
		}

		
		
		
	    break;	   
	    case 'recurring_payment_failed': // Echec de paiement

	    break;	   
	    case 'recurring_payment_skipped': // Paiement sauté (Paypal retentera 3 fois à 5 jours d'intervalle)

	    break;
	    case 'recurring_payment_suspended': // Abonnement suspendu

	    break;
	
	    case 'recurring_payment_suspended_due_to_max_failed_payment': // Abonnement suspendu car trop d'échecs

		if(!$SMDetected || $PSPaypalSubscription->paypal_payer_id != Tools::getValue('payer_id') || $PSPaypalSubscription->paypal_profile_id != Tools::getValue('recurring_payment_id'))
		    break;

		if(empty($PSPaypalSubscription->id)) 
		    die('Unable to find paypal_profile_id');
		
		    $getSubscription = SMSubscription::getList(array('id_order' => (int)$PSPaypalSubscription->id_order));

		    $subscription = new SMSubscription($getSubscription->id_subscription);

		    $subscription->paypalStopSubscription();
		    		    
		    $employeeList = Employee::getEmployees();
		    $id_employee = $employeeList[0]['id_employee'];
		    
		    SMLog::addLog('paypalSuspended_SMSubscription', $subscription, $id_employee);
		    
		    
	    break;	    
	    case 'recurring_payment_profile_cancel': // Abonnement annulé

		if(!$SMDetected || $PSPaypalSubscription->paypal_payer_id != Tools::getValue('payer_id') || $PSPaypalSubscription->paypal_profile_id != Tools::getValue('recurring_payment_id'))
		    break;

		if(empty($PSPaypalSubscription->id)) 
		    die('Unable to find paypal_profile_id');
		
		    $getSubscription = SMSubscription::getList(array('id_order' => (int)$PSPaypalSubscription->id_order));

		    $subscription = new SMSubscription($getSubscription->id_subscription);

		    if($subscription->status == SMSubscription::$STATUS_ACTIVE){
			$subscription->paypalStopSubscription();

			$employeeList = Employee::getEmployees();
			$id_employee = $employeeList[0]['id_employee'];

			SMLog::addLog('paypalStop_SMSubscription', $subscription, $id_employee);
		    }
    
		
	    break;
	}
 
	
                
    }
}

