<?php

/**
 * Fonctions outils pour le module Gestion d'abonnements
 */
abstract class PSTools extends ObjectModelCore {

    public function __construct() {
	parent::__construct();
    }
    
    /**
     * Sérialise les données POST
     */
    static public function serializePostFields($postFields) {

	foreach ($postFields as $key => $value) {
	    $value = urlencode($value);
	    $postFields[$key] = "$key=$value";
	}

	$postFields = implode($postFields, '&');

	return $postFields;
    }
    
    /**
     * Envoi des données à Paypal
     */
    static public function curlGet($url, $postfields = false) {

	static $curl;

	if (empty($curl)) {
	    $cookiejar = 'curl_cookiejar.txt';
	    @unlink($cookiejar);
	    $curl = curl_init();
	    curl_setopt($curl, CURLOPT_COOKIEJAR, $cookiejar);
	    curl_setopt($curl, CURLOPT_COOKIEFILE, $cookiejar);
	    curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
	    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	    curl_setopt($curl, CURLOPT_MAXREDIRS, 5);
	    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
	}
	curl_setopt($curl, CURLOPT_URL, $url);
	if (stripos($url, 'https') !== false) {
	    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
	    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
	}
	if ($postfields) {
	    curl_setopt($curl, CURLOPT_POST, 1);
	    curl_setopt($curl, CURLOPT_POSTFIELDS, $postfields);
	}
	if (($retcurl = curl_exec($curl)) === false) {
	    return NULL;
	}

	$response = array();
	parse_str($retcurl, $response);

	return $response;
    }
    
    /**
     * Récupération de la dernière ligne insérée dans la table PS_paypal
     */
    static public function getLastPaypalSubscriptions($paypal_token = null) {

	if ($paypal_token == NULL) 	    
	    return false;
	

	$paypalSubscription = PSPaypalSubscription::getList(array('paypal_token' => $paypal_token));

	return $paypalSubscription[0];
    }
    
    /**
    * Récupération des données de configuration du module
    */
    static public function getModuleConfiguration() {

	$config = array();

	$config['billing_period'] = Configuration::get('billing_period');
	$config['billing_frequency'] = Configuration::get('billing_frequency');
	$config['billing_nb_cycles'] = Configuration::get('billing_nb_cycles');
	$config['billing_max_failed_payments'] = Configuration::get('billing_max_failed_payments');
	$config['paypal_merchant_user_name'] = Configuration::get('paypal_merchant_user_name');
	$config['paypal_merchant_password'] = Configuration::get('paypal_merchant_password');
	$config['paypal_merchant_signature'] = Configuration::get('paypal_merchant_signature');
	$config['paypal_return_url_cancel'] = Configuration::get('paypal_return_url_cancel');


	return $config;
    }

    
    /**
     * Détecte si le module Gestion d'abonnement éxiste
     */
    static public function detectSubscriptionsManager() {

	$subscriptionsmanager = ModuleCore::getInstanceByName('subscriptionsmanager');

	if (!empty($subscriptionsmanager))
	    return $subscriptionsmanager->active;

	return false;
    }

    

    /**
     * Récupération des informations d'un produit ou d'un ensemble de produits
     */
    static public function getProductName($id_cart) {

	$defaultLanguage = (int) (Configuration::get('PS_LANG_DEFAULT')); // Init de la langue par défaut

	$cart = new Cart($id_cart);

	$products = $cart->getProducts(); // récupération des produits dans le panier

	$name = '';
	$i = 0;
	foreach($products as $product){
	    $prod = new Product($product['id_product']); // Instance du produit
	    
	    if($i > 0)
		$name .= ' - ';
	    $name .= $prod->name [$defaultLanguage]; // On insère le nom du produit
	    $attributes = product::getAttributesParams($product['id_product'], $product['id_product_attribute']);
	   
	    if(!empty($attributes)){
		$name .= " ( ";
		foreach($attributes as $attribute){
		    $name .= $attribute['name'].' ';
		}
		$name .= " )";
	    }
	   
	   $i ++;
	}


	return Tools::substr($name, 0, 127);
    }

    
   


    /**
     * Création d'un etat de paiement "En attente de confirmation de Paypal"
     */
    static public function CreateOrderState() {

	if (!Configuration::get('PSPS_OS_PENDING')) { // Si aucune variable "SM_OS_PENDING"
	    $orderState = new OrderState (); // Instance d'un OrderState
	    $orderState->name = array(); // Initialisation du nom sous forme d'un tableau

	    foreach (Language::getLanguages() as $language) { // Pour chaque langue
		if (Tools::strtolower($language ['iso_code']) == 'fr') // Si la langue est fr
		    $orderState->name [$language ['id_lang']] = 'En attente de confirmation de Paypal';
		else // Sinon
		    $orderState->name [$language ['id_lang']] = 'Awaiting confirmation from Paypal';
	    }

	    $orderState->send_email = false; // Pas d'envoi d'email
	    $orderState->color = '#4169E1'; // Couleur de l'état
	    $orderState->hidden = false; // Pas caché
	    $orderState->delivery = false; // Pas livré
	    $orderState->logable = true;
	    $orderState->invoice = false; // Pas de facture


	    if ($orderState->add()) { // Si l'ajout est fait avec succès
		$source = _PS_MODULE_DIR_ . '/paypalsubscriptions/img/order_state.gif';
		$destination = _PS_IMG_DIR_ . 'os/' . (int) $orderState->id . '.gif';

		// Si le fichier existe
		if (file_exists($source))
		    copy($source, $destination); // Déplacement de l'image associée dans le dossier par défaut
	    }
	    else{ // Sinon
		PSLog::addLog('create_order_state_error', $orderState);
		return false; // On retourne Faux
	    }


	    Configuration::updateValue('PSPS_OS_PENDING', (int) $orderState->id); // Mise à jout de la valeur
	    PSLog::addLog('create_order_state_ok', $orderState);
	}
	
	

	return true; // Retourne Vrai
	
	
		
    }
    
    /**
     * Supprime un Etat de commande
     */
    static public function DeleteOrderState() {

	$id_order_state = Configuration::get('PSPS_OS_PENDING');

	// tente de charge l'order state depuis lid de configuration
	$orderState = new OrderState($id_order_state);
	$orderState->delete();

	$sql = "DELETE FROM " . _DB_PREFIX_ . 'order_state_lang WHERE id_order_state = ' . (int) $id_order_state;

	Db::getInstance()->query($sql);
	$destination = _PS_IMG_DIR_ . 'os/' . (int) $id_order_state . '.gif';

	// Suppression du fichier de l'état
	if (file_exists($destination)) {
	    unlink($destination);
	}
	
	Configuration::deleteByName('PSPS_OS_PENDING');

	return true;
    }
    
    
    /**
     * Vérification de la création de l'abonnement lié au token
     */
    static public function checkCreation($token){
	
	$PSPaypalSubscriptions = PSPaypalSubscription::getList(array('paypal_token' => $token));
	
	if(!empty($PSPaypalSubscriptions)){
	    $log = PSlog::getList(array('token' => $PSPaypalSubscriptions[0]['paypal_profile_id']));

	    if(!empty($log) && $log[0]['log_txn_type'] == 'recurring_payment_profile_created')
		echo 1;
	}
    }
    
    /**
     * Annulation de l'abonnement coté Paypal
     */
    static public function cancelPaypalSubscription(SMSubscription $subscription) {
	
	
	if(empty($subscription)){
	    PSLog::addLog('cancel_subscription_error');
	    return false;
	}
		
	$paypal_subscriptions = new PaypalSubscriptions();
	
	$paypaUrlNvp = 'https://api-3t.paypal.com/nvp';
	$paypalMerchantUserName = Configuration::get('paypal_merchant_user_name');
	$paypalMerchantPassword = Configuration::get('paypal_merchant_password');
	$paypalMerchantSignature = Configuration::get('paypal_merchant_signature');
		
	$PSPaypalSubscription_get = PSPaypalSubscription::getList(array('id_order' => $subscription->id_order));
	
	if(empty($PSPaypalSubscription_get)){
	    PSLog::addLog('cancel_subscription_error');
	    return false;
	}
	
	$PSPaypalSubscription = new PSPaypalSubscription($PSPaypalSubscription_get[0]['id_paypal_subscription']);

	// Appel de Paypal pour annuler l'abo
	$postFields = array();
	$postFields['USER'] = $paypalMerchantUserName;
	$postFields['PWD'] = $paypalMerchantPassword;
	$postFields['SIGNATURE'] = $paypalMerchantSignature;
	$postFields['VERSION'] = 86;
	$postFields['PROFILEID'] = $PSPaypalSubscription->paypal_profile_id;
	$postFields['METHOD'] = 'ManageRecurringPaymentsProfileStatus';
	$postFields['ACTION'] = 'Cancel'; // Cancel / Suspend / reactivate
	$postFields['NOTE'] = $paypal_subscriptions->l('Canceled from merchant site');


	$postFields = PSTools::serializePostFields($postFields);

	$response = PSTools::curlGet($paypaUrlNvp, $postFields);

	if($response['ACK'] != 'Success'){
	    PSLog::addLog('cancel_subscription_error', $response);
	    return false;
	}
	else
	    PSLog::addLog('cancel_subscription_ok', $response);
	
	
	$PSPaypalSubscription->cancel_from_presta_datetime = date('Y-m-d h:i:s');
	$PSPaypalSubscription->update();
	
	if($subscription->status == SMSubscription::$STATUS_ACTIVE){
	    $subscription->paypalStopSubscription();

	    $employeeList = Employee::getEmployees();
	    $id_employee = $employeeList[0]['id_employee'];

	    SMLog::addLog('paypalStop_SMSubscription', $subscription, $id_employee);
	}
	
	return true;
    }

    
    

}

