<?php

if (!defined('_PS_VERSION_'))
    exit;


if (file_exists(dirname(__FILE__) . '/../subscriptionsmanager/subscriptionsmanager.php'))
    require_once (dirname(__FILE__) . '/../subscriptionsmanager/subscriptionsmanager.php');


require_once (dirname(__FILE__) . '/models/PSPaypalSubscription.php');
require_once (dirname(__FILE__) . '/models/PSLog.php');
require_once (dirname(__FILE__) . '/models/PSTools.php');

class PaypalSubscriptions extends PaymentModule {

    private $_html = '';

    public function __construct() {
	$this->name = 'paypalsubscriptions';
	$this->tab = 'payments_gateways';
	$this->version = '2.4';
	$this->module_key = "3022707ee462411b3ff2ecb4c7737494";
	$this->author = 'Aduler.com';


	parent::__construct();

	$this->displayName = $this->l('Paypal Subscriptions');
	$this->description = $this->l('Module for subscriptions by Paypal.');
	$this->confirmUninstall = $this->l('Are you sure you want to delete this module ?');
    }

    private function _initSQL() {

	Db::getInstance()->Execute('
		CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'PS_paypal_subscription` (
		  `id_paypal_subscription` int(10) unsigned NOT NULL auto_increment,
		  `id_customer` int(10) unsigned NOT NULL,
		  `id_cart` int(10) unsigned NOT NULL,
		  `id_order` int(10) unsigned NOT NULL,
		  `paypal_payer_id` varchar(20) DEFAULT NULL,
		  `paypal_profile_start_date` varchar(20) DEFAULT NULL,
		  `paypal_desc` varchar(255) DEFAULT NULL,
		  `paypal_billing_period` varchar(20) DEFAULT NULL,
		  `paypal_billing_frequency` tinyint(2) DEFAULT NULL,
		  `paypal_total_billing_cycles` tinyint(2) DEFAULT NULL,
		  `paypal_billing_amt` decimal(5,2) DEFAULT NULL,
		  `paypal_currency_code` char(3) DEFAULT NULL,
		  `paypal_country_code` char(2) DEFAULT NULL,
		  `paypal_max_failed_payments` tinyint(1) DEFAULT NULL,
		  `paypal_token` varchar(20) DEFAULT NULL,
		  `paypal_profile_id` varchar(20) DEFAULT NULL,
		  `paypal_ack` varchar(20) DEFAULT NULL,
		  `create_datetime` datetime NOT NULL,
		  `cancel_from_presta_datetime` datetime  DEFAULT "0000-00-00",
		  `cancel_from_paypal_datetime` datetime  DEFAULT "0000-00-00",
		  PRIMARY KEY (`id_paypal_subscription`)
		) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;') or die("Installation failed :" . Db::getInstance()->getMsgError());

	Db::getInstance()->Execute('
		CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'PS_log` (
		  `id_log` int(10) unsigned NOT NULL auto_increment,
		  `log_txn_type` VARCHAR(255) NULL DEFAULT NULL,
		  `serialized_data` LONGTEXT NULL DEFAULT NULL,
		  `log_date` datetime DEFAULT "0000-00-00",		  
		  PRIMARY KEY (`id_log`)
		) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;') or die("Installation failed :" . Db::getInstance()->getMsgError());

	return true;
    }

    private function _razSql() {
	Db::getInstance()->Execute('DROP TABLE `' . _DB_PREFIX_ . 'PS_paypal_subscription`');
	Db::getInstance()->Execute('DROP TABLE `' . _DB_PREFIX_ . 'PS_log`');

	return true;
    }

    public function install() {
	if (!parent::install() || !$this->registerHook('payment') || !$this->registerHook('paymentTop') || !$this->_initSQL())
	    return false;
	
	
	PSLog::addLog('module_install');

	if (!Configuration::updateValue('billing_period', NULL) || !Configuration::updateValue('billing_frequency', NULL) || !Configuration::updateValue('billing_nb_cycles', NULL) || !Configuration::updateValue('billing_max_failed_payments', NULL) || !Configuration::updateValue('paypal_merchant_user_name', NULL) || !Configuration::updateValue('paypal_merchant_password', NULL) || !Configuration::updateValue('paypal_merchant_signature', NULL) || !Configuration::updateValue('paypal_return_url_cancel', NULL))
	    return false;

	if (!PSTools::CreateOrderState())
	    return false;
	
	if (function_exists('curl_version') < 1)
	    return false;
	

	return true;
    }

    public function uninstall() {

	if (!parent::uninstall() || !$this->unregisterHook('payment') || !$this->unregisterHook('paymentTop') || !$this->_razSql())
	    return false;

	if (!Configuration::deleteByName('billing_period') || !Configuration::deleteByName('billing_frequency') || !Configuration::deleteByName('billing_nb_cycles') || !Configuration::deleteByName('billing_max_failed_payments') || !Configuration::deleteByName('paypal_merchant_user_name') || !Configuration::deleteByName('paypal_merchant_password') || !Configuration::deleteByName('paypal_merchant_signature') || !Configuration::deleteByName('paypal_return_url_cancel'))
	    return false;

	if (!PSTools::DeleteOrderState())
	    return false;

	return true;
    }

    //////////////////////////////
    //           HOOK           //
    //////////////////////////////

    /**
     * Appel lors de la phase 5 du tunnel d'achat (page de paiement)
     */
    public function hookPayment() {

	if (!$this->active)
	    return;

	$buttonAction = '';
	if (!Configuration::get('PS_ORDER_PROCESS_TYPE')) { // Si le tunnel est sur plusieurs pages, il faut une URL spéciale..
	    $buttonAction = $this->context->link->getPageLink("order", true);

	    $buttonAction.='?step=3&multi-shipping=';
	}

	$cart = new Cart($this->context->cart->id);

	$currency_obj = new Currency($cart->id_currency);

	$currency = $currency_obj->iso_code;
	$total = (float) $cart->getOrderTotal(true, Cart::BOTH);

	$isSubscription = FALSE; // Variable servant à déterminer si le panier est un abonnement ou non
	// Si le module Gestion des abonnements est détecté
	if (PSTools::detectSubscriptionsManager()) {

	    $schema = SMTools::getSchemaFromIdCart($cart->id); // Récupération du schéma associé

	    if (!empty($schema)) { // Si il a bien un shcmé
		if ($schema['one_shot'] == 1) // Si le paiement est direct
		    $isSubscription = FALSE;
		else
		    $isSubscription = TRUE;
	    }
	    else
		$isSubscription = FALSE;
	}
	else {
	    $isSubscription = TRUE;
	}


	$PSPaypalSubscriptions = PSPaypalSubscription::getList(array('id_cart' => $this->context->cart->id));

	if (!empty($PSPaypalSubscriptions)) {
	    foreach ($PSPaypalSubscriptions as $PSPaypalSubscription) {
		Db::getInstance()->Execute('DELETE FROM `' . _DB_PREFIX_ . 'PS_paypal_subscription` WHERE `id_paypal_subscription` = ' . $PSPaypalSubscription['id_paypal_subscription'] . ';');
	    }
	}


	if (Tools::isSubmit('preprocessPaypalPayment')) {

	    /* VERSION ""Recurring Payments Profile with Express Checkout */
	    // https://developer.paypal.com/webapps/developer/docs/classic/express-checkout/ht_ec-recurringPaymentProfile-curl-etc/


	    $paypalUrlNvp = 'https://api-3t.paypal.com/nvp';
	    $paypalMerchantUserName = Configuration::get('paypal_merchant_user_name');
	    $paypalMerchantPassword = Configuration::get('paypal_merchant_password');
	    $paypalMerchantSignature = Configuration::get('paypal_merchant_signature');

	    $profileDescription = PSTools::getProductName($this->context->cart->id);

	    $cancelUrl = Configuration::get('paypal_return_url_cancel');

	    if (Configuration::get('PS_REWRITING_SETTINGS') == 1)
		$returnUrl = _PS_BASE_URL_ . __PS_BASE_URI__ . 'module/paypalsubscriptions/process_payment';
	    else
		$returnUrl = _PS_BASE_URL_ . __PS_BASE_URI__ . 'modules/paypalsubscriptions/controllers/front/process_payment.php';

	    // Step 1: Set Up the Payment Authorization
	    $postFields = array();
	    $postFields['USER'] = $paypalMerchantUserName;
	    $postFields['PWD'] = $paypalMerchantPassword;
	    $postFields['SIGNATURE'] = $paypalMerchantSignature;
	    $postFields['METHOD'] = 'SetExpressCheckout';
	    $postFields['VERSION'] = 86;




	    if ($isSubscription) {
		$postFields['L_BILLINGTYPE0'] = 'RecurringPayments'; #The type of billing agreement
		$postFields['L_BILLINGAGREEMENTDESCRIPTION0'] = $profileDescription; #The description of the billing agreement
		
		
		/*
		TODO - Multi subscriptions
		$postFields['L_BILLINGTYPE1'] = 'RecurringPayments'; #The type of billing agreement
		$postFields['L_BILLINGAGREEMENTDESCRIPTION1'] = "TEST"; #The description of the billing agreement
		
		$postFields['PAYMENTREQUEST_0_PAYMENTACTION'] = 'SALE';
		$postFields['PAYMENTREQUEST_0_AMT'] = 11;
		$postFields['PAYMENTREQUEST_0_CURRENCYCODE'] = $currency;
		*/
		
		
		$max_failed_payment = 1;
	    } else {
		$postFields['PAYMENTREQUEST_0_PAYMENTACTION'] = 'SALE';
		$postFields['PAYMENTREQUEST_0_AMT'] = $total;
		$postFields['PAYMENTREQUEST_0_CURRENCYCODE'] = $currency;
		$max_failed_payment = Configuration::get('billing_max_failed_payments');
	    }

	    
	    $postFields['cancelUrl'] = $cancelUrl; // For use if the consumer decides not to proceed with payment
	    $postFields['returnUrl'] = $returnUrl; #For use if the consumer proceeds with payment

	    $postFields = PSTools::serializePostFields($postFields);

	    $response = PSTools::curlGet($paypalUrlNvp, $postFields); 
	    	    
	  
	    $this->smarty->assign('button_action', $buttonAction);

	    $this->smarty->assign('id_customer', $this->context->customer->id);



	    if (empty($response['TOKEN']) || empty($response['ACK']) || ($response['ACK'] != 'Success')) { // Authorization OK de Paypal
		
		if(PSTools::detectSubscriptionsManager() && !empty($schema))
		    $this->context->smarty->assign('isSubscription', 1);
		else	   
		    $this->context->smarty->assign('isSubscription', $isSubscription);	

		$this->smarty->assign('id_customer', $this->context->customer->id);
		
		PSLog::addLog('sync_error', $response);
	
		$this->smarty->assign('error', $this->l('Synchronization error with Paypal'));
		return $this->display(__FILE__, '/views/templates/front/payment_button.tpl');
	    }
	    else
		PSLog::addLog('sync_ok', $response);

	    $token = urldecode($response['TOKEN']);


	    $PSPaypalSubscription = new PSPaypalSubscription();
	    $PSPaypalSubscription->id_customer = $this->context->customer->id;
	    $PSPaypalSubscription->id_cart = $this->context->cart->id;
	    $PSPaypalSubscription->paypal_token = $token;
	    $PSPaypalSubscription->paypal_max_failed_payments = $max_failed_payment;
	    
	    $PSPaypalSubscription->save();


	    // Step 2: Redirect the Customer to PayPal for Authorization
	    Tools::redirectLink('https://www.paypal.com/cgi-bin/webscr?cmd=_express-checkout&token=' . $token);

	    // la fin des étapes se fera dans controllers/front/processPayment.php
	    // Step 3: Obtain Customer Details    
	    // Step 4: Create the Recurring Payments Profile
	}

	$this->smarty->assign('button_action', $buttonAction);

	if(PSTools::detectSubscriptionsManager() && !empty($schema))
	    $this->context->smarty->assign('isSubscription', 1);
	else	   
	    $this->context->smarty->assign('isSubscription', $isSubscription);	
	    
	$this->smarty->assign('id_customer', $this->context->customer->id);
	


	return $this->display(__FILE__, '/views/templates/front/payment_button.tpl');
    }

    //////////////////////////////
    //         CONTENT          //
    //////////////////////////////

    /**
     * Affichage des informations du module en BO
     */
    public function getContent() {

	$this->context->controller->addCSS(_MODULE_DIR_ . $this->name . '/css/paypalsubscriptions.css', 'all');
	
	$request_uri = $this->context->link->getAdminLink('AdminModules') . '&configure=' . $this->name . '&module_name=' . $this->name;
	$this->smarty->assign('request_uri', $request_uri);
	
	if(!Tools::isEmpty('log') && Tools::getValue('log') == 1){
	    
	    $logs = PSLog::getListFormatted();
	    $this->smarty->assign('logs', $logs);
	    
	    
	    return $this->display(__FILE__, '/views/templates/admin/log_list.tpl');
	}
	
	
	
	$sm = PSTools::detectSubscriptionsManager();

	if (Tools::isSubmit('Save')) {

	    Configuration::updateValue('billing_period', ((!$sm) ? pSQL(Tools::getValue('billing_period'), false) : 'NULL'));
	    Configuration::updateValue('billing_frequency', ((!$sm) ? pSQL(Tools::getValue('billing_frequency'), false) : 'NULL'));
	    Configuration::updateValue('billing_nb_cycles', ((!$sm) ? pSQL(Tools::getValue('billing_nb_cycles'), false) : 'NULL'));
	    Configuration::updateValue('billing_max_failed_payments', ((!$sm) ? pSQL(Tools::getValue('billing_max_failed_payments'), false) : '1'));
	    Configuration::updateValue('paypal_merchant_user_name', pSQL(Tools::getValue('paypal_merchant_user_name'), false));
	    Configuration::updateValue('paypal_merchant_password', pSQL(Tools::getValue('paypal_merchant_password'), false));
	    Configuration::updateValue('paypal_merchant_signature', pSQL(Tools::getValue('paypal_merchant_signature'), false));
	    Configuration::updateValue('paypal_return_url_cancel', pSQL(Tools::getValue('paypal_return_url_cancel'), false));

	    $this->smarty->assign('confirm', $this->l('Data updated'));
	    
	    $array = array();
	    $array['billing_period'] = Tools::getValue('billing_period');
	    $array['billing_frequency'] = Tools::getValue('billing_frequency');
	    $array['billing_nb_cycles'] = Tools::getValue('billing_nb_cycles');
	    $array['billing_max_failed_payments'] = Tools::getValue('billing_max_failed_payments');
	    $array['paypal_merchant_user_name'] = Tools::getValue('paypal_merchant_user_name');
	    $array['paypal_merchant_password'] = Tools::getValue('paypal_merchant_password');
	    $array['paypal_merchant_signature'] = Tools::getValue('paypal_merchant_signature');
	    $array['paypal_return_url_cancel'] = Tools::getValue('paypal_return_url_cancel');
	    
	    PSLog::addLog('configuration_update', $array);
	}


	$request_uri = Tools::safeOutput($_SERVER ['REQUEST_URI']);


	$moduleConfiguration = PSTools::getModuleConfiguration();


	$ipn_url = _PS_BASE_URL_ . __PS_BASE_URI__ . 'modules/' . $this->name . '/controllers/front/ipn.php';



	if ($sm) { // module détecté, on récupère sa version pour compatibilité
	    require_once(dirname(__FILE__) . '/../subscriptionsmanager/subscriptionsmanager.php');
	    $subscriptionsmanager = new SubscriptionsManager();
	    $sm_version = $subscriptionsmanager->version;
	}


	if ($sm) { // module détecté, pas de période ni de frquence
	    $billing_period = '';
	    $billing_frequency = '';
	    $billing_nb_cycles = '';
	} else {
	    $billing_period = (!empty($moduleConfiguration['billing_period'])) ? $moduleConfiguration['billing_period'] : 'Month';
	    $billing_frequency = (!empty($moduleConfiguration['billing_frequency'])) ? $moduleConfiguration['billing_frequency'] : '1';
	    $billing_nb_cycles = (!empty($moduleConfiguration['billing_nb_cycles'])) ? $moduleConfiguration['billing_nb_cycles'] : '12';
	}
	$this->smarty->assign('billing_period', $billing_period);
	$this->smarty->assign('billing_frequency', $billing_frequency);
	$this->smarty->assign('billing_nb_cycles', $billing_nb_cycles);

	if ($sm)
	    $this->smarty->assign('sm_version', $sm_version);

	$this->smarty->assign('request_uri', $request_uri);
	$this->smarty->assign('author', $this->author);
	$this->smarty->assign('version', $this->version);
	$this->smarty->assign('displayName', $this->displayName);
	$this->smarty->assign('ipn_url', $ipn_url);
	$this->smarty->assign('sm', $sm);
	$this->smarty->assign('periods', array("Day", "Week", "SemiMonth", "Month", "Year"));
	$this->smarty->assign('conf', $moduleConfiguration);

	
	return $this->display(__FILE__, '/views/templates/admin/paypal_subscription.tpl');
    }

    //////////////////////////////
    //        FUNCTIONS         //
    //////////////////////////////

    

    /**
     * Validation de la commande
     */
    public function validateOrder($id_cart, $id_order_state, $amountPaid, $paymentMethod = 'Unknown', $message = null, $transaction = array(), $currency_special = null, $dont_touch_amount = false, $secure_key = false, Shop $shop = null) {
	if ($this->active)
	    parent::validateOrder((int) $id_cart, (int) $id_order_state, (float) $amountPaid, $paymentMethod, $message, $transaction, $currency_special, $dont_touch_amount, $secure_key, $shop);
    }

    
    

    
    
    

    
}
