{* ----------------------------------------
   Template Prestashop DiscountShop
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ---------------------------------------- *}

<!-- MODULE Home featured products -->
<div id="homefeatured" class="block products_block">
	<h4>{l s='Featured products' mod='homefeatured'}</h4>
	{if isset($products) AND $products}
		<div class="block_content">
			{assign var='nbItemsPerLine' value=4}
			<ul>
				{foreach from=$products item=product name=homeFeaturedProducts}
					<li class="ajax_block_product {if $smarty.foreach.homeFeaturedProducts.first}first_item{elseif $smarty.foreach.homeFeaturedProducts.last}last_item{else}item{/if}{if $smarty.foreach.homeFeaturedProducts.iteration%$nbItemsPerLine == 0} last_item_of_line{elseif $smarty.foreach.homeFeaturedProducts.iteration%$nbItemsPerLine == 1} first_item_of_line{/if} span3">
						<div class="left_block">
							<div class="product_img_container">
								<a href="{$product.link}" title="{$product.name|escape:html:'UTF-8'}" class="product_image">
									<img src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'home')}" alt="{$product.name|escape:html:'UTF-8'}" />
								</a>
								{if !isset($ptm_quickview) OR isset($ptm_quickview) AND $ptm_quickview == 1}
									<a class="quick-view" href="{$product.link|escape:'html':'UTF-8'}">
										<span>{l s='Quick view' mod='homefeatured'}</span>
									</a>
								{/if}
							</div>
							<h5>{if isset($product.new) && $product.new == 1}<span class="new">{l s='New' mod='homefeatured'}</span>{/if}<a href="{$product.link}" title="{$product.name|escape:'htmlall':'UTF-8'}">{$product.name|truncate:40:'...'|escape:'htmlall':'UTF-8'}</a></h5>
							{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
								{hook h='displayProductListReviews' product=$product}
							{/if}
							<div class="product_desc">{$product.description_short|strip_tags:'UTF-8'|truncate:110:'...'}</div>
							<a class="lnk_view" href="{$product.link|escape:'htmlall':'UTF-8'}" title="{l s='View this product' mod='homefeatured'}">{l s='View this product' mod='homefeatured'}</a>
						</div>
						<div class="right_block">
							{assign var='specific_prices' value=$product.specific_prices}
							{if isset($product.on_sale) && $product.on_sale && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE OR isset($product.reduction) && $product.reduction && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE}
								{if $specific_prices.reduction_type}
									<p class="reduction">{if $specific_prices.reduction_type == 'percentage'}-{$specific_prices.reduction*100}%{/if}{if $specific_prices.reduction_type == 'amount'}-{($specific_prices.reduction|round:2*100/$product.price_without_reduction)|round:0}%{/if}</p>
								{/if}
							{/if}
							{if (!$PS_CATALOG_MODE AND ((isset($product.show_price) && $product.show_price) || (isset($product.available_for_order) && $product.available_for_order)))}
								<p class="price_container">
									{if isset($product.show_price) && $product.show_price}
										<span class="price">{if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}</span>
										{if isset($product.on_sale) && $product.on_sale OR isset($product.reduction) && $product.reduction}<span class="old_price">{convertPrice price=$product.price_without_reduction}</span>{/if}
									{/if}
								</p>
							{/if}
							{if isset($product.online_only) && $product.online_only}<p class="online_only">{l s='Online only !' mod='homefeatured'}</p>{/if}
							{if isset($product.available_for_order) && $product.available_for_order && !$PS_CATALOG_MODE}
								{if ($product.allow_oosp AND $product.quantity > 0 || $product.quantity > 0)}
									<p class="available">{l s='Available' mod='homefeatured'}</p>
								{elseif ($product.allow_oosp AND $product.quantity <= 0)}
									<p class="available_later">{if isset($product.available_later) && $product.available_later}{$product.available_later}{else}{l s='Out of stock' mod='homefeatured'}{/if}</p>
								{elseif (isset($product.quantity_all_versions) && $product.quantity_all_versions > 0)}
									<p class="available_later">{l s='Available with different options' mod='homefeatured'}</p>
								{else}
									<p class="unavailable">{l s='Out of stock' mod='homefeatured'}</p>
								{/if}
							{/if}
							{if !$product.available_for_order}
								<p class="unavailable">{l s='Unavailable product' mod='homefeatured'}</p>
							{/if}
						</div>
						<div>
							{if !isset($ptm_homebuttons) OR isset($ptm_homebuttons) AND $ptm_homebuttons == 1}
								<a class="button" href="{$product.link}" title="{l s='View' mod='homefeatured'}">{l s='View' mod='homefeatured'}</a>
								{if ($product.id_product_attribute == 0 OR (isset($add_prod_display) AND ($add_prod_display == 1))) AND !isset($restricted_country_mode) AND $product.minimal_quantity == 1 AND $product.customizable != 2 AND !$PS_CATALOG_MODE}
									{if ($product.quantity > 0 OR $product.allow_oosp) && $product.available_for_order}
										<a class="exclusive ajax_add_to_cart_button" rel="ajax_id_product_{$product.id_product}" href="{$link->getPageLink('cart.php', true)}?qty=1&amp;id_product={$product.id_product}&amp;token={$static_token}&amp;add" title="{l s='Add to cart' mod='homefeatured'}">{l s='Add to cart' mod='homefeatured'}</a>
									{else}
										<span class="exclusive">{l s='Add to cart' mod='homefeatured'}</span>
									{/if}
								{/if}
							{/if}
						</div>
					</li>
				{/foreach}
			</ul>
		</div>
	{else}
		<p>{l s='No featured products' mod='homefeatured'}</p>
	{/if}
</div>
<!-- /MODULE Home featured products -->