{* ----------------------------------------
   Template Prestashop DiscountShop
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ---------------------------------------- *}

{include file="$tpl_dir./errors.tpl"}
{if isset($orderRet)}
	<h3>{l s='Return #'}<span class="color-myaccount">{$orderRet->id|string_format:"%06d"}</span>&nbsp;{l s='placed on'}&nbsp;{dateFormat date=$order->date_add full=0}</h3>
	<div>
		<p class="bold">{l s='We have logged your return request.'}</p>
		<p>{l s='Your package must be returned to us within'} {$nbdaysreturn} {l s='days of receiving your order.'}</p>
		<br />
		<p>{l s='Current status of your merchandise return :'} <span class="bold">{$state_name|escape:'htmlall':'UTF-8'}</span></p>
		<br />
		<p>{l s='List of items to be returned :'}</p>
	</div>
	<div id="order-detail-content" class="table_block">
		<table class="std">
			<thead>
				<tr>
					<th class="first_item">{l s='Product'}</th>
					<th class="last_item center">{l s='Quantity'}</th>
				</tr>
			</thead>
			<tbody>
			{foreach from=$products item=product name=products}

				{assign var='quantityDisplayed' value=0}
				{foreach from=$returnedCustomizations item='customization' name=products}
					{if $customization.product_id == $product.product_id}
						<tr class="{if $smarty.foreach.products.index % 2}alternate_item{else}item{/if}{if $smarty.foreach.products.first} first_item{/if}">
							<td class="bold">{$customization.name|escape:'htmlall':'UTF-8'}<br />{if $customization.reference}{l s='Reference :'} {$customization.reference|escape:'htmlall':'UTF-8'}{/if}</td>
							<td class="center"><span class="order_qte editable">{$customization.product_quantity|intval}</span></td>
						</tr>
						{assign var='productId' value=$customization.product_id}
						{assign var='productAttributeId' value=$customization.product_attribute_id}
						{assign var='customizationId' value=$customization.id_customization}
						{foreach from=$customizedDatas.$productId.$productAttributeId.$customizationId.datas key='type' item='datas'}
							<tr class="alternate_item">
								<td>
									{if $type == $smarty.const._CUSTOMIZE_FILE_}
									<ul class="customizationUploaded">
										{foreach from=$datas item='data'}
											<li><img src="{$pic_dir}{$data.value}_small" alt="" class="customizationUploaded" /></li>
										{/foreach}
									</ul>
									{elseif $type == $smarty.const._CUSTOMIZE_TEXTFIELD_}
									<ul class="typedText">{counter start=0 print=false}
										{foreach from=$datas item='data'}
											{assign var='customizationFieldName' value="Text #"|cat:$data.id_customization_field}
											<li>{$data.name|default:$customizationFieldName} : {$data.value}</li>
										{/foreach}
									</ul>
									{/if}
								</td>
								<td></td>
							</tr>
						{/foreach}
						{assign var='quantityDisplayed' value=$quantityDisplayed+$customization.product_quantity}
					{/if}
				{/foreach}

				{if $product.product_quantity > $quantityDisplayed}
					<tr class="{if $smarty.foreach.products.index % 2}alternate_item{else}item{/if}{if $smarty.foreach.products.first} first_item{/if}">
						<td class="bold">{$product.product_name|escape:'htmlall':'UTF-8'}<br />{if $product.product_reference}{l s='Reference :'} {$product.product_reference|escape:'htmlall':'UTF-8'}{/if}</td>
						<td class="center"><span class="order_qte editable">{$product.product_quantity|intval}</span></td>
					</tr>
				{/if}
			{/foreach}
			</tbody>
		</table>
	</div>

	{if $orderRet->state == 2}
	<br />
	<p class="bold">{l s='REMINDER :'}</p>
	<div>
		- {l s='All products must be returned in their original packaging without damage or wear.'}
		<br />- {l s='Please print out the'} <a href="{$link->getPageLink('pdf-order-return.php', true)}?id_order_return={$orderRet->id|intval}" class="bold">{l s='PDF return slip'}</a> {l s='and include it with your package.'}
		<br />- {l s='Please see PDF return slip'} (<a href="{$link->getPageLink('pdf-order-return.php', true)}?id_order_return={$orderRet->id|intval}" class="bold">{l s='for the correct address'}</a>)
		<br /><br />
		{l s='Upon receiving your package, we will notify you by e-mail. We will then begin processing the reimbursement of your order total.'}
		<br /><br /><a href="{$link->getPageLink('contact-form.php', true)}" class="bold">{l s='Please let us know if you have any questions.'}</a>
		<br />
		<br />
		<p class="bold">{l s='If the conditions of return listed above are not respected, we reserve the right to refuse your package and/or reimbursement.'}</p>
	</div>
	{elseif $orderRet->state == 1}
		<p class="bold">{l s='You must wait for our confirmation before returning any merchandise.'}</p>
	{/if}
	<br />
{/if}