{* ----------------------------------------
   Template Prestashop DiscountShop
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ---------------------------------------- *}

<script type="text/javascript">
	var productsList = $("#product_list");
	if ($(".gridview").hasClass("active"))
		productsList.removeClass("list").addClass("grid");
	else if ($(".listview").hasClass("active"))
		productsList.removeClass("grid").addClass("list");
</script>

{if isset($products)}
	<!-- Products list -->
	{assign var='nbItemsPerLine' value=4}
	<ul id="product_list" class="clearfix{if !isset($ptm_listdisplay) OR !isset($smarty.cookies.switchercookie) AND isset($ptm_listdisplay) AND $ptm_listdisplay == 1 OR isset($smarty.cookies.switchercookie) AND $smarty.cookies.switchercookie=="grid"} grid{/if}{if !isset($smarty.cookies.switchercookie) AND isset($ptm_listdisplay) AND $ptm_listdisplay == 0 OR isset($smarty.cookies.switchercookie) AND $smarty.cookies.switchercookie=="list"} list{/if}">
	{foreach from=$products item=product name=products}
		<li class="ajax_block_product {if $smarty.foreach.products.index % 2}alternate_item{else}item{/if}{if $smarty.foreach.products.first} first_item{elseif $smarty.foreach.products.last} last_item{/if}{if $smarty.foreach.products.iteration%$nbItemsPerLine == 0} last_item_of_line{elseif $smarty.foreach.products.iteration%$nbItemsPerLine == 1} first_item_of_line{/if} span3">
			<div class="left_block">
				<div class="product_img_container">
					<a href="{$product.link|escape:'htmlall':'UTF-8'}" class="product_img_link" title="{$product.name|escape:'htmlall':'UTF-8'}">
						<img src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'home')}" alt="{$product.legend|escape:'htmlall':'UTF-8'}" />
					</a>
					{if !isset($ptm_quickview) OR isset($ptm_quickview) AND $ptm_quickview == 1}
						<a class="quick-view" href="{$product.link|escape:'html':'UTF-8'}">
							<span>{l s='Quick view'}</span>
						</a>
					{/if}
				</div>
				<h3>{if isset($product.new) && $product.new == 1}<span class="new">{l s='New'}</span>{/if}<a href="{$product.link|escape:'htmlall':'UTF-8'}" title="{$product.name|escape:'htmlall':'UTF-8'}">{$product.name|truncate:40:'...'|escape:'htmlall':'UTF-8'}</a></h3>
				{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
					{hook h='displayProductListReviews' product=$product}
				{/if}
				<p class="product_desc">{$product.description_short|strip_tags:'UTF-8'|truncate:110:'...'}</p>
				<a class="lnk_view" href="{$product.link|escape:'htmlall':'UTF-8'}" title="{l s='View this product'}">{l s='View this product'}</a>
			</div>
			<div class="right_block">
				{assign var='specific_prices' value=$product.specific_prices}
				{if isset($product.on_sale) && $product.on_sale && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE OR isset($product.reduction) && $product.reduction && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE}
					{if $specific_prices.reduction_type}
						<p class="reduction">{if $specific_prices.reduction_type == 'percentage'}-{$specific_prices.reduction*100}%{/if}{if $specific_prices.reduction_type == 'amount'}-{($specific_prices.reduction|round:2*100/$product.price_without_reduction)|round:0}%{/if}</p>
					{/if}
				{/if}
				{if (!$PS_CATALOG_MODE AND ((isset($product.show_price) && $product.show_price) || (isset($product.available_for_order) && $product.available_for_order)))}
					<p class="price_container">
						{if isset($product.show_price) && $product.show_price}
							<span class="price">{if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}</span>
							{if isset($product.on_sale) && $product.on_sale OR isset($product.reduction) && $product.reduction}<span class="old_price">{convertPrice price=$product.price_without_reduction}</span>{/if}
						{/if}
					</p>
				{/if}
				{if isset($product.online_only) && $product.online_only}<p class="online_only">{l s='Online only !'}</p>{/if}
				{if isset($product.available_for_order) && $product.available_for_order && !$PS_CATALOG_MODE}
					{if ($product.allow_oosp AND $product.quantity > 0 || $product.quantity > 0)}
						<p class="available">{l s='Available'}</p>
					{elseif ($product.allow_oosp AND $product.quantity <= 0)}
						<p class="available_later">{if isset($product.available_later) && $product.available_later}{$product.available_later}{else}{l s='Out of stock'}{/if}</p>
					{elseif (isset($product.quantity_all_versions) && $product.quantity_all_versions > 0)}
						<p class="available_later">{l s='Available with different options'}</p>
					{else}
						<p class="unavailable">{l s='Out of stock'}</p>
					{/if}
				{/if}
				{if !$product.available_for_order}
					<p class="unavailable">{l s='Unavailable product'}</p>
				{/if}
			</div>
			{if isset($comparator_max_item) && $comparator_max_item}
				<p class="compare">
					<input type="checkbox" onclick="checkForComparison({$comparator_max_item})" id="comparator_item_{$product.id_product}" class="comparator" value="{$product.id_product}"/>
					<label for="comparator_item_{$product.id_product}">{l s='Select to compare'}</label>
				</p>
			{/if}
			{if isset($product.color_list)}
				<div class="color-list-container">{$product.color_list}</div>
			{/if}
			<div>
				{if !isset($ptm_listbuttons) OR isset($ptm_listbuttons) AND $ptm_listbuttons == 1}
					<a class="button" href="{$product.link|escape:'htmlall':'UTF-8'}" title="{l s='View'}">{l s='View'}</a>
					{if ($product.id_product_attribute == 0 || (isset($add_prod_display) && ($add_prod_display == 1))) && !isset($restricted_country_mode) && $product.minimal_quantity <= 1 && $product.customizable != 2 && !$PS_CATALOG_MODE}
						{if ($product.allow_oosp || $product.quantity > 0) && $product.available_for_order}
							<a class="exclusive ajax_add_to_cart_button" rel="ajax_id_product_{$product.id_product|intval}" href="{$link->getPageLink('cart.php', true)}?add=1&amp;id_product={$product.id_product|intval}{if isset($static_token)}&amp;token={$static_token}{/if}" title="{l s='Add to cart'}">{l s='Add to cart'}</a>						
						{else}
							<span class="exclusive">{l s='Add to cart'}</span>
						{/if}
					{/if}
				{/if}
			</div>
		</li>
	{/foreach}
	</ul>
	<!-- /Products list -->
{/if}