{* ----------------------------------------
   Template Prestashop DiscountShop
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ---------------------------------------- *}

{capture name=path}{l s='Product Comparison'}{/capture}

{include file="$tpl_dir./breadcrumb.tpl"}
<h1>{l s='Product Comparison'}</h1>

{if $hasProduct}
<div class="products_block">
	<table id="product_comparison">
		<tr>
			<td class="td_empty"></td>
			{assign var='taxes_behavior' value=false}
			{if $use_taxes && (!$priceDisplay  || $priceDisplay == 2)}
				{assign var='taxes_behavior' value=true}
			{/if}
		{foreach from=$products item=product name=for_products}
			{assign var='replace_id' value=$product->id|cat:'|'}

			<td style="width:{$width}%" class="ajax_block_product comparison_infos">
				{assign var='specific_prices' value=$product->specificPrice}
				{*{if isset($product->new) && $product->new == true}<span class="new">{l s='New'}</span>{/if}*}
				<h5><a href="{$product->getLink()}" title="{$product->name|escape:'htmlall':'UTF-8'}">{$product->name|truncate:40:'...'|escape:'htmlall':'UTF-8'}</a></h5>
				{*<div class="product_desc">{$product->description_short|strip_tags:'UTF-8'|truncate:60:'...'}</div>*}
				<a href="{$product->getLink()}" title="{$product->name|escape:html:'UTF-8'}" class="product_image">
					<img src="{$link->getImageLink($product->link_rewrite, $product->id_image, 'home')}" alt="{$product->name|escape:html:'UTF-8'}" />
				</a>
				<div class="comparison_product_infos">
					<div class="comparison_prices_container">
					{if isset($product->on_sale) && $product->on_sale && isset($product->show_price) && $product->show_price && !$PS_CATALOG_MODE}<p class="comparison_reduction">{l s='On sale'} <span>{if $specific_prices.reduction_type == 'percentage'}-{$specific_prices.reduction*100}%{/if}{if $specific_prices.reduction_type == 'amount'}-{($specific_prices.reduction|round:2*100/($product->getPrice($taxes_behavior)+$product->specificPrice.reduction))|round:0}%{/if}</span></p>
					{elseif isset($product->specificPrice.reduction) && $product->specificPrice.reduction && isset($product->show_price) && $product->show_price && !$PS_CATALOG_MODE}<p class="comparison_reduction">{l s='Promotion'} <span>{if $specific_prices.reduction_type == 'percentage'}-{$specific_prices.reduction*100}%{/if}{if $specific_prices.reduction_type == 'amount'}-{($specific_prices.reduction|round:2*100/($product->getPrice($taxes_behavior)+$product->specificPrice.reduction))|round:0}%{/if}</span></p>{/if}
					{if isset($product->show_price) && $product->show_price && !$PS_CATALOG_MODE}
						<p class="comparison_price_container">
							<span class="price">{convertPrice price=$product->getPrice($taxes_behavior)}</span>
							{if isset($product->on_sale) && $product->on_sale OR isset($product->specificPrice.reduction) && $product->specificPrice.reduction}<span class="old_price">{if $specific_prices.reduction_type == 'percentage'}{convertPrice price=$product->getPrice($taxes_behavior)/(1-$product->specificPrice.reduction)}{/if}{if $specific_prices.reduction_type == 'amount'}{convertPrice price=$product->getPrice($taxes_behavior)+($product->specificPrice.reduction)}{/if}</span>{/if}
						</p>
						{if !empty($product->unity) && $product->unit_price_ratio > 0.000000}
								{math equation="pprice / punit_price"  pprice=$product->getPrice($taxes_behavior)  punit_price=$product->unit_price_ratio assign=unit_price}
							<p class="comparison_unit_price">{convertPrice price=$unit_price}&nbsp;{l s='per'}&nbsp;{$product->unity|escape:'htmlall':'UTF-8'}</p>
						{else}
						&nbsp;
						{/if}
					{/if}
					</div>
				{*<p class="online_only">{if isset($product->online_only) && $product->online_only}{l s='Online only !'}{/if}</p>*}
				{*<!-- availability -->
				{if isset($product->available_for_order) && $product->available_for_order && !$PS_CATALOG_MODE}
					{if ($product->allow_oosp || $product->quantity > 0)}
						<p class="available">{l s='Available'}</p>
					{else}
						<p class="unavailable">{l s='Out of stock'}</p>
					{/if}
				{/if}
				{if !$product->available_for_order}
					<p class="unavailable">{l s='Unavailable product'}</p>
				{/if}*}
				{if !isset($ptm_listbuttons) OR isset($ptm_listbuttons) AND $ptm_listbuttons == 1}
					<a class="button" href="{$product->getLink()}" title="{l s='View'}">{l s='View'}</a>
					{if (!$product->hasAttributes() OR (isset($add_prod_display) AND ($add_prod_display == 1))) AND $product->minimal_quantity == 1 AND $product->customizable != 2 AND !isset($restricted_country_mode) AND !$PS_CATALOG_MODE}
						{if ($product->quantity > 0 OR $product->allow_oosp) && $product->available_for_order}
							<a class="exclusive ajax_add_to_cart_button" rel="ajax_id_product_{$product->id}" href="{$link->getPageLink('cart.php', true)}?qty=1&amp;id_product={$product->id}&amp;token={$static_token}&amp;add" title="{l s='Add to cart'}"><span></span>{l s='Add to cart'}</a>
						{else}
							<span class="exclusive">{l s='Add to cart'}</span>
						{/if}
					{/if}
				{/if}
				<div class="clear"></div>
				<a class="cmp_remove" href="{$request_uri|replace:$replace_id:''}">{l s='Remove this product'}</a>
				</div>
			</td>
		{/foreach}
		</tr>

		<tr class="comparison_header">
			<td>
				{l s='Features'}
			</td>
			{section loop=$products|count step=1 start=0 name=td}
			<td></td>
			{/section}
		</tr>

		{if $ordered_features}
		{foreach from=$ordered_features item=feature}
		<tr>
			{cycle values='comparison_feature_odd,comparison_feature_even' assign='classname'}
			<td class="{$classname}" >
				<strong>{$feature.name|escape:'htmlall':'UTF-8'}</strong>
			</td>

			{foreach from=$products item=product name=for_products}
				{assign var='product_id' value=$product->id}
				{assign var='feature_id' value=$feature.id_feature}
				{if isset($product_features[$product_id])}
					{assign var='tab' value=$product_features[$product_id]}
					<td style="width:{$width}%" class="{$classname} comparison_infos">{$tab[$feature_id]|escape:'htmlall':'UTF-8'}</td>
				{else}
					<td style="width:{$width}%" class="{$classname} comparison_infos"></td>
				{/if}
			{/foreach}
		</tr>
		{/foreach}
		{else}
			<tr>
				<td></td>
				<td colspan="{$products|@count + 1}">{l s='No features to compare'}</td>
			</tr>
		{/if}

		{*{$HOOK_EXTRA_PRODUCT_COMPARISON}*}
	</table>
</div>
{else}
	<p class="warning">{l s='There are no products selected for comparison.'}</p>
{/if}