{* ----------------------------------------
   Template Prestashop DiscountShop
   Copyright Prestacrea
   Author: Prestacrea
   Website: http://www.prestacrea.com
   ---------------------------------------- *}

{capture name=path}{l s='Your shopping cart'}{/capture}
{include file="$tpl_dir./breadcrumb.tpl"}

<h1 id="cart_title">{l s='Shopping cart summary'}</h1>

{if isset($account_created)}
	<p class="success">
		{l s='Your account has been created.'}
	</p>
{/if}
{assign var='current_step' value='summary'}
{include file="$tpl_dir./order-steps.tpl"}
{include file="$tpl_dir./errors.tpl"}

{if isset($empty)}
	<p class="warning">{l s='Your shopping cart is empty.'}</p>
{elseif $PS_CATALOG_MODE}
	<p class="warning">{l s='This store has not accepted your new order.'}</p>
{else}
	<script type="text/javascript">
	// <![CDATA[
	var currencySign = '{$currencySign|html_entity_decode:2:"UTF-8"}';
	var currencyRate = '{$currencyRate|floatval}';
	var currencyFormat = '{$currencyFormat|intval}';
	var currencyBlank = '{$currencyBlank|intval}';
	var txtProduct = "{l s='product'}";
	var txtProducts = "{l s='products'}";
	var deliveryAddress = {$cart->id_address_delivery|intval};
	// ]]>
	</script>
	<p style="display:none" id="emptyCartWarning" class="warning">{l s='Your shopping cart is empty.'}</p>
<div id="order-detail-content" class="table_block">
	<table id="cart_summary" class="std">
		<thead>
			<tr>
				<th class="cart_product first_item">{l s='Product'}</th>
				<th class="cart_description item">{l s='Description'}</th>
				<th class="cart_unit item">{l s='Unit price'}</th>
				<th class="cart_quantity item">{l s='Qty'}</th>
				<th class="cart_total item">{l s='Total price'}</th>
			</tr>
		</thead>
		<tbody>
		{foreach $products as $product}
			{assign var='productId' value=$product.id_product}
			{assign var='productAttributeId' value=$product.id_product_attribute}
			{assign var='quantityDisplayed' value=0}
			{assign var='odd' value=$product@iteration%2}
			{if isset($gift_products)}{assign var='ignoreProductLast' value=isset($customizedDatas.$productId.$productAttributeId) || count($gift_products)}{/if}
			{* Display the product line *}
			{include file="$tpl_dir./shopping-cart-product-line.tpl" productLast=$product@last productFirst=$product@first}
			{* Then the customized datas ones*}
			{if isset($customizedDatas.$productId.$productAttributeId)}
				{if isset($product.id_address_delivery)}{assign var=customizedDatas value=$customizedDatas.$productId.$productAttributeId[$product.id_address_delivery]}{else}{assign var=customizedDatas value=$customizedDatas.$productId.$productAttributeId}{/if}
				{foreach $customizedDatas as $id_customization=>$customization}
					<tr id="product_{$product.id_product}_{$product.id_product_attribute}_{$id_customization}{if isset($product.id_address_delivery)}_{$product.id_address_delivery|intval}{/if}" class="product_customization_for_{$product.id_product}_{$product.id_product_attribute}{if isset($product.id_address_delivery)}_{$product.id_address_delivery|intval}{/if} {if $odd}odd{else}even{/if} customization alternate_item {if $product@last && $customization@last && isset($gift_products) && !count($gift_products)}last_item{/if}">
						<td></td>
						<td>
							{foreach $customization.datas as $type => $custom_data}
								{if $type == $CUSTOMIZE_FILE}
									<div class="customizationUploaded">
										<ul class="customizationUploaded">
											{foreach $custom_data as $picture}
												<li><img src="{$pic_dir}{$picture.value}_small" alt="" class="customizationUploaded" /></li>
											{/foreach}
										</ul>
									</div>
								{elseif $type == $CUSTOMIZE_TEXTFIELD}
									<ul class="typedText">
										{foreach $custom_data as $textField}
											<li>
												{if $textField.name}
													{$textField.name}
												{else}
													{l s='Text #'}{$textField@index+1}
												{/if}
												: {$textField.value}
											</li>
										{/foreach}
									</ul>
								{/if}
							{/foreach}
							{if isset($cannotModify) AND $cannotModify == 1}
							{else}
								<p class="cart_delete">
									<a rel="nofollow" class="cart_quantity_delete" id="{$product.id_product}_{$product.id_product_attribute}_{$id_customization}{if isset($product.id_address_delivery)}_{$product.id_address_delivery|intval}{/if}" href="{$link->getPageLink('cart.php', true)}?delete&amp;id_product={$product.id_product|intval}&amp;ipa={$product.id_product_attribute|intval}&amp;id_customization={$id_customization}{if isset($product.id_address_delivery)}&amp;id_address_delivery={$product.id_address_delivery}{/if}&amp;token={$token_cart}" title="{l s='Delete this product'}">{l s='Delete this product'}</a>
								</p>
							{/if}
						</td>
						<td></td>
						<td class="cart_quantity">
							{if isset($cannotModify) AND $cannotModify == 1}
								<span>{if $quantityDisplayed == 0 AND isset($customizedDatas.$productId.$productAttributeId)}{$customizedDatas.$productId.$productAttributeId|@count}{else}{$product.cart_quantity-$quantityDisplayed}{/if}</span>
							{else}
								<div id="cart_quantity_button" class="cart_quantity_button">
									<a rel="nofollow" class="cart_quantity_up" id="cart_quantity_up_{$product.id_product}_{$product.id_product_attribute}_{$id_customization}{if isset($product.id_address_delivery)}_{$product.id_address_delivery|intval}{/if}" href="{$link->getPageLink('cart.php', true)}?add&amp;id_product={$product.id_product|intval}&amp;ipa={$product.id_product_attribute|intval}{if isset($product.id_address_delivery)}&amp;id_address_delivery={$product.id_address_delivery}{/if}&amp;id_customization={$id_customization}&amp;token={$token_cart}" title="{l s='Add'}"><i class="icon-plus-square"></i></a>
									{if $product.minimal_quantity < ($customization.quantity -$quantityDisplayed) OR $product.minimal_quantity <= 1}
										<a rel="nofollow" class="cart_quantity_down" id="cart_quantity_down_{$product.id_product}_{$product.id_product_attribute}_{$id_customization}{if isset($product.id_address_delivery)}_{$product.id_address_delivery|intval}{/if}" href="{$link->getPageLink('cart.php', true)}?add&amp;id_product={$product.id_product|intval}&amp;ipa={$product.id_product_attribute|intval}{if isset($product.id_address_delivery)}&amp;id_address_delivery={$product.id_address_delivery}{/if}&amp;id_customization={$id_customization}&amp;op=down&amp;token={$token_cart}" title="{l s='Subtract'}">
											<i class="icon-minus-square"></i>
										</a>
									{else}
										<a class="cart_quantity_down" style="opacity:0.3" id="cart_quantity_down_{$product.id_product}_{$product.id_product_attribute}_{$id_customization}" href="#" title="{l s='Subtract'}">
											<i class="icon-minus-square"></i>
										</a>
									{/if}
								</div>
								<input type="hidden" value="{$customization.quantity}" name="quantity_{$product.id_product}_{$product.id_product_attribute}_{$id_customization}_hidden"/>
								<input size="2" type="text" value="{$customization.quantity}" class="cart_quantity_input" name="quantity_{$product.id_product}_{$product.id_product_attribute}_{$id_customization}{if isset($product.id_address_delivery)}_{$product.id_address_delivery|intval}{/if}"/>
							{/if}
						</td>
						<td></td>
					</tr>
					{assign var='quantityDisplayed' value=$quantityDisplayed+$customization.quantity}
				{/foreach}
				{* If it exists also some uncustomized products *}
				{if $product.quantity-$quantityDisplayed > 0}{include file="$tpl_dir./shopping-cart-product-line.tpl" productLast=$product@last productFirst=$product@first}{/if}
			{/if}
		{/foreach}
		{if isset($gift_products)}
		{assign var='last_was_odd' value=$product@iteration%2}
		{foreach $gift_products as $product}
			{assign var='productId' value=$product.id_product}
			{assign var='productAttributeId' value=$product.id_product_attribute}
			{assign var='quantityDisplayed' value=0}
			{assign var='odd' value=($product@iteration+$last_was_odd)%2}
			{assign var='ignoreProductLast' value=isset($customizedDatas.$productId.$productAttributeId)}
			{assign var='cannotModify' value=1}
			{* Display the gift product line *}
			{include file="$tpl_dir./shopping-cart-product-line.tpl" productLast=$product@last productFirst=$product@first}
		{/foreach}
		{/if}
		</tbody>
		{if sizeof($discounts)}
		<tbody>
		{foreach $discounts as $discount}
			<tr class="cart_discount {if $discount@last}last_item{elseif $discount@first}first_item{else}item{/if}" id="cart_discount_{$discount.id_discount}">
				<td></td>
				<td class="cart_discount_name">
					<p>{if isset($discount.code)}{$discount.code}{else}{$discount.name}{/if} - {$discount.description}</p>
					<p class="cart_discount_delete">
						<a href="{if $opc}{$link->getPageLink('order-opc.php', true)}{else}{$link->getPageLink('order.php', true)}{/if}?deleteDiscount={$discount.id_discount}" class="price_discount_delete" title="{l s='Delete this coupon code'}">{l s='Delete this coupon code'}</a>
					</span>
				</td>
				<td></td>
				<td></td>
				<td class="cart_discount_price">
					<span class="price-discount price">{if !$priceDisplay}{displayPrice price=$discount.value_real*-1}{else}{displayPrice price=$discount.value_tax_exc*-1}{/if}</span>
				</td>
			</tr>
		{/foreach}
		</tbody>
		{/if}
	</table>
	<table id="cart_summary_total" class="std">
		{if $use_taxes}
			{if $priceDisplay}
				<tr class="cart_total_price">
					<td>{if $display_tax_label}{l s='Total products (tax excl.) :'}{else}{l s='Total products :'}{/if}</td>
					<td id="total_product" class="price">{displayPrice price=$total_products}</td>
				</tr>
			{else}
				<tr class="cart_total_price">
					<td>{if $display_tax_label}{l s='Total products (tax incl.) :'}{else}{l s='Total products :'}{/if}</td>
					<td id="total_product" class="price">{displayPrice price=$total_products_wt}</td>
				</tr>
			{/if}
		{else}
			<tr class="cart_total_price">
				<td>{l s='Total products :'}</td>
				<td id="total_product" class="price">{displayPrice price=$total_products}</td>
			</tr>
		{/if}
		<tr class="cart_total_voucher" {if $total_discounts == 0}style="display:none"{/if}>
			<td>
				{if $use_taxes}
					{if $priceDisplay}
						{if $display_tax_label}{l s='Total coupon codes (tax excl.) :'}{else}{l s='Total coupon codes :'}{/if}
					{else}
						{if $display_tax_label}{l s='Total coupon codes (tax incl.) :'}{else}{l s='Total coupon codes :'}{/if}
					{/if}
				{else}
					{l s='Total coupon codes :'}
				{/if}
			</td>
			<td id="total_discount" class="price-discount price">
				{if $use_taxes && !$priceDisplay}
					{assign var='total_discounts_negative' value=$total_discounts}
				{else}
					{assign var='total_discounts_negative' value=$total_discounts_tax_exc}
				{/if}
				{if $total_discounts_negative < 0}
					{displayPrice price=$total_discounts_negative}
				{else}
					{displayPrice price=$total_discounts_negative * -1}
				{/if}
			</td>
		</tr>
		<tr class="cart_total_voucher" {if $total_wrapping == 0}style="display:none"{/if}>
			<td>
				{if $use_taxes}
					{if $priceDisplay}
						{if $display_tax_label}{l s='Total gift-wrapping (tax excl.) :'}{else}{l s='Total gift-wrapping :'}{/if}
					{else}
						{if $display_tax_label}{l s='Total gift-wrapping (tax incl.) :'}{else}{l s='Total gift-wrapping :'}{/if}
					{/if}
				{else}
					{l s='Total gift-wrapping :'}
				{/if}
			</td>
			<td id="total_wrapping" class="price-discount price">
				{if $use_taxes}
					{if $priceDisplay}
						{displayPrice price=$total_wrapping_tax_exc}
					{else}
						{displayPrice price=$total_wrapping}
					{/if}
				{else}
					{displayPrice price=$total_wrapping_tax_exc}
				{/if}
			</td>
		</tr>
		{if $total_shipping_tax_exc <= 0 && !isset($virtualCart)}
			<tr class="cart_total_delivery">
				<td>{l s='Total shipping :'}</td>
				<td id="total_shipping" class="price">{l s='Free Shipping !'}</td>
			</tr>
		{else}
			{if $use_taxes}
				{if $priceDisplay}
					<tr class="cart_total_delivery" {if $total_shipping_tax_exc <= 0}style="display:none"{/if}>
						<td>{if $display_tax_label}{l s='Total shipping (tax excl.) :'}{else}{l s='Total shipping :'}{/if}</td>
						<td id="total_shipping" class="price">{displayPrice price=$total_shipping_tax_exc}</td>
					</tr>
				{else}
					<tr class="cart_total_delivery" {if $total_shipping <= 0}style="display:none"{/if}>
						<td>{if $display_tax_label}{l s='Total shipping (tax incl.) :'}{else}{l s='Total shipping :'}{/if}</td>
						<td id="total_shipping" class="price">{displayPrice price=$total_shipping}</td>
					</tr>
				{/if}
			{else}
				<tr class="cart_total_delivery" {if $total_shipping_tax_exc <= 0}style="display:none"{/if}>
					<td>{l s='Total shipping :'}</td>
					<td id="total_shipping" class="price">{displayPrice price=$total_shipping_tax_exc}</td>
				</tr>
			{/if}
		{/if}
		{if $use_taxes}
			<tr class="cart_total_price">
				<td>{l s='Total (tax excl.) :'}</td>
				<td id="total_price_without_tax" class="price">{displayPrice price=$total_price_without_tax}</td>
			</tr>
			<tr class="cart_total_tax">
				<td>{l s='Total tax :'}</td>
				<td id="total_tax" class="price">{displayPrice price=$total_tax}</td>
			</tr>
		{/if}
		<tr class="cart_total_price">
			{if $use_taxes}
				<td id="total_price_label" class="total_price">{l s='Total (tax incl.) :'}</td>
				<td id="total_price_amount" class="total_price price">{displayPrice price=$total_price}</td>
			{else}
				<td id="total_price_label" class="total_price">{l s='Total :'}</td>
				<td id="total_price_amount" class="total_price price">{displayPrice price=$total_price_without_tax}</td>
			{/if}
		</tr>
	</table>
	{if $voucherAllowed}
		<table id="cart_summary_voucher" class="std">
			<tr>
				<td id="cart_voucher" class="cart_voucher">
					<p id="title_voucher" class="title_voucher">{l s='Use a coupon code :'}</p>
					{if isset($errors_discount) && $errors_discount}
						<ul class="error">
						{foreach $errors_discount as $k=>$error}
							<li>{$error|escape:'htmlall':'UTF-8'}</li>
						{/foreach}
						</ul>
					{/if}
					<form action="{if $opc}{$link->getPageLink('order-opc.php', true)}{else}{$link->getPageLink('order.php', true)}{/if}" method="post" id="voucher">
						<fieldset>
							<p><label for="discount_name">{l s='Coupon code :'}</label></p>
							<p><input type="text" class="discount_name" id="discount_name" name="discount_name" value="{if isset($discount_name) && $discount_name}{$discount_name}{/if}" /></p>
							<p class="submit"><input type="hidden" name="submitDiscount" /><input type="submit" name="submitAddDiscount" value="{l s='OK'}" class="button" /></p>
						</fieldset>
					</form>
					{if $displayVouchers}
						<p id="title_offers" class="title_offers">{l s='Take advantage of our offers :'}</p>
						<div id="display_cart_vouchers">
							{foreach $displayVouchers as $voucher}
								{if isset($voucher.code)}
									{if $voucher.code != ''}<span onclick="$('#discount_name').val('{$voucher.code}');return false;" class="voucher_name">{$voucher.code}</span> - {/if}{$voucher.name}<br />
								{else}
									<span onclick="$('#discount_name').val('{$voucher.name}');return false;" class="voucher_name">{$voucher.name}</span> - {$voucher.description} <br />
								{/if}
							{/foreach}
						</div>
					{/if}
				</td>
			</tr>
		</table>
	{/if}
	<div class="clear"></div>
</div>

{if isset($show_option_allow_separate_package) && $show_option_allow_separate_package}
<p>
	<input type="checkbox" name="allow_seperated_package" id="allow_seperated_package" {if $cart->allow_seperated_package}checked="checked"{/if} />
	<label for="allow_seperated_package">{l s='Send the available products first.'}</label>
</p>
{/if}
{if !$opc}
	{if Configuration::get('PS_ALLOW_MULTISHIPPING')}
		<p>
			<input type="checkbox" {if $multi_shipping}checked="checked"{/if} id="enable-multishipping" />
			<label for="enable-multishipping">{l s='I want to specify a delivery address for each individual product.'}</label>
		</p>
	{/if}
{/if}

<div id="HOOK_SHOPPING_CART">{$HOOK_SHOPPING_CART}</div>

<p class="cart_navigation">
	{if !$opc}
		<a href="{if $back}{$link->getPageLink('order.php', true)}?step=1&amp;back={$back}{else}{$link->getPageLink('order.php', true)}?step=1{/if}" class="exclusive standard-checkout" title="{l s='Next'}">{l s='Next'} &raquo;</a>
		{if Configuration::get('PS_ALLOW_MULTISHIPPING')}
			<a href="{if $back}{$link->getPageLink('order', true, NULL, 'step=1&amp;back={$back}')}{else}{$link->getPageLink('order', true, NULL, 'step=1')}{/if}&amp;multi-shipping=1" class="multishipping-button multishipping-checkout exclusive" title="{l s='Next'}">{l s='Next'} &raquo;</a>
		{/if}
	{/if}
	<a href="{if (isset($smarty.server.HTTP_REFERER) && strstr($smarty.server.HTTP_REFERER, 'order.php')) || isset($smarty.server.HTTP_REFERER) && strstr($smarty.server.HTTP_REFERER, 'order-opc.php') || !isset($smarty.server.HTTP_REFERER)}{$link->getPageLink('index.php')}{else}{$smarty.server.HTTP_REFERER|escape:'htmlall':'UTF-8'|secureReferrer}{/if}" class="button_large" title="{l s='Continue shopping'}">&laquo; {l s='Continue shopping'}</a>
</p>
	{if !empty($HOOK_SHOPPING_CART_EXTRA)}
		<div class="clear"></div>
		<div class="cart_navigation_extra">
			<div id="HOOK_SHOPPING_CART_EXTRA">{$HOOK_SHOPPING_CART_EXTRA}</div>
		</div>
	{/if}
{/if}