{* Template Prestashop DiscountShop
 * Copyright Prestacrea
 * Author: Prestacrea
 * Website: http://www.prestacrea.com *}

{include file="$tpl_dir./breadcrumb.tpl"}
{include file="$tpl_dir./errors.tpl"}

{if isset($category)}
	{if $category->id AND $category->active}
		<h1>
			{strip}
				{$category->name|escape:'htmlall':'UTF-8'}
				{if isset($categoryNameComplement)}
					{$categoryNameComplement|escape:'htmlall':'UTF-8'}
				{/if}
			{/strip}
		</h1>
		
		<div class="resumecat category-product-count">
			{include file="$tpl_dir./category-count.tpl"}
		</div>
		
		{if $scenes || $category->description || $category->id_image}
		<div class="content_scene_cat">
			{if $scenes}
				<!-- Scenes -->
				{include file="$tpl_dir./scenes.tpl" scenes=$scenes}
			{else}
				<!-- Category image -->
				{if $category->id_image}
				<div class="align_center">
					<img src="{$link->getCatImageLink($category->link_rewrite, $category->id_image, 'category')}" alt="{$category->name|escape:'htmlall':'UTF-8'}" title="{$category->name|escape:'htmlall':'UTF-8'}" id="categoryImage" width="528" height="200" style="{if !$category->description}display:block{else}margin-bottom:5px{/if}" />
				</div>
				{/if}
			{/if}

			{if $category->description}
				<div class="cat_desc">
					<p>{$category->description}</p>
				</div>
			{/if}
		</div>
		{/if}
		{if isset($subcategories)}
		<!-- Subcategories -->
		<div id="subcategories" class="clearfix">
			<ul class="inline_list">
			{foreach from=$subcategories item=subcategory}
				<li class="clearfix">
					<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'htmlall':'UTF-8'}" title="{$subcategory.name|escape:'htmlall':'UTF-8'}" class="img">
						<img src="{$link->getCatImageLink($subcategory.link_rewrite, $subcategory.id_image, 'subcategory')}" alt="{$subcategory.name|escape:'htmlall':'UTF-8'}" width="80" height="30" />
					</a>
					<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'htmlall':'UTF-8'}" class="cat_name" title="{$subcategory.name|escape:'htmlall':'UTF-8'}">{$subcategory.name|escape:'htmlall':'UTF-8'}</a>
					{if $subcategory.description}
						<p class="cat_desc">{$subcategory.description|strip_tags:'UTF-8'|escape:'htmlall':'UTF-8'|truncate:120:'...'}</p>
					{/if}
				</li>
			{/foreach}
			</ul>
		</div>
		{/if}

		{if $products}
			<div class="content_sortPagiBar">
				{include file="$tpl_dir./pagination.tpl"}
				<div class="sortPagiBar clearfix">
					{include file="$tpl_dir./product-sort.tpl"}
					{include file="$tpl_dir./product-compare.tpl"}
					{*{include file="$tpl_dir./nbr-product-page.tpl"}*}
					<div class="clear"></div>
				</div>
			</div>
			
			{include file="$tpl_dir./product-list.tpl" products=$products}
			
			<div class="content_sortPagiBar">
				<div class="sortPagiBar clearfix">
					{include file="$tpl_dir./product-sort.tpl"}
					{include file="$tpl_dir./product-compare.tpl"}
					{*{include file="$tpl_dir./nbr-product-page.tpl"}*}
					<div class="clear"></div>
				</div>
				{include file="$tpl_dir./pagination.tpl"}
			</div>
		{/if}
	{elseif $category->id}
		<p class="warning">{l s='This category is currently unavailable.'}</p>
	{/if}
{/if}