{* Template Prestashop DiscountShop
 * Copyright Prestacrea
 * Author: Prestacrea
 * Website: http://www.prestacrea.com *}

{include file="$tpl_dir./breadcrumb.tpl"}

{include file="$tpl_dir./errors.tpl"}

{if !isset($errors) OR !sizeof($errors)}
	<h1>{l s='List of products by manufacturer'}&nbsp;{$manufacturer->name|escape:'htmlall':'UTF-8'}</h1>
	{if !empty($manufacturer->description) || !empty($manufacturer->short_description)}
		<div class="description_box clearfix">
			<img src="{$img_manu_dir}{$manufacturer->id_manufacturer|escape:'htmlall':'UTF-8'}-medium.jpg" alt="{$manufacturer->name|escape:'htmlall':'UTF-8'}" width="80" height="80" />
			{$manufacturer->description}
			<div class="clear"></div>
		</div>
	{/if}

	{if $products}
		<div class="content_sortPagiBar">
			{include file="$tpl_dir./pagination.tpl"}
			<div class="sortPagiBar clearfix">
				{include file="$tpl_dir./product-sort.tpl"}
				{include file="$tpl_dir./product-compare.tpl"}
				<div class="clear"></div>
			</div>
		</div>
	
		{include file="$tpl_dir./product-list.tpl" products=$products}
	
		<div class="content_sortPagiBar">
			<div class="sortPagiBar clearfix">
				{include file="$tpl_dir./product-sort.tpl"}
				{include file="$tpl_dir./product-compare.tpl"}
				<div class="clear"></div>
			</div>
			{include file="$tpl_dir./pagination.tpl"}
		</div>
	{else}
		<p class="warning">{l s='No products for this manufacturer.'}</p>
	{/if}
{/if}