{* Template Prestashop DiscountShop
 * Copyright Prestacrea
 * Author: Prestacrea
 * Website: http://www.prestacrea.com *}

{if isset($products)}
	<!-- Products list -->
	<ul id="product_list" class="clear">
	{foreach from=$products item=product name=products}
		<li class="ajax_block_product {if $smarty.foreach.products.first}first_item{elseif $smarty.foreach.products.last}last_item{/if} {if $smarty.foreach.products.index % 2}alternate_item{else}item{/if} clearfix">
			<div class="left_block">
				<a href="{$product.link|escape:'htmlall':'UTF-8'}" class="product_img_link" title="{$product.name|escape:'htmlall':'UTF-8'}">
					<img src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'home')}" alt="{$product.legend|escape:'htmlall':'UTF-8'}" width="120" height="120" />
				</a>
				<h3>{if isset($product.new) && $product.new == 1}<span class="new">{l s='New'}</span>{/if}<a href="{$product.link|escape:'htmlall':'UTF-8'}" title="{$product.name|escape:'htmlall':'UTF-8'}">{$product.name|strip_tags:'UTF-8'|escape:'htmlall':'UTF-8'|truncate:50:'...'}</a></h3>
				<p class="product_desc">{$product.description_short|strip_tags:'UTF-8'|escape:'htmlall':'UTF-8'|truncate:150:'...'}</p>
				{if isset($comparator_max_item) && $comparator_max_item}
					<p class="compare">
						<input type="checkbox" onclick="checkForComparison({$comparator_max_item})" id="comparator_item_{$product.id_product}" class="comparator" value="{$product.id_product}"/>
						<label for="comparator_item_{$product.id_product}">{l s='Select to compare'}</label>
					</p>
				{/if}
				<a class="lnk_view" href="{$product.link|escape:'htmlall':'UTF-8'}" title="{l s='View this product'}">{l s='View this product'}</a>
			</div>
			<div class="right_block">
				{assign var='specific_prices' value=$product.specific_prices}
				{if isset($product.on_sale) && $product.on_sale && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE OR isset($product.reduction) && $product.reduction && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE}
					<p class="reduction">{if $specific_prices.reduction_type == 'percentage'}-{$specific_prices.reduction*100}%{/if}{if $specific_prices.reduction_type == 'amount'}-{$specific_prices.reduction|round:2}{$currency->sign}{/if}</p>
				{/if}
				{if (!$PS_CATALOG_MODE AND ((isset($product.show_price) && $product.show_price) || (isset($product.available_for_order) && $product.available_for_order)))}
					<p class="price_container">
						{if isset($product.show_price) && $product.show_price}
							<span class="price">{if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}</span>
							{if isset($product.on_sale) && $product.on_sale OR isset($product.reduction) && $product.reduction}<span class="old_price">{convertPrice price=$product.price_without_reduction}</span>{/if}
						{/if}
					</p>
				{/if}
				{if isset($product.online_only) && $product.online_only}<p class="online_only">{l s='Online only !'}</p>{/if}
				{if isset($product.available_for_order) && $product.available_for_order && !$PS_CATALOG_MODE}
					{if ($product.allow_oosp || $product.quantity > 0)}
						<p class="available">{l s='Available'}</p>
					{elseif (isset($product.quantity_all_versions) && $product.quantity_all_versions > 0)}
						<p class="available_later">{l s='Product available with different options'}</p>
					{else}
						<p class="unavailable">{l s='Out of stock'}</p>
					{/if}
				{/if}
				{if !$product.available_for_order}
					<p class="unavailable">{l s='Unavailable product'}</p>
				{/if}
				{if ($product.id_product_attribute == 0 || (isset($add_prod_display) && ($add_prod_display == 1))) && !isset($restricted_country_mode) && $product.minimal_quantity <= 1 && $product.customizable != 2 && !$PS_CATALOG_MODE}
					{if ($product.allow_oosp || $product.quantity > 0) && $product.available_for_order}
						<a class="exclusive ajax_add_to_cart_button" rel="ajax_id_product_{$product.id_product|intval}" href="{$link->getPageLink('cart.php', true)}?add=1&amp;id_product={$product.id_product|intval}{if isset($static_token)}&amp;token={$static_token}{/if}" title="{l s='Add to cart'}">{l s='Add to cart'}</a>					
					{else}
						<span class="exclusive">{l s='Add to cart'}</span>
					{/if}
				{/if}
			</div>
		</li>
	{/foreach}
	</ul>
	<div class="clear"></div>
	<!-- /Products list -->
{/if}