{* Template Prestashop DiscountShop
 * Copyright Prestacrea
 * Author: Prestacrea
 * Website: http://www.prestacrea.com *}

{include file="$tpl_dir./breadcrumb.tpl"}

{include file="$tpl_dir./errors.tpl"}

{if !isset($errors) OR !sizeof($errors)}
	<h1>{l s='List of products by supplier'}&nbsp;{$supplier->name|escape:'htmlall':'UTF-8'}</h1>
	{if !empty($supplier->description)}
		<div class="description_box clearfix">
			<img src="{$img_sup_dir}{$supplier->id_supplier|escape:'htmlall':'UTF-8'}-medium.jpg" alt="{$supplier->name|escape:'htmlall':'UTF-8'}" width="80" height="80" />
			<p>{$supplier->description}</p>
			<div class="clear"></div>
		</div>
	{/if}

	{if $products}
		<div class="content_sortPagiBar">
			{include file="$tpl_dir./pagination.tpl"}
			<div class="sortPagiBar clearfix">
				{include file="$tpl_dir./product-sort.tpl"}
				{include file="$tpl_dir./product-compare.tpl"}
				<div class="clear"></div>
			</div>
		</div>
	
		{include file="$tpl_dir./product-list.tpl" products=$products}
	
		<div class="content_sortPagiBar">
			<div class="sortPagiBar clearfix">
				{include file="$tpl_dir./product-sort.tpl"}
				{include file="$tpl_dir./product-compare.tpl"}
				<div class="clear"></div>
			</div>
			{include file="$tpl_dir./pagination.tpl"}
		</div>
	{else}
		<p class="warning">{l s='No products for this supplier.'}</p>
	{/if}
{/if}